/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class GeneralPKCS11KeyFactory
extends SecretKeyFactorySpi {
    private SessionManager sessionManager = null;
    private Config config = null;
    private KeyMechanismBuilder mechanismBuilder = null;
    private Provider provider = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");

    public GeneralPKCS11KeyFactory(Provider provider, String algorithm) {
        IBMPKCS11Impl.verifyJceJar();
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.mechanismBuilder = MechanismBuilderImpl.createKeyMechanismBuilder(algorithm);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (GeneralPKCS11KeyFactory.debug != null) {
            GeneralPKCS11KeyFactory.debug.entry(16384L, (Object)"GeneralPKCS11KeyFactory", "engineGenerateSecret");
        }
        genKey = null;
        keyType = this.mechanismBuilder.getKeyType();
        if (keySpec == null) {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            if (GeneralPKCS11KeyFactory.debug != null) {
                GeneralPKCS11KeyFactory.debug.text(16384L, (Object)"GeneralPKCS11KeyFactory", "engineGenerateSecret", "not a PKCS11KeySpec");
            }
            session = null;
            try {
                object = null;
                ID = null;
                isToken = Boolean.FALSE;
                isSensitive = Boolean.FALSE;
                encrypt = Boolean.TRUE;
                wrapping = Boolean.TRUE;
                extractable = Boolean.TRUE;
                value = null;
                attrTypes = null;
                attrValues = null;
                if (keySpec instanceof SecretKeySpec) {
                    if (GeneralPKCS11KeyFactory.debug != null) {
                        GeneralPKCS11KeyFactory.debug.text(16384L, (Object)"GeneralPKCS11KeyFactory", "engineGenerateSecret", "is a SecretKeySpec");
                    }
                    generalPKCS11KeySpec = (SecretKeySpec)keySpec;
                    value = generalPKCS11KeySpec.getEncoded();
                } else if (keySpec instanceof DESKeySpec) {
                    dks = (DESKeySpec)keySpec;
                    value = dks.getKey();
                } else if (keySpec instanceof DESedeKeySpec) {
                    dks = (DESedeKeySpec)keySpec;
                    value = dks.getKey();
                } else {
                    if (GeneralPKCS11KeyFactory.debug != null) {
                        GeneralPKCS11KeyFactory.debug.text(16384L, (Object)"GeneralPKCS11KeyFactory", "engineGenerateSecret", "unknown KeySpec");
                    }
                    throw new InvalidKeySpecException("Unknown Key specification");
                }
                ID = this.genID();
                hattrs = null;
                keys = null;
                numEles = 0;
                if (this.config != null) {
                    hattrs = this.config.getAttributes("IMPORT", PKCS11Object.SECRET_KEY, keyType);
                    keys = hattrs.keySet();
                    numEles = keys.size();
                    attrTypes = new int[4 + numEles];
                    attrValues = new Object[4 + numEles];
                    attrTypes[0] = 0;
                    attrTypes[1] = 256;
                    attrTypes[2] = 258;
                    attrTypes[3] = 17;
                    attrValues[0] = PKCS11Object.SECRET_KEY;
                    attrValues[1] = keyType;
                    attrValues[2] = ID;
                    attrValues[3] = value;
                    it = keys.iterator();
                    i = 1;
                    while (it.hasNext()) {
                        key = it.next();
                        attrTypes[3 + i] = key;
                        attrValues[3 + i] = hattrs.get(key);
                        if (GeneralPKCS11KeyFactory.debug != null) {
                            GeneralPKCS11KeyFactory.debug.text(16384L, (Object)"GeneralPKCS11Factory", "engineGenerateSecret", "attrtype=" + attrTypes[3 + i] + ", attrvalue=" + attrValues[3 + i]);
                        }
                        ++i;
                    }
                } else {
                    attrTypes1 = new int[]{0, 256, 258, 2, 1, 259, 260, 261, 262, 263, 17};
                    attrTypes = attrTypes1;
                    attrValues = new Object[]{PKCS11Object.SECRET_KEY, keyType, ID, Boolean.TRUE, isToken, isSensitive, encrypt, new Boolean(encrypt), wrapping, new Boolean(wrapping), value};
                }
                session = this.sessionManager.getObjSession();
                object = session.createObject(attrTypes, attrValues);
                genKey = new GeneralKey(session, object, this.mechanismBuilder.getAlgorithm());
                if (session.getBoolAttributeValue(object, 1)) ** GOTO lbl102
                session.addObject();
                genKey.setSession(session);
            }
            catch (InvalidKeyException e) {
                if (GeneralPKCS11KeyFactory.debug != null) {
                    GeneralPKCS11KeyFactory.debug.exception(16384L, (Object)"GeneralPKCS11KeyFactory", "engineGenerateSecret", (Throwable)e);
                }
                if (session == null) ** GOTO lbl102
                this.sessionManager.releaseSession(session);
            }
        } else {
            object = ((PKCS11KeySpec)keySpec).getObject();
            session = null;
            try {
                session = this.sessionManager.getOpSession();
                genKey = new GeneralKey(session, object, this.mechanismBuilder.getAlgorithm());
            }
            catch (InvalidKeyException e) {
                if (GeneralPKCS11KeyFactory.debug != null) {
                    GeneralPKCS11KeyFactory.debug.exception(16384L, (Object)"GeneralPKCS11KeyFactory", "engineGenerateSecret", (Throwable)e);
                }
                if (session != null) {
                    this.sessionManager.releaseSession(session);
                }
            }
        }
lbl102:
        // 6 sources

        if (GeneralPKCS11KeyFactory.debug != null) {
            GeneralPKCS11KeyFactory.debug.exit(16384L, (Object)"GeneralPKCS11KeyFactory", "engineGenerateSecret");
        }
        return genKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        try {
            String algorithmName = this.mechanismBuilder.getAlgorithm();
            if (key != null && key instanceof PKCS11SecretKey && key.getAlgorithm().equalsIgnoreCase(algorithmName) && key.getFormat().equalsIgnoreCase("PKCS#11")) {
                Class<?> SecretKeySpec2 = Class.forName("javax.crypto.spec.SecretKeySpec");
                if (keySpec != null && SecretKeySpec2.isAssignableFrom(keySpec)) {
                    if (((GeneralKey)key).getSensitive().booleanValue()) {
                        throw new PKCS11Exception("Secret key value is not exportable");
                    }
                    return new SecretKeySpec(((GeneralKey)key).getValue(), algorithmName);
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key != null && key.getAlgorithm().equalsIgnoreCase(algorithmName) && key.getFormat().equalsIgnoreCase("RAW")) {
                Class<?> SecretKeySpec3 = Class.forName("javax.crypto.spec.SecretKeySpec");
                if (keySpec != null && SecretKeySpec3.isAssignableFrom(keySpec)) {
                    return new SecretKeySpec(key.getEncoded(), algorithmName);
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        try {
            if (debug != null) {
                debug.text(16384L, (Object)"GeneralPKCS11KeyFactory", "engineTranslateKey", "key.getAlgorithm()=" + key.getAlgorithm() + " mechanismBuilder.getAlgorithm()=" + this.mechanismBuilder.getAlgorithm() + " key.getFormat=" + key.getFormat());
            }
            if (key != null && key.getAlgorithm().equalsIgnoreCase(this.mechanismBuilder.getAlgorithm())) {
                if (key instanceof PKCS11SecretKey) {
                    return key;
                }
                if (key.getFormat().equalsIgnoreCase("RAW")) {
                    SecretKeySpec genKeySpec = (SecretKeySpec)this.engineGetKeySpec(key, (Class)SecretKeySpec.class);
                    return this.engineGenerateSecret(genKeySpec);
                }
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }

    private byte[] genID() {
        byte[] labelName = new byte[33];
        byte[] labelSaltData = new byte[24];
        byte[] labelTmp = null;
        int labelLength = 0;
        try {
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom", this.provider);
            random.nextBytes(labelSaltData);
        }
        catch (Exception random) {
            // empty catch block
        }
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        try {
            labelTmp = bigInt.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Can not convert string");
        }
        labelLength = bigInt.toString().length();
        if (labelLength > 24) {
            labelLength = 24;
        }
        System.arraycopy(labelTmp, 0, labelName, 9, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 80;
        labelName[4] = 75;
        labelName[5] = 67;
        labelName[6] = 83;
        labelName[7] = 49;
        labelName[8] = 49;
        return labelName;
    }
}

