/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public final class IBMOAEPParameters
extends AlgorithmParametersSpi {
    private static ObjectIdentifier MGF1;
    private static ObjectIdentifier PSpec;
    private MGF1ParameterSpec MGFSpec = MGF1ParameterSpec.SHA1;
    private String HASHALGO = "SHA-1";
    private String MGFName = "MGF1";
    private PSource PSrc;
    private byte[] PSourceVal;

    public IBMOAEPParameters(Provider provider) {
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof OAEPParameterSpec)) {
            throw new InvalidParameterSpecException("Incorrect Parameter Specification");
        }
        OAEPParameterSpec castSpec = (OAEPParameterSpec)paramSpec;
        this.HASHALGO = castSpec.getDigestAlgorithm();
        this.MGFName = castSpec.getMGFAlgorithm();
        AlgorithmParameterSpec uncastMGFSPec = castSpec.getMGFParameters();
        PSource uncastPSource = castSpec.getPSource();
        if (!this.MGFName.equalsIgnoreCase("MGF1")) {
            throw new InvalidParameterSpecException("Unsupported mgf " + this.MGFName + "; MGF1 only");
        }
        if (!(uncastMGFSPec instanceof MGF1ParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate mgf parameters; non-null MGF1ParameterSpec only");
        }
        this.MGFSpec = (MGF1ParameterSpec)uncastMGFSPec;
        if (!uncastPSource.getAlgorithm().equals("PSpecified")) {
            throw new InvalidParameterSpecException("Unsupported pSource " + uncastPSource.getAlgorithm() + "; PSpecified only");
        }
        this.PSrc = (PSource.PSpecified)uncastPSource;
        this.PSourceVal = ((PSource.PSpecified)this.PSrc).getValue();
    }

    private static String convertToStandardName(String internalName) {
        if (internalName.equals("SHA") || internalName.equals("SHA1") || internalName.equals("SHA-1")) {
            return "SHA-1";
        }
        if (internalName.equals("SHA224") || internalName.equals("SHA-224")) {
            return "SHA-224";
        }
        if (internalName.equals("SHA256") || internalName.equals("SHA-256") || internalName.equals("SHA2") || internalName.equals("SHA-2")) {
            return "SHA-256";
        }
        if (internalName.equals("SHA384") || internalName.equals("SHA-384")) {
            return "SHA-384";
        }
        if (internalName.equals("SHA512") || internalName.equals("SHA-512")) {
            return "SHA-512";
        }
        return internalName;
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        DerInputStream der = new DerInputStream(encoded);
        this.HASHALGO = "SHA-1";
        this.MGFSpec = MGF1ParameterSpec.SHA1;
        DerValue[] datum = der.getSequence(3);
        for (int i = 0; i < datum.length; ++i) {
            AlgorithmId val;
            DerValue data = datum[i];
            if (data.isContextSpecific((byte)0)) {
                String tempName = AlgorithmId.parse((DerValue)data.getData().getDerValue()).getName();
                this.HASHALGO = IBMOAEPParameters.convertToStandardName(tempName);
                continue;
            }
            if (data.isContextSpecific((byte)1)) {
                val = AlgorithmId.parse((DerValue)data.getData().getDerValue());
                if (!val.getOID().equals(MGF1)) {
                    throw new IOException("Only MGF1 mgf is supported");
                }
                AlgorithmId params = AlgorithmId.parse((DerValue)new DerValue(val.getEncodedParams()));
                String tempName = params.getName();
                if ((tempName = IBMOAEPParameters.convertToStandardName(tempName)).equals("SHA-1")) {
                    this.MGFSpec = MGF1ParameterSpec.SHA1;
                    continue;
                }
                if (tempName.equals("SHA-224")) {
                    this.MGFSpec = MGF1ParameterSpec.SHA224;
                    continue;
                }
                if (tempName.equals("SHA-256")) {
                    this.MGFSpec = MGF1ParameterSpec.SHA256;
                    continue;
                }
                if (tempName.equals("SHA-384")) {
                    this.MGFSpec = MGF1ParameterSpec.SHA384;
                    continue;
                }
                if (tempName.equals("SHA-512")) {
                    this.MGFSpec = MGF1ParameterSpec.SHA512;
                    continue;
                }
                throw new IOException("Unrecognized parameter spec");
            }
            if (data.isContextSpecific((byte)2)) {
                val = AlgorithmId.parse((DerValue)data.getData().getDerValue());
                if (!val.getOID().equals(PSpec)) {
                    throw new IOException("Wrong OID for pSpecified");
                }
                DerInputStream dis = new DerInputStream(val.getEncodedParams());
                this.PSourceVal = dis.getOctetString();
                if (dis.available() != 0) {
                    throw new IOException("Extra data for pSpecified");
                }
                PSource pSource = this.PSrc = this.PSourceVal == null ? PSource.PSpecified.DEFAULT : new PSource.PSpecified(this.PSourceVal);
                if (this.PSourceVal != null) continue;
                this.PSourceVal = new byte[0];
                continue;
            }
            throw new IOException("Invalid encoded OAEPParameters");
        }
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        if (decodingMethod != null && !decodingMethod.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        this.engineInit(encoded);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (OAEPParameterSpec.class.isAssignableFrom(paramSpec)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(new OAEPParameterSpec(this.HASHALGO, this.MGFName, this.MGFSpec, this.PSrc)));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        AlgorithmId MGFAlgorithmId;
        AlgorithmId HASHAlgorithmId;
        DerOutputStream encoded = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        DerOutputStream temp2 = new DerOutputStream();
        try {
            HASHAlgorithmId = AlgorithmId.get((String)IBMOAEPParameters.convertToStandardName(this.HASHALGO));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("AlgorithmId " + this.HASHALGO + " impl not found");
        }
        HASHAlgorithmId.encode(temp);
        encoded.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), temp);
        temp = new DerOutputStream();
        temp.putOID(MGF1);
        try {
            MGFAlgorithmId = AlgorithmId.get((String)IBMOAEPParameters.convertToStandardName(this.MGFSpec.getDigestAlgorithm()));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("AlgorithmId " + this.MGFName + " impl not found");
        }
        MGFAlgorithmId.encode(temp);
        temp2 = new DerOutputStream();
        temp2.write((byte)48, temp);
        encoded.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), temp2);
        temp = new DerOutputStream();
        temp.putOID(PSpec);
        temp.putOctetString(this.PSourceVal);
        temp2 = new DerOutputStream();
        temp2.write((byte)48, temp);
        encoded.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), temp2);
        DerOutputStream out = new DerOutputStream();
        out.write((byte)48, encoded);
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        if (encodingMethod != null && !encodingMethod.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MD: " + this.HASHALGO + "\n");
        sb.append("MGF: MGF1 " + this.MGFSpec.getDigestAlgorithm() + "\n");
        sb.append("PSource: PSpecified " + (this.PSourceVal.length == 0 ? "" : new HexDumpEncoder().encodeBuffer(this.PSourceVal)) + "\n");
        return sb.toString();
    }

    static {
        try {
            MGF1 = new ObjectIdentifier("1.2.840.113549.1.1.8");
            PSpec = new ObjectIdentifier("1.2.840.113549.1.1.9");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

