/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPublicKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.ec.ECParameters;
import com.ibm.security.ec.ECPrivateKeyImpl;
import com.ibm.security.ec.ECPublicKeyImpl;
import com.ibm.security.ec.NamedCurve;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class PKCS11ECKeyFactory
extends KeyFactorySpi {
    private SessionManager sessionManager;
    private String algorithm;
    private Config config;
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11ECKeyFactory";

    public PKCS11ECKeyFactory(Provider provider) {
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
    }

    public PKCS11ECKeyFactory() {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    static ECParameterSpec getECParameterSpec(String name) {
        return NamedCurve.getECParameterSpec((String)name);
    }

    static ECParameterSpec getECParameterSpec(int keySize) {
        return NamedCurve.getECParameterSpec((int)keySize);
    }

    static ECParameterSpec getECParameterSpec(ECParameterSpec spec) {
        return ECParameters.getNamedCurve((ECParameterSpec)spec);
    }

    static ECParameterSpec decodeParameters(byte[] params) throws IOException {
        return ECParameters.decodeParameters((byte[])params);
    }

    static byte[] encodeParameters(ECParameterSpec params) {
        return ECParameters.encodeParameters((ECParameterSpec)params);
    }

    static ECPoint decodePoint(byte[] encoded, EllipticCurve curve) throws IOException {
        return ECParameters.decodePoint((byte[])encoded, (EllipticCurve)curve);
    }

    static byte[] getEncodedPublicValue(PublicKey key) throws InvalidKeyException {
        if (key instanceof ECPublicKeyImpl) {
            return ((ECPublicKeyImpl)key).getEncodedPublicValue();
        }
        if (key instanceof ECPublicKey) {
            ECPublicKey ecKey = (ECPublicKey)key;
            ECPoint w = ecKey.getW();
            ECParameterSpec params = ecKey.getParams();
            return ECParameters.encodePoint((ECPoint)w, (EllipticCurve)params.getCurve());
        }
        throw new InvalidKeyException("Key class not yet supported: " + key.getClass().getName());
    }

    @Override
    protected final Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof PublicKey) {
            PublicKey publicKey = this.implTranslatePublicKey((PublicKey)key);
            return publicKey;
        }
        if (key instanceof PrivateKey) {
            PrivateKey privateKey = this.implTranslatePrivateKey((PrivateKey)key);
            return privateKey;
        }
        throw new InvalidKeyException("Key must be instance of PublicKey or PrivateKey");
    }

    protected PublicKey implTranslatePublicKey(PublicKey key) throws InvalidKeyException {
        try {
            if (key instanceof ECPublicKey) {
                if (key instanceof PKCS11ECPublicKey) {
                    return key;
                }
                ECPublicKey ecKey = (ECPublicKey)key;
                return this.generatePublic(ecKey.getW(), ecKey.getParams());
            }
            if ("X.509".equals(key.getFormat())) {
                byte[] encoded = key.getEncoded();
                key = new ECPublicKeyImpl(encoded);
                return this.implTranslatePublicKey(key);
            }
            throw new InvalidKeyException("PublicKey must be instance of ECPublicKey or have X.509 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create EC public key", e);
        }
    }

    protected PrivateKey implTranslatePrivateKey(PrivateKey key) throws InvalidKeyException {
        try {
            if (key instanceof ECPrivateKey) {
                if (key instanceof PKCS11ECPrivateKey) {
                    return key;
                }
                ECPrivateKey ecKey = (ECPrivateKey)key;
                return this.generatePrivate(ecKey.getS(), ecKey.getParams());
            }
            if ("PKCS#8".equals(key.getFormat())) {
                byte[] encoded = key.getEncoded();
                key = new ECPrivateKeyImpl(encoded);
                return this.implTranslatePrivateKey(key);
            }
            throw new InvalidKeyException("PrivateKey must be instance of ECPrivateKey or have PKCS#8 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create EC private key", e);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                byte[] encoded = ((X509EncodedKeySpec)keySpec).getEncoded();
                ECPublicKeyImpl key = new ECPublicKeyImpl(encoded);
                return this.implTranslatePublicKey((PublicKey)key);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Could not create EC public key", e);
            }
        }
        if (!(keySpec instanceof ECPublicKeySpec)) {
            throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
        }
        try {
            ECPublicKeySpec ec = (ECPublicKeySpec)keySpec;
            return this.generatePublic(ec.getW(), ec.getParams());
        }
        catch (Exception e) {
            throw new InvalidKeySpecException("Could not create EC public key", e);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                byte[] encoded = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                ECPrivateKeyImpl key = new ECPrivateKeyImpl(encoded);
                return this.implTranslatePrivateKey((PrivateKey)key);
            }
            catch (GeneralSecurityException e) {
                throw new InvalidKeySpecException("Could not create EC private key", e);
            }
        }
        if (!(keySpec instanceof ECPrivateKeySpec)) {
            throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
        }
        try {
            ECPrivateKeySpec ec = (ECPrivateKeySpec)keySpec;
            return this.generatePrivate(ec.getS(), ec.getParams());
        }
        catch (Exception e) {
            throw new InvalidKeySpecException("Could not create EC private key", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey generatePublic(ECPoint point, ECParameterSpec params) throws PKCS11Exception, InvalidKeyException {
        byte[] encodedParams = ECParameters.encodeParameters((ECParameterSpec)params);
        byte[] pointdata = ECParameters.encodePoint((ECPoint)point, (EllipticCurve)params.getCurve());
        DerValue der = new DerValue(4, pointdata);
        byte[] encodedpoint = null;
        try {
            encodedpoint = der.toByteArray();
        }
        catch (IOException ex) {
            throw new InvalidKeyException(ex);
        }
        HashMap<Integer, Object> attributes = new HashMap<Integer, Object>();
        attributes.put(0, PKCS11Object.PUBLIC_KEY);
        attributes.put(256, PKCS11Object.EC);
        attributes.put(385, encodedpoint);
        attributes.put(384, encodedParams);
        if (this.config != null) {
            attributes.putAll(this.config.getAttributes("IMPORT", PKCS11Object.PUBLIC_KEY, PKCS11Object.EC));
        }
        int[] publicKeyTypes = new int[attributes.size()];
        Object[] publicKeyValues = new Object[attributes.size()];
        Iterator it = attributes.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            publicKeyTypes[i] = (Integer)entry.getKey();
            publicKeyValues[i++] = entry.getValue();
        }
        Session session = null;
        try {
            PKCS11ECPublicKey myPKCS11ECPublicKey;
            session = this.sessionManager.getObjSession();
            PKCS11Object obj = session.createObject(publicKeyTypes, publicKeyValues);
            if (!session.getBoolAttributeValue(obj, 1)) {
                session.addObject();
            }
            PKCS11ECPublicKey pKCS11ECPublicKey = myPKCS11ECPublicKey = new PKCS11ECPublicKey(session, obj, (byte[])attributes.get(258), (byte[])attributes.get(257), (String)attributes.get(3), encodedParams, encodedpoint);
            return pKCS11ECPublicKey;
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger s, ECParameterSpec params) throws PKCS11Exception, InvalidKeyException {
        HashMap<Integer, Object> attribs = new HashMap<Integer, Object>();
        if (this.config != null) {
            attribs.putAll(this.config.getAttributes("IMPORT", PKCS11Object.PRIVATE_KEY, PKCS11Object.EC));
        }
        attribs.put(0, PKCS11Object.PRIVATE_KEY);
        attribs.put(256, PKCS11Object.EC);
        attribs.put(17, PKCS11ECKeyFactory.getMagnitude(s));
        byte[] encodedParams = ECParameters.encodeParameters((ECParameterSpec)params);
        attribs.put(384, encodedParams);
        int[] privTypes = new int[attribs.size()];
        Object[] privValues = new Object[attribs.size()];
        Iterator it = attribs.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            privTypes[i] = (Integer)entry.getKey();
            privValues[i++] = entry.getValue();
        }
        Session session = null;
        try {
            PKCS11ECPrivateKey myPKCS11ECPrivateKey;
            session = this.sessionManager.getObjSession();
            PKCS11Object obj = session.createObject(privTypes, privValues);
            if (!session.getBoolAttributeValue(obj, 1)) {
                session.addObject();
            }
            PKCS11ECPrivateKey pKCS11ECPrivateKey = myPKCS11ECPrivateKey = new PKCS11ECPrivateKey(session, obj, (byte[])attribs.get(258), (byte[])attribs.get(257), (String)attribs.get(3), encodedParams, s);
            return pKCS11ECPrivateKey;
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        if (debug1 != null) {
            String keyString = key.toString();
            debug1.entry(16384L, (Object)className, "engineGetKeySpec", (Object)keyString, keySpec);
        }
        try {
            Class<T> ecPrivKeySpecClass;
            Class<T> ecPubKeySpecClass;
            if (key instanceof PKCS11ECPublicKey) {
                ecPubKeySpecClass = Class.forName("java.security.spec.ECPublicKeySpec");
                Class<T> x509KeySpecClass = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (ecPubKeySpecClass.isAssignableFrom(keySpec)) {
                    PKCS11ECPublicKey ecPubKey = (PKCS11ECPublicKey)key;
                    if (debug1 != null) {
                        debug1.text(16384L, (Object)className, "engineGetKeySpec", "The input key is a PKCS11ECPublicKey.  Returning an ECPublicKeySpec.");
                        debug1.exit(16384L, (Object)className, "engineGetKeySpec ");
                    }
                    return (T)new ECPublicKeySpec(ecPubKey.getW(), ecPubKey.getParams());
                }
                if (x509KeySpecClass.isAssignableFrom(keySpec)) {
                    if (debug1 != null) {
                        debug1.text(16384L, (Object)className, "engineGetKeySpec_1", "The input key is a PKCS11ECPublicKey.  Returning an X509EncodedKeySpec.");
                        debug1.exit(16384L, (Object)className, "engineGetKeySpec_1");
                    }
                    return (T)new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug1 != null) {
                    debug1.text(16384L, (Object)className, "engineGetKeySpec_2", "Inappropriate key specification");
                    debug1.exit(16384L, (Object)className, "engineGetKeySpec_2");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof ECPublicKey) {
                ecPubKeySpecClass = Class.forName("java.security.spec.ECPublicKeySpec");
                Class<T> x509KeySpecClass = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (ecPubKeySpecClass.isAssignableFrom(keySpec)) {
                    ECPublicKey ecPubKey = (ECPublicKey)key;
                    if (debug1 != null) {
                        debug1.text(16384L, (Object)className, "engineGetKeySpec_3", "The input key is an ECPublicKey.  Returning an ECPublicKeySpec.");
                        debug1.exit(16384L, (Object)className, "engineGetKeySpec_3");
                    }
                    return (T)new ECPublicKeySpec(ecPubKey.getW(), ecPubKey.getParams());
                }
                if (x509KeySpecClass.isAssignableFrom(keySpec)) {
                    if (debug1 != null) {
                        debug1.text(16384L, (Object)className, "engineGetKeySpec_4", "The input key is an ECPublicKey.  Returning an X509EncodedKeySpec.");
                        debug1.exit(16384L, (Object)className, "engineGetKeySpec_4");
                    }
                    return (T)new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug1 != null) {
                    debug1.text(16384L, (Object)className, "engineGetKeySpec_5", "Inappropriate key specification");
                    debug1.exit(16384L, (Object)className, "engineGetKeySpec_5");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof PKCS11ECPrivateKey) {
                ecPrivKeySpecClass = Class.forName("java.security.spec.ECPrivateKeySpec");
                Class<T> pkcs8KeySpecClass = Class.forName("java.security.spec.PKCS8EncodedKeySpec");
                if (ecPrivKeySpecClass.isAssignableFrom(keySpec)) {
                    PKCS11ECPrivateKey ecPrivKey = (PKCS11ECPrivateKey)key;
                    if (ecPrivKey.getSensitive().booleanValue()) {
                        if (debug1 != null) {
                            debug1.text(16384L, (Object)className, "engineGetKeySpec_6", "The input key is a PKCS11ECPrivateKey that is SENSITIVE.");
                            debug1.text(16384L, (Object)className, "engineGetKeySpec_6", "Private key value is not exportable.");
                            debug1.exit(16384L, (Object)className, "engineGetKeySpec_6");
                        }
                        throw new PKCS11Exception("Private key value is not exportable");
                    }
                    if (debug1 != null) {
                        debug1.text(16384L, (Object)className, "engineGetKeySpec_7", "The input key is a PKCS11ECPrivateKey.  Returning an ECPrivateKeySpec.");
                        debug1.exit(16384L, (Object)className, "engineGetKeySpec_7");
                    }
                    return (T)new ECPrivateKeySpec(ecPrivKey.getS(), ecPrivKey.getParams());
                }
                if (pkcs8KeySpecClass.isAssignableFrom(keySpec)) {
                    if (debug1 != null) {
                        debug1.text(16384L, (Object)className, "engineGetKeySpec_8", "The input key is a PKCS11ECPrivateKey.  Returning a PKCS8EncodedKeySpec.");
                        debug1.exit(16384L, (Object)className, "engineGetKeySpec_8");
                    }
                    return (T)new PKCS8EncodedKeySpec(key.getEncoded());
                }
                if (debug1 != null) {
                    debug1.text(16384L, (Object)className, "engineGetKeySpec_9", "Inappropriate key specification");
                    debug1.exit(16384L, (Object)className, "engineGetKeySpec_9");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof ECPrivateKey) {
                ecPrivKeySpecClass = Class.forName("java.security.spec.ECPrivateKeySpec");
                Class<T> pkcs8KeySpecClass = Class.forName("java.security.spec.PKCS8EncodedKeySpec");
                if (ecPrivKeySpecClass.isAssignableFrom(keySpec)) {
                    ECPrivateKey ecPrivKey = (ECPrivateKey)key;
                    if (debug1 != null) {
                        debug1.text(16384L, (Object)className, "engineGetKeySpec_10", "The input key is a ECPrivateKey.  Returning an ECPrivateKeySpec.");
                        debug1.exit(16384L, (Object)className, "engineGetKeySpec_10");
                    }
                    return (T)new ECPrivateKeySpec(ecPrivKey.getS(), ecPrivKey.getParams());
                }
                if (pkcs8KeySpecClass.isAssignableFrom(keySpec)) {
                    if (debug1 != null) {
                        debug1.text(16384L, (Object)className, "engineGetKeySpec_11", "The input key is a ECPrivateKey.  Returning a PKCS8EncodedKeySpec.");
                        debug1.exit(16384L, (Object)className, "engineGetKeySpec_11");
                    }
                    return (T)new PKCS8EncodedKeySpec(key.getEncoded());
                }
                if (debug1 != null) {
                    debug1.text(16384L, (Object)className, "engineGetKeySpec_12", "Inappropriate key specification");
                    debug1.exit(16384L, (Object)className, "engineGetKeySpec_12");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug1 != null) {
                debug1.text(16384L, (Object)className, "engineGetKeySpec_14", "Inappropriate key type");
                debug1.exit(16384L, (Object)className, "engineGetKeySpec_14");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException e) {
            if (debug1 != null) {
                debug1.exception(16384L, (Object)className, "engineGetKeySpec", (Throwable)e);
                debug1.exit(16384L, (Object)className, "engineGetKeySpec");
            }
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    public static byte[] getMagnitude(BigInteger bi) {
        byte[] b = bi.toByteArray();
        if (b.length > 1 && b[0] == 0) {
            int n = b.length - 1;
            byte[] newarray = new byte[n];
            System.arraycopy(b, 1, newarray, 0, n);
            b = newarray;
        }
        return b;
    }
}

