/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECKeyFactory;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.ec.ECPrivateKeyImpl;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.util.Date;

public final class PKCS11ECPrivateKey
extends PrivateKeyInfo
implements PKCS11PrivateKey,
ECPrivateKey {
    private PKCS11Object object = null;
    private Session session = null;
    private SessionManager sessionManager = null;
    static final long serialVersionUID = 49589318543531L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.EC;
    private byte[] id = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isSensitive = null;
    private Boolean isSecondaryAuth = null;
    private Integer authPinFlags = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private Boolean isSignRecover = null;
    private Boolean isUnwrap = null;
    private Boolean isExtractable = null;
    private Boolean isAlwaysSensitive = null;
    private Boolean isNeverExtractable = null;
    private BigInteger s;
    private ECParameterSpec params;
    private byte[] encoded;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11ECPrivateKey";

    public PKCS11ECPrivateKey(Session session, PKCS11Object object, byte[] id, byte[] subject, String label, byte[] parms) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS11ECPrivateKey");
        }
        this.sessionManager = session.getSessionManager();
        this.object = object;
        if (id != null) {
            this.id = new byte[id.length];
            System.arraycopy(id, 0, this.id, 0, id.length);
        } else {
            this.id = (byte[])this.getValue(session, this.object, 258);
        }
        if (subject != null) {
            this.subject = new byte[subject.length];
            System.arraycopy(subject, 0, this.subject, 0, subject.length);
        } else {
            this.subject = (byte[])this.getValue(session, this.object, 257);
        }
        this.label = label != null ? new String(label) : (String)this.getValue(session, this.object, 3);
        this.isToken = (Boolean)this.getValue(session, this.object, 1);
        this.isSensitive = (Boolean)this.getValue(session, this.object, 259);
        this.isSign = (Boolean)this.getValue(session, this.object, 264);
        this.isDecrypt = (Boolean)this.getValue(session, this.object, 261);
        this.isUnwrap = (Boolean)this.getValue(session, this.object, 263);
        this.isExtractable = (Boolean)this.getValue(session, this.object, 354);
        this.isPrivate = (Boolean)this.getValue(session, this.object, 2);
        this.isModifiable = (Boolean)this.getValue(session, this.object, 368);
        this.startDate = (Date)this.getValue(session, this.object, 272);
        this.endDate = (Date)this.getValue(session, this.object, 273);
        this.isDerive = (Boolean)this.getValue(session, this.object, 268);
        this.isLocal = (Boolean)this.getValue(session, this.object, 355);
        this.isSecondaryAuth = (Boolean)this.getValue(session, this.object, 512);
        this.authPinFlags = (Integer)this.getValue(session, this.object, 513);
        this.isSignRecover = (Boolean)this.getValue(session, this.object, 265);
        this.isAlwaysSensitive = (Boolean)this.getValue(session, this.object, 357);
        this.isNeverExtractable = (Boolean)this.getValue(session, this.object, 356);
        try {
            this.s = (BigInteger)this.getValue(session, this.object, 17);
        }
        catch (ClassCastException ex) {
            this.s = new BigInteger(1, (byte[])this.getValue(session, this.object, 17));
        }
        try {
            this.params = PKCS11ECKeyFactory.decodeParameters(parms);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse key values", e);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "PKCS11ECPrivateKey");
        }
    }

    public PKCS11ECPrivateKey(Session session, PKCS11Object object, byte[] id, byte[] subject, String label, byte[] parms, BigInteger value) throws InvalidKeyException {
        this(session, object, id, subject, label, parms);
        this.s = value;
    }

    @Override
    public Boolean getLocal() {
        return this.isLocal;
    }

    @Override
    public Boolean getSensitive() {
        return this.isSensitive;
    }

    @Override
    public byte[] getSubject() {
        if (this.subject == null) {
            return null;
        }
        return (byte[])this.subject.clone();
    }

    @Override
    public Boolean getAlwaysSensitive() {
        return this.isAlwaysSensitive;
    }

    @Override
    public Boolean getSign() {
        return this.isSign;
    }

    @Override
    public Boolean getSecondaryAuth() {
        return this.isSecondaryAuth;
    }

    @Override
    public Integer getAuthPinFlags() {
        return this.authPinFlags;
    }

    @Override
    public Boolean getDecrypt() {
        return this.isDecrypt;
    }

    @Override
    public Boolean getSignRecover() {
        return this.isSignRecover;
    }

    @Override
    public Boolean getUnwrap() {
        return this.isUnwrap;
    }

    @Override
    public Boolean getExtractable() {
        if (this.isExtractable == null) {
            return null;
        }
        return this.isExtractable;
    }

    @Override
    public Boolean getNeverExtractable() {
        return this.isNeverExtractable;
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public String getFormat() {
        return "PKCS#11";
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoded == null) {
            try {
                ECPrivateKeyImpl key = new ECPrivateKeyImpl(this.s, this.params);
                this.encoded = key.getEncoded();
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)"PKCS11ECPrivateKey", "getEncoded", (Throwable)e);
                }
                return null;
            }
        }
        return this.encoded;
    }

    @Override
    public BigInteger getS() {
        return this.s;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    @Override
    public PKCS11Object getObject() {
        return this.object;
    }

    @Override
    public byte[] getID() {
        return (byte[])this.id.clone();
    }

    @Override
    public Boolean getDerive() {
        return this.isDerive;
    }

    @Override
    public Boolean getModifiable() {
        return this.isModifiable;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public Boolean getToken() {
        if (debug != null) {
            System.out.println("PKCS11ECPrivateKey.java:  getToken( ):  Returning a value of:  " + this.isToken);
        }
        return this.isToken;
    }

    private Object getValue(Session session, PKCS11Object pkcs11obj, int attr) {
        return session.getAttrValue(pkcs11obj, attr);
    }

    @Override
    public Date getStartDate() {
        if (this.startDate != null) {
            return (Date)this.startDate.clone();
        }
        return null;
    }

    @Override
    public Date getEndDate() {
        if (this.endDate != null) {
            return (Date)this.endDate.clone();
        }
        return null;
    }

    @Override
    public Integer getKeyType() {
        return this.keyType;
    }

    @Override
    public Boolean getPrivate() {
        return this.isPrivate;
    }

    void setSession(Session sess) {
        this.session = sess;
    }

    @Override
    public void rm() {
        Session sess = null;
        if (this.session != null) {
            this.session.removeObject();
        }
        if (this.getObject() != null) {
            try {
                sess = this.sessionManager.getOpSession();
                sess.destroyObject(this.getObject());
                this.object = null;
                this.session = null;
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "finalize");
        }
        if (IBMPKCS11Impl.doMemoryManagement()) {
            if (!this.getToken().booleanValue()) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "finalize", "Free this PKCS11ECPrivateKey object since it is a session key.");
                }
                this.rm();
                super.finalize();
            } else if (debug != null) {
                debug.text(16384L, (Object)className, "finalize", "Do NOT free this PKCS11ECPrivateKey object since it is a token.");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "finalize");
        }
    }

    @Override
    public void setKeyAsToken(boolean token) {
        this.isToken = token;
    }
}

