/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECKeyFactory;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.KeyUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.EllipticCurve;

final class Signature {
    private MessageDigest msgdig;
    private PKCS11Key hw_key_to_delete = null;
    private boolean isSign;
    private int mechanism;
    private int modSize = 256;
    private int ecKeySize = 0;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.Signature";
    private Provider provider;

    protected Signature(int mechanism, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Signature", (Object)new Integer(mechanism));
        }
        this.mechanism = mechanism;
        this.provider = provider;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "Signature");
        }
    }

    protected void engineInitSign(Session sess, PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            String keyString = privateKey.toString();
            debug.entry(16384L, (Object)className, "engineInitSign", (Object)keyString);
        }
        this.isSign = true;
        PrivateKey ppkey = privateKey;
        if (!(privateKey instanceof RSAPrivateKey || privateKey instanceof DSAPrivateKey || privateKey instanceof PKCS11ECPrivateKey)) {
            Object kf;
            if (privateKey instanceof java.security.interfaces.RSAPrivateKey || privateKey instanceof RSAPrivateCrtKey || privateKey instanceof java.security.interfaces.DSAPrivateKey) {
                kf = null;
                String alg = privateKey.getAlgorithm();
                try {
                    if (alg.equalsIgnoreCase("DSA")) {
                        kf = KeyFactory.getInstance("DSA", this.provider);
                        ppkey = (PKCS11PrivateKey)((KeyFactory)kf).translateKey(privateKey);
                        this.hw_key_to_delete = (PKCS11Key)((Object)ppkey);
                    }
                    kf = KeyFactory.getInstance("RSA", this.provider);
                    ppkey = (PKCS11PrivateKey)((KeyFactory)kf).translateKey(privateKey);
                    this.hw_key_to_delete = (PKCS11Key)((Object)ppkey);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInitSign_1", (Throwable)new InvalidKeyException("Cannot convert private key: " + privateKey + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInitSign");
                    }
                    throw new InvalidKeyException("Cannot convert private key: " + privateKey + " with reason: " + e.getMessage());
                }
            } else if (privateKey instanceof ECPrivateKey) {
                try {
                    kf = new PKCS11ECKeyFactory(this.provider);
                    ppkey = ((PKCS11ECKeyFactory)kf).implTranslatePrivateKey(privateKey);
                    this.hw_key_to_delete = (PKCS11Key)((Object)ppkey);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInitSign_2", (Throwable)e);
                    }
                    throw new InvalidKeyException("Cannot convert private key: " + privateKey + " with reason: " + e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInitSign_2", (Throwable)new InvalidKeyException("not a PKCS11 DSA or PKCS11 RSA private key"));
                    debug.exit(16384L, (Object)className, "engineInitSign");
                }
                throw new InvalidKeyException("not a DSA or RSA private key: " + privateKey);
            }
        }
        PKCS11Object keyObject = null;
        if (ppkey instanceof RSAPrivateKey) {
            keyObject = ((RSAPrivateKey)ppkey).getObject();
            this.modSize = ((RSAPrivateKey)ppkey).getModulus().bitLength() / 8 + 10;
            RSAKeyFactory.checkKeyLengths((int)((RSAPrivateKey)ppkey).getModulus().bitLength(), (BigInteger)((RSAPrivateKey)ppkey).getPublicExponent(), (int)512, (int)Integer.MAX_VALUE);
        } else if (ppkey instanceof DSAPrivateKey) {
            keyObject = ((DSAPrivateKey)ppkey).getObject();
        } else if (ppkey instanceof PKCS11ECPrivateKey) {
            keyObject = ((PKCS11ECPrivateKey)ppkey).getObject();
        }
        sess.signInit(this.mechanism, null, keyObject);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitSign");
        }
    }

    protected void engineInitVerify(Session sess, PublicKey publicKey) throws InvalidKeyException {
        EllipticCurve curve;
        if (debug != null) {
            String keyString = publicKey.toString();
            debug.entry(16384L, (Object)className, "engineInitVerify", (Object)keyString);
        }
        this.isSign = false;
        PublicKey ppkey = publicKey;
        if (!(publicKey instanceof RSAPublicKey || publicKey instanceof DSAPublicKey || publicKey instanceof PKCS11ECPublicKey)) {
            KeyFactory kf;
            if (publicKey instanceof java.security.interfaces.RSAPublicKey || publicKey instanceof java.security.interfaces.DSAPublicKey) {
                kf = null;
                String alg = publicKey.getAlgorithm();
                try {
                    if (alg.equalsIgnoreCase("DSA")) {
                        kf = KeyFactory.getInstance("DSA", this.provider);
                        ppkey = (PKCS11PublicKey)kf.translateKey(publicKey);
                        this.hw_key_to_delete = (PKCS11Key)((Object)ppkey);
                    }
                    kf = KeyFactory.getInstance("RSA", this.provider);
                    ppkey = (PKCS11PublicKey)kf.translateKey(publicKey);
                    this.hw_key_to_delete = (PKCS11Key)((Object)ppkey);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInitVerify_1", (Throwable)new InvalidKeyException("Cannot convert public key: " + publicKey + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInitVerify");
                    }
                    throw new InvalidKeyException("Cannot convert public key: " + publicKey + " with reason: " + e.getMessage());
                }
            } else if (publicKey instanceof ECPublicKey) {
                try {
                    kf = KeyFactory.getInstance("EC", this.provider);
                    ppkey = (ECPublicKey)kf.translateKey(publicKey);
                    curve = ((PKCS11ECPublicKey)ppkey).getParams().getCurve();
                    this.ecKeySize = curve.getField().getFieldSize();
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineInitVerify_2", "Elliptic Curve key size: " + this.ecKeySize);
                    }
                    this.hw_key_to_delete = (PKCS11Key)((Object)ppkey);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInitVerify_2", (Throwable)e);
                    }
                    throw new InvalidKeyException("Cannot convert public key: " + publicKey + " with reason: " + e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInitVerify_2", (Throwable)new InvalidKeyException("not a DSA, RSA, or EC public key"));
                    debug.exit(16384L, (Object)className, "engineInitVerify");
                }
                throw new InvalidKeyException("not a DSA, RSA, or EC public key: " + publicKey);
            }
        }
        PKCS11Object keyObject = null;
        if (ppkey instanceof RSAPublicKey) {
            keyObject = ((RSAPublicKey)ppkey).getObject();
        }
        if (ppkey instanceof DSAPublicKey) {
            keyObject = ((DSAPublicKey)ppkey).getObject();
        } else if (ppkey instanceof PKCS11ECPublicKey) {
            keyObject = ((PKCS11ECPublicKey)ppkey).getObject();
            curve = ((PKCS11ECPublicKey)ppkey).getParams().getCurve();
            this.ecKeySize = curve.getField().getFieldSize();
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineInitVerify_2", "Elliptic Curve key size: " + this.ecKeySize);
            }
        }
        sess.verifyInit(this.mechanism, null, keyObject);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitVerify");
        }
    }

    protected void engineUpdate(Session sess, byte[] data, int off, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{data, new Integer(off), new Integer(len)};
            debug.entry(16384L, (Object)className, "engineUpdate", parms);
        }
        if (this.isSign) {
            sess.signUpdate(data, off, len);
        } else {
            sess.verifyUpdate(data, off, len);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineSign(Session sess) throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign");
        }
        int size = 0;
        byte[] signature = null;
        byte[] outdata = new byte[this.modSize];
        size = sess.signFinal(outdata, 0);
        signature = new byte[size];
        System.arraycopy(outdata, 0, signature, 0, size);
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineSign", "Sign() size = " + size);
            HexDumpEncoder hde = new HexDumpEncoder();
            debug.text(16384L, (Object)className, "engineSign", "outdata = " + hde.encode(outdata));
            debug.text(16384L, (Object)className, "engineSign", "signature = " + hde.encode(signature));
            debug.exit(16384L, (Object)className, "engineSign");
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return signature;
    }

    protected byte[] engineSign(Session session, byte[] data, int length) throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign", (Object)data, (Object)new Integer(length));
        }
        int size = 0;
        byte[] signature = null;
        byte[] outdata = new byte[this.modSize];
        size = session.sign(data, 0, length, outdata, 0);
        signature = new byte[size];
        System.arraycopy(outdata, 0, signature, 0, size);
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineSign", "Sign(data, len) size = " + size);
            HexDumpEncoder hde = new HexDumpEncoder();
            debug.text(16384L, (Object)className, "engineSign", "signature(data, len) = " + hde.encode(signature));
            debug.exit(16384L, (Object)className, "engineSign");
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return signature;
    }

    protected boolean engineVerify(Session sess, byte[] signature) throws SignatureException {
        boolean result = false;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineVerify", (Object)signature);
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineVerify", "signature.length = " + signature.length);
            HexDumpEncoder hde = new HexDumpEncoder();
            debug.text(16384L, (Object)className, "engineVerify", "signature = " + hde.encode(signature));
        }
        switch (this.mechanism) {
            case 18: {
                byte[] signingBytes;
                if (signature.length != 40) {
                    HexDumpEncoder hde;
                    signingBytes = this.asn1ToDSA(signature);
                    if (debug != null) {
                        hde = new HexDumpEncoder();
                        debug.text(16384L, (Object)className, "engineVerify", "signingBytes = " + hde.encode(signingBytes));
                    }
                    result = sess.verifyFinal(signingBytes, 0, signingBytes.length);
                    if (debug == null) break;
                    debug.text(16384L, (Object)className, "engineVerify", "signature result = " + result);
                    hde = new HexDumpEncoder();
                    debug.text(16384L, (Object)className, "engineVerify", "signingBytes = " + hde.encode(signingBytes));
                    break;
                }
                result = sess.verifyFinal(signature, 0, signature.length);
                break;
            }
            case 4161: 
            case 4162: {
                byte[] signingBytes = this.asn1ToECDSA(signature);
                result = sess.verifyFinal(signingBytes, 0, signingBytes.length);
                break;
            }
            default: {
                result = sess.verifyFinal(signature, 0, signature.length);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineVerify");
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return result;
    }

    protected boolean engineVerify(Session sess, byte[] signature, byte[] data, int length) throws SignatureException {
        boolean result = false;
        if (debug != null) {
            Object[] parms = new Object[]{signature, data, new Integer(length)};
            debug.entry(16384L, (Object)className, "engineVerify", parms);
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineVerify", "signature.length = " + signature.length);
            HexDumpEncoder hde = new HexDumpEncoder();
            debug.text(16384L, (Object)className, "engineVerify", "signature = " + hde.encode(signature));
        }
        switch (this.mechanism) {
            case 18: {
                byte[] signingBytes;
                if (signature.length != 40) {
                    HexDumpEncoder hde;
                    signingBytes = this.asn1ToDSA(signature);
                    if (debug != null) {
                        hde = new HexDumpEncoder();
                        debug.text(16384L, (Object)className, "engineVerify", "signingBytes = " + hde.encode(signingBytes));
                    }
                    result = sess.verify(data, 0, length, signingBytes, 0, signingBytes.length);
                    if (debug == null) break;
                    debug.text(16384L, (Object)className, "engineVerify", "signature result = " + result);
                    hde = new HexDumpEncoder();
                    debug.text(16384L, (Object)className, "engineVerify", "signingBytes = " + hde.encode(signingBytes));
                    break;
                }
                result = sess.verify(data, 0, length, signature, 0, signature.length);
                break;
            }
            case 4161: 
            case 4162: {
                byte[] signingBytes = this.asn1ToECDSA(signature);
                result = sess.verify(data, 0, length, signingBytes, 0, signingBytes.length);
                break;
            }
            default: {
                result = sess.verify(data, 0, length, signature, 0, signature.length);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineVerify");
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return result;
    }

    protected void engineDummyVerify(Session sess, String algorithm) {
        try {
            byte[] signature = algorithm.indexOf("DSA") > 0 ? new byte[40] : new byte[this.modSize];
            sess.verifyFinal(signature, 0, signature.length);
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
    }

    private byte[] asn1ToECDSA(byte[] sig) throws SignatureException {
        try {
            DerInputStream in = new DerInputStream(sig, 0, sig.length, false);
            DerValue[] values = in.getSequence(2);
            if (values.length != 2 || in.available() != 0) {
                throw new IOException("Invalid encoding for signature");
            }
            BigInteger r = values[0].getPositiveBigInteger();
            BigInteger s = values[1].getPositiveBigInteger();
            byte[] br = KeyUtil.trimZeroes((byte[])r.toByteArray());
            byte[] bs = KeyUtil.trimZeroes((byte[])s.toByteArray());
            int k = Math.max(br.length, bs.length);
            byte[] res = new byte[k << 1];
            System.arraycopy(br, 0, res, k - br.length, br.length);
            System.arraycopy(bs, 0, res, res.length - bs.length, bs.length);
            return res;
        }
        catch (Exception e) {
            throw new SignatureException("Invalid encoding for signature", e);
        }
    }

    private byte[] asn1ToDSA(byte[] signature) throws SignatureException {
        byte[] signingBytes = new byte[40];
        if (signature.length < 4) {
            throw new SignatureException("Invalid signature length: " + signature.length);
        }
        int lenr = signature[3];
        if (lenr + 3 + 2 < 0) {
            throw new SignatureException("Decoded invalid value from signature: " + lenr);
        }
        if (signature.length < lenr + 3 + 2 + 1) {
            throw new SignatureException("Invalid signature length: " + signature.length);
        }
        int lens = signature[lenr + 3 + 2];
        int startPosR = 4;
        int startPosS = lenr + 6;
        if (lens > 20) {
            lens = 20;
            startPosS = lenr + 6 + 1;
        }
        if (lenr > 20) {
            lenr = 20;
            startPosR = 5;
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineVerify", "signature len = " + signature[1]);
            debug.text(16384L, (Object)className, "engineVerify", "signature lenr = " + lenr);
            debug.text(16384L, (Object)className, "engineVerify", "signature lens = " + lens);
            debug.text(16384L, (Object)className, "engineVerify", "signature startPosR = " + startPosR);
            debug.text(16384L, (Object)className, "engineVerify", "signature startPosS = " + startPosS);
        }
        try {
            System.arraycopy(signature, startPosR, signingBytes, 0 + (20 - lenr), lenr);
            System.arraycopy(signature, startPosS, signingBytes, 20 + (20 - lens), lens);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new SignatureException("Invalid signature length.");
        }
        return signingBytes;
    }
}

