/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.misc.BASE64Decoder;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.util.Cache;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class X509Factory
extends CertificateFactorySpi {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static int defaultExpectedLineLength = 80;
    private static char[] endBoundary = new char[]{'-', '-', '-', '-', '-', 'E', 'N', 'D'};
    private static final int ENC_MAX_LENGTH = 0x400000;
    private static final Cache certCache = Cache.newSoftMemoryCache((int)750);
    private Iterator supported_encodings;
    protected static final String pkcs7String = "PKCS7";
    protected static final String pkipString = "PkiPath";
    protected static final String x509String = "X.509";
    private ArrayList supported_encodings_vector = new ArrayList(2);
    private Provider provider = null;
    boolean isZOS = System.getProperty("os.name").equalsIgnoreCase("Z/OS") | true | false;

    public X509Factory() {
        this.supported_encodings_vector.add(pkipString);
        this.supported_encodings_vector.add(pkcs7String);
        this.supported_encodings = Collections.unmodifiableList(this.supported_encodings_vector).iterator();
        this.provider = Security.getProvider("IBMPKCS11Impl");
    }

    public X509Factory(Provider provider) {
        this.supported_encodings_vector.add(pkipString);
        this.supported_encodings_vector.add(pkcs7String);
        this.supported_encodings = Collections.unmodifiableList(this.supported_encodings_vector).iterator();
        this.provider = provider;
    }

    @Override
    public Certificate engineGenerateCertificate(InputStream is) throws CertificateException {
        if (is == null) {
            certCache.clear();
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] encoding;
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            if ((encoding = X509Factory.readSequence(is)) != null) {
                X509CertImpl cert = new X509CertImpl(encoding, this.provider.getName());
                return cert;
            }
            if (this.isBase64(is)) {
                byte[] data = this.base64_to_binary(is);
                return new X509CertImpl(data, this.provider.getName());
            }
            return new X509CertImpl(is, this.provider.getName());
        }
        catch (IOException ioe) {
            throw new CertificateException(ioe.getMessage());
        }
    }

    private static byte[] readSequence(InputStream in) throws IOException {
        int totalLength;
        int valueLength;
        in.mark(0x400000);
        byte[] b = new byte[4];
        int i = X509Factory.readFully(in, b, 0, b.length);
        if (i != b.length || b[0] != 48) {
            in.reset();
            return null;
        }
        i = b[1] & 0xFF;
        if (i < 128) {
            valueLength = i;
            totalLength = valueLength + 2;
        } else if (i == 129) {
            valueLength = b[2] & 0xFF;
            totalLength = valueLength + 3;
        } else if (i == 130) {
            valueLength = (b[2] & 0xFF) << 8 | b[3] & 0xFF;
            totalLength = valueLength + 4;
        } else {
            in.reset();
            return null;
        }
        if (totalLength > 0x400000) {
            in.reset();
            return null;
        }
        byte[] encoding = new byte[totalLength];
        System.arraycopy(b, 0, encoding, 0, b.length);
        int n = totalLength - b.length;
        i = X509Factory.readFully(in, encoding, b.length, n);
        if (i != n) {
            in.reset();
            return null;
        }
        return encoding;
    }

    private static int readFully(InputStream in, byte[] buffer, int offset, int length) throws IOException {
        int n;
        int read = 0;
        while (length > 0 && (n = in.read(buffer, offset, length)) > 0) {
            read += n;
            length -= n;
            offset += n;
        }
        return read;
    }

    public synchronized X509CertImpl intern(X509Certificate c) throws CertificateException {
        if (c == null) {
            return null;
        }
        boolean isImpl = c instanceof X509CertImpl;
        byte[] encoding = isImpl ? ((X509CertImpl)c).getEncodedInternal() : c.getEncoded();
        X509CertImpl newC = (X509CertImpl)X509Factory.getFromCache(certCache, encoding);
        if (newC != null) {
            return newC;
        }
        if (isImpl) {
            newC = (X509CertImpl)c;
        } else {
            newC = new X509CertImpl(encoding, this.provider.getName());
            encoding = newC.getEncodedInternal();
        }
        X509Factory.addToCache(certCache, encoding, newC);
        return newC;
    }

    private static synchronized Object getFromCache(Cache cache, byte[] encoding) {
        Cache.EqualByteArray key = new Cache.EqualByteArray(encoding);
        Object value = cache.get((Object)key);
        return value;
    }

    private static synchronized void addToCache(Cache cache, byte[] encoding, Object value) {
        if (encoding.length > 0x400000) {
            return;
        }
        Cache.EqualByteArray key = new Cache.EqualByteArray(encoding);
        cache.put((Object)key, value);
    }

    public Collection engineGenerateCertificates(InputStream is) throws CertificateException {
        if (is == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            return this.parseX509orPKCS7Cert(is);
        }
        catch (IOException ioe) {
            throw new CertificateException(ioe.getMessage());
        }
    }

    @Override
    public CRL engineGenerateCRL(InputStream is) throws CRLException {
        if (is == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            if (this.isBase64(is)) {
                byte[] data = this.base64_to_binary(is);
                return new X509CRLImpl(data);
            }
            return new X509CRLImpl(is);
        }
        catch (IOException ioe) {
            throw new CRLException(ioe.getMessage());
        }
    }

    public Collection engineGenerateCRLs(InputStream is) throws CRLException {
        if (is == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            return this.parseX509orPKCS7CRL(is);
        }
        catch (IOException ioe) {
            throw new CRLException(ioe.getMessage());
        }
    }

    private Collection parseX509orPKCS7Cert(InputStream is) throws CertificateException, IOException {
        ArrayList<X509CertImpl> coll = new ArrayList<X509CertImpl>();
        boolean first = true;
        while (is.available() != 0) {
            InputStream is2 = is;
            if (this.isBase64(is2)) {
                is2 = new ByteArrayInputStream(this.base64_to_binary(is2));
            }
            if (first) {
                is2.mark(is2.available());
            }
            try {
                coll.add(new X509CertImpl(is2, this.provider.getName()));
            }
            catch (CertificateException e) {
                if (first) {
                    is2.reset();
                    byte[] data = new byte[is2.available()];
                    is2.read(data);
                    Certificate[] certs = null;
                    try {
                        SignedData pkcs7data = new SignedData(data, this.provider.getName());
                        certs = pkcs7data.getCertificates();
                    }
                    catch (IOException e1) {
                        try {
                            ContentInfo cif = new ContentInfo(data, this.provider.getName());
                            Content ct = cif.getContent();
                            if (ct instanceof SignedData) {
                                certs = ((SignedData)ct).getCertificates();
                            }
                        }
                        catch (IOException e2) {
                            throw new CertificateException("Fail to parse input stream");
                        }
                    }
                    if (certs != null) {
                        return Arrays.asList(certs);
                    }
                    return new ArrayList(0);
                }
                throw e;
            }
            if (!first) continue;
            first = false;
        }
        return coll;
    }

    private Collection parseX509orPKCS7CRL(InputStream is) throws CRLException, IOException {
        ArrayList<X509CRLImpl> coll = new ArrayList<X509CRLImpl>();
        boolean first = true;
        while (is.available() != 0) {
            InputStream is2 = is;
            if (this.isBase64(is)) {
                is2 = new ByteArrayInputStream(this.base64_to_binary(is2));
            }
            if (first) {
                is2.mark(is2.available());
            }
            try {
                coll.add(new X509CRLImpl(is2));
            }
            catch (CRLException e) {
                if (first) {
                    is2.reset();
                    byte[] data = new byte[is2.available()];
                    is2.read(data);
                    X509CRL[] crls = null;
                    try {
                        SignedData pkcs7data = new SignedData(data, this.provider.getName());
                        crls = (X509CRL[])pkcs7data.getCRLs();
                    }
                    catch (IOException e1) {
                        try {
                            ContentInfo cif = new ContentInfo(data, this.provider.getName());
                            Content ct = cif.getContent();
                            if (ct instanceof SignedData) {
                                crls = (X509CRL[])((SignedData)ct).getCRLs();
                            }
                        }
                        catch (IOException e2) {
                            throw new CRLException("Fail to parse input stream");
                        }
                    }
                    if (crls != null) {
                        return Arrays.asList(crls);
                    }
                    return new ArrayList(0);
                }
                throw e;
            }
            if (!first) continue;
            first = false;
        }
        return coll;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] base64_to_binary(InputStream is) throws IOException {
        long len = 0L;
        is.mark(is.available());
        BufferedInputStream bufin = new BufferedInputStream(is);
        InputStreamReader isr = null;
        try {
            if (this.isZOS) {
                if (this.getBase64Codepage(is).equalsIgnoreCase("8859_1")) {
                    isr = new InputStreamReader((InputStream)bufin, "8859_1");
                } else {
                    if (!this.getBase64Codepage(is).equalsIgnoreCase("IBM-1047")) throw new IOException("Unsupported codepage for encoding.");
                    isr = new InputStreamReader((InputStream)bufin, "IBM-1047");
                }
            } else {
                isr = new InputStreamReader((InputStream)bufin, "8859_1");
            }
        }
        catch (UnsupportedEncodingException e) {
            isr = new InputStreamReader(bufin);
        }
        BufferedReader br = new BufferedReader(isr);
        String temp = this.readLine(br);
        if (temp == null || !temp.startsWith("-----BEGIN")) {
            throw new IOException("Unsupported encoding");
        }
        len += (long)temp.length();
        StringBuffer strBuf = new StringBuffer();
        while ((temp = this.readLine(br)) != null && !temp.startsWith("-----END")) {
            strBuf.append(temp);
        }
        if (temp == null) {
            throw new IOException("Unsupported encoding");
        }
        len += (long)temp.length();
        is.reset();
        is.skip(len += (long)strBuf.length());
        BASE64Decoder decoder = new BASE64Decoder();
        return decoder.decodeBuffer(strBuf.toString());
    }

    private byte[] getTotalBytes(InputStream is) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        baos.reset();
        while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, n);
        }
        return baos.toByteArray();
    }

    private boolean isBase64(InputStream is) throws IOException {
        if (is.available() >= 10) {
            is.mark(10);
            int c1 = is.read();
            int c2 = is.read();
            int c3 = is.read();
            int c4 = is.read();
            int c5 = is.read();
            int c6 = is.read();
            int c7 = is.read();
            int c8 = is.read();
            int c9 = is.read();
            int c10 = is.read();
            is.reset();
            if (c1 == 45 && c2 == 45 && c3 == 45 && c4 == 45 && c5 == 45 && c6 == 66 && c7 == 69 && c8 == 71 && c9 == 73 && c10 == 78) {
                return true;
            }
            return c1 == 96 && c2 == 96 && c3 == 96 && c4 == 96 && c5 == 96 && c6 == 194 && c7 == 197 && c8 == 199 && c9 == 201 && c10 == 213 && this.isZOS;
        }
        return false;
    }

    private String getBase64Codepage(InputStream is) throws IOException {
        if (is.available() >= 1) {
            is.mark(1);
            int c1 = is.read();
            is.reset();
            if (c1 == 45) {
                return "8859_1";
            }
            if (c1 == 96) {
                return "IBM-1047";
            }
            throw new IOException("Unknown Encoding.");
        }
        throw new IOException("Cannot determine encoding format.");
    }

    private String readLine(BufferedReader br) throws IOException {
        int c;
        int i = 0;
        boolean isMatch = true;
        boolean matched = false;
        StringBuffer sb = new StringBuffer(defaultExpectedLineLength);
        do {
            c = br.read();
            if (isMatch && i < endBoundary.length) {
                boolean bl = isMatch = (char)c == endBoundary[i++];
            }
            if (!matched) {
                matched = isMatch && i == endBoundary.length;
            }
            sb.append((char)c);
        } while (c != -1 && c != 10 && c != 13);
        if (!matched && c == -1) {
            return null;
        }
        if (c == 13) {
            br.mark(1);
            int c2 = br.read();
            if (c2 == 10) {
                sb.append((char)c);
            } else {
                br.reset();
            }
        }
        return sb.toString();
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException("input stream is null");
        }
        Class<?> certPathImplCls = null;
        Constructor constructor = null;
        try {
            byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(inStream));
            ByteArrayInputStream bais = new ByteArrayInputStream(totalBytes);
            if (this.isBase64(bais)) {
                totalBytes = this.base64_to_binary(bais);
            }
            DerInputStream dis = new DerInputStream(totalBytes);
            DerValue[] seq = dis.getSequence(3);
            final Object[] params = new Object[2];
            try {
                Class<?> certPathImplClstemp;
                certPathImplCls = certPathImplClstemp = Class.forName("com.ibm.security.cert.CertPathImpl");
                if (certPathImplCls == null) {
                    return null;
                }
                final Class[] ctrParams = new Class[]{String.class, List.class};
                constructor = (Constructor)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Constructor cotemp = null;
                            cotemp = certPathImplClstemp.getDeclaredConstructor(ctrParams);
                            cotemp.setAccessible(true);
                            return cotemp;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                });
                if (constructor == null) {
                    return null;
                }
            }
            catch (Exception ee) {
                return null;
            }
            final Constructor constructortemp = constructor;
            if (seq.length == 0) {
                params[0] = x509String;
                params[1] = Collections.EMPTY_LIST;
                CertPath cp = null;
                cp = (CertPath)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return (CertPath)constructortemp.newInstance(params);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                });
                return cp;
            }
            ArrayList<Certificate> certList = new ArrayList<Certificate>(seq.length);
            for (int i = seq.length - 1; i >= 0; --i) {
                ByteArrayInputStream bis = new ByteArrayInputStream(seq[i].toByteArray());
                certList.add(this.engineGenerateCertificate(bis));
                bis.close();
            }
            params[0] = x509String;
            params[1] = Collections.unmodifiableList(certList);
            CertPath cp = null;
            try {
                cp = (CertPath)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return (CertPath)constructortemp.newInstance(params);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                });
                return cp;
            }
            catch (Exception ee) {
                return null;
            }
        }
        catch (IOException ioe) {
            throw new CertificateException("IOException parsing PkiPath data: " + ioe);
        }
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        CertPath certPath = null;
        if (encoding.equals(pkcs7String)) {
            Collection certCollection = this.engineGenerateCertificates(inStream);
            LinkedList<X509Certificate> myList = new LinkedList<X509Certificate>();
            for (X509Certificate thisCert : certCollection) {
                myList.add(thisCert);
            }
            certPath = this.engineGenerateCertPath(myList);
        } else if (encoding.equals(pkipString)) {
            certPath = this.engineGenerateCertPath(inStream);
        } else {
            throw new CertificateException("Encoding: " + encoding + " not valid.");
        }
        return certPath;
    }

    public CertPath engineGenerateCertPath(List certificates) throws CertificateException {
        LinkedList<X509Certificate> certPathList = new LinkedList<X509Certificate>();
        X509Certificate[] certs = new X509Certificate[certificates.size()];
        boolean match = false;
        boolean matchCount = false;
        int numberOfCertificates = certificates.size();
        boolean numberOfCertificatesAdded = false;
        boolean ordered = false;
        try {
            certificates.toArray(certs);
        }
        catch (ArrayStoreException asex) {
            throw new CertificateException("Not X.509 certificates");
        }
        for (int i = 0; i < certs.length; ++i) {
            certPathList.add(certs[i]);
        }
        Class<?> certPathImplCls = null;
        Constructor constructor = null;
        try {
            Class<?> certPathImplClstemp;
            certPathImplCls = certPathImplClstemp = Class.forName("com.ibm.security.cert.CertPathImpl");
            if (certPathImplCls == null) {
                return null;
            }
            final Class[] params = new Class[]{String.class, List.class};
            constructor = (Constructor)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Constructor cotemp = null;
                        cotemp = certPathImplClstemp.getDeclaredConstructor(params);
                        cotemp.setAccessible(true);
                        return cotemp;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            if (constructor == null) {
                return null;
            }
        }
        catch (Exception ee) {
            return null;
        }
        final Object[] params = new Object[]{x509String, certPathList};
        final Constructor constructortemp = constructor;
        CertPath cp = null;
        try {
            cp = (CertPath)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return (CertPath)constructortemp.newInstance(params);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            return cp;
        }
        catch (Exception ee) {
            return null;
        }
    }

    public Iterator engineGetCertPathEncodings() {
        return this.supported_encodings;
    }
}

