/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IBMSASL
extends Provider {
    private static final long serialVersionUID = 8622598936488630849L;
    protected static Logger logger;
    private static final String SASL_LOGGER_NAME = "javax.security.sasl";
    private static final String info = "IBM SASL provider(implements client mechanisms for: DIGEST-MD5, GSSAPI, EXTERNAL, PLAIN, CRAM-MD5, NTLM; server mechanisms for: DIGEST-MD5, GSSAPI, CRAM-MD5, NTLM)";

    public IBMSASL() {
        super("IBMSASL", 1.8, info);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                IBMSASL.this.put("SaslClientFactory.DIGEST-MD5", "com.ibm.security.sasl.digest.FactoryImpl");
                IBMSASL.this.put("SaslClientFactory.NTLM", "com.ibm.security.sasl.ntlm.FactoryImpl");
                IBMSASL.this.put("SaslClientFactory.GSSAPI", "com.ibm.security.sasl.gsskerb.FactoryImpl");
                IBMSASL.this.put("SaslClientFactory.EXTERNAL", "com.ibm.security.sasl.ClientFactoryImpl");
                IBMSASL.this.put("SaslClientFactory.PLAIN", "com.ibm.security.sasl.ClientFactoryImpl");
                IBMSASL.this.put("SaslClientFactory.CRAM-MD5", "com.ibm.security.sasl.ClientFactoryImpl");
                IBMSASL.this.put("SaslServerFactory.CRAM-MD5", "com.ibm.security.sasl.ServerFactoryImpl");
                IBMSASL.this.put("SaslServerFactory.GSSAPI", "com.ibm.security.sasl.gsskerb.FactoryImpl");
                IBMSASL.this.put("SaslServerFactory.DIGEST-MD5", "com.ibm.security.sasl.digest.FactoryImpl");
                IBMSASL.this.put("SaslServerFactory.NTLM", "com.ibm.security.sasl.ntlm.FactoryImpl");
                return null;
            }
        });
        try {
            IBMSASL.initLogger();
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, "IBMSASL", "<init>", "IBMSASL Build-Level: -" + IBMSASL.getDebugDate("com.ibm.security.sasl.IBMSASL"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getDebugDate(String className) {
        String versionDate = "Unknown";
        try {
            Class<?> thisClass = Class.forName(className);
            Package thisPackage = thisClass.getPackage();
            String versionInfo = thisPackage.getImplementationVersion();
            int index = versionInfo.indexOf("_");
            versionDate = versionInfo.substring(index + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return versionDate;
    }

    private static synchronized void initLogger() {
        if (logger == null) {
            logger = Logger.getLogger(SASL_LOGGER_NAME);
        }
    }
}

