/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl.digest;

import com.ibm.security.sasl.digest.DigestMD5Client;
import com.ibm.security.sasl.digest.DigestMD5Server;
import com.ibm.security.sasl.util.PolicyUtils;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public final class FactoryImpl
implements SaslClientFactory,
SaslServerFactory {
    private static final String[] myMechs = new String[]{"DIGEST-MD5"};
    private static final int DIGEST_MD5 = 0;
    private static final int[] mechPolicies = new int[]{17};

    @Override
    public SaslClient createSaslClient(String[] mechs, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (int i = 0; i < mechs.length; ++i) {
            if (!mechs[i].equals(myMechs[0]) || !PolicyUtils.checkPolicy(mechPolicies[0], props)) continue;
            if (cbh == null) {
                throw new SaslException("Callback handler with support for RealmChoiceCallback, RealmCallback, NameCallback, and PasswordCallback required");
            }
            return new DigestMD5Client(authorizationId, protocol, serverName, props, cbh);
        }
        return null;
    }

    @Override
    public SaslServer createSaslServer(String mech, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        if (mech.equals(myMechs[0]) && PolicyUtils.checkPolicy(mechPolicies[0], props)) {
            if (cbh == null) {
                throw new SaslException("Callback handler with support for AuthorizeCallback, RealmCallback, NameCallback, and PasswordCallback required");
            }
            return new DigestMD5Server(protocol, serverName, props, cbh);
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> env) {
        return PolicyUtils.filterMechs(myMechs, mechPolicies, env);
    }
}

