/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;

public class CertPathSystemProperties {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private static boolean onlyEECert = false;
    private static boolean enableCRLDP = false;
    private static boolean enableNULLCRLDP = false;
    private static boolean enableDELTACRL = false;
    private static boolean enableAIAEXT = false;
    private static boolean enableOCSP = false;
    private static String ocspResponderURL = null;
    private static String ocspResponderCertSubjectName = null;
    private static String ocspResponderCertIssuerName = null;
    private static String ocspResponderCertSerialNumber = null;
    private static String ocspConnectTimeout = null;
    private static final int DEFAULT_OCSP_CONNECT_TIMEOUT = 15000;
    private static String crlsConnectTimeout = null;
    private static final int DEFAULT_CRLS_CONNECT_TIMEOUT = 15000;
    private static String ocspClockSkew = null;
    private static final int DEFAULT_OCSP_CLOCK_SKEW = 900000;

    public static boolean getOnlyEECert() {
        return onlyEECert;
    }

    public static boolean getEnableCRLDP() {
        return enableCRLDP;
    }

    public static boolean getEnableNULLCRLDP() {
        return enableNULLCRLDP;
    }

    public static boolean getEnableAIAEXT() {
        return enableAIAEXT;
    }

    public static boolean getEnableOCSP() {
        return enableOCSP;
    }

    public static String getOCSPResponderURL() {
        return ocspResponderURL;
    }

    public static String getOCSPResponderCertSubjectName() {
        return ocspResponderCertSubjectName;
    }

    public static String getOCSPResponderCertIssuerName() {
        return ocspResponderCertIssuerName;
    }

    public static String getOCSPResponderCertSerialNumber() {
        return ocspResponderCertSerialNumber;
    }

    public static int getOCSPConnectTimeout() {
        int timeout;
        if (ocspConnectTimeout != null) {
            timeout = new Integer(ocspConnectTimeout);
            if ((timeout *= 1000) < 0) {
                timeout = 15000;
            }
        } else {
            timeout = 15000;
        }
        return timeout;
    }

    public static int getCRLSConnectTimeout() {
        int timeout;
        if (crlsConnectTimeout != null) {
            timeout = new Integer(crlsConnectTimeout);
            if ((timeout *= 1000) < 0) {
                timeout = 15000;
            }
        } else {
            timeout = 15000;
        }
        return timeout;
    }

    public static int getOCSPClockSkew() {
        int clockSkew;
        if (ocspClockSkew != null) {
            clockSkew = new Integer(ocspClockSkew);
            if ((clockSkew *= 1000) < 0) {
                clockSkew = 900000;
            }
        } else {
            clockSkew = 900000;
        }
        return clockSkew;
    }

    public static void main(String[] args) {
        CertPathSystemProperties myProperties = new CertPathSystemProperties();
        System.out.println("=============================================================================================");
        System.out.println("\n\n\nCertpathSystemProperties.java:  main():  getOnlyEECert() returned:                     " + CertPathSystemProperties.getOnlyEECert());
        System.out.println("CertpathSystemProperties.java:  main():  getEnableCRLDP() returned:                    " + CertPathSystemProperties.getEnableCRLDP());
        System.out.println("CertpathSystemProperties.java:  main():  getEnableNULLCRLDP() returned:                " + CertPathSystemProperties.getEnableNULLCRLDP());
        System.out.println("CertpathSystemProperties.java:  main():  getEnableAIAEXT() returned:                   " + CertPathSystemProperties.getEnableAIAEXT());
        System.out.println("CertpathSystemProperties.java:  main():  getEnableOCSP() returned:                     " + CertPathSystemProperties.getEnableOCSP());
        System.out.println("CertpathSystemProperties.java:  main():  getOCSPResponderURL() returned:               " + CertPathSystemProperties.getOCSPResponderURL());
        System.out.println("CertpathSystemProperties.java:  main():  getOCSPResponderCertSubjectName() returned:   " + CertPathSystemProperties.getOCSPResponderCertSubjectName());
        System.out.println("CertpathSystemProperties.java:  main():  getOCSPResponderCertIssuerName() returned:    " + CertPathSystemProperties.getOCSPResponderCertIssuerName());
        System.out.println("CertpathSystemProperties.java:  main():  getOCSPResponderCertSerialNumber() returned:  " + CertPathSystemProperties.getOCSPResponderCertSerialNumber());
        System.out.println("CertpathSystemProperties.java:  main():  getOCSPConnectTimeout() returned:             " + CertPathSystemProperties.getOCSPConnectTimeout());
        System.out.println("CertpathSystemProperties.java:  main():  getOCSPClockSkew() returned:                  " + CertPathSystemProperties.getOCSPClockSkew());
        System.out.println("CertpathSystemProperties.java:  main():  getCRLSConnectTimeout() returned:             " + CertPathSystemProperties.getCRLSConnectTimeout());
    }

    static {
        String enabled = null;
        enabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.security.onlyCheckRevocationOfEECert");
            }
        });
        onlyEECert = new Boolean(enabled);
        if (debug != null) {
            System.out.println("CertPathSystemProperties.java:  com.ibm.security.onlyCheckRevocationOfEECert = " + onlyEECert);
        }
        enabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.security.enableCRLDP");
            }
        });
        enableCRLDP = new Boolean(enabled);
        if (debug != null) {
            System.out.println("CertPathSystemProperties.java:  com.ibm.security.enableCRLDP = " + enableCRLDP);
        }
        enabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.security.enableNULLCRLDP");
            }
        });
        enableNULLCRLDP = new Boolean(enabled);
        if (debug != null) {
            System.out.println("CertPathSystemProperties.java:  com.ibm.security.enableNULLCRLDP = " + enableNULLCRLDP);
        }
        enabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.security.enableDELTACRL");
            }
        });
        enableDELTACRL = new Boolean(enabled);
        if (debug != null) {
            System.out.println("CertPathSystemProperties.java:  com.ibm.security.enableDELTACRL = " + enableDELTACRL);
        }
        enabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.security.enableAIAEXT");
            }
        });
        enableAIAEXT = new Boolean(enabled);
        if (debug != null) {
            System.out.println("CertPathSystemProperties.java:  com.ibm.security.enableAIAEXT = " + enableAIAEXT);
        }
        enabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("ocsp.enable");
            }
        });
        enableOCSP = new Boolean(enabled);
        if (debug != null) {
            System.out.println("CertPathSystemProperties.java:  ocsp.enable = " + enableOCSP);
        }
        if (enableOCSP) {
            ocspResponderURL = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ocsp.responderURL");
                }
            });
            if (debug != null) {
                if (ocspResponderURL != null) {
                    System.out.println("CertPathSystemProperties.java:  ocsp.responderURL = " + ocspResponderURL);
                } else {
                    System.out.println("CertPathSystemProperties.java:  ocsp.responderURL = null");
                }
            }
            ocspResponderCertSubjectName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ocsp.responderCertSubjectName");
                }
            });
            if (debug != null) {
                if (ocspResponderCertSubjectName != null) {
                    System.out.println("CertPathSystemProperties.java:  ocsp.responderCertSubjectName = " + ocspResponderCertSubjectName);
                } else {
                    System.out.println("CertPathSystemProperties.java:  ocsp.responderCertSubjectName = null");
                }
            }
            ocspResponderCertIssuerName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ocsp.responderCertIssuerName");
                }
            });
            if (debug != null) {
                if (ocspResponderCertIssuerName != null) {
                    System.out.println("CertPathSystemProperties.java:  ocsp.responderCertIssuerName = " + ocspResponderCertIssuerName);
                } else {
                    System.out.println("CertPathSystemProperties.java:  ocsp.responderCertIssuerName = null");
                }
            }
            ocspResponderCertSerialNumber = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ocsp.responderCertSerialNumber");
                }
            });
            if (debug != null) {
                if (ocspResponderCertSerialNumber != null) {
                    System.out.println("CertPathSystemProperties.java:  ocsp.responderCertSerialNumber = " + ocspResponderCertSerialNumber);
                } else {
                    System.out.println("CertPathSystemProperties.java:  ocsp.responderCertSerialNumber = null");
                }
            }
            ocspConnectTimeout = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("com.ibm.security.ocsp.timeout");
                }
            });
            if (debug != null) {
                if (ocspConnectTimeout != null) {
                    System.out.println("CertPathSystemProperties.java:  com.ibm.security.ocsp.timeout  = " + ocspConnectTimeout + " seconds");
                } else {
                    System.out.println("CertPathSystemProperties.java:  com.ibm.security.ocsp.timeout  = null.  A default value of 15 will be used.");
                }
            }
            ocspClockSkew = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("com.ibm.security.ocsp.clockSkew");
                }
            });
            if (debug != null) {
                if (ocspClockSkew != null) {
                    System.out.println("CertPathSystemProperties.java:  com.ibm.security.ocsp.clockSkew  = " + ocspClockSkew + " seconds");
                } else {
                    System.out.println("CertPathSystemProperties.java:  com.ibm.security.ocsp.clockSkew  = null.  A default value of 900 will be used.");
                }
            }
        }
        crlsConnectTimeout = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.security.crls.timeout");
            }
        });
        if (debug != null) {
            if (crlsConnectTimeout != null) {
                System.out.println("CertPathSystemProperties.java:  com.ibm.security.crls.timeout  = " + crlsConnectTimeout + " seconds");
            } else {
                System.out.println("CertPathSystemProperties.java:  com.ibm.security.crls.timeout  = null.  A default value of 15 will be used.");
            }
        }
    }
}

