/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;

public class CollectionCertStoreImpl
extends CertStoreSpi {
    private LinkedList X509Certs = new LinkedList();
    private LinkedList X509CRLs = new LinkedList();

    public CollectionCertStoreImpl(CertStoreParameters params) throws InvalidAlgorithmParameterException {
        super(params);
        this.init(params);
    }

    private void init(CertStoreParameters params) throws InvalidAlgorithmParameterException {
        Collection<Object> certs = new LinkedList();
        if (!(params instanceof CollectionCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("CollectionCertStoreParameters not valid");
        }
        certs = ((CollectionCertStoreParameters)params).getCollection();
        for (Object cert : certs) {
            if (cert instanceof X509Certificate) {
                this.X509Certs.add(cert);
                continue;
            }
            if (cert instanceof X509CRL) {
                this.X509CRLs.add(cert);
                continue;
            }
            throw new InvalidAlgorithmParameterException();
        }
    }

    public Collection engineGetCertificates(CertSelector selector) throws CertStoreException {
        if (selector == null) {
            return this.X509Certs;
        }
        LinkedList<Certificate> matchedCollection = new LinkedList<Certificate>();
        for (Certificate cert : this.X509Certs) {
            if (!selector.match(cert)) continue;
            matchedCollection.add(cert);
        }
        return matchedCollection;
    }

    public Collection engineGetCRLs(CRLSelector selector) throws CertStoreException {
        if (selector == null) {
            return this.X509CRLs;
        }
        LinkedList<CRL> matchedCollection = new LinkedList<CRL>();
        for (CRL crl : this.X509CRLs) {
            if (!selector.match(crl)) continue;
            matchedCollection.add(crl);
        }
        return matchedCollection;
    }
}

