/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.cert.BasicOCSPResponse;
import com.ibm.security.cert.CertID;
import com.ibm.security.cert.OCSPResponseStatus;
import com.ibm.security.cert.SingleResponse;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.Extension;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OCSPResponse {
    private OCSPResponseStatus status;
    private byte[] responseData;
    private ObjectIdentifier responseType;
    public static final ObjectIdentifier basicResponseType;
    private static final Debug debug;
    private byte[] nonce = null;

    public OCSPResponse(OCSPResponseStatus status, BasicOCSPResponse response) {
        if (status == null) {
            throw new IllegalArgumentException("status can not be null");
        }
        this.status = status;
        try {
            this.responseData = response.encode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.responseType = basicResponseType;
    }

    public OCSPResponse(byte[] encodedData) throws IOException {
        this.init(new DerInputStream(encodedData));
    }

    public OCSPResponse(DerValue der) throws IOException {
        this.init(der.toDerInputStream());
    }

    void init(DerInputStream inputData) throws IOException {
        byte[] myInputDataCopy = inputData.toByteArray();
        DerInputStream indata = new DerInputStream(myInputDataCopy);
        DerValue[] ders = indata.getSequence(2);
        if (ders.length > 0) {
            this.status = new OCSPResponseStatus(ders[0]);
            if (ders.length > 1) {
                int tag = ders[1].getTag() & 0x1F;
                if (tag != 0) {
                    throw new IOException("invalid tag of ResponseBytes: " + tag);
                }
                DerInputStream dis = ders[1].getData();
                DerValue[] ders2 = dis.getSequence(2);
                if (ders2.length != 2) {
                    throw new IOException("invalid sequence of ResponseBytes, length=" + ders2.length);
                }
                if (!ders2[0].getOID().equals(basicResponseType)) {
                    throw new IOException("unknown response type, oid=" + ders2[0].getOID());
                }
                this.responseData = ders2[1].getOctetString();
                this.responseType = basicResponseType;
                this.nonce = this.getNonceFromOCSPResponse(myInputDataCopy);
                if (debug != null) {
                    if (this.nonce != null) {
                        System.out.println("OCSPResponse.java:  init():  The nonce from the OCSPResponse NOT NULL:");
                        System.out.println(OCSPResponse.toHexString(this.nonce));
                    } else {
                        System.out.println("OCSPResponse.java:  init():  The nonce from the OCSPResponse is NULL");
                    }
                }
            }
        } else {
            throw new IOException("input data does not contain valid OCSPResponse value");
        }
    }

    public byte[] encode() throws IOException {
        DerValue[] ders = null;
        ders = this.responseData == null ? new DerValue[1] : new DerValue[2];
        ders[0] = new DerValue(this.status.encode());
        if (ders.length == 2) {
            DerValue[] ders2 = new DerValue[2];
            DerOutputStream dos = new DerOutputStream();
            dos.putOID(basicResponseType);
            ders2[0] = new DerValue(dos.toByteArray());
            dos = new DerOutputStream();
            dos.putOctetString(this.responseData);
            ders2[1] = new DerValue(dos.toByteArray());
            dos = new DerOutputStream();
            dos.putSequence(ders2);
            ders[1] = new DerValue(dos.toByteArray());
        }
        DerOutputStream temp = new DerOutputStream();
        temp.putSequence(ders);
        return temp.toByteArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("OCSPResponse:[\n");
        sb.append("  status: " + this.status.getStatusAsString() + "\n");
        if (this.responseData != null) {
            sb.append("  response type: " + this.responseType.toString() + "\n");
            sb.append("  response data: \n" + new HexDumpEncoder().encode(this.responseData));
        }
        sb.append("  ]");
        return sb.toString();
    }

    public OCSPResponseStatus getResponseStatus() {
        return this.status;
    }

    public ObjectIdentifier getResponseType() {
        return this.responseType;
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    byte[] getNonce() {
        return this.nonce;
    }

    public static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int len = block.length;
        int high = 0;
        int low = 0;
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                buf.append('\n');
            }
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
            buf.append(' ');
        }
        return buf.toString();
    }

    byte[] getNonceFromOCSPResponse(byte[] bytes) throws IOException {
        short tag;
        ObjectIdentifier NONCE_EXTENSION_OID = ObjectIdentifier.newInternal((int[])new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2});
        ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal((int[])new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
        short NAME_TAG = 1;
        short KEY_TAG = 2;
        ResponseStatus[] rsvalues = ResponseStatus.values();
        DerValue der = new DerValue(bytes);
        if (der.getTag() != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derIn = der.getData();
        int status = derIn.getEnumerated().intValue();
        if (status < 0 || status >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + status);
        }
        ResponseStatus responseStatus = rsvalues[status];
        if (responseStatus != ResponseStatus.SUCCESSFUL) {
            return null;
        }
        der = derIn.getDerValue();
        if (!der.isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue tmp = der.getData().getDerValue();
        if (tmp.getTag() != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derIn = tmp.getData();
        ObjectIdentifier responseType = derIn.getOID();
        if (!responseType.equals((Object)OCSP_BASIC_RESPONSE_OID)) {
            throw new IOException("Unsupported OCSP response type: " + responseType);
        }
        DerInputStream basicOCSPResponse = new DerInputStream(derIn.getOctetString());
        DerValue[] seqTmp = basicOCSPResponse.getSequence(2);
        if (seqTmp.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue responseData = seqTmp[0];
        byte[] tbsResponseData = seqTmp[0].toByteArray();
        if (responseData.getTag() != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream seqDerIn = responseData.getData();
        DerValue seq = seqDerIn.getDerValue();
        if (seq.isContextSpecific((byte)0) && seq.isConstructed() && seq.isContextSpecific()) {
            seq = seq.getData().getDerValue();
            int version = seq.getInteger().intValue();
            if (seq.getData().available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            seq = seqDerIn.getDerValue();
        }
        if ((tag = (short)((byte)(seq.getTag() & 0x1F))) != NAME_TAG && tag != KEY_TAG) {
            throw new IOException("Bad encoding in responderID element of OCSP response: expected ASN.1 context specific tag 0 or 1");
        }
        seq = seqDerIn.getDerValue();
        DerValue[] singleResponseDer = seqDerIn.getSequence(1);
        byte[] nonce = null;
        if (seqDerIn.available() > 0 && (seq = seqDerIn.getDerValue()).isContextSpecific((byte)1)) {
            DerValue[] responseExtDer = seq.getData().getSequence(3);
            for (int i = 0; i < responseExtDer.length; ++i) {
                Extension ext = new Extension(responseExtDer[i]);
                if (ext.getExtensionId().equals((Object)NONCE_EXTENSION_OID)) {
                    nonce = ext.getExtensionValue();
                    continue;
                }
                if (!ext.isCritical()) continue;
                throw new IOException("Unsupported OCSP critical extension: " + ext.getExtensionId());
            }
        }
        return nonce;
    }

    Map<CertID, SingleResponse> getCertIDToSingleResponseMap(byte[] bytes, Date date) throws IOException {
        short tag;
        ObjectIdentifier NONCE_EXTENSION_OID = ObjectIdentifier.newInternal((int[])new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2});
        ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal((int[])new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
        short NAME_TAG = 1;
        short KEY_TAG = 2;
        ResponseStatus[] rsvalues = ResponseStatus.values();
        DerValue der = new DerValue(bytes);
        if (der.getTag() != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derIn = der.getData();
        int status = derIn.getEnumerated().intValue();
        if (status < 0 || status >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + status);
        }
        ResponseStatus responseStatus = rsvalues[status];
        if (responseStatus != ResponseStatus.SUCCESSFUL) {
            Map<CertID, SingleResponse> singleResponseMap = Collections.emptyMap();
            return singleResponseMap;
        }
        der = derIn.getDerValue();
        if (!der.isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue tmp = der.getData().getDerValue();
        if (tmp.getTag() != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derIn = tmp.getData();
        ObjectIdentifier responseType = derIn.getOID();
        if (!responseType.equals((Object)OCSP_BASIC_RESPONSE_OID)) {
            throw new IOException("Unsupported OCSP response type: " + responseType);
        }
        DerInputStream basicOCSPResponse = new DerInputStream(derIn.getOctetString());
        DerValue[] seqTmp = basicOCSPResponse.getSequence(2);
        if (seqTmp.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue responseData = seqTmp[0];
        byte[] tbsResponseData = seqTmp[0].toByteArray();
        if (responseData.getTag() != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream seqDerIn = responseData.getData();
        DerValue seq = seqDerIn.getDerValue();
        if (seq.isContextSpecific((byte)0) && seq.isConstructed() && seq.isContextSpecific()) {
            seq = seq.getData().getDerValue();
            int version = seq.getInteger().intValue();
            if (seq.getData().available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            seq = seqDerIn.getDerValue();
        }
        if ((tag = (short)((byte)(seq.getTag() & 0x1F))) != NAME_TAG && tag != KEY_TAG) {
            throw new IOException("Bad encoding in responderID element of OCSP response: expected ASN.1 context specific tag 0 or 1");
        }
        seq = seqDerIn.getDerValue();
        DerValue[] singleResponseDer = seqDerIn.getSequence(1);
        HashMap<CertID, SingleResponse> singleResponseMap = new HashMap<CertID, SingleResponse>(singleResponseDer.length);
        for (int i = 0; i < singleResponseDer.length; ++i) {
            SingleResponse singleResponse = new SingleResponse(singleResponseDer[i], date);
            singleResponseMap.put(singleResponse.getCertID(), singleResponse);
        }
        return singleResponseMap;
    }

    static {
        debug = Debug.getInstance((String)"certpath");
        ObjectIdentifier temp = null;
        try {
            temp = new ObjectIdentifier("1.3.6.1.5.5.7.48.1.1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        basicResponseType = temp;
    }

    static enum ResponseStatus {
        SUCCESSFUL,
        MALFORMED_REQUEST,
        INTERNAL_ERROR,
        TRY_LATER,
        UNUSED,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }
}

