/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.AlgorithmChecker;
import com.ibm.security.cert.BasicChecker;
import com.ibm.security.cert.CRSChecker;
import com.ibm.security.cert.CertPathSystemProperties;
import com.ibm.security.cert.CertStatus;
import com.ibm.security.cert.NameChecker;
import com.ibm.security.cert.OCSPCertPathStatusUnknownException;
import com.ibm.security.cert.OCSPCertRevokedException;
import com.ibm.security.cert.OCSPChecker;
import com.ibm.security.cert.PKIXRevocationCheckerImpl;
import com.ibm.security.cert.PolicyChecker;
import com.ibm.security.cert.PolicyTree;
import com.ibm.security.cert.UntrustedChecker;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathChecker;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXReason;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PKIXCertPathValidatorImpl
extends CertPathValidatorSpi {
    private static final Debug debug = Debug.getInstance((String)"certpath");

    @Override
    public CertPathChecker engineGetRevocationChecker() {
        return new PKIXRevocationCheckerImpl();
    }

    @Override
    public CertPathValidatorResult engineValidate(CertPath cp, CertPathParameters param) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        X509Certificate currentCert;
        PolicyChecker policyChecker;
        BasicChecker basicChecker;
        PKIXCertPathValidatorResult result;
        block88: {
            X509Certificate targetCert;
            if (cp == null || param == null) {
                throw new CertPathValidatorException("both certpath and certpath parameters can not be null", new NullPointerException());
            }
            if (debug != null) {
                System.out.println("CertPathValidatorResult: certpath: " + cp);
            }
            result = null;
            int policy_mapping = 0;
            int inhibit_any_policy = 0;
            int explicit_policy = 0;
            HashSet<String> user_initial_policy_set = null;
            boolean policyQualifiersRejected = true;
            List<? extends Certificate> certPathCerts = cp.getCertificates();
            int numberOfCertsInCertPath = certPathCerts.size();
            PKIXParameters pkixParam = null;
            CertSelector certSelector = null;
            Set<TrustAnchor> trustBaseSet = null;
            Date validationDate = null;
            List<CertStore> certStoreList = null;
            boolean revocationEnabled = true;
            List<PKIXCertPathChecker> certPathCheckers = null;
            String sigProvider = null;
            if (!cp.getType().equals("X.509") && !cp.getType().equals("X509")) {
                throw new InvalidAlgorithmParameterException("inappropriate certification path type specified, must be X.509 or X509");
            }
            if (param instanceof PKIXParameters) {
                pkixParam = (PKIXParameters)param;
                user_initial_policy_set = new HashSet<String>(pkixParam.getInitialPolicies());
                if (user_initial_policy_set.isEmpty()) {
                    user_initial_policy_set.add("2.5.29.32.0");
                }
                trustBaseSet = pkixParam.getTrustAnchors();
                certSelector = pkixParam.getTargetCertConstraints();
                revocationEnabled = pkixParam.isRevocationEnabled();
                policy_mapping = pkixParam.isPolicyMappingInhibited() ? 0 : numberOfCertsInCertPath + 1;
                inhibit_any_policy = pkixParam.isAnyPolicyInhibited() ? 0 : numberOfCertsInCertPath + 1;
                explicit_policy = pkixParam.isExplicitPolicyRequired() ? 0 : numberOfCertsInCertPath + 1;
                validationDate = pkixParam.getDate();
                if (validationDate == null) {
                    validationDate = new Date();
                }
            } else {
                throw new InvalidAlgorithmParameterException("Parameter type unsupported - " + param.getClass().getName());
            }
            certStoreList = pkixParam.getCertStores();
            certPathCheckers = pkixParam.getCertPathCheckers();
            policyQualifiersRejected = pkixParam.getPolicyQualifiersRejected();
            sigProvider = pkixParam.getSigProvider();
            if (certSelector != null && certPathCerts.size() > 0 && !certSelector.match(targetCert = (X509Certificate)certPathCerts.get(0))) {
                throw new CertPathValidatorException("Certain certificate select criteria don't match", null, cp, numberOfCertsInCertPath, PKIXReason.PATH_TOO_LONG);
            }
            UntrustedChecker untrustedChecker = new UntrustedChecker();
            basicChecker = new BasicChecker(cp, trustBaseSet, validationDate, sigProvider);
            CRSChecker crsChecker = null;
            OCSPChecker ocspChecker = null;
            RevocationPreference revocationPreference = this.getRevocationPreference(pkixParam);
            if (revocationEnabled) {
                if (debug != null) {
                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  Revocation checking is enabled");
                }
                crsChecker = new CRSChecker(cp, certStoreList, true, false, trustBaseSet, validationDate, true, sigProvider, pkixParam);
                String[] ocspProperties = new String[]{CertPathSystemProperties.getEnableOCSP() ? "true" : "false", CertPathSystemProperties.getOCSPResponderURL(), CertPathSystemProperties.getOCSPResponderCertSubjectName(), CertPathSystemProperties.getOCSPResponderCertIssuerName(), CertPathSystemProperties.getOCSPResponderCertSerialNumber()};
                if (debug != null) {
                    System.out.println("CERTPATH: The OCSP \"system properties\" are: ");
                    System.out.println("          ocsp.enable=" + ocspProperties[0]);
                    System.out.println("          ocsp.responderURL=" + ocspProperties[1]);
                    System.out.println("          ocsp.responderCertSubjectName=" + ocspProperties[2]);
                    System.out.println("          ocsp.responderCertIssuerName=" + ocspProperties[3]);
                    System.out.println("          ocsp.responderCertSerialNumber=" + ocspProperties[4]);
                }
                if (ocspProperties[0] != null && ocspProperties[0].equalsIgnoreCase("true") || this.getPKIXRevocationCheckerFromPKIXParameters(pkixParam) != null) {
                    URI responderURIFromPKIXRevocationChecker;
                    URL responderURLFromPKIXRevocationChecker = null;
                    PKIXRevocationChecker pkixRevocationChecker = this.getPKIXRevocationCheckerFromPKIXParameters(pkixParam);
                    if (pkixRevocationChecker != null && (responderURIFromPKIXRevocationChecker = pkixRevocationChecker.getOcspResponder()) != null) {
                        try {
                            responderURLFromPKIXRevocationChecker = responderURIFromPKIXRevocationChecker.toURL();
                            if (debug != null) {
                                System.out.println("CERTPATH: PKIXCertPathValidator.java:  engineValidate(): ");
                                System.out.println("          The following OCSP responder URL was specified within PKIXRevocationChecker: ");
                                System.out.println("          " + responderURLFromPKIXRevocationChecker.toString());
                            }
                        }
                        catch (Exception ex) {
                            throw new CertPathValidatorException("Malformed responder URI passed within PKIXRevocationChecker:." + responderURIFromPKIXRevocationChecker.toString());
                        }
                    }
                    if (responderURLFromPKIXRevocationChecker != null) {
                        ocspProperties[1] = responderURLFromPKIXRevocationChecker.toString();
                        if (debug != null) {
                            System.out.println("CERTPATH: PKIXCertPathValidator.java:  ocspProperties[1] which carries the OCSP responder URL");
                            System.out.println("          has been reassigned the value of the responder URL carried within PKIXRevocationChecker:");
                            System.out.println(ocspProperties[1]);
                        }
                    }
                    if (ocspProperties[2] != null) {
                        ocspChecker = new OCSPChecker(ocspProperties[1], ocspProperties[2], cp, pkixParam);
                    } else if (ocspProperties[3] != null && ocspProperties[4] != null) {
                        String HEX_DIGITS = "0123456789ABCDEFabcdef";
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < ocspProperties[4].length(); ++i) {
                            if (HEX_DIGITS.indexOf(ocspProperties[4].charAt(i)) <= -1) continue;
                            sb.append(ocspProperties[4].charAt(i));
                        }
                        if (debug != null) {
                            System.out.println("CERTPATH: get serial number of responder certificate=" + sb.toString());
                        }
                        ocspChecker = new OCSPChecker(ocspProperties[1], ocspProperties[3], new BigInteger(sb.toString(), 16), cp, pkixParam);
                    } else if (ocspProperties[1] != null && ocspProperties[2] == null && ocspProperties[3] == null && ocspProperties[4] == null) {
                        if (debug != null) {
                            System.out.println("CERTPATH: PKIXCertPathValidator.java:  engineValidate():  Only ocsp.enable and ocsp.responderURL were specified.");
                        }
                        ocspChecker = new OCSPChecker(ocspProperties[1], null, cp, pkixParam);
                    } else {
                        if (debug != null) {
                            System.out.println("\n\n\n==============================================================================");
                            System.out.println("CERTPATH:  PKIXCertPathValidator.java:  engineValidate():  REVOCATION CHECKING IS ENABLED");
                            System.out.println("CERTPATH:  PKIXCertPathValidator.java:  engineValidate():  OCSP IS ENABLED");
                            System.out.println("CERTPATH:  PKIXCertPathValidator.java:  engineValidate():  NO RESPONDER'S CERT SUBJECT NAME IS SPECIFIED");
                            System.out.println("CERTPATH:  PKIXCertPathValidator.java:  engineValidate():  NO RESPONDER'S CERT ISSUER AND RESPONDER'S CERT SERIAL IS SPECIFIED");
                            System.out.println("CERTPATH:  PKIXCertPathValidator.java:  engineValidate():  CREATING OCSPChecker WITH NULL RESPONDER URL AND NULL RESPONDER SUBJECT NAME\n\n");
                            System.out.println("==============================================================================\n\n\n");
                        }
                        ocspChecker = new OCSPChecker(null, null, cp, pkixParam);
                    }
                }
            }
            policyChecker = new PolicyChecker(cp, pkixParam.getPolicyQualifiersRejected(), user_initial_policy_set, explicit_policy, policy_mapping, inhibit_any_policy);
            NameChecker nameChecker = new NameChecker(cp, sigProvider);
            if (numberOfCertsInCertPath == 0) {
                Iterator<TrustAnchor> it = trustBaseSet.iterator();
                TrustAnchor ta = it.next();
                PublicKey pk = ta.getCAPublicKey();
                if (pk == null) {
                    pk = ta.getTrustedCert().getPublicKey();
                }
                result = new PKIXCertPathValidatorResult(ta, policyChecker.getPolicyTree().getRoot(), pk);
                return result;
            }
            untrustedChecker.init(false);
            basicChecker.init(false);
            if (revocationEnabled) {
                crsChecker.init(false);
            }
            if (ocspChecker != null) {
                ocspChecker.init(false);
            }
            policyChecker.init(false);
            nameChecker.init(false);
            PKIXCertPathValidatorImpl.initCheckers(certPathCheckers);
            currentCert = null;
            boolean wasCRSCheckerCheckCalled = false;
            boolean didCRSCheckerReportUndeterminedForThisCert = false;
            boolean shouldOCSPCheckerStillBeCalled = true;
            for (int i = numberOfCertsInCertPath - 1; i >= 0; --i) {
                currentCert = (X509Certificate)certPathCerts.get(i);
                wasCRSCheckerCheckCalled = false;
                didCRSCheckerReportUndeterminedForThisCert = false;
                Set<String> unresolvedCriticalExtensions = currentCert.getCriticalExtensionOIDs();
                if (unresolvedCriticalExtensions == null) {
                    unresolvedCriticalExtensions = new HashSet<String>();
                }
                untrustedChecker.check(currentCert, unresolvedCriticalExtensions);
                basicChecker.check((Certificate)currentCert, unresolvedCriticalExtensions);
                if (debug != null) {
                    System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  Will the revocationPreference allow CRSChecker.check() to be called FIRST?");
                }
                if (revocationEnabled) {
                    if (revocationPreference == RevocationPreference.ONLY_CRLS || revocationPreference == RevocationPreference.PREFER_CRLS) {
                        if (debug != null) {
                            System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  YES, the revocationPreference was either ONLY_CRLS or PREFER_CRLS");
                            System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  CRSChecker.check() will be called next.");
                        }
                        try {
                            if (debug != null) {
                                System.out.println("==============================================================================================");
                                System.out.println("==============================================================================================");
                                System.out.println("======================     CRSChecker.check() CALLED BELOW      ==============================");
                                System.out.println("==============================================================================================");
                                System.out.println("==============================================================================================");
                            }
                            crsChecker.check(currentCert, unresolvedCriticalExtensions);
                            if (debug != null) {
                                System.out.println("==============================================================================================");
                                System.out.println("==============================================================================================");
                                System.out.println("======================     CRSChecker.check() CALLED ABOVE      ==============================");
                                System.out.println("==============================================================================================");
                                System.out.println("==============================================================================================");
                                System.out.println("\nCertPathValidatorImpl.java:  engineValidate():  CRSChecker.check() DID NOT throw exception to report revocation status UNDETERMINED for this cert");
                            }
                            wasCRSCheckerCheckCalled = true;
                        }
                        catch (CertPathValidatorException ex) {
                            CertPathValidatorException.Reason revocationReason = ex.getReason();
                            if (revocationReason == CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS) {
                                if (debug != null) {
                                    System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  CRSChecker.check() threw a CertPathValidatorException for this cert for");
                                    System.out.println("                                                REVOCATION STATUS UNDETERMINED ");
                                }
                                if (revocationPreference == RevocationPreference.ONLY_CRLS) {
                                    throw ex;
                                }
                                didCRSCheckerReportUndeterminedForThisCert = true;
                            }
                            if (debug != null) {
                                System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  CRSChecker.check() threw a CertPathValidatorException for this cert for a reason \"OTHER THAN\"");
                                System.out.println("                                                REVOCATION STATUS UNDETERMINED ");
                                System.out.println("                                                Rethrow that exception now.    ");
                            }
                            throw ex;
                        }
                    } else if (debug != null) {
                        System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  NO. The revocationPreference PREFER_OCSP or ONLY_OCSP does not allow CRSChecker.check() to be called first");
                    }
                }
                policyChecker.check(currentCert, unresolvedCriticalExtensions);
                nameChecker.check((Certificate)currentCert, unresolvedCriticalExtensions);
                TrustAnchor myTrustAnchor = null;
                X509Certificate signerCert = null;
                if (i == numberOfCertsInCertPath - 1) {
                    myTrustAnchor = basicChecker.getTrustAnchor();
                    signerCert = myTrustAnchor.getTrustedCert();
                } else {
                    signerCert = (X509Certificate)certPathCerts.get(i + 1);
                    myTrustAnchor = new TrustAnchor(signerCert, null);
                }
                AlgorithmChecker algorithmChecker = new AlgorithmChecker(myTrustAnchor, (AlgorithmConstraints)AlgorithmChecker.certPathDefaultConstraints);
                algorithmChecker.check(currentCert, unresolvedCriticalExtensions);
                PKIXCertPathValidatorImpl.moreChecks(currentCert, certPathCheckers, unresolvedCriticalExtensions);
                if (unresolvedCriticalExtensions.isEmpty()) continue;
                StringBuffer sb = new StringBuffer();
                Iterator<String> iter = unresolvedCriticalExtensions.iterator();
                while (iter.hasNext()) {
                    sb.append(iter.next());
                }
                throw new CertPathValidatorException(" The following critical extensions were not processed: " + sb, null, cp, i, PKIXReason.UNRECOGNIZED_CRIT_EXT);
            }
            if (wasCRSCheckerCheckCalled) {
                if (!didCRSCheckerReportUndeterminedForThisCert) {
                    if (debug != null) {
                        System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  CRSChecker.check() was called and DID NOT not report a revocation status of UNDETERMINED for this cert.");
                        System.out.println("                                                OCSPChecker.check() NEED NOT be called below, if configured.");
                    }
                    shouldOCSPCheckerStillBeCalled = false;
                } else {
                    if (debug != null) {
                        System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  CRSChecker.check() was called and DID report a revocation status of UNDETERMINED for this cert.");
                        System.out.println("                                                OCSPChecker.check() MUST be called below, if configured.");
                    }
                    shouldOCSPCheckerStillBeCalled = true;
                }
            }
            if (revocationEnabled) {
                if (debug != null) {
                    System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  Will the revocationPreference allow us to call OCSPChecker.check() ?");
                }
                if (revocationPreference == RevocationPreference.PREFER_OCSP || revocationPreference == RevocationPreference.PREFER_CRLS || revocationPreference == RevocationPreference.ONLY_OCSP) {
                    if (debug != null) {
                        System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  YES, the revocationPreference was either PREFER_CRLS, PREFER_OCSP or ONLY_OCSP");
                    }
                    if (shouldOCSPCheckerStillBeCalled) {
                        if (ocspChecker != null) {
                            Set<String> unresolvedCriticalExtensions = currentCert.getCriticalExtensionOIDs();
                            try {
                                if (debug != null) {
                                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  Invoking OCSPChecker.check() to check ENTIRE cert chain");
                                }
                                if (debug != null) {
                                    System.out.println("==============================================================================================");
                                    System.out.println("==============================================================================================");
                                    System.out.println("======================    OCSPChecker.check() CALLED BELOW      ==============================");
                                    System.out.println("==============================================================================================");
                                    System.out.println("==============================================================================================");
                                }
                                ocspChecker.check(null, unresolvedCriticalExtensions);
                                if (debug != null) {
                                    System.out.println("==============================================================================================");
                                    System.out.println("==============================================================================================");
                                    System.out.println("======================    OCSPChecker.check() CALLED ABOVE      ==============================");
                                    System.out.println("==============================================================================================");
                                    System.out.println("==============================================================================================");
                                }
                                if (debug != null) {
                                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  Returned from OCSPChecker.check() to check ENTIRE cert chain");
                                }
                            }
                            catch (CertPathValidatorException ex) {
                                Throwable throwable;
                                if (revocationPreference == RevocationPreference.ONLY_OCSP) {
                                    if (debug != null) {
                                        System.out.println("\n==============================================================================================");
                                        System.out.println("==============================================================================================");
                                        System.out.println("======================    OCSPChecker.check() THREW A           ==============================");
                                        System.out.println("======================    CertPathValidatorException.           ==============================");
                                        System.out.println("======================                                          ==============================");
                                        System.out.println("======================    recheck() will NOT BE CALLED          ==============================");
                                        System.out.println("======================    since the revocation preference is    ==============================");
                                        System.out.println("======================    RevocationPreference.ONLY_OCSP.       ==============================");
                                        System.out.println("==============================================================================================");
                                        System.out.println("==============================================================================================");
                                    }
                                    throw ex;
                                }
                                if (debug != null) {
                                    System.out.println("\n==============================================================================================");
                                    System.out.println("==============================================================================================");
                                    System.out.println("======================    OCSPChecker.check() THREW A           ==============================");
                                    System.out.println("======================    CertPathValidatorException.            ==============================");
                                    System.out.println("======================                                          ==============================");
                                    System.out.println("======================    recheck() will be called below.       ==============================");
                                    System.out.println("==============================================================================================");
                                    System.out.println("==============================================================================================");
                                }
                                if (debug != null) {
                                    System.out.println("\n=====================================================================================================");
                                    System.out.println("=======================================================================================================");
                                    System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  OCSPChecker.check() threw a CertPathValidatorException.");
                                    System.out.println("                                                    This means that the revocation status returned for one or more certs");
                                    System.out.println("                                                    in the cert chain was REVOKED, or UNKNOWN, or NULL.");
                                    System.out.println("                                                    This also means that rechecking by CRSChecker will ");
                                    System.out.println("                                                    now be performed.                                  ");
                                    System.out.println("=======================================================================================================");
                                    System.out.println("=======================================================================================================");
                                    System.out.println(ex.toString());
                                    ex.printStackTrace();
                                }
                                if ((throwable = ex.getCause()) != null) {
                                    if (debug != null) {
                                        System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  The CertPathValidator exception contains an embedded exception.");
                                    }
                                    if (throwable instanceof OCSPCertRevokedException) {
                                        if (debug != null) {
                                            System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  The embedded exception represents an OCSPCertRevokedException.  Just rethrow it.");
                                        }
                                        throw ex;
                                    }
                                    if (throwable instanceof OCSPCertPathStatusUnknownException) {
                                        if (debug != null) {
                                            System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  The embedded exception represents an OCSPCertPathStatusUnknownException.  Recheck each cert with a NULL or UNKNOWN status.");
                                        }
                                        if (debug != null) {
                                            System.out.println("\n=====================================================================================================");
                                            System.out.println("=======================================================================================================");
                                            System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  Calling recheck() to check only the certs          ");
                                            System.out.println("                                                    with a NULL or UNKNOWN status.                     ");
                                            System.out.println("=======================================================================================================");
                                            System.out.println("=======================================================================================================");
                                        }
                                        this.recheck(((OCSPCertPathStatusUnknownException)throwable).getStatuses(), ((OCSPCertPathStatusUnknownException)throwable).getCertificates(), crsChecker, certPathCerts);
                                    } else {
                                        if (debug != null) {
                                            System.out.println("\n===================================================================================================== ");
                                            System.out.println("======================================================================================================= ");
                                            System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  Calling recheck() (failover) to recheck all certs   ");
                                            System.out.println("                                                    with CRSChecker.check(), because an unspecified     ");
                                            System.out.println("                                                    embedded exception was thrown by OCSPChecker.check().");
                                            System.out.println("======================================================================================================= ");
                                            System.out.println("======================================================================================================= ");
                                        }
                                        this.recheck(crsChecker, certPathCerts);
                                    }
                                    break block88;
                                }
                                if (debug != null) {
                                    System.out.println("\n===================================================================================================== ");
                                    System.out.println("======================================================================================================= ");
                                    System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  Calling recheck() to recheck all certs with CRSChecker.check().");
                                    System.out.println("                                                    There was no embedded exception thrown by OCSPChecker.check().");
                                    System.out.println("======================================================================================================= ");
                                    System.out.println("======================================================================================================= ");
                                }
                                this.recheck(crsChecker, certPathCerts);
                            }
                        }
                    } else if (debug != null) {
                        System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  NO. OCSPChecker.check() was not called since CRSChecker.check() was called first and did not report UNDETERMINED  ");
                    }
                } else if (debug != null) {
                    System.out.println("PKIXCertPathValidatorImpl.java:  engineValidate():  NO. OCSPChecker.check() was not called since the revocationPreference ONLY_CRLS did not allow it ");
                }
            }
        }
        PublicKey pKey = currentCert.getPublicKey();
        TrustAnchor anchor = basicChecker.getTrustAnchor();
        PolicyTree tree = policyChecker.getPolicyTree();
        PolicyNode node = null;
        if (tree.isValid()) {
            node = tree.getRoot();
        }
        if (debug != null) {
            System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  engineValidate():  Returning from PKIXCertPathValidator.engineValidate() ");
            System.out.println("==================================================================================================================== ");
        }
        result = new PKIXCertPathValidatorResult(anchor, node, pKey);
        return result;
    }

    private void recheck(CRSChecker checker, List certPathCerts) throws CertPathValidatorException {
        X509Certificate currentCert = null;
        int numberOfCertsInCertPath = certPathCerts.size();
        for (int i = numberOfCertsInCertPath - 1; i >= 0; --i) {
            currentCert = (X509Certificate)certPathCerts.get(i);
            checker.check(currentCert, null);
        }
    }

    private void recheck(CertStatus[] statuses, X509Certificate[] certs, CRSChecker checker, List certPathCerts) throws CertPathValidatorException {
        int i;
        int numberOfCertsInCertPath = certPathCerts.size();
        if (debug != null) {
            System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  recheck():  Rechecking ALL certs with NULL or UNKNOWN statuses with CRSChecker.check()");
            System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  recheck():  Before doing anything, dump the OCSP revocation status for each cert.");
            for (i = numberOfCertsInCertPath - 1; i >= 0; --i) {
                if (statuses[i] == null) {
                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  recheck():  st[" + i + "] is NULL for cert " + ((X509Certificate)certPathCerts.get(i)).getSubjectDN().getName());
                    continue;
                }
                if (statuses[i].getStatus() == 2) {
                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  recheck():  st[" + i + "] is UNKNOWN for cert " + ((X509Certificate)certPathCerts.get(i)).getSubjectDN().getName());
                    continue;
                }
                if (statuses[i].getStatus() == 1) {
                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  recheck():  st[" + i + "] is REVOKED for cert " + ((X509Certificate)certPathCerts.get(i)).getSubjectDN().getName());
                    continue;
                }
                if (statuses[i].getStatus() != 0) continue;
                System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  recheck():  st[" + i + "] is GOOD for cert " + ((X509Certificate)certPathCerts.get(i)).getSubjectDN().getName());
            }
            System.out.println("CERTPATH:  PKIXCertPathValidator.java:  recheck():  Call CRSChecker.check() for each cert with an OCSP revocation status of UNKNOWN or NULL.");
            System.out.println("                                                    Note:  If CRSChecker.check() throws an exception, it isn't caught.");
        }
        for (i = numberOfCertsInCertPath - 1; i >= 0; --i) {
            if (statuses[i] == null || statuses[i].getStatus() == 2) {
                checker.check((X509Certificate)certPathCerts.get(i), null);
                continue;
            }
            checker.check();
        }
    }

    static void initCheckers(Collection certPathCheckers) throws CertPathValidatorException {
        for (PKIXCertPathChecker pcpc : certPathCheckers) {
            pcpc.init(false);
        }
    }

    static void moreChecks(X509Certificate cert, List certPathCheckers, Collection unresolvedCriticalExtensions) throws CertPathValidatorException {
        for (PKIXCertPathChecker pcpc : certPathCheckers) {
            pcpc.check(cert, unresolvedCriticalExtensions);
        }
    }

    private String[] getOCSPProperties() {
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] result = new String[5];
                result[0] = Security.getProperty("ocsp.enable");
                if (result[0] != null && result[0].equalsIgnoreCase("true")) {
                    result[1] = Security.getProperty("ocsp.responderURL");
                    result[2] = Security.getProperty("ocsp.responderCertSubjectName");
                    result[3] = Security.getProperty("ocsp.responderCertIssuerName");
                    result[4] = Security.getProperty("ocsp.responderCertSerialNumber");
                }
                return result;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    PKIXRevocationChecker getPKIXRevocationCheckerFromPKIXParameters(PKIXParameters pkixParams) {
        int size;
        PKIXCertPathChecker checker = null;
        List<PKIXCertPathChecker> tmpList = pkixParams.getCertPathCheckers();
        if (tmpList != null) {
            size = tmpList.size();
            if (size == 0) {
                if (debug != null) {
                    System.out.println("CERTPATH:  OCSPChecker:  PKIXParameters DID NOT contain a PKIXRevocationChecker object.");
                }
                return null;
            }
        } else {
            if (debug != null) {
                System.out.println("CERTPATH:  OCSPChecker:  PKIXParameters DID NOT contain a PKIXRevocationChecker object.");
            }
            return null;
        }
        int i = 0;
        while (i < size) {
            checker = tmpList.get(i);
            if (checker instanceof PKIXRevocationCheckerImpl) {
                if (debug != null) {
                    System.out.println("CERTPATH:  OCSPChecker:  PKIXParameters DID contain a PKIXRevocationChecker object.");
                }
                return (PKIXRevocationCheckerImpl)checker;
            }
            ++i;
        }
        return null;
    }

    RevocationPreference getRevocationPreference(PKIXParameters pkixParams) throws CertPathValidatorException {
        PKIXRevocationChecker checker = this.getPKIXRevocationCheckerFromPKIXParameters(pkixParams);
        if (checker != null) {
            Set<PKIXRevocationChecker.Option> optionSet;
            if (debug != null) {
                System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  getRevocationPreference():  The RevocationChecker is not null.");
            }
            if ((optionSet = checker.getOptions()) != null && optionSet.size() != 0) {
                if (debug != null) {
                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  getRevocationPreference():  The RevocationChecker optionSet is not null or empty.");
                }
                if (!optionSet.contains((Object)PKIXRevocationChecker.Option.PREFER_CRLS)) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  getRevocationPreference():  PREFER_CRLS was NOT specified by the caller.");
                    }
                    if (!optionSet.contains((Object)PKIXRevocationChecker.Option.NO_FALLBACK)) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  getRevocationPreference():  NO_FALLBACK was NOT specified.  Therefore, PREFER_OCSP is assumed.");
                        }
                        return RevocationPreference.PREFER_OCSP;
                    }
                    if (debug != null) {
                        System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  getRevocationPreference():  However, NO_FALLBACK was specified.  Therefore, ONLY_OCSP is assumed.");
                    }
                    return RevocationPreference.ONLY_OCSP;
                }
                if (debug != null) {
                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  getRevocationPreference():  PREFER_CRLS was specified by the caller.");
                }
                if (!optionSet.contains((Object)PKIXRevocationChecker.Option.NO_FALLBACK)) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  getRevocationPreference():  NO_FALLBACK was NOT specified.  Therefore, PREFER_CRLS is assumed.");
                    }
                    return RevocationPreference.PREFER_CRLS;
                }
                if (debug != null) {
                    System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  getRevocationPreference():  However, NO_FALLBACK was specified.  Therefore, ONLY_CRLS is assumed.");
                }
                return RevocationPreference.ONLY_CRLS;
            }
            if (debug != null) {
                System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  getRevocationPreference():  The RevocationChecker optionSet is null or empty.  Therefore, PREFER_OCSP is assumed by default.");
            }
            return RevocationPreference.PREFER_OCSP;
        }
        if (debug != null) {
            System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  getRevocationPreference():  The RevocationChecker is null, check ocsp.enable property.");
        }
        if (CertPathSystemProperties.getEnableOCSP()) {
            if (debug != null) {
                System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  getRevocationPreference():  The ocsp.enable is set to true.  PREFER_OCSP is assumed.");
            }
            return RevocationPreference.PREFER_OCSP;
        }
        if (debug != null) {
            System.out.println("CERTPATH:  PKIXCertPathValidatorImpl.java:  getRevocationPreference():  The ocsp.enable is not true.  ONLY_CRLS is assumed.");
        }
        return RevocationPreference.ONLY_CRLS;
    }

    private static enum RevocationPreference {
        PREFER_OCSP,
        PREFER_CRLS,
        ONLY_OCSP,
        ONLY_CRLS;

    }
}

