/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertPathSystemProperties;
import com.ibm.security.cert.CertStoreHelper;
import com.ibm.security.util.Cache;
import com.ibm.security.x509.AccessDescription;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.URIName;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

class URICertStore
extends CertStoreSpi {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private static final int CHECK_INTERVAL = 30000;
    private static final int CACHE_SIZE = 185;
    private final CertificateFactory factory;
    private Collection<X509Certificate> certs = Collections.emptySet();
    private X509CRL crl;
    private long lastChecked;
    private long lastModified;
    private URI uri;
    private boolean ldap = false;
    private CertStore ldapCertStore;
    private String ldapPath;
    private static final Cache certStoreCache = Cache.newSoftMemoryCache((int)185);

    URICertStore(CertStoreParameters params) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        super(params);
        if (!(params instanceof URICertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("params must be instanceof URICertStoreParameters");
        }
        this.uri = ((URICertStoreParameters)params).uri;
        if (this.uri.getScheme().toLowerCase().equals("ldap")) {
            if (LDAP.helper() == null) {
                throw new NoSuchAlgorithmException("LDAP not present");
            }
            this.ldap = true;
            this.ldapCertStore = LDAP.helper().getCertStore(this.uri);
            this.ldapPath = this.uri.getPath();
            if (this.ldapPath.charAt(0) == '/') {
                this.ldapPath = this.ldapPath.substring(1);
            }
        }
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException();
        }
    }

    static synchronized CertStore getInstance(URICertStoreParameters params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CertStore ucs;
        if (debug != null) {
            System.out.println("CertStore URI:" + params.uri);
        }
        if ((ucs = (CertStore)certStoreCache.get((Object)params)) == null) {
            ucs = new UCS(new URICertStore(params), null, "URI", params);
            certStoreCache.put((Object)params, (Object)ucs);
        } else if (debug != null) {
            System.out.println("URICertStore.getInstance: cache hit");
        }
        return ucs;
    }

    static CertStore getInstance(AccessDescription ad) throws IOException {
        if (!ad.getAccessMethod().equals(AccessDescription.Ad_CAISSUERS_Id)) {
            return null;
        }
        GeneralNameInterface gn = ad.getAccessLocation().getName();
        if (gn.getType() != 6) {
            if (debug != null) {
                System.out.println("Ignore this AccessDescription.  NO URI. ");
            }
            return null;
        }
        String uriNameString = ((URIName)gn).getName();
        try {
            URI uri = new URI(uriNameString);
            if (debug != null) {
                System.out.println("    URINameString  = " + uriNameString);
                System.out.println("    URI scheme  = " + uri.getScheme());
                System.out.println("    URI host     = " + uri.getHost());
                System.out.println("    URI port   = " + uri.getPort());
                System.out.println("    URI path  = " + uri.getPath());
            }
            return URICertStore.getInstance(new URICertStoreParameters(uri));
        }
        catch (Exception ex) {
            if (debug != null) {
                System.out.println("exception creating CertStore: " + ex);
                ex.printStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Collection<X509Certificate> engineGetCertificates(CertSelector selector) throws CertStoreException {
        if (this.ldap) {
            X509CertSelector xsel = (X509CertSelector)selector;
            try {
                xsel = LDAP.helper().wrap(xsel, xsel.getSubject(), this.ldapPath);
                return this.ldapCertStore.getCertificates(xsel);
            }
            catch (IOException ioe) {
                throw new CertStoreException(ioe);
            }
        }
        long time = System.currentTimeMillis();
        if (time - this.lastChecked < 30000L) {
            if (debug == null) return URICertStore.getMatchingCerts(this.certs, selector);
            System.out.println("Returning certificates from cache");
            return URICertStore.getMatchingCerts(this.certs, selector);
        }
        this.lastChecked = time;
        InputStream in = null;
        try {
            URLConnection connection = this.uri.toURL().openConnection();
            if (this.lastModified != 0L) {
                connection.setIfModifiedSince(this.lastModified);
            }
            in = connection.getInputStream();
            long oldLastModified = this.lastModified;
            this.lastModified = connection.getLastModified();
            if (oldLastModified != 0L) {
                HttpURLConnection hconn;
                if (oldLastModified == this.lastModified) {
                    if (debug != null) {
                        System.out.println("Not modified, using cached copy");
                    }
                    Collection<X509Certificate> collection = URICertStore.getMatchingCerts(this.certs, selector);
                    return collection;
                }
                if (connection instanceof HttpURLConnection && (hconn = (HttpURLConnection)connection).getResponseCode() == 304) {
                    if (debug != null) {
                        System.out.println("Not modified, using cached copy");
                    }
                    Collection<X509Certificate> collection = URICertStore.getMatchingCerts(this.certs, selector);
                    return collection;
                }
            }
            if (debug != null) {
                System.out.println("Downloading new certificates...");
            }
            this.certs = this.factory.generateCertificates(in);
            Collection<X509Certificate> collection = URICertStore.getMatchingCerts(this.certs, selector);
            return collection;
        }
        catch (IOException e) {
            if (debug != null) {
                System.out.println("Exception fetching certificates:");
                e.printStackTrace();
            }
        }
        catch (CertificateException e) {
            if (debug != null) {
                System.out.println("Exception fetching certificates:");
                e.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        this.lastModified = 0L;
        this.certs = Collections.emptySet();
        return this.certs;
    }

    private static Collection<X509Certificate> getMatchingCerts(Collection<X509Certificate> certs, CertSelector selector) {
        if (selector == null) {
            return certs;
        }
        ArrayList<X509Certificate> matchedCerts = new ArrayList<X509Certificate>(certs.size());
        for (X509Certificate cert : certs) {
            if (!selector.match(cert)) continue;
            matchedCerts.add(cert);
        }
        return matchedCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Collection<X509CRL> engineGetCRLs(CRLSelector selector) throws CertStoreException {
        if (this.ldap) {
            X509CRLSelector xsel = (X509CRLSelector)selector;
            try {
                xsel = LDAP.helper().wrap(xsel, null, this.ldapPath);
                return this.ldapCertStore.getCRLs(xsel);
            }
            catch (IOException ioe) {
                throw new CertStoreException(ioe);
            }
        }
        long time = System.currentTimeMillis();
        if (time - this.lastChecked < 30000L) {
            if (debug == null) return URICertStore.getMatchingCRLs(this.crl, selector);
            System.out.println("Returning CRL from cache");
            return URICertStore.getMatchingCRLs(this.crl, selector);
        }
        this.lastChecked = time;
        InputStream in = null;
        try {
            URLConnection connection = this.uri.toURL().openConnection();
            if (this.lastModified != 0L) {
                connection.setIfModifiedSince(this.lastModified);
            }
            connection.setConnectTimeout(CertPathSystemProperties.getCRLSConnectTimeout());
            in = connection.getInputStream();
            long oldLastModified = this.lastModified;
            this.lastModified = connection.getLastModified();
            if (oldLastModified != 0L) {
                HttpURLConnection hconn;
                if (oldLastModified == this.lastModified) {
                    if (debug != null) {
                        System.out.println("Not modified, using cached copy");
                    }
                    Collection<X509CRL> collection = URICertStore.getMatchingCRLs(this.crl, selector);
                    return collection;
                }
                if (connection instanceof HttpURLConnection && (hconn = (HttpURLConnection)connection).getResponseCode() == 304) {
                    if (debug != null) {
                        System.out.println("Not modified, using cached copy");
                    }
                    Collection<X509CRL> collection = URICertStore.getMatchingCRLs(this.crl, selector);
                    return collection;
                }
            }
            if (debug != null) {
                System.out.println("Downloading new CRL...");
            }
            this.crl = (X509CRL)this.factory.generateCRL(in);
            Collection<X509CRL> collection = URICertStore.getMatchingCRLs(this.crl, selector);
            return collection;
        }
        catch (IOException e) {
            if (debug != null) {
                System.out.println("Exception fetching CRL:");
                e.printStackTrace();
            }
        }
        catch (CRLException e) {
            if (debug != null) {
                System.out.println("Exception fetching CRL:");
                e.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        this.lastModified = 0L;
        this.crl = null;
        return Collections.emptyList();
    }

    private static Collection<X509CRL> getMatchingCRLs(X509CRL crl, CRLSelector selector) {
        if (selector == null || crl != null && selector.match(crl)) {
            return Collections.singletonList(crl);
        }
        return Collections.emptyList();
    }

    private static class UCS
    extends CertStore {
        protected UCS(CertStoreSpi spi, Provider p, String type, CertStoreParameters params) {
            super(spi, p, type, params);
        }
    }

    public static class URICertStoreParameters
    implements CertStoreParameters {
        private final URI uri;
        private volatile int hashCode = 0;

        public URICertStoreParameters(URI uri) {
            this.uri = uri;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof URICertStoreParameters)) {
                return false;
            }
            URICertStoreParameters params = (URICertStoreParameters)obj;
            return this.uri.equals(params.uri);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                this.hashCode = result = 37 * result + this.uri.hashCode();
            }
            return this.hashCode;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.toString());
            }
        }
    }

    private static class LDAP {
        private static final String CERT_STORE_HELPER = "com.ibm.security.cert.ldap.LDAPCertStoreHelper";
        private static final CertStoreHelper helper = AccessController.doPrivileged(new PrivilegedAction<CertStoreHelper>(){

            @Override
            public CertStoreHelper run() {
                try {
                    Class<?> c = Class.forName(LDAP.CERT_STORE_HELPER, true, null);
                    return (CertStoreHelper)c.newInstance();
                }
                catch (ClassNotFoundException cnf) {
                    return null;
                }
                catch (InstantiationException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
        });

        private LDAP() {
        }

        static CertStoreHelper helper() {
            return helper;
        }
    }
}

