/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert.deploy;

import com.ibm.misc.Debug;
import com.ibm.security.cert.deploy.AdaptableX509CertSelector;
import com.ibm.security.cert.deploy.AlgorithmChecker;
import com.ibm.security.cert.deploy.URICertStore;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.CRLDistributionPointsExtension;
import com.ibm.security.x509.DistributionPoint;
import com.ibm.security.x509.DistributionPointName;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.IssuingDistributionPointExtension;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.RDN;
import com.ibm.security.x509.ReasonFlags;
import com.ibm.security.x509.SerialNumber;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.action.GetBooleanAction;

public class DistributionPointFetcher {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private static final boolean USE_CRLDP = AccessController.doPrivileged(new GetBooleanAction("com.ibm.security.enableCRLDP"));

    private DistributionPointFetcher() {
    }

    public static Collection<X509CRL> getCRLs(X509CRLSelector selector, boolean signFlag, PublicKey prevKey, String provider, List<CertStore> certStores, boolean[] reasonsMask, Set<TrustAnchor> trustAnchors, Date validity) throws CertStoreException, GeneralNamesException {
        if (!USE_CRLDP) {
            return Collections.emptySet();
        }
        X509Certificate cert = selector.getCertificateChecking();
        if (cert == null) {
            return Collections.emptySet();
        }
        try {
            CRLDistributionPointsExtension ext;
            X509CertImpl certImpl = X509CertImpl.toImpl((X509Certificate)cert);
            if (debug != null) {
                System.out.println("DistributionPointFetcher.getCRLs: Checking CRLDPs for " + certImpl.getSubjectX500Principal());
            }
            if ((ext = certImpl.getCRLDistributionPointsExtension()) == null) {
                if (debug != null) {
                    System.out.println("No CRLDP ext");
                }
                return Collections.emptySet();
            }
            DistributionPoint[] pointArray = ext.get("distribution_pts");
            ArrayList<DistributionPoint> points = new ArrayList<DistributionPoint>(Arrays.asList(pointArray));
            HashSet<X509CRL> results = new HashSet<X509CRL>();
            Iterator t = points.iterator();
            while (t.hasNext() && !Arrays.equals(reasonsMask, ALL_REASONS)) {
                DistributionPoint point = (DistributionPoint)t.next();
                Collection<X509CRL> crls = DistributionPointFetcher.getCRLs(selector, certImpl, point, reasonsMask, signFlag, prevKey, provider, certStores, trustAnchors, validity);
                results.addAll(crls);
            }
            if (debug != null) {
                System.out.println("Returning " + results.size() + " CRLs");
            }
            return results;
        }
        catch (CertificateException e) {
            return Collections.emptySet();
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    private static Collection<X509CRL> getCRLs(X509CRLSelector selector, X509CertImpl certImpl, DistributionPoint point, boolean[] reasonsMask, boolean signFlag, PublicKey prevKey, String provider, List<CertStore> certStores, Set<TrustAnchor> trustAnchors, Date validity) throws GeneralNamesException, IOException {
        GeneralNames fullName = null;
        DistributionPointName tmpname = point.getName();
        if (tmpname != null) {
            if (tmpname instanceof GeneralNames) {
                fullName = (GeneralNames)tmpname;
            } else if (fullName == null && tmpname instanceof RDN) {
                RDN relativeName = (RDN)point.getName();
                try {
                    GeneralNames crlIssuers = point.getIssuer();
                    if (crlIssuers == null) {
                        fullName = DistributionPointFetcher.getFullNames((X500Name)certImpl.getIssuerDN(), relativeName);
                    }
                    if (crlIssuers.size() != 1) {
                        return Collections.emptySet();
                    }
                    fullName = DistributionPointFetcher.getFullNames((X500Name)((GeneralName)crlIssuers.get(0)).getName(), relativeName);
                }
                catch (IOException e) {
                    return Collections.emptySet();
                }
            }
        } else {
            return Collections.emptySet();
        }
        ArrayList<X509CRL> possibleCRLs = new ArrayList<X509CRL>();
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>(2);
        for (GeneralName name : fullName) {
            URIName uriName;
            X509CRL crl;
            if (name.getType() == 4) {
                X500Name x500Name = (X500Name)name.getName();
                possibleCRLs.addAll(DistributionPointFetcher.getCRLs(x500Name, certImpl.getIssuerX500Principal(), certStores));
                continue;
            }
            if (name.getType() != 6 || (crl = DistributionPointFetcher.getCRL(uriName = (URIName)name.getName())) == null) continue;
            possibleCRLs.add(crl);
        }
        for (X509CRL crl : possibleCRLs) {
            try {
                selector.setIssuerNames(null);
                if (!selector.match(crl) || !DistributionPointFetcher.verifyCRL(certImpl, point, crl, reasonsMask, signFlag, prevKey, provider, trustAnchors, certStores, validity)) continue;
                crls.add(crl);
            }
            catch (Exception e) {
                if (debug == null) continue;
                System.out.println("Exception verifying CRL: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return crls;
    }

    private static X509CRL getCRL(URIName name) {
        URI uri = name.getURI();
        if (debug != null) {
            System.out.println("Trying to fetch CRL from DP " + uri);
        }
        try {
            CertStore ucs = URICertStore.getInstance(new URICertStore.URICertStoreParameters(uri));
            Collection<? extends CRL> crls = ucs.getCRLs(null);
            if (crls.isEmpty()) {
                return null;
            }
            return (X509CRL)crls.iterator().next();
        }
        catch (Exception e) {
            if (debug != null) {
                System.out.println("Exception getting CRL from CertStore: " + e);
                e.printStackTrace();
            }
            return null;
        }
    }

    private static Collection<X509CRL> getCRLs(X500Name name, X500Principal certIssuer, List<CertStore> certStores) {
        if (debug != null) {
            System.out.println("Trying to fetch CRL from DP " + name);
        }
        X509CRLSelector xcs = new X509CRLSelector();
        xcs.addIssuer(new X500Principal(name.getName()));
        xcs.addIssuer(certIssuer);
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        for (CertStore store : certStores) {
            try {
                for (CRL cRL : store.getCRLs(xcs)) {
                    crls.add((X509CRL)cRL);
                }
            }
            catch (CertStoreException cse) {
                if (debug == null) continue;
                System.out.println("Non-fatal exception while retrieving CRLs: " + cse);
                cse.printStackTrace();
            }
        }
        return crls;
    }

    static boolean verifyCRL(X509CertImpl certImpl, DistributionPoint point, X509CRL crl, boolean[] reasonsMask, boolean signFlag, PublicKey prevKey, String provider, Set<TrustAnchor> trustAnchors, List<CertStore> certStores, Date validity) throws CRLException, IOException, GeneralNamesException {
        int i;
        Iterator<String> i2;
        boolean indirectCRL = false;
        X509CRLImpl crlImpl = X509CRLImpl.toImpl((X509CRL)crl);
        IssuingDistributionPointExtension idpExt = crlImpl.getIssuingDistributionPointExtension();
        X500Name certIssuer = (X500Name)certImpl.getIssuerDN();
        X500Name crlIssuer = (X500Name)crlImpl.getIssuerDN();
        GeneralNames pointCrlIssuers = point.getIssuer();
        X500Name pointCrlIssuer = null;
        if (pointCrlIssuers != null) {
            if (idpExt == null || ((Boolean)idpExt.get("indirect_crl")).equals(Boolean.FALSE)) {
                return false;
            }
            boolean match = false;
            Iterator t = pointCrlIssuers.iterator();
            while (!match && t.hasNext()) {
                GeneralNameInterface name = ((GeneralName)t.next()).getName();
                if (!crlIssuer.equals((Object)name)) continue;
                pointCrlIssuer = (X500Name)name;
                match = true;
            }
            if (!match) {
                return false;
            }
            if (DistributionPointFetcher.issues(certImpl, crlImpl, provider)) {
                prevKey = certImpl.getPublicKey();
            } else {
                indirectCRL = true;
            }
        } else {
            if (!crlIssuer.equals(certIssuer)) {
                if (debug != null) {
                    System.out.println("crl issuer does not equal cert issuer");
                }
                return false;
            }
            byte[] certAKID = certImpl.getExtensionValue(PKIXExtensions.AuthorityKey_Id.toString());
            byte[] crlAKID = crlImpl.getExtensionValue(PKIXExtensions.AuthorityKey_Id.toString());
            if (certAKID == null || crlAKID == null) {
                if (DistributionPointFetcher.issues(certImpl, crlImpl, provider)) {
                    prevKey = certImpl.getPublicKey();
                }
            } else if (!Arrays.equals(certAKID, crlAKID)) {
                if (DistributionPointFetcher.issues(certImpl, crlImpl, provider)) {
                    prevKey = certImpl.getPublicKey();
                } else {
                    indirectCRL = true;
                }
            }
        }
        if (!indirectCRL && !signFlag) {
            return false;
        }
        if (idpExt != null) {
            Boolean b;
            DistributionPointName idpPoint = (DistributionPointName)idpExt.get("distribution_pt");
            if (idpPoint != null) {
                boolean match;
                GeneralNames idpNames = null;
                if (idpPoint != null) {
                    if (idpPoint instanceof GeneralNames) {
                        idpNames = (GeneralNames)idpPoint;
                    } else if (idpNames == null && idpPoint instanceof RDN) {
                        RDN relativeName = (RDN)idpPoint;
                        if (debug != null) {
                            System.out.println("IDP relativeName:" + relativeName);
                        }
                        idpNames = DistributionPointFetcher.getFullNames(crlIssuer, relativeName);
                    }
                }
                GeneralNames pointNames = null;
                DistributionPointName tmpname = point.getName();
                if (tmpname != null) {
                    if (tmpname instanceof GeneralNames) {
                        pointNames = (GeneralNames)tmpname;
                    } else if (pointNames == null && tmpname instanceof RDN) {
                        RDN relativeName = (RDN)tmpname;
                        if (debug != null) {
                            System.out.println("DP relativeName:" + relativeName);
                        }
                        if (indirectCRL) {
                            if (pointCrlIssuers.size() != 1) {
                                if (debug != null) {
                                    System.out.println("must only be one CRL issuer when relative name present");
                                }
                                return false;
                            }
                            pointNames = DistributionPointFetcher.getFullNames(pointCrlIssuer, relativeName);
                        } else {
                            pointNames = DistributionPointFetcher.getFullNames(certIssuer, relativeName);
                        }
                    }
                    match = false;
                    i2 = idpNames.iterator();
                    while (!match && i2.hasNext()) {
                        GeneralNameInterface idpName = ((GeneralName)i2.next()).getName();
                        if (debug != null) {
                            System.out.println("idpName: " + idpName);
                        }
                        Iterator p = pointNames.iterator();
                        while (!match && p.hasNext()) {
                            GeneralNameInterface pointName = ((GeneralName)p.next()).getName();
                            if (debug != null) {
                                System.out.println("pointName: " + pointName);
                            }
                            match = idpName.equals(pointName);
                        }
                    }
                    if (!match) {
                        if (debug != null) {
                            System.out.println("IDP name does not match DP name");
                        }
                        return false;
                    }
                } else {
                    match = false;
                    Iterator t = pointCrlIssuers.iterator();
                    while (!match && t.hasNext()) {
                        GeneralNameInterface crlIssuerName = ((GeneralName)t.next()).getName();
                        Iterator i3 = idpNames.iterator();
                        while (!match && i3.hasNext()) {
                            GeneralNameInterface idpName = ((GeneralName)i3.next()).getName();
                            match = crlIssuerName.equals(idpName);
                        }
                    }
                    if (!match) {
                        return false;
                    }
                }
            } else {
                if (debug != null) {
                    System.out.println("IDP must be relative or full DN");
                }
                return false;
            }
            if ((b = (Boolean)idpExt.get("user_certs_only")).equals(Boolean.TRUE) && certImpl.getBasicConstraints() != -1) {
                if (debug != null) {
                    System.out.println("cert must be a EE cert");
                }
                return false;
            }
            b = (Boolean)idpExt.get("ca_certs_only");
            if (b.equals(Boolean.TRUE) && certImpl.getBasicConstraints() == -1) {
                if (debug != null) {
                    System.out.println("cert must be a CA cert");
                }
                return false;
            }
            b = (Boolean)idpExt.get("only_attribute_certs");
            if (b.equals(Boolean.TRUE)) {
                if (debug != null) {
                    System.out.println("cert must not be an AA cert");
                }
                return false;
            }
        }
        boolean[] interimReasonsMask = new boolean[9];
        ReasonFlags reasons = null;
        if (idpExt != null) {
            reasons = (ReasonFlags)idpExt.get("limited_reasons");
        }
        ReasonFlags pointReasons = point.getReasons();
        if (reasons != null) {
            if (pointReasons != null) {
                boolean[] idpReasonFlags = reasons.getFlags();
                for (i = 0; i < idpReasonFlags.length; ++i) {
                    if (!idpReasonFlags[i] || !pointReasons.getFlags()[i]) continue;
                    interimReasonsMask[i] = true;
                }
            } else {
                interimReasonsMask = (boolean[])reasons.getFlags().clone();
            }
        } else if (idpExt == null || reasons == null) {
            if (pointReasons != null) {
                interimReasonsMask = (boolean[])pointReasons.getFlags().clone();
            } else {
                interimReasonsMask = new boolean[9];
                Arrays.fill(interimReasonsMask, true);
            }
        }
        boolean oneOrMore = false;
        for (i = 0; i < interimReasonsMask.length && !oneOrMore; ++i) {
            if (reasonsMask[i] || !interimReasonsMask[i]) continue;
            oneOrMore = true;
        }
        if (!oneOrMore) {
            return false;
        }
        if (indirectCRL) {
            X509CertSelector certSel = new X509CertSelector();
            certSel.setSubject(crlIssuer.getName());
            boolean[] crlSign = new boolean[]{false, false, false, false, false, false, true};
            certSel.setKeyUsage(crlSign);
            AuthorityKeyIdentifierExtension akidext = crlImpl.getAuthKeyIdExtension();
            if (akidext != null) {
                SerialNumber asn;
                KeyIdentifier akid = (KeyIdentifier)akidext.get("key_id");
                if (akid != null) {
                    DerOutputStream derout = new DerOutputStream();
                    derout.putOctetString(akid.getIdentifier());
                    certSel.setSubjectKeyIdentifier(derout.toByteArray());
                }
                if ((asn = (SerialNumber)akidext.get("serial_number")) != null) {
                    certSel.setSerialNumber(asn.getNumber());
                }
            }
            HashSet<TrustAnchor> newTrustAnchors = new HashSet<TrustAnchor>(trustAnchors);
            if (prevKey != null) {
                X500Principal principal = certImpl.getIssuerX500Principal();
                TrustAnchor temporary = new TrustAnchor(principal, prevKey, null);
                newTrustAnchors.add(temporary);
            }
            PKIXBuilderParameters params = null;
            try {
                params = new PKIXBuilderParameters(newTrustAnchors, (CertSelector)certSel);
            }
            catch (InvalidAlgorithmParameterException iape) {
                throw new CRLException(iape);
            }
            params.setCertStores(certStores);
            params.setSigProvider(provider);
            params.setDate(validity);
            try {
                CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
                PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(params);
                prevKey = result.getPublicKey();
            }
            catch (Exception e) {
                throw new CRLException(e);
            }
        }
        try {
            AlgorithmChecker.check(prevKey, crl);
        }
        catch (CertPathValidatorException cpve) {
            if (debug != null) {
                System.out.println("CRL signature algorithm check failed: " + cpve);
            }
            return false;
        }
        try {
            crl.verify(prevKey, provider);
        }
        catch (Exception e) {
            if (debug != null) {
                System.out.println("CRL signature failed to verify");
            }
            return false;
        }
        Set<String> unresCritExts = crl.getCriticalExtensionOIDs();
        if (unresCritExts != null) {
            unresCritExts.remove(PKIXExtensions.IssuingDistributionPoint_Id.toString());
            if (!unresCritExts.isEmpty()) {
                if (debug != null) {
                    System.out.println("Unrecognized critical extension(s) in CRL: " + unresCritExts);
                    i2 = unresCritExts.iterator();
                    while (i2.hasNext()) {
                        System.out.println(i2.next());
                    }
                }
                return false;
            }
        }
        for (int i4 = 0; i4 < interimReasonsMask.length; ++i4) {
            if (reasonsMask[i4] || !interimReasonsMask[i4]) continue;
            reasonsMask[i4] = true;
        }
        return true;
    }

    private static GeneralNames getFullNames(X500Name issuer, RDN rdn) throws IOException {
        ArrayList<RDN> rdns = new ArrayList<RDN>(issuer.rdns());
        rdns.add(rdn);
        X500Name fullName = new X500Name(rdns.toArray(new RDN[0]));
        GeneralNames fullNames = new GeneralNames();
        fullNames.add((Object)new GeneralName((GeneralNameInterface)fullName));
        return fullNames;
    }

    private static boolean issues(X509CertImpl cert, X509CRLImpl crl, String provider) throws IOException {
        boolean matched = false;
        AdaptableX509CertSelector issuerSelector = new AdaptableX509CertSelector();
        boolean[] usages = cert.getKeyUsage();
        if (usages != null) {
            usages[6] = true;
            issuerSelector.setKeyUsage(usages);
        }
        X500Principal crlIssuer = crl.getIssuerX500Principal();
        issuerSelector.setSubject(crlIssuer);
        AuthorityKeyIdentifierExtension crlAKID = crl.getAuthKeyIdExtension();
        if (crlAKID != null) {
            issuerSelector.parseAuthorityKeyIdentifierExtension(crlAKID);
        }
        if ((matched = issuerSelector.match((Certificate)cert)) && (crlAKID == null || cert.getAuthorityKeyIdentifierExtension() == null)) {
            try {
                crl.verify(cert.getPublicKey(), provider);
                matched = true;
            }
            catch (Exception e) {
                matched = false;
            }
        }
        return matched;
    }
}

