/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.extObjectInputStream;

public class SealedObject
implements Serializable {
    static final long serialVersionUID = 4482838265551344752L;
    private byte[] encryptedContent = null;
    private String sealAlg = null;
    private String paramsAlg = null;
    protected byte[] encodedParams = null;
    private static final String[] z;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SealedObject(Serializable serializable, Cipher cipher) throws IOException, IllegalBlockSizeException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        try {
            this.encryptedContent = cipher.doFinal(byArray);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        if (cipher.getParameters() != null) {
            this.encodedParams = cipher.getParameters().getEncoded();
            this.paramsAlg = cipher.getParameters().getAlgorithm();
        }
        this.sealAlg = cipher.getAlgorithm();
    }

    protected SealedObject(SealedObject sealedObject) {
        this.encryptedContent = (byte[])sealedObject.encryptedContent.clone();
        this.sealAlg = sealedObject.sealAlg;
        this.paramsAlg = sealedObject.paramsAlg;
        this.encodedParams = (byte[])(sealedObject.encodedParams != null ? (byte[])sealedObject.encodedParams.clone() : null);
    }

    public final String getAlgorithm() {
        return this.sealAlg;
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException(z[4]);
        }
        try {
            return this.a(key, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(z[3]);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getObject(Cipher cipher) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray = cipher.doFinal(this.encryptedContent);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try (extObjectInputStream extObjectInputStream2 = new extObjectInputStream(byteArrayInputStream);){
            Object object;
            Object object2 = object = extObjectInputStream2.readObject();
            return object2;
        }
    }

    public final Object getObject(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        block9: {
            if (key == null) {
                throw new NullPointerException(z[5]);
            }
            if (string != null && string.length() != 0) break block9;
            throw new IllegalArgumentException(z[6]);
        }
        try {
            return this.a(key, string);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new InvalidKeyException(generalSecurityException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object a(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher;
        block20: {
            AlgorithmParameters algorithmParameters = null;
            if (this.encodedParams != null) {
                try {
                    algorithmParameters = string != null ? AlgorithmParameters.getInstance(this.paramsAlg, string) : AlgorithmParameters.getInstance(this.paramsAlg);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    if (string == null) {
                        throw new NoSuchAlgorithmException(this.paramsAlg + z[0]);
                    }
                    throw new NoSuchProviderException(noSuchProviderException.getMessage());
                }
                algorithmParameters.init(this.encodedParams);
            }
            try {
                cipher = string != null ? Cipher.getInstance(this.sealAlg, string) : Cipher.getInstance(this.sealAlg);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new NoSuchAlgorithmException(z[2]);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (string == null) {
                    throw new NoSuchAlgorithmException(this.sealAlg + z[1]);
                }
                throw new NoSuchProviderException(noSuchProviderException.getMessage());
            }
            try {
                block19: {
                    if (algorithmParameters == null) break block19;
                    cipher.init(2, key, algorithmParameters);
                    break block20;
                }
                cipher.init(2, key);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
            }
        }
        byte[] byArray = cipher.doFinal(this.encryptedContent);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try (extObjectInputStream extObjectInputStream2 = new extObjectInputStream(byteArrayInputStream);){
            Object object;
            Object object2 = object = extObjectInputStream2.readObject();
            return object2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.encryptedContent != null) {
            this.encryptedContent = (byte[])this.encryptedContent.clone();
        }
        if (this.encodedParams != null) {
            this.encodedParams = (byte[])this.encodedParams.clone();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u001ff\u0014e\u0016Yg\u000e\u007fR";
        int n2 = -1;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block18;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 63;
                                break;
                            }
                            case 1: {
                                n8 = 8;
                                break;
                            }
                            case 2: {
                                n8 = 123;
                                break;
                            }
                            case 3: {
                                n8 = 17;
                                break;
                            }
                            default: {
                                n8 = 54;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u001ff\u0014e\u0016Yg\u000e\u007fR";
                    n2 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "oi\u001fu_Qo[e^^|[fWL(\u000ebS[(\u0012\u007f\u0016Lm\u001a}_Qo[~FZz\u001ae_Pf[\u007fYK(\u001agWVd\u001asZZ";
                    n2 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "^d\u001c~DV|\u0013|\u0016Qg\u000f1PP}\u0015u";
                    n2 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "Tm\u00021_L(\u0015dZS";
                    n2 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "Tm\u00021_L(\u0015dZS";
                    n2 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "Ra\bb_Qo[aDP~\u0012uSM";
                    n2 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        z = stringArray3;
    }
}

