/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.MessageDigest;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    private static final long serialVersionUID = 6577238317307289933L;
    private byte[] key;
    private String algorithm;
    private static final String[] z;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SecretKeySpec(byte[] byArray, String string) {
        if (byArray == null) throw new IllegalArgumentException(z[4]);
        if (string == null) {
            throw new IllegalArgumentException(z[4]);
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException(z[5]);
        }
        this.key = (byte[])byArray.clone();
        this.algorithm = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SecretKeySpec(byte[] byArray, int n, int n2, String string) {
        if (byArray == null) throw new IllegalArgumentException(z[3]);
        if (string == null) {
            throw new IllegalArgumentException(z[3]);
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException(z[1]);
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException(z[2]);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(z[0]);
        }
        this.key = new byte[n2];
        System.arraycopy(byArray, n, this.key, 0, n2);
        this.algorithm = string;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return z[12];
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    public int hashCode() {
        int n = 0;
        for (int i = 1; i < this.key.length; ++i) {
            n += this.key[i] * i;
        }
        if (this.algorithm.equalsIgnoreCase(z[7])) {
            return n ^= z[6].hashCode();
        }
        return n ^= this.algorithm.toLowerCase().hashCode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        String string = ((SecretKey)object).getAlgorithm();
        if (!(string.equalsIgnoreCase(this.algorithm) || string.equalsIgnoreCase(z[8]) && this.algorithm.equalsIgnoreCase(z[10]) || string.equalsIgnoreCase(z[9]) && this.algorithm.equalsIgnoreCase(z[11]))) {
            return false;
        }
        byte[] byArray = ((SecretKey)object).getEncoded();
        return MessageDigest.isEqual(this.key, byArray);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[13];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "c;=p\n|~=5\u0004n*:&\u0006";
        int n2 = -1;
        block20: while (true) {
            char[] cArray;
            block25: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block24: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block24;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block25;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 15;
                                break;
                            }
                            case 1: {
                                n8 = 94;
                                break;
                            }
                            case 2: {
                                n8 = 83;
                                break;
                            }
                            case 3: {
                                n8 = 80;
                                break;
                            }
                            default: {
                                n8 = 99;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "J3#$\u001a/56)";
                    n2 = 0;
                    continue block20;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "F0%1\u000ff:s?\u0005i-6$Lc;=7\u0017g~0?\u000em7=1\u0017f1=";
                    n2 = 1;
                    continue block20;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "B7 #\na9s1\u0011h+>5\r{";
                    n2 = 2;
                    continue block20;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "B7 #\na9s1\u0011h+>5\r{";
                    n2 = 3;
                    continue block20;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "J3#$\u001a/56)";
                    n2 = 4;
                    continue block20;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "k; 5\u0007j";
                    n2 = 5;
                    continue block20;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "[,: \u000fj\u001a\u0016\u0003";
                    n2 = 6;
                    continue block20;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "K\u001b\u00005\u0007j";
                    n2 = 7;
                    continue block20;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "[,: \u000fj\u001a\u0016\u0003";
                    n2 = 8;
                    continue block20;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "[,: \u000fj\u001a\u0016\u0003";
                    n2 = 9;
                    continue block20;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "K\u001b\u00005\u0007j";
                    n2 = 10;
                    continue block20;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "]\u001f\u0004";
                    n2 = 11;
                    continue block20;
                }
                case 11: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        z = stringArray3;
    }
}

