/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.jgss.mech.krb5.ServiceCreds;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.KDCOptions;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.KrbTgsReq;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.CredentialsUtil;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.LoginOptions;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.krb5.internal.TicketFlags;
import com.ibm.security.krb5.internal.ccache.c;
import com.ibm.security.krb5.internal.ccache.d;
import com.ibm.security.krb5.internal.crypto.o;
import com.ibm.security.krb5.internal.ktab.KeyTab;
import com.ibm.security.krb5.internal.ktab.f;
import com.ibm.security.krb5.internal.l;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Date;

public class Credentials {
    Ticket a;
    PrincipalName b;
    PrincipalName c;
    EncryptionKey d;
    TicketFlags e;
    KerberosTime f;
    KerberosTime g;
    KerberosTime h;
    KerberosTime i;
    HostAddresses j;
    EncryptionKey[] k;
    private ServiceCreds l;
    private static d m;
    private static boolean n;
    private static boolean o;
    static Krb5Debug p;
    private static final String[] z;

    private static native Credentials acquireDefaultNativeCreds(int[] var0);

    public Credentials(Ticket ticket, PrincipalName principalName, PrincipalName principalName2, EncryptionKey encryptionKey, TicketFlags ticketFlags, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses) {
        this.a = ticket;
        this.b = principalName;
        this.c = principalName2;
        this.d = encryptionKey;
        this.e = ticketFlags;
        this.f = kerberosTime;
        this.g = kerberosTime2;
        this.h = kerberosTime3;
        this.i = kerberosTime4;
        this.j = hostAddresses;
    }

    public Credentials(byte[] byArray, String string, String string2, byte[] byArray2, int n2, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws KrbException, IOException {
        this(new Ticket(byArray), new PrincipalName(string), new PrincipalName(string2), new EncryptionKey(n2, byArray2), blArray == null ? null : new TicketFlags(blArray), date == null ? null : new KerberosTime(date), date2 == null ? null : new KerberosTime(date2), date3 == null ? null : new KerberosTime(date3), date4 == null ? null : new KerberosTime(date4), null);
    }

    public Credentials(PrincipalName principalName, EncryptionKey encryptionKey) throws RealmException {
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(z[32]);
        }
        if (encryptionKey == null) {
            I18NException.throwIllegalArgumentException(z[31]);
        }
        this.b = principalName;
        this.k = new EncryptionKey[1];
        this.k[0] = (EncryptionKey)encryptionKey.clone();
        if (Krb5Debug.on(3)) {
            p.out(3, z[33] + EncryptedData.encTypeToString(this.k[0].getEType()));
        }
    }

    public Credentials(String string, ServiceCreds serviceCreds) throws RealmException {
        if (serviceCreds == null) {
            I18NException.throwIllegalArgumentException(z[30]);
        }
        if (string != null) {
            this.b = new PrincipalName(string);
        }
        this.l = serviceCreds;
    }

    public Credentials(PrincipalName principalName, EncryptionKey[] encryptionKeyArray) throws RealmException {
        int n2;
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(z[16]);
        }
        if (encryptionKeyArray == null) {
            I18NException.throwIllegalArgumentException(z[12]);
        }
        this.b = principalName;
        this.k = new EncryptionKey[encryptionKeyArray.length];
        for (n2 = 0; n2 < encryptionKeyArray.length; ++n2) {
            this.k[n2] = (EncryptionKey)encryptionKeyArray[n2].clone();
        }
        if (Krb5Debug.on(3)) {
            p.out(3, z[13] + encryptionKeyArray.length + z[11]);
            for (n2 = 0; n2 < encryptionKeyArray.length; ++n2) {
                p.out(3, z[14] + (n2 + 1) + z[15] + EncryptedData.encTypeToString(this.k[n2].getEType()));
            }
        }
    }

    public final PrincipalName getClient() {
        return this.b;
    }

    public final PrincipalName getServer() {
        return this.c;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EncryptionKey getSessionKey() {
        if (this.d == null) {
            if (Krb5Debug.on(3)) {
                p.out(3, z[8]);
            }
            if (this.k != null) {
                return (EncryptionKey)this.k[0].clone();
            }
            if (Krb5Debug.on(3)) {
                p.out(3, z[7]);
            }
            return null;
        }
        if (Krb5Debug.on(3) && Credentials.a(this.d.getBytes())) {
            p.out(3, z[9] + (this.d != null ? new HexDumpEncoder().encode(this.d.getBytes()) : ""));
        }
        return this.d;
    }

    public final Date getStartTime() {
        if (this.g != null) {
            return this.g.toDate();
        }
        return null;
    }

    public final Date getEndTime() {
        if (this.h != null) {
            return this.h.toDate();
        }
        return null;
    }

    public final Date getRenewTill() {
        if (this.i != null) {
            return this.i.toDate();
        }
        return null;
    }

    public final boolean[] getFlags() {
        if (this.e == null) {
            return null;
        }
        return this.e.a();
    }

    public final InetAddress[] getClientAddresses() {
        if (this.j == null) {
            return null;
        }
        return this.j.getInetAddresses();
    }

    public final byte[] getEncoded() {
        byte[] byArray = null;
        try {
            byArray = this.a.asn1Encode();
        }
        catch (Asn1Exception asn1Exception) {
            if (Krb5Debug.on(6)) {
                p.out(3, asn1Exception);
            }
        }
        catch (IOException iOException) {
            if (Krb5Debug.on(6)) {
                p.out(3, iOException);
            }
        }
        return byArray;
    }

    public boolean isRenewable() {
        return this.e.get(8);
    }

    public boolean isForwardable() {
        return this.e.get(1);
    }

    public Ticket getTicket() {
        if (Krb5Debug.on(3)) {
            p.out(3, z[44]);
        }
        return this.a;
    }

    public TicketFlags getTicketFlags() {
        return this.e;
    }

    public boolean checkDelegate() {
        boolean bl = false;
        try {
            bl = this.e.get(13);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void resetDelegate() {
        this.e.set(13, false);
    }

    public Credentials renew() throws KrbException, IOException {
        KDCOptions kDCOptions = new KDCOptions();
        boolean[] blArray = this.e.a();
        for (int i2 = 1; i2 < 6; ++i2) {
            kDCOptions.set(i2, blArray[i2]);
        }
        kDCOptions.set(30, true);
        kDCOptions.set(8, true);
        return new KrbTgsReq(kDCOptions, this, this.c, null, null, null, null, this.j, null, null, null).sendAndGetCreds();
    }

    public static Credentials acquireTGTFromCache(PrincipalName principalName, String string) throws KrbException, IOException {
        d d2 = com.ibm.security.krb5.internal.ccache.d.a(principalName, string);
        if (d2 == null) {
            return null;
        }
        c c2 = d2.f();
        return c2.c();
    }

    public static Credentials acquireTGTFromCache(PrincipalName principalName, InputStream inputStream) throws KrbException, IOException {
        d d2 = com.ibm.security.krb5.internal.ccache.d.a(principalName, inputStream);
        if (d2 == null) {
            return null;
        }
        c c2 = d2.f();
        return c2.c();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Credentials acquireDefaultCreds() {
        Credentials credentials = null;
        m = com.ibm.security.krb5.internal.ccache.d.a();
        if (m == null) {
            return Credentials.getDefaultNativeCreds();
        }
        if (Krb5Debug.on(3)) {
            p.out(3, z[1]);
        }
        c c2 = m.f();
        return c2.c();
    }

    public static Credentials getServiceCreds(String string, File file) throws IOException, IllegalArgumentException {
        block23: {
            EncryptionKey[] encryptionKeyArray;
            KeyTab keyTab;
            PrincipalName principalName;
            block24: {
                principalName = null;
                PrincipalName principalName2 = null;
                if (string != null) {
                    try {
                        principalName = new PrincipalName(string);
                    }
                    catch (Exception exception) {
                        if (Krb5Debug.on(6)) {
                            p.out(3, z[4] + string + z[5] + exception.toString());
                        }
                        return null;
                    }
                }
                keyTab = null;
                keyTab = file == null ? KeyTab.getInstance() : KeyTab.getInstance(file);
                if (keyTab == null) break block23;
                if (principalName != null) break block24;
                encryptionKeyArray = keyTab.getEntry(principalName);
                if (encryptionKeyArray == null) {
                    return null;
                }
                principalName2 = encryptionKeyArray.getService();
                if (principalName2 == null) {
                    return null;
                }
                principalName = principalName2;
            }
            try {
                block25: {
                    encryptionKeyArray = keyTab.getAllKeys(principalName);
                    if (encryptionKeyArray != null && encryptionKeyArray.length > 0) break block25;
                    I18NException.throwIllegalArgumentException(z[2], new String[]{principalName.toString(), keyTab.tabName()});
                }
                return new Credentials(principalName, encryptionKeyArray);
            }
            catch (Exception exception) {
                if (Krb5Debug.on(6)) {
                    p.out(3, z[3] + exception.toString());
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Credentials getServiceCreds(PrincipalName principalName, InputStream inputStream) throws IOException, KrbException {
        EncryptionKey[] encryptionKeyArray;
        f f2 = new f(inputStream);
        if (principalName == null) {
            encryptionKeyArray = f2.a(principalName);
            if (encryptionKeyArray == null) {
                return null;
            }
            principalName = encryptionKeyArray.getService();
            if (principalName == null) {
                return null;
            }
        }
        if ((encryptionKeyArray = f2.b(principalName)) == null || encryptionKeyArray.length <= 0) {
            I18NException.throwIllegalArgumentException(z[6], new String[]{principalName.toString(), inputStream.toString()});
        }
        return new Credentials(principalName, encryptionKeyArray);
    }

    public static Credentials acquireCreds(String string) {
        Credentials credentials = null;
        try {
            PrincipalName principalName = new PrincipalName(string);
            credentials = Credentials.a(principalName, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return credentials;
    }

    public static Credentials acquireCreds(String string, String string2) {
        return Credentials.acquireCreds(string);
    }

    private static Credentials a(PrincipalName principalName, String string, LoginOptions loginOptions) {
        Credentials credentials;
        block25: {
            PrincipalName principalName2 = null;
            credentials = null;
            String string2 = principalName.getRealmString();
            try {
                c c2;
                block29: {
                    block27: {
                        block28: {
                            block26: {
                                if (principalName == null || string2 == null) break block25;
                                principalName2 = PrincipalName.tgsService(string2, string2);
                                m = string == null ? com.ibm.security.krb5.internal.ccache.d.a(principalName) : com.ibm.security.krb5.internal.ccache.d.a(principalName, string);
                                if (m == null || m.c().match(principalName)) break block26;
                                m = null;
                            }
                            if (m != null) break block27;
                            if (string != null) break block28;
                            m = com.ibm.security.krb5.internal.ccache.d.a(principalName);
                            break block27;
                        }
                        m = com.ibm.security.krb5.internal.ccache.d.a(principalName, string);
                    }
                    if (m == null || m.e() == null) break block25;
                    c2 = m.a(loginOptions, principalName2);
                    if (c2 == null || !c2.a()) break block25;
                    if (!Krb5Debug.on(3)) break block29;
                    p.out(3, z[27]);
                }
                credentials = c2.c();
            }
            catch (Exception exception) {
                credentials = null;
            }
        }
        if (credentials == null) {
            m = null;
        }
        return credentials;
    }

    public static Credentials acquireServiceCreds(PrincipalName principalName, Credentials credentials) throws Exception {
        return Credentials.acquireServiceCreds(principalName, credentials, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Credentials acquireServiceCreds(PrincipalName principalName, Credentials credentials, KDCOptions kDCOptions, HostAddresses hostAddresses) throws KrbException, Exception {
        Credentials credentials2 = com.ibm.security.krb5.internal.l.a(principalName, credentials, kDCOptions, hostAddresses);
        if (credentials2 == null) return credentials2;
        if (!Krb5Debug.on(3)) return credentials2;
        p.out(3, z[0]);
        Credentials.printDebug(credentials2);
        return credentials2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Credentials acquireSvcCreds(PrincipalName principalName, KDCOptions kDCOptions, HostAddresses hostAddresses) throws KrbException, Exception {
        l l2 = new l();
        Credentials credentials = l2.d(principalName, this, kDCOptions, hostAddresses);
        if (credentials == null) return credentials;
        if (!Krb5Debug.on(3)) return credentials;
        p.out(3, z[10]);
        Credentials.printDebug(credentials);
        return credentials;
    }

    public static Credentials acquireServiceCreds(String string, Credentials credentials) throws KrbException, IOException {
        return CredentialsUtil.acquireServiceCreds(string, credentials);
    }

    public static Credentials acquireS4U2selfCreds(PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        return CredentialsUtil.acquireS4U2selfCreds(principalName, credentials);
    }

    public static Credentials acquireS4U2proxyCreds(String string, Ticket ticket, PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        return CredentialsUtil.acquireS4U2proxyCreds(string, ticket, principalName, credentials);
    }

    public d getCache() {
        return m;
    }

    public EncryptionKey getServiceKey() {
        if (this.k != null) {
            return (EncryptionKey)this.k[0].clone();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EncryptionKey getServiceKey(int n2) {
        EncryptionKey[] encryptionKeyArray = this.getServiceKeys();
        int n3 = 0;
        while (n3 < encryptionKeyArray.length) {
            if (encryptionKeyArray[n3].getEType() == n2) {
                return encryptionKeyArray[n3];
            }
            ++n3;
        }
        return null;
    }

    public EncryptionKey[] getServiceCredKeys(PrincipalName principalName) {
        return this.l.getEKeys(principalName);
    }

    public EncryptionKey[] getServiceKeys() {
        if (this.k == null) {
            return null;
        }
        EncryptionKey[] encryptionKeyArray = new EncryptionKey[this.k.length];
        for (int i2 = 0; i2 < this.k.length; ++i2) {
            encryptionKeyArray[i2] = (EncryptionKey)this.k[i2].clone();
        }
        return encryptionKeyArray;
    }

    public void setServiceKey(EncryptionKey encryptionKey) throws Exception {
        if (encryptionKey == null) {
            I18NException.throwException(z[54]);
        }
        if (this.k != null) {
            I18NException.throwException(z[53]);
        }
        this.k = new EncryptionKey[1];
        this.k[0] = (EncryptionKey)encryptionKey.clone();
    }

    public void setServiceKeys(EncryptionKey[] encryptionKeyArray) throws Exception {
        if (encryptionKeyArray == null) {
            I18NException.throwException(z[29]);
        }
        if (this.k != null) {
            I18NException.throwException(z[28]);
        }
        this.k = new EncryptionKey[encryptionKeyArray.length];
        for (int i2 = 0; i2 < this.k.length; ++i2) {
            this.k[i2] = (EncryptionKey)encryptionKeyArray[i2].clone();
        }
    }

    public static void printDebug(Credentials credentials) {
        block7: {
            block6: {
                System.out.println(z[50]);
                PrintStream printStream = System.out;
                StringBuilder stringBuilder = new StringBuilder().append(z[51]);
                String string = credentials.b != null ? credentials.b.toString() : "";
                printStream.println(stringBuilder.append(string).toString());
                PrintStream printStream2 = System.out;
                StringBuilder stringBuilder2 = new StringBuilder().append(z[52]);
                String string2 = credentials.c != null ? credentials.c.toString() : "";
                printStream2.println(stringBuilder2.append(string2).toString());
                System.out.println(z[45] + credentials.a.sname.toString());
                if (credentials.g == null) break block6;
                System.out.println(z[46] + credentials.g.getTime());
                break block7;
            }
            System.out.println(z[49]);
        }
        System.out.println(z[47] + credentials.h.getTime());
        System.out.println(z[48]);
    }

    public static synchronized void ensureLoaded() {
        block9: {
            block8: {
                if (!n && !o) break block8;
                return;
            }
            o = true;
            try {
                AccessController.doPrivileged(new com.ibm.security.krb5.c());
                n = true;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (Krb5Debug.on(6)) {
                    exception.printStackTrace();
                    Krb5Debug krb5Debug = new Krb5Debug(z[26]);
                    krb5Debug.out(3, z[25] + exception);
                }
            }
            catch (Exception exception) {
                if (!Krb5Debug.on(6)) break block9;
                exception.printStackTrace();
                Krb5Debug krb5Debug = new Krb5Debug(z[24]);
                krb5Debug.out(3, z[23] + exception);
            }
        }
    }

    public static Credentials getDefaultNativeCreds() {
        Credentials credentials = null;
        String string = Credentials.a(z[19]);
        if (!string.startsWith(z[20])) {
            return null;
        }
        if (!o) {
            try {
                Credentials.ensureLoaded();
            }
            catch (Exception exception) {
                if (Krb5Debug.on(3)) {
                    p.out(3, z[21]);
                    exception.printStackTrace();
                }
                o = true;
            }
        }
        if (n) {
            p.out(3, z[17]);
            credentials = Credentials.acquireDefaultNativeCreds(com.ibm.security.krb5.internal.crypto.o.a(z[18]));
        } else {
            p.out(3, z[22]);
        }
        return credentials;
    }

    public Date getAuthTime() {
        if (this.f == null) {
            return null;
        }
        return this.f.toDate();
    }

    public static boolean isAlreadyLoaded() {
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(z[34]);
        stringBuffer.append(z[39]).append(this.b);
        stringBuffer.append(z[40]).append(this.c);
        if (this.f != null) {
            stringBuffer.append(z[41]).append(this.f);
        }
        if (this.g != null) {
            stringBuffer.append(z[43]).append(this.g);
        }
        stringBuffer.append(z[37]).append(this.h);
        stringBuffer.append(z[42]).append(this.i);
        stringBuffer.append(z[36]).append(this.e);
        stringBuffer.append(z[38]).append(this.d.getEType());
        stringBuffer.append(z[35]).append(this.a.encPart.a);
        return stringBuffer.toString();
    }

    public ServiceCreds getServiceCreds() {
        return this.l;
    }

    private static String a(String string) {
        String string2 = AccessController.doPrivileged(new com.ibm.security.krb5.d(string));
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean a(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return true;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[57];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "D2\u0018jn\u001fhCGh\u0013mJZ2\u001boW\\u\biuLn\feEL_\biBZ&Z~C]i\bbOG{ZoTLx\t6";
        int n3 = -1;
        block64: while (true) {
            char[] cArray;
            block69: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block68: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block68;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block69;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 122;
                                break;
                            }
                            case 1: {
                                n9 = 12;
                                break;
                            }
                            case 2: {
                                n9 = 38;
                                break;
                            }
                            case 3: {
                                n9 = 41;
                                break;
                            }
                            default: {
                                n9 = 28;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "D2\u0018bn\u0018OTLx\t,@Fi\u0014h\u0006]t\u001f,BLz\u001byJ]<\u000eeEBy\u000e,A[}\u0014xOG{ZxOJw\u001fx\u0006@rZoTLx\u001fbR@}\u0016,EH\u007f\u0012i\b";
                    n3 = 0;
                    continue block64;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "4cmLe<~IDW\u000emDyn\u0013bE";
                    n3 = 1;
                    continue block64;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "D2\u0018\t_\biBLr\u000eeGEoTkC]O\u001f~P@\u007f\u001fOTLx\t,CQ\u007f\u001f|R@s\u00146\u0006";
                    n3 = 2;
                    continue block64;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "D2\u0018\t_\biBLr\u000eeGEoTkC]O\u001f~P@\u007f\u001fOTLx\t,CQ\u007f\u001f|R@s\u0014,E[y\u001bxOG{Z\u007fC[j\u0013oC\tr\u001baC\tz\u0015~\u0006";
                    n3 = 3;
                    continue block64;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "@,";
                    n3 = 4;
                    continue block64;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "4cmLe<~IDW\u000emDyn\u0013bE";
                    n3 = 5;
                    continue block64;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ";`J\tW\u001fuU\t}\bi\u0006gi\u0016`";
                    n3 = 6;
                    continue block64;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = ")iUZu\u0015b\u0006by\u0003,OZ<<eTZhZ_C[j\u0013oC\tW\u001fu";
                    n3 = 7;
                    continue block64;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = ")iUZu\u0015b\u0006by\u0003,OZ<5bJP<)iT_u\u0019i\u0006by\u00036\u0006";
                    n3 = 8;
                    continue block64;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "D2\u0018jn\u001fhCGh\u0013mJZ2\u001boW\\u\biu_\u007f9~CMo@,TLh\u000f~H@r\u001d,E[y\u001e\u007f\u001c";
                    n3 = 9;
                    continue block64;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "ZgCPoT,mLeZx_Yy\t6";
                    n3 = 10;
                    continue block64;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "4yJEW\u001fu";
                    n3 = 11;
                    continue block64;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "D2\u0018\t_\biBLr\u000eeGEo@,e[y\u001bxCM<9~CMy\u0014xOHp\t,Q@h\u0012,";
                    n3 = 12;
                    continue block64;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "sW";
                    n3 = 13;
                    continue block64;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "',";
                    n3 = 14;
                    continue block64;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "4yJER\u001baC";
                    n3 = 15;
                    continue block64;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "D2\u0006h\u007f\u000byO[yZhCO}\u000f`R\tr\u001bxO_yZOTLx\u001fbR@}\u0016\u007f";
                    n3 = 16;
                    continue block64;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\u001ei@Hi\u0016xy]w\u000eSCG\u007f\u000euVLo";
                    n3 = 17;
                    continue block64;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\u0015\u007f\bG}\u0017i";
                    n3 = 18;
                    continue block64;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "-eHMs\r\u007f";
                    n3 = 19;
                    continue block64;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "9mH\tr\u0015x\u0006Es\u001bh\u0006Jn\u001fhCGh\u0013mJZ<\u0019mEAy";
                    n3 = 20;
                    continue block64;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "D2\u0018jn\u001fhCGh\u0013mJZ&ZbI\tr\u001bxO_yZOTLx\u001fbR@}\u0016\u007f\u0006Es\u001bhCM";
                    n3 = 21;
                    continue block64;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "?tELl\u000eeIG<\u0016cGMu\u0014k\u0006G}\u000eePL<\u0019cBL&Z";
                    n3 = 22;
                    continue block64;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "9~CMy\u0014xOHp\t6\u001c\t";
                    n3 = 23;
                    continue block64;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "?tELl\u000eeIG<\u0016cGMu\u0014k\u0006G}\u000eePL<\u0019cBL&Z";
                    n3 = 24;
                    continue block64;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "9~CMy\u0014xOHp\t6\u001c\t";
                    n3 = 25;
                    continue block64;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "D2\u0018bn\u0018OTLx\t,@Fi\u0014h\u0006]t\u001f,PHp\u0013h\u0006]u\u0019gC]<\u001d~GGh\u0013bA\th\u0013oMLhZeH\t\u007f\biBLr\u000eeGE<\u0019mEAyT";
                    n3 = 26;
                    continue block64;
                }
                case 26: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 28;
                    string2 = "?tOZh\u0013bAby\u0003\u007f";
                    n3 = 27;
                    continue block64;
                }
                case 27: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 29;
                    string2 = "4yJEW\u001fu";
                    n3 = 28;
                    continue block64;
                }
                case 28: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 30;
                    string2 = "4yJEW\u001fu";
                    n3 = 29;
                    continue block64;
                }
                case 29: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 31;
                    string2 = "4yJEW\u001fu";
                    n3 = 30;
                    continue block64;
                }
                case 30: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 32;
                    string2 = "4yJER\u001baC";
                    n3 = 31;
                    continue block64;
                }
                case 31: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 33;
                    string2 = "D2\u0018\t_\biBLr\u000eeGEo@,e[y\u001bxCM<9~CMy\u0014xOHp\t,Q@h\u0012,\u0017\tw\u001fu\u0006FzZx_YyZ";
                    n3 = 32;
                    continue block64;
                }
                case 32: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 34;
                    string2 = "9~CMy\u0014xOHp\t6";
                    n3 = 33;
                    continue block64;
                }
                case 33: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 35;
                    string2 = "p,\u0006\t4\u000egR\tw\u001fu\u000f\u0014";
                    n3 = 34;
                    continue block64;
                }
                case 34: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 36;
                    string2 = "pjJH{\t6\u0006";
                    n3 = 35;
                    continue block64;
                }
                case 35: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 37;
                    string2 = "piHMH\u0013aC\u0014";
                    n3 = 36;
                    continue block64;
                }
                case 36: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 38;
                    string2 = "pIrPl\u001f,\u000eZw\u001fu\u000f\u0014";
                    n3 = 37;
                    continue block64;
                }
                case 37: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 39;
                    string2 = "poJ@y\u0014x\u001b";
                    n3 = 38;
                    continue block64;
                }
                case 38: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 40;
                    string2 = "p\u007fC[j\u001f~\u001b";
                    n3 = 39;
                    continue block64;
                }
                case 39: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 41;
                    string2 = "pmS]t.eKL!";
                    n3 = 40;
                    continue block64;
                }
                case 40: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 42;
                    string2 = "p~CGy\rXOEpG";
                    n3 = 41;
                    continue block64;
                }
                case 41: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 43;
                    string2 = "p\u007fRHn\u000eXODyG";
                    n3 = 42;
                    continue block64;
                }
                case 42: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 44;
                    string2 = "(iR\\n\u0014eHN<.eEBy\u000e";
                    n3 = 43;
                    continue block64;
                }
                case 43: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 45;
                    string2 = "sxOJw\u001fx\u001c\to\u0014mKL&Z";
                    n3 = 44;
                    continue block64;
                }
                case 44: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 46;
                    string2 = "s\u007fRHn\u000eXODy@,";
                    n3 = 45;
                    continue block64;
                }
                case 45: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 47;
                    string2 = "siHMH\u0013aC\u0013<";
                    n3 = 46;
                    continue block64;
                }
                case 46: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 48;
                    string2 = "Z,\u0006\t<Z,\u0006\u00041W!e[y\u001eiH]u\u001b`U\ty\u0014h\u000b\u00041W";
                    n3 = 47;
                    continue block64;
                }
                case 47: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 49;
                    string2 = "s\u007fRHn\u000eXODy@,h|P6";
                    n3 = 48;
                    continue block64;
                }
                case 48: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 50;
                    string2 = "D2\u0018mY8Ya\u0013<W!\u000b\u0004_\biBLr\u000eeGEoW!\u000b\u0004";
                    n3 = 49;
                    continue block64;
                }
                case 49: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 51;
                    string2 = "soJ@y\u0014x\u001c\t";
                    n3 = 50;
                    continue block64;
                }
                case 50: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 52;
                    string2 = "s\u007fC[j\u001f~\u001c\t";
                    n3 = 51;
                    continue block64;
                }
                case 51: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 53;
                    string2 = "?tOZh\u0013bAby\u0003\u007f";
                    n3 = 52;
                    continue block64;
                }
                case 52: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 54;
                    string2 = "4yJEW\u001fu";
                    n3 = 53;
                    continue block64;
                }
                case 53: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 55;
                    string2 = "9~CMy\u0014xOHp\t6";
                    n3 = 54;
                    continue block64;
                }
                case 54: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 56;
                    string2 = "@,";
                    n3 = 55;
                    continue block64;
                }
                case 55: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        n = false;
        o = false;
        p = new Krb5Debug(z[55] + Thread.currentThread().getName() + z[56]);
    }
}

