/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.internal.KDCReqBody;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.PAData;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public class KDCReq {
    private int a;
    private int b;
    private PAData[] c;
    private KDCReqBody d;

    public KDCReq(PAData[] pADataArray, KDCReqBody kDCReqBody, int n2) {
        this.a = 5;
        this.b = n2;
        this.c = pADataArray;
        this.d = kDCReqBody;
    }

    public KDCReq() {
    }

    public KDCReq(byte[] byArray, int n2) throws Asn1Exception, IOException, KrbException {
        this.a(new DerValue(byArray), n2);
    }

    public KDCReq(DerValue derValue, int n2) throws Asn1Exception, IOException, KrbException {
        this.a(derValue, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void a(DerValue derValue, int n2) throws Asn1Exception, IOException, KrbException {
        DerValue derValue2;
        if ((derValue.getTag() & 0x1F) != n2) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue.getData().getDerValue();
        if (derValue3.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue4 = derValue3.getData().getDerValue();
        if ((derValue4.getTag() & 0x1F) != 1) throw new Asn1Exception(906);
        BigInteger bigInteger = derValue4.getData().getBigInteger();
        this.a = bigInteger.intValue();
        if (this.a != 5) {
            throw new KrbApErrException(39);
        }
        derValue4 = derValue3.getData().getDerValue();
        if ((derValue4.getTag() & 0x1F) != 2) throw new Asn1Exception(906);
        bigInteger = derValue4.getData().getBigInteger();
        this.b = bigInteger.intValue();
        if (this.b != n2) {
            throw new KrbApErrException(40);
        }
        if ((derValue3.getData().peekByte() & 0x1F) == 3) {
            derValue4 = derValue3.getData().getDerValue();
            derValue2 = derValue4.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new Asn1Exception(906);
            }
            Vector<PAData> vector = new Vector<PAData>();
            while (derValue2.getData().available() > 0) {
                vector.addElement(new PAData(derValue2.getData().getDerValue()));
            }
            if (vector.size() > 0) {
                this.c = new PAData[vector.size()];
                vector.copyInto(this.c);
            }
        } else {
            this.c = null;
        }
        derValue4 = derValue3.getData().getDerValue();
        if ((derValue4.getTag() & 0x1F) != 4) throw new Asn1Exception(906);
        derValue2 = derValue4.getData().getDerValue();
        this.d = new KDCReqBody(derValue2, this.b);
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2;
        block5: {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.putInteger(BigInteger.valueOf(this.a));
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream3);
            derOutputStream3 = new DerOutputStream();
            derOutputStream3.putInteger(BigInteger.valueOf(this.b));
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream3);
            if (this.c == null || this.c.length <= 0) break block5;
            derOutputStream3 = new DerOutputStream();
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                derOutputStream3.write(this.c[i2].asn1Encode());
            }
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)48, derOutputStream3);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream);
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.getReqBody().asn1Encode(this.b));
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, (boolean)true, (byte)((byte)this.b)), derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public byte[] asn1EncodeReqBody() throws Asn1Exception, IOException {
        return this.getReqBody().asn1Encode(this.b);
    }

    public PAData[] getPAData() {
        return this.c;
    }

    public KDCReqBody getRequestBody() {
        return this.getReqBody();
    }

    public int getMessageType() {
        return this.b;
    }

    public int getProtocolVersionNumber() {
        return this.a;
    }

    public KDCReqBody getReqBody() {
        return this.d;
    }
}

