/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class Ticket
implements Cloneable {
    public int tkt_vno;
    public PrincipalName sname;
    public EncryptedData encPart;

    private Ticket() {
    }

    public Object clone() {
        Ticket ticket = new Ticket();
        ticket.sname = (PrincipalName)this.sname.clone();
        ticket.encPart = (EncryptedData)this.encPart.clone();
        ticket.tkt_vno = this.tkt_vno;
        return ticket;
    }

    public Ticket(PrincipalName principalName, EncryptedData encryptedData) {
        this.tkt_vno = 5;
        this.sname = principalName;
        this.encPart = encryptedData;
    }

    public Ticket(byte[] byArray) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.a(new DerValue(byArray));
    }

    public Ticket(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.a(derValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        if ((derValue.getTag() & 0x1F) != 1 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.tkt_vno = derValue3.getData().getBigInteger().intValue();
        if (this.tkt_vno != 5) {
            throw new KrbApErrException(39);
        }
        Realm realm = Realm.parse(derValue2.getData(), (byte)1, false);
        this.sname = PrincipalName.parse(derValue2.getData(), (byte)2, false, realm);
        this.encPart = EncryptedData.parse(derValue2.getData(), (byte)3, false);
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.tkt_vno));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.sname.getRealm().asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.sname.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.encPart.asn1Encode());
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(DerValue.createTag((byte)64, (boolean)true, (byte)1), derOutputStream2);
        return derOutputStream3.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Ticket parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException, RealmException, KrbApErrException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new Ticket(derValue2);
    }

    public int getVersionNumber() {
        return this.tkt_vno;
    }

    public Realm getRealm() {
        return null;
    }

    public PrincipalName getServer() {
        return this.sname;
    }

    public EncryptedData getEncryptedPart() {
        return this.encPart;
    }
}

