/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.giop.GIOPUtil;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.util.LinkedList;

final class FragmentQueue
extends LinkedList {
    private static final long serialVersionUID = 0L;
    private static final String CLASS = FragmentQueue.class.getName();
    private final int fragTimeout;
    final int requestId;
    final byte msgType;
    private boolean lastFragmentReceived = false;

    public Object writeReplace() throws ObjectStreamException {
        throw new NotSerializableException(this.getClass().getName());
    }

    FragmentQueue(int n, byte by, int n2) {
        this.requestId = n;
        this.msgType = by;
        this.fragTimeout = n2;
    }

    synchronized void addNextFragment(WsByteBuffer[] wsByteBufferArray) {
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "Next fragment for ", GIOPUtil.messageTypeName(this.msgType), " message, request number ", Trc.str(this.requestId), Trc.hex(wsByteBufferArray), CLASS, "addNextFragment:100");
        }
        this.add(wsByteBufferArray);
        this.notify();
    }

    synchronized void addLastFragment(WsByteBuffer[] wsByteBufferArray) {
        this.lastFragmentReceived = true;
        this.addNextFragment(wsByteBufferArray);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "Last fragment received.", CLASS, "addLastFragment:114");
        }
    }

    synchronized WsByteBuffer[] getNextFragment() {
        if (this.size() > 0) {
            return (WsByteBuffer[])this.removeFirst();
        }
        if (this.fragTimeout == 0) {
            do {
                try {
                    this.wait();
                    if (this.size() > 0) {
                        return (WsByteBuffer[])this.removeFirst();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.size() <= 0);
            return (WsByteBuffer[])this.removeFirst();
        }
        long l = this.fragTimeout;
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                this.wait(l);
                if (this.size() > 0) {
                    return (WsByteBuffer[])this.removeFirst();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.size() > 0) {
                return (WsByteBuffer[])this.removeFirst();
            }
            l = l2 - System.currentTimeMillis();
        }
        throw GIOPUtil.fragmentTimeoutException(this.requestId, this.msgType);
    }

    synchronized boolean finished() {
        return this.lastFragmentReceived && this.isEmpty();
    }
}

