/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.rmi.util.Store;

public class TreeStore
implements Store {
    private Entry head = null;
    private static final int DEFAULT_SIZE = 16;
    private int lastLocation = Integer.MIN_VALUE;
    private final int size;

    public TreeStore(int n) {
        this.size = n < 2 ? 2 : n;
        this.head = new StartNode(this.size);
    }

    public TreeStore() {
        this.size = 16;
        this.head = new StartNode(this.size);
    }

    @Override
    public void add(int n, Object object) {
        if (n < this.lastLocation) {
            throw new UnsupportedAdditionException(n, this.lastLocation);
        }
        this.lastLocation = n;
        this.head = this.head.add(n, object);
    }

    @Override
    public Object get(int n) {
        return this.head.get(n);
    }

    public static final class UnsupportedAdditionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnsupportedAdditionException(int n, int n2) {
            super("Attempt to add a record for location 0x" + Integer.toHexString(n) + ", which is prior to the location of the last addition, " + "0x" + Integer.toHexString(n2));
        }
    }

    private static final class StartNode
    extends Entry {
        private final int size;

        StartNode(int n) {
            super(0, -1, 1);
            this.size = n;
        }

        @Override
        Entry add(int n, Object object) {
            return new Node(n, object, this.size);
        }

        @Override
        Object get(int n) {
            throw new Store.NoSuchElementException(n);
        }

        @Override
        boolean isFull(int n) {
            return false;
        }
    }

    private static final class Node
    extends Entry {
        private final Object[] objects;

        public Node(int n, Object object, int n2) {
            super(n, 0, n2);
            this.objects = new Object[n2];
            this.objects[0] = object;
        }

        @Override
        public Entry add(int n, Object object) {
            if (this.locations.length == this.index) {
                return new Branch(this, n, object);
            }
            this.locations[this.index] = n;
            this.objects[this.index] = object;
            ++this.index;
            return this;
        }

        @Override
        public Object get(int n) {
            int n2 = this.getLocationIndex(n);
            if (n2 < 0) {
                throw new Store.NoSuchElementException(n);
            }
            return this.objects[n2];
        }

        @Override
        final boolean isFull(int n) {
            return this.locations.length == this.index && n == this.depth + 1;
        }
    }

    private static final class Branch
    extends Entry {
        public final Entry[] entries;

        public Branch(Entry entry, int n, Object object) {
            super(entry.locations[0], entry.depth + 1, entry.locations.length);
            this.entries = new Entry[this.locations.length];
            this.entries[0] = entry;
            this.addNode(n, object);
        }

        @Override
        public Entry add(int n, Object object) {
            int n2 = this.index - 1;
            if (this.entries[n2].isFull(this.depth)) {
                if (this.locations.length == this.index) {
                    return new Branch(this, n, object);
                }
                this.addNode(n, object);
            } else {
                this.entries[n2] = this.entries[n2].add(n, object);
            }
            return this;
        }

        private void addNode(int n, Object object) {
            this.locations[this.index] = n;
            this.entries[this.index] = new Node(n, object, this.locations.length);
            ++this.index;
        }

        @Override
        public Object get(int n) {
            int n2 = this.getLocationIndex(n);
            if (n2 < 0) {
                n2 = -n2 - 1;
            }
            return this.entries[n2].get(n);
        }

        @Override
        final boolean isFull(int n) {
            return this.locations.length == this.index && n == this.depth + 1 && this.entries[this.index - 1].isFull(this.depth);
        }
    }

    private static abstract class Entry {
        protected final int[] locations;
        public final int depth;
        protected int index;

        Entry(int n, int n2, int n3) {
            this.locations = new int[n3];
            this.locations[0] = n;
            this.depth = n2;
            this.index = 1;
        }

        abstract Entry add(int var1, Object var2);

        abstract Object get(int var1);

        abstract boolean isFull(int var1);

        protected final int getLocationIndex(int n) {
            int n2;
            for (n2 = 0; n2 < this.index && n > this.locations[n2]; ++n2) {
            }
            return n2 < this.index && n == this.locations[n2] ? n2 : -n2;
        }
    }
}

