/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util.ranges;

import com.ibm.rmi.util.ranges.FreeRange;
import com.ibm.rmi.util.ranges.OpenRange;
import com.ibm.rmi.util.ranges.RangeSetBuilder;
import com.ibm.rmi.util.ranges.Ranges;
import java.util.Arrays;

final class RangeSetBuilderImpl
implements RangeSetBuilder {
    private static final int EXTENT = 10;
    private int[] rangeBoundaries = new int[10];
    private int count = 0;

    RangeSetBuilderImpl() {
        Arrays.fill(this.rangeBoundaries, Integer.MAX_VALUE);
    }

    @Override
    public int[] getRangeSet() {
        int[] nArray = new int[this.count];
        System.arraycopy(this.rangeBoundaries, 0, nArray, 0, this.count);
        return nArray;
    }

    @Override
    public FreeRange and() {
        return new FreeRangeImpl();
    }

    public String toString() {
        return Ranges.stringifyRangeSet(this.rangeBoundaries, this.count);
    }

    void endRange(int n, int n2) {
        if (!this.unbounded()) {
            throw new Error("Attempt to add upper bound " + Ranges.stringifyBound(n, n2) + " without a corresponding lower bound.");
        }
        if (this.last() > Ranges.compose(n, n2)) {
            throw new Error("attempt to add bound out of sequence: " + Ranges.stringifyBound(n, n2));
        }
        this.add(Ranges.compose(n, n2));
    }

    void startRange(int n, int n2) {
        int n3 = Ranges.compose(n, n2);
        if (this.count != 0) {
            if (this.last() >= Ranges.compose(n, n2)) {
                throw new Error("attempt to add bound out of sequence: " + Ranges.stringifyBound(n, n2));
            }
            if (this.unbounded()) {
                int n4 = (n << 16) - 1;
                if (n4 < this.last()) {
                    throw new Error("cannot insert new lower bound " + Ranges.stringifyBound(n, n2) + " because there is an existing " + "unmatched lower bound at " + "that major version");
                }
                this.add(n4);
            }
        }
        this.add(n3);
    }

    private void add(int n) {
        if (this.rangeBoundaries.length - this.count < 1) {
            int[] nArray = new int[this.rangeBoundaries.length + 10];
            Arrays.fill(nArray, Integer.MAX_VALUE);
            System.arraycopy(this.rangeBoundaries, 0, nArray, 0, this.rangeBoundaries.length);
        }
        this.rangeBoundaries[this.count++] = n;
    }

    private int last() {
        return this.rangeBoundaries[this.count - 1];
    }

    private boolean unbounded() {
        return this.count % 2 == 1;
    }

    private class FreeRangeImpl
    implements FreeRange {
        private FreeRangeImpl() {
        }

        @Override
        public OpenRange from(int n, int n2) {
            RangeSetBuilderImpl.this.startRange(n, n2);
            return new OpenRangeImpl();
        }
    }

    private final class OpenRangeImpl
    implements OpenRange {
        private OpenRangeImpl() {
        }

        @Override
        public RangeSetBuilder onwards() {
            return RangeSetBuilderImpl.this;
        }

        @Override
        public RangeSetBuilder to(int n, int n2) {
            RangeSetBuilderImpl.this.endRange(n, n2);
            return this.onwards();
        }
    }
}

