/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.io;

import com.ibm.jvm.io.LocalizedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public final class ConsoleInputStream
extends FilterInputStream {
    private static final String encoding;
    private static final CharsetDecoder btc;
    private static final CharsetEncoder ctb;
    private static boolean conversionRequired;
    private ByteBuffer reservedIn = null;
    private ByteBuffer reservedOut = null;
    private boolean alreadyClosed = false;

    private ConsoleInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public static void setConversionRequired(boolean bl) {
        conversionRequired = bl;
    }

    public static InputStream localize(InputStream inputStream) {
        if (btc == null || ctb == null) {
            return inputStream;
        }
        return new ConsoleInputStream(inputStream);
    }

    public static String getEncoding(InputStream inputStream) {
        if (inputStream instanceof ConsoleInputStream) {
            ConsoleInputStream cfr_ignored_0 = (ConsoleInputStream)inputStream;
            return encoding;
        }
        return null;
    }

    static InputStream getInputStream(InputStream inputStream) {
        if (inputStream instanceof ConsoleInputStream) {
            return ((ConsoleInputStream)inputStream).in;
        }
        return inputStream;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray) != -1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (conversionRequired) {
            int n4;
            int n5;
            if (null != this.reservedOut) {
                int n6 = n5 = this.reservedOut.remaining() > n2 ? n2 : this.reservedOut.remaining();
                if (this.reservedOut.remaining() >= n2) {
                    System.arraycopy(this.reservedOut.array(), this.reservedOut.position(), byArray, n, n2);
                    this.reservedOut.position(this.reservedOut.position() + n2);
                    if (!this.reservedOut.hasRemaining()) {
                        this.reservedOut = null;
                    }
                    return n2;
                }
                System.arraycopy(this.reservedOut.array(), this.reservedOut.position(), byArray, n, this.reservedOut.remaining());
                n += n5;
                n2 -= n5;
                n3 = n5;
                this.reservedOut = null;
            }
            if (this.alreadyClosed) {
                if (n3 > 0) {
                    return n3;
                }
                this.alreadyClosed = false;
                return -1;
            }
            n5 = (int)Math.ceil((double)n2 / (double)ctb.maxBytesPerChar());
            if ((float)n5 < ctb.maxBytesPerChar()) {
                n5 = (int)Math.ceil(ctb.maxBytesPerChar());
            }
            int n7 = 0;
            byte[] byArray2 = null;
            if (null != this.reservedIn) {
                n4 = this.reservedIn.remaining();
                byArray2 = new byte[n5 += n4];
                System.arraycopy(this.reservedIn.array(), this.reservedIn.position(), byArray2, 0, n4);
                n7 = n4;
                n5 -= n4;
                this.reservedIn = null;
            } else {
                byArray2 = new byte[n5];
            }
            n4 = this.in.read(byArray2, n7, n5);
            if (n4 > 0) {
                Object object;
                Object object2;
                Object object3;
                Object object4 = ByteBuffer.wrap(byArray2, 0, n7 + n4);
                CoderResult coderResult = btc.decode((ByteBuffer)object4, (CharBuffer)(object3 = CharBuffer.allocate(n4)), false);
                if (coderResult.isOverflow()) {
                    while (!coderResult.isUnderflow()) {
                        object2 = CharBuffer.allocate(((Buffer)object3).limit() * 2 + 1);
                        ((Buffer)object3).limit(((Buffer)object3).position());
                        ((Buffer)object3).position(0);
                        object2.put((CharBuffer)object3);
                        object3 = object2;
                        coderResult = btc.decode((ByteBuffer)object4, (CharBuffer)object3, false);
                    }
                }
                if (((Buffer)object4).hasRemaining()) {
                    object2 = new byte[((Buffer)object4).remaining()];
                    System.arraycopy(byArray2, ((Buffer)object4).position(), object2, 0, ((Buffer)object4).remaining());
                    this.reservedIn = ByteBuffer.wrap(object2);
                }
                if (0 == ((Buffer)object3).position()) {
                    return 0;
                }
                object2 = new byte[(int)Math.ceil((float)((Buffer)object3).position() * ctb.maxBytesPerChar())];
                object4 = ByteBuffer.wrap(object2);
                ((Buffer)object3).limit(((Buffer)object3).position());
                ((Buffer)object3).position(0);
                coderResult = ctb.encode((CharBuffer)object3, (ByteBuffer)object4, false);
                if (coderResult.isOverflow()) {
                    while (!coderResult.isUnderflow()) {
                        byte[] byArray3 = new byte[((Buffer)object4).limit() * 2 + 1];
                        object = ByteBuffer.wrap(byArray3);
                        ((Buffer)object4).limit(((Buffer)object4).position());
                        ((Buffer)object4).position(0);
                        ((ByteBuffer)object).put((ByteBuffer)object4);
                        object4 = object;
                        coderResult = btc.decode((ByteBuffer)object4, (CharBuffer)object3, false);
                    }
                }
                object2 = ((ByteBuffer)object4).array();
                if (((Buffer)object4).position() > n2) {
                    System.arraycopy(object2, 0, byArray, n, n2);
                    int n8 = ((Buffer)object4).position() - n2;
                    object = new byte[n8];
                    System.arraycopy(object2, n2, object, 0, n8);
                    this.reservedOut = ByteBuffer.wrap((byte[])object);
                    n3 += n2;
                } else {
                    System.arraycopy(object2, 0, byArray, n, ((Buffer)object4).position());
                    n3 += ((Buffer)object4).position();
                }
            } else if (n4 == -1) {
                Object object;
                byte[] byArray4;
                Object object5;
                Object object6;
                Object object7 = null == this.reservedIn ? ByteBuffer.wrap(new byte[0]) : this.reservedIn;
                CoderResult coderResult = btc.decode((ByteBuffer)object7, (CharBuffer)(object6 = CharBuffer.allocate(((Buffer)object7).remaining() + 1)), true);
                if (coderResult.isOverflow()) {
                    while (!coderResult.isUnderflow()) {
                        object5 = CharBuffer.allocate(((Buffer)object6).limit() * 2 + 1);
                        ((Buffer)object6).limit(((Buffer)object6).position());
                        ((Buffer)object6).position(0);
                        ((CharBuffer)object5).put((CharBuffer)object6);
                        object6 = object5;
                        coderResult = btc.decode((ByteBuffer)object7, (CharBuffer)object6, true);
                    }
                }
                if ((coderResult = btc.flush((CharBuffer)object6)).isOverflow()) {
                    while (!coderResult.isUnderflow()) {
                        object5 = CharBuffer.allocate(((Buffer)object6).limit() * 2 + 1);
                        ((Buffer)object6).limit(((Buffer)object6).position());
                        ((Buffer)object6).position(0);
                        ((CharBuffer)object5).put((CharBuffer)object6);
                        object6 = object5;
                        coderResult = btc.flush((CharBuffer)object6);
                    }
                }
                ((Buffer)object6).limit(((Buffer)object6).position());
                ((Buffer)object6).position(0);
                object5 = new byte[(int)Math.ceil((float)((Buffer)object6).position() * ctb.maxBytesPerChar()) + 1];
                object7 = ByteBuffer.wrap((byte[])object5);
                coderResult = ctb.encode((CharBuffer)object6, (ByteBuffer)object7, true);
                if (coderResult.isOverflow()) {
                    while (!coderResult.isUnderflow()) {
                        byArray4 = new byte[((Buffer)object7).limit() * 2 + 1];
                        object = ByteBuffer.wrap(byArray4);
                        ((Buffer)object7).limit(((Buffer)object7).position());
                        ((Buffer)object7).position(0);
                        ((ByteBuffer)object).put((ByteBuffer)object7);
                        object7 = object;
                        coderResult = ctb.encode((CharBuffer)object6, (ByteBuffer)object7, true);
                    }
                }
                if ((coderResult = ctb.flush((ByteBuffer)object7)).isOverflow()) {
                    while (!coderResult.isUnderflow()) {
                        byArray4 = new byte[((Buffer)object7).limit() * 2 + 1];
                        object = ByteBuffer.wrap(byArray4);
                        ((Buffer)object7).limit(((Buffer)object7).position());
                        ((Buffer)object7).position(0);
                        ((ByteBuffer)object).put((ByteBuffer)object7);
                        object7 = object;
                        coderResult = ctb.flush((ByteBuffer)object7);
                    }
                }
                object5 = ((ByteBuffer)object7).array();
                if (((Buffer)object7).position() > n2) {
                    System.arraycopy(object5, 0, byArray, n, n2);
                    int n9 = ((Buffer)object7).position() - n2;
                    object = new byte[n9];
                    System.arraycopy(object5, n2, object, 0, n9);
                    this.reservedOut = ByteBuffer.wrap((byte[])object);
                    n3 += n2;
                } else {
                    System.arraycopy(object5, 0, byArray, n, ((Buffer)object7).position());
                    n3 += ((Buffer)object7).position();
                }
                if (0 == n3) {
                    n3 = -1;
                }
                btc.reset();
                ctb.reset();
                this.alreadyClosed = -1 != n3;
            }
        } else {
            n3 = this.in.read(byArray, n, n2);
        }
        return n3;
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        String string2 = AccessController.doPrivileged(new GetPropertyAction("console.encoding"));
        if (string2 == null && LocalizedInputStream.nonASCIIPlatform) {
            string2 = AccessController.doPrivileged(new GetPropertyAction("ibm.system.encoding"));
        }
        if (string2 == null) {
            string2 = string;
        }
        CharsetDecoder charsetDecoder = null;
        CharsetEncoder charsetEncoder = null;
        conversionRequired = false;
        if (!string2.equals(string)) {
            if ("z/OS".equals(AccessController.doPrivileged(new GetPropertyAction("os.name")))) {
                if (!Charset.isSupported(string2)) {
                    string2 = "IBM1047";
                }
                if (!Charset.isSupported(string)) {
                    string = "IBM1047";
                }
            }
            try {
                charsetDecoder = Charset.forName(string2).newDecoder();
                charsetEncoder = Charset.forName(string).newEncoder();
                charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                unsupportedCharsetException.printStackTrace();
            }
            conversionRequired = true;
        }
        encoding = string2;
        btc = charsetDecoder;
        ctb = charsetEncoder;
    }
}

