/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.bootstrap;

import com.ibm.security.bootstrap.InternalSHA;
import com.ibm.security.util.DerInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;

public final class DSASignature
extends Signature {
    private DSAParams params;
    private BigInteger presetP;
    private BigInteger presetQ;
    private BigInteger presetG;
    private BigInteger presetY;
    private InternalSHA dataSHA = new InternalSHA();

    public DSASignature() {
        super("SHA/DSA");
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        throw new InvalidKeyException("Bootstrap provider dose not support signing");
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("not a DSA public key: " + publicKey);
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        this.presetY = dSAPublicKey.getY();
        this.dataSHA.reset();
        this.setParams(dSAPublicKey.getParams());
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        throw new SignatureException("Bootstrap provider dose not support signing");
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        Object object;
        Object object2;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        try {
            object2 = new DerInputStream(byArray);
            object = object2.getSequence(2);
            bigInteger = object[0].getBigInteger();
            bigInteger2 = object[1].getBigInteger();
        }
        catch (IOException iOException) {
            throw new SignatureException("invalid encoding for signature");
        }
        object2 = this.generateW(this.presetP, this.presetQ, this.presetG, bigInteger2);
        object = this.generateV(this.presetY, this.presetP, this.presetQ, this.presetG, (BigInteger)object2, bigInteger);
        return ((BigInteger)object).equals(bigInteger);
    }

    private void reset() {
        this.dataSHA.reset();
    }

    BigInteger generateR(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        BigInteger bigInteger5 = bigInteger3.modPow(bigInteger4, bigInteger);
        return bigInteger5.remainder(bigInteger2);
    }

    BigInteger generateS(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        byte[] byArray = this.dataSHA.digest();
        BigInteger bigInteger5 = new BigInteger(1, byArray);
        BigInteger bigInteger6 = bigInteger4.modInverse(bigInteger2);
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger3);
        bigInteger7 = bigInteger5.add(bigInteger7);
        bigInteger7 = bigInteger6.multiply(bigInteger7);
        return bigInteger7.remainder(bigInteger2);
    }

    BigInteger generateW(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        return bigInteger4.modInverse(bigInteger2);
    }

    BigInteger generateV(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) {
        byte[] byArray = this.dataSHA.digest();
        BigInteger bigInteger7 = new BigInteger(1, byArray);
        bigInteger7 = bigInteger7.multiply(bigInteger5);
        BigInteger bigInteger8 = bigInteger7.remainder(bigInteger3);
        BigInteger bigInteger9 = bigInteger6.multiply(bigInteger5).remainder(bigInteger3);
        BigInteger bigInteger10 = bigInteger4.modPow(bigInteger8, bigInteger2);
        BigInteger bigInteger11 = bigInteger.modPow(bigInteger9, bigInteger2);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger11);
        BigInteger bigInteger13 = bigInteger12.remainder(bigInteger2);
        return bigInteger13.remainder(bigInteger3);
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new InvalidParameterException("invalid parameter");
    }

    @Override
    protected Object engineGetParameter(String string) {
        System.out.println("Get Parameters.");
        return null;
    }

    private void setParams(DSAParams dSAParams) {
        this.params = dSAParams;
        this.presetP = dSAParams.getP();
        this.presetQ = dSAParams.getQ();
        this.presetG = dSAParams.getG();
    }

    private void setParams(DSAParameterSpec dSAParameterSpec) {
        this.presetP = dSAParameterSpec.getP();
        this.presetQ = dSAParameterSpec.getQ();
        this.presetG = dSAParameterSpec.getG();
    }

    @Override
    protected void engineUpdate(byte by) {
        this.dataSHA.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.dataSHA.update(byArray, n, n2);
    }
}

