/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.AccessController;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Scanner;
import sun.net.AbstractNetworkSelector;
import sun.net.NetworkProvider;
import sun.net.SocketAction;
import sun.security.action.GetPropertyAction;

final class NetworkSelector
extends AbstractNetworkSelector {
    private static final boolean enabled;
    private static final String osName;
    private static final String osArch;
    private static InetAddress preferredAddress;
    private static boolean debugInterception;
    private static LinkedList<AbstractNetworkSelector.Rule> bindRules;
    private static LinkedList<AbstractNetworkSelector.Rule> connectRules;
    private static LinkedList<AbstractNetworkSelector.Rule> acceptRules;
    private static HashMap<String, NetworkProvider> providerMap;

    NetworkSelector() {
    }

    private static boolean initializeRules() {
        boolean bl = false;
        String string = AccessController.doPrivileged(new GetPropertyAction("com.ibm.net.rdma.conf"));
        if (string != null) {
            bindRules = new LinkedList();
            connectRules = new LinkedList();
            acceptRules = new LinkedList();
            providerMap = new HashMap();
            try {
                NetworkSelector.loadRulesFromFile(string);
                bl = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        for (NetworkProvider networkProvider : providerMap.values()) {
                            networkProvider.cleanup();
                        }
                    }
                });
            } else {
                bindRules = null;
                connectRules = null;
                acceptRules = null;
                providerMap = null;
            }
        }
        return bl;
    }

    private static NetworkProvider loadProvider(String string) {
        NetworkProvider networkProvider = null;
        if (providerMap.containsKey(string)) {
            networkProvider = providerMap.get(string);
        } else if (string.equalsIgnoreCase("rdma")) {
            try {
                Class<?> clazz = Class.forName("java.net.RDMANetworkProvider", true, null);
                networkProvider = (NetworkProvider)clazz.newInstance();
                Method method = clazz.getMethod("initialize", null);
                method.invoke(networkProvider, null);
                networkProvider.setPreferredAddress(AbstractNetworkSelector.Host.getIBAddressList(), AbstractNetworkSelector.Host.getEthAddressList());
                preferredAddress = networkProvider.getPreferredAddress();
                debugInterception = networkProvider.isDebugOn();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                return null;
            }
            providerMap.put(string, networkProvider);
        }
        return networkProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void loadRulesFromFile(String var0) throws IOException {
        var1_1 = new Scanner(new File(var0));
lbl2:
        // 3 sources

        try {
            while (var1_1.hasNextLine()) {
                block17: {
                    var2_2 = var1_1.nextLine().trim();
                    if (var2_2.length() == 0 || var2_2.charAt(0) == '#') continue;
                    var3_3 = var2_2.split("\\s+");
                    if (var3_3.length < 4) {
                        NetworkSelector.fail("Malformed line '%s'", new Object[]{var2_2});
                    }
                    if ((var4_4 = NetworkSelector.loadProvider(var3_3[0])) == null) {
                        NetworkSelector.fail("Network provider for '%s' could not be loaded", new Object[]{var3_3[0]});
                    }
                    if ((var5_5 = SocketAction.parse(var3_3[1])) == null) {
                        NetworkSelector.fail("SocketAction '%s' not recognized", new Object[]{var3_3[1]});
                    }
                    if (var5_5 == SocketAction.ACCEPT && var3_3.length < 5) {
                        NetworkSelector.fail("Less than expected number of arguments '%s'", new Object[]{var2_2});
                    }
                    if ((var5_5 == SocketAction.BIND || var5_5 == SocketAction.CONNECT) && var3_3.length > 4) {
                        NetworkSelector.fail("Greater than expected number of arguments '%s'", new Object[]{var2_2});
                    }
                    if ((var6_6 = AbstractNetworkSelector.Host.parse(var5_5, var3_3[2], false)) == null) {
                        NetworkSelector.fail("Primary host field '%s' not valid", new Object[]{var3_3[2]});
                    }
                    var7_7 = null;
                    try {
                        var7_7 = new AbstractNetworkSelector.PortRange(var3_3[3]);
                    }
                    catch (NumberFormatException var8_9) {
                        NetworkSelector.fail("Malformed port range '%s'", new Object[]{var3_3[3]});
                    }
                    if (var5_5 != SocketAction.ACCEPT) break block17;
                    for (var8_8 = 4; var8_8 < var3_3.length; ++var8_8) {
                        var9_10 = AbstractNetworkSelector.Host.parse(var5_5, var3_3[var8_8], true);
                        if (var9_10 == null) continue;
                        for (var10_11 = 0; var10_11 < var6_6.length; ++var10_11) {
                            for (var11_12 = 0; var11_12 < var9_10.length; ++var11_12) {
                                NetworkSelector.addRule(NetworkSelector.bindRules, NetworkSelector.acceptRules, NetworkSelector.connectRules, new AbstractNetworkSelector.HostPortRule(var5_5, var6_6[var10_11], var7_7, var9_10[var11_12], var4_4));
                            }
                        }
                    }
                    ** GOTO lbl2
                }
                for (var8_8 = 0; var8_8 < var6_6.length; ++var8_8) {
                    NetworkSelector.addRule(NetworkSelector.bindRules, NetworkSelector.acceptRules, NetworkSelector.connectRules, new AbstractNetworkSelector.HostPortRule(var5_5, var6_6[var8_8], var7_7, null, var4_4));
                }
                ** GOTO lbl2
            }
        }
        finally {
            var1_1.close();
        }
    }

    static NetworkProvider getNetworkProvider(SocketAction socketAction, InetAddress inetAddress, int n, InetAddress inetAddress2) {
        return enabled ? NetworkSelector.getNetworkProvider(bindRules, acceptRules, connectRules, socketAction, inetAddress, n, inetAddress2) : null;
    }

    static boolean isDebugOn() {
        return debugInterception;
    }

    static {
        debugInterception = false;
        boolean bl = false;
        GetPropertyAction getPropertyAction = new GetPropertyAction("os.name");
        osName = AccessController.doPrivileged(getPropertyAction);
        getPropertyAction = new GetPropertyAction("os.arch");
        osArch = AccessController.doPrivileged(getPropertyAction);
        if (osName.equalsIgnoreCase("linux") && !osArch.startsWith("s390")) {
            bl = NetworkSelector.initializeRules();
        }
        enabled = bl;
        if (NetworkSelector.isDebugOn() && bl) {
            System.out.printf("JSORI:NET: >>>==========%n", new Object[0]);
            System.out.printf("%s", NetworkSelector.printRules(bindRules, acceptRules, connectRules, preferredAddress));
            System.out.printf("JSORI:NET: ==========<<<%n", new Object[0]);
        }
    }
}

