/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.jvm.ClassLoaderDiagnosticsHelper;
import com.ibm.jvm.MemorySafetyService;
import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.Shared;
import com.ibm.oti.shared.SharedClassHelperFactory;
import com.ibm.oti.shared.SharedClassURLClasspathHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.FactoryURLClassLoader;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sun.misc.JavaNetAccess;
import sun.misc.Resource;
import sun.misc.SharedSecrets;
import sun.misc.URLClassPath;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.file.FileURLConnection;

public class URLClassLoader
extends SecureClassLoader
implements Closeable {
    private final URLClassPath ucp;
    private final AccessControlContext acc;
    private SharedClassURLClasspathHelper sharedClassURLClasspathHelper;
    private SharedClassMetaDataCache sharedClassMetaDataCache;
    private WeakHashMap<Closeable, Void> closeables = new WeakHashMap();
    private static Vector showClassLoadingFor = null;
    private static boolean showLoadingMessages = false;
    private static final String showClassLoadingProperty = "ibm.cl.verbose";

    private boolean usingSharedClasses() {
        return this.sharedClassURLClasspathHelper != null;
    }

    private void initializeSharedClassesSupport(URL[] uRLArray) {
        SharedClassHelperFactory sharedClassHelperFactory = Shared.getSharedClassHelperFactory();
        if (sharedClassHelperFactory != null) {
            try {
                this.sharedClassURLClasspathHelper = sharedClassHelperFactory.getURLClasspathHelper((ClassLoader)this, uRLArray);
            }
            catch (HelperAlreadyDefinedException helperAlreadyDefinedException) {
                helperAlreadyDefinedException.printStackTrace();
            }
            if (this.usingSharedClasses()) {
                this.sharedClassMetaDataCache = new SharedClassMetaDataCache(uRLArray.length);
            }
        }
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initializeSharedClassesSupport(uRLArray);
        this.acc = AccessController.getContext();
        this.ucp = new URLClassPath(uRLArray, null, this.sharedClassURLClasspathHelper, this.acc);
    }

    URLClassLoader(URL[] uRLArray, ClassLoader classLoader, AccessControlContext accessControlContext) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initializeSharedClassesSupport(uRLArray);
        this.acc = accessControlContext;
        this.ucp = new URLClassPath(uRLArray, null, this.sharedClassURLClasspathHelper, accessControlContext);
    }

    public URLClassLoader(URL[] uRLArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initializeSharedClassesSupport(uRLArray);
        this.acc = AccessController.getContext();
        this.ucp = new URLClassPath(uRLArray, null, this.sharedClassURLClasspathHelper, this.acc);
    }

    URLClassLoader(URL[] uRLArray, AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initializeSharedClassesSupport(uRLArray);
        this.acc = accessControlContext;
        this.ucp = new URLClassPath(uRLArray, null, this.sharedClassURLClasspathHelper, accessControlContext);
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initializeSharedClassesSupport(uRLArray);
        this.acc = AccessController.getContext();
        this.ucp = new URLClassPath(uRLArray, uRLStreamHandlerFactory, this.sharedClassURLClasspathHelper, this.acc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            if (uRL == null) {
                return null;
            }
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            if (uRLConnection instanceof JarURLConnection) {
                JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
                JarFile jarFile = jarURLConnection.getJarFile();
                WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
                synchronized (weakHashMap) {
                    if (!this.closeables.containsKey(jarFile)) {
                        this.closeables.put(jarFile, null);
                    }
                }
            }
            if (uRLConnection instanceof FileURLConnection) {
                WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
                synchronized (weakHashMap) {
                    this.closeables.put(inputStream, null);
                }
            }
            return inputStream;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("closeClassLoader"));
        }
        List<IOException> list = this.ucp.closeLoaders();
        Object object = this.closeables;
        synchronized (object) {
            Set<Closeable> set = this.closeables.keySet();
            Iterator<Closeable> object2 = set.iterator();
            while (object2.hasNext()) {
                Closeable closeable = object2.next();
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    list.add(iOException);
                }
            }
            this.closeables.clear();
        }
        if (list.isEmpty()) {
            return;
        }
        object = list.remove(0);
        for (IOException iOException : list) {
            ((Throwable)object).addSuppressed(iOException);
        }
        throw object;
    }

    protected void addURL(URL uRL) {
        this.ucp.addURL(uRL);
    }

    public URL[] getURLs() {
        return this.ucp.getURLs();
    }

    private boolean showClassLoading(String string) {
        if (showLoadingMessages) {
            Enumeration enumeration = showClassLoadingFor.elements();
            while (enumeration.hasMoreElements()) {
                Pattern pattern = (Pattern)enumeration.nextElement();
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        try {
            int n;
            SharedClassMetaData sharedClassMetaData;
            Object object;
            Object object2;
            boolean bl = this.showClassLoading(string);
            if (bl) {
                ClassLoaderDiagnosticsHelper.attemptingToLoadClass(this, string);
            }
            if (this.usingSharedClasses() && (object2 = this.sharedClassURLClasspathHelper.findSharedClass(string, (SharedClassURLClasspathHelper.IndexHolder)(object = new SharedClassIndexHolder()))) != null && (sharedClassMetaData = this.sharedClassMetaDataCache.getSharedClassMetaData(n = ((SharedClassIndexHolder)object).index)) != null) {
                try {
                    Class clazz = this.defineClass(string, (byte[])object2, sharedClassMetaData.getCodeSource(), sharedClassMetaData.getManifest());
                    if (bl) {
                        ClassLoaderDiagnosticsHelper.loadedClass(this, string);
                    }
                    return clazz;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if ((object2 = (Object)((Class)AccessController.doPrivileged(object = new ClassFinder(string, this), this.acc))) == null) {
                if (bl) {
                    ClassLoaderDiagnosticsHelper.failedToLoadClass(this, string);
                }
                throw new ClassNotFoundException(string);
            }
            if (bl) {
                ClassLoaderDiagnosticsHelper.loadedClass(this, string);
            }
            return object2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    private Package getAndVerifyPackage(String string, Manifest manifest, URL uRL) {
        Package package_ = this.getPackage(string);
        if (package_ != null) {
            if (package_.isSealed()) {
                if (!package_.isSealed(uRL)) {
                    throw new SecurityException("sealing violation: package " + string + " is sealed");
                }
            } else if (manifest != null && this.isSealed(string, manifest)) {
                throw new SecurityException("sealing violation: can't seal package " + string + ": already loaded");
            }
        }
        return package_;
    }

    private void definePackageInternal(String string, Manifest manifest, URL uRL) {
        block5: {
            if (this.getAndVerifyPackage(string, manifest, uRL) == null) {
                try {
                    if (manifest != null) {
                        this.definePackage(string, manifest, uRL);
                    } else {
                        this.definePackage(string, null, null, null, null, null, null, null);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.getAndVerifyPackage(string, manifest, uRL) != null) break block5;
                    throw new AssertionError((Object)("Cannot find package " + string));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> defineClass(String string, Resource resource) throws IOException {
        long l;
        CodeSigner[] codeSignerArray;
        Object object;
        Class<?> clazz = null;
        CodeSource codeSource = null;
        Manifest manifest = null;
        long l2 = System.nanoTime();
        int n = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n != -1) {
            object = string.substring(0, n);
            manifest = resource.getManifest();
            this.definePackageInternal((String)object, manifest, uRL);
        }
        if ((object = resource.getByteBuffer()) != null) {
            codeSignerArray = resource.getCodeSigners();
            long l3 = -1L;
            try {
                l3 = MemorySafetyService.enterSafeMemoryArea();
                codeSource = new CodeSource(uRL, codeSignerArray);
            }
            finally {
                MemorySafetyService.exitLastMemoryArea((long)l3);
            }
            clazz = this.defineClass(string, (ByteBuffer)object, codeSource);
        } else {
            codeSignerArray = (CodeSigner[])resource.getBytes();
            CodeSigner[] codeSignerArray2 = resource.getCodeSigners();
            l = -1L;
            try {
                l = MemorySafetyService.enterSafeMemoryArea();
                codeSource = new CodeSource(uRL, codeSignerArray2);
            }
            finally {
                MemorySafetyService.exitLastMemoryArea((long)l);
            }
            clazz = this.defineClass(string, (byte[])codeSignerArray, 0, codeSignerArray.length, codeSource);
        }
        if (this.usingSharedClasses()) {
            int n2 = resource.getClasspathLoadIndex();
            SharedClassMetaData sharedClassMetaData = this.sharedClassMetaDataCache.getSharedClassMetaData(n2);
            if (sharedClassMetaData == null) {
                sharedClassMetaData = new SharedClassMetaData(codeSource, manifest);
                l = -1L;
                try {
                    l = MemorySafetyService.enterSafeMemoryArea();
                    sharedClassMetaData = new SharedClassMetaData(codeSource, manifest);
                }
                finally {
                    MemorySafetyService.exitLastMemoryArea((long)l);
                }
                this.sharedClassMetaDataCache.setSharedClassMetaData(n2, sharedClassMetaData);
            }
            boolean bl = false;
            try {
                bl = this.sharedClassURLClasspathHelper.storeSharedClass(clazz, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return clazz;
    }

    private Class defineClass(String string, byte[] byArray, CodeSource codeSource, Manifest manifest) throws IOException {
        int n = string.lastIndexOf(46);
        URL uRL = codeSource.getLocation();
        if (n != -1) {
            String string2 = string.substring(0, n);
            Package package_ = this.getPackage(string2);
            if (package_ != null) {
                if (package_.isSealed()) {
                    if (!package_.isSealed(uRL)) {
                        throw new SecurityException("sealing violation: package " + string2 + " is sealed");
                    }
                } else if (manifest != null && this.isSealed(string2, manifest)) {
                    throw new SecurityException("sealing violation: can't seal package " + string2 + ": already loaded");
                }
            } else if (manifest != null) {
                this.definePackage(string2, manifest, uRL);
            } else {
                this.definePackage(string2, null, null, null, null, null, null, null);
            }
        }
        return this.defineClass(string, byArray, 0, byArray.length, codeSource);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    @Override
    public URL findResource(final String string) {
        URL uRL = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return URLClassLoader.this.ucp.findResource(string, true);
            }
        }, this.acc);
        return uRL != null ? this.ucp.checkURL(uRL) : null;
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        final Enumeration<URL> enumeration = this.ucp.findResources(string, true);
        return new Enumeration<URL>(){
            private URL url = null;

            private boolean next() {
                URL uRL;
                if (this.url != null) {
                    return true;
                }
                while ((uRL = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                    @Override
                    public URL run() {
                        if (!enumeration.hasMoreElements()) {
                            return null;
                        }
                        return (URL)enumeration.nextElement();
                    }
                }, URLClassLoader.this.acc)) != null) {
                    this.url = URLClassLoader.this.ucp.checkURL(uRL);
                    if (this.url == null) continue;
                }
                return this.url != null;
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.url;
                this.url = null;
                return uRL;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Object object;
        Permission permission;
        URLConnection uRLConnection;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        try {
            uRLConnection = uRL.openConnection();
            permission = uRLConnection.getPermission();
        }
        catch (IOException iOException) {
            permission = null;
            uRLConnection = null;
        }
        if (permission instanceof FilePermission) {
            object = permission.getName();
            if (((String)object).endsWith(File.separator)) {
                object = (String)object + "-";
                long l = -1L;
                try {
                    l = MemorySafetyService.enterSafeMemoryArea();
                    permission = new FilePermission((String)object, "read");
                }
                finally {
                    MemorySafetyService.exitLastMemoryArea((long)l);
                }
            }
        } else {
            String string;
            if (permission == null && uRL.getProtocol().equals("file")) {
                object = uRL.getFile().replace('/', File.separatorChar);
                if (((String)(object = ParseUtil.decode((String)object))).endsWith(File.separator)) {
                    object = (String)object + "-";
                }
                long l = -1L;
                try {
                    l = MemorySafetyService.enterSafeMemoryArea();
                    permission = new FilePermission((String)object, "read");
                }
                finally {
                    MemorySafetyService.exitLastMemoryArea((long)l);
                }
            }
            object = uRL;
            if (uRLConnection instanceof JarURLConnection) {
                object = ((JarURLConnection)uRLConnection).getJarFileURL();
            }
            if ((string = ((URL)object).getHost()) != null && string.length() > 0) {
                long l = -1L;
                try {
                    l = MemorySafetyService.enterObjectsMemoryArea((Object)this);
                    permission = new SocketPermission(string, "connect,accept");
                }
                finally {
                    MemorySafetyService.exitLastMemoryArea((long)l);
                }
            }
        }
        if (permission != null) {
            object = System.getSecurityManager();
            if (object != null) {
                Permission permission2 = permission;
                AccessController.doPrivileged(new PrivilegedAction<Void>((SecurityManager)object, permission2){
                    final /* synthetic */ SecurityManager val$sm;
                    final /* synthetic */ Permission val$fp;
                    {
                        this.val$sm = securityManager;
                        this.val$fp = permission;
                    }

                    @Override
                    public Void run() throws SecurityException {
                        this.val$sm.checkPermission(this.val$fp);
                        return null;
                    }
                }, this.acc);
            }
            permissionCollection.add(permission);
        }
        return permissionCollection;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray, final ClassLoader classLoader) {
        final AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new FactoryURLClassLoader(uRLArray, classLoader, accessControlContext);
            }
        });
        return uRLClassLoader;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray) {
        final AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new FactoryURLClassLoader(uRLArray, accessControlContext);
            }
        });
        return uRLClassLoader;
    }

    static {
        Vector<Pattern> vector = new Vector<Pattern>();
        String string = System.getProperty(showClassLoadingProperty);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = string2.replaceAll("\\.", "\\.");
                string3 = string3.replaceAll("\\*", ".*");
                try {
                    Pattern pattern = Pattern.compile(string3);
                    vector.addElement(pattern);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    System.err.println("Illegal class matching expression \"" + string2 + "\" supplied by property " + showClassLoadingProperty);
                }
            }
        }
        if (!vector.isEmpty()) {
            showLoadingMessages = true;
        }
        showClassLoadingFor = vector;
        SharedSecrets.setJavaNetAccess(new JavaNetAccess(){

            @Override
            public URLClassPath getURLClassPath(URLClassLoader uRLClassLoader) {
                return uRLClassLoader.ucp;
            }

            @Override
            public String getOriginalHostName(InetAddress inetAddress) {
                return inetAddress.holder.getOriginalHostName();
            }
        });
        ClassLoader.registerAsParallelCapable();
    }

    final class ClassFinder
    implements PrivilegedExceptionAction {
        private String name;
        private ClassLoader classloader;

        public ClassFinder(String string, ClassLoader classLoader) {
            this.name = string;
            this.classloader = classLoader;
        }

        public Object run() throws ClassNotFoundException {
            String string = this.name.replace('.', '/').concat(".class");
            try {
                Resource resource = URLClassLoader.this.ucp.getResource(string, false, this.classloader, URLClassLoader.this.showClassLoading(this.name));
                if (resource != null) {
                    return URLClassLoader.this.defineClass(this.name, resource);
                }
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(this.name, iOException);
            }
            return null;
        }
    }

    private class SharedClassMetaDataCache {
        private static final int BLOCKSIZE = 10;
        private SharedClassMetaData[] store;

        public SharedClassMetaDataCache(int n) {
            this.store = new SharedClassMetaData[n];
        }

        public synchronized SharedClassMetaData getSharedClassMetaData(int n) {
            if (n < 0 || this.store.length < n + 1) {
                return null;
            }
            return this.store[n];
        }

        public synchronized void setSharedClassMetaData(int n, SharedClassMetaData sharedClassMetaData) {
            this.ensureSize(n);
            this.store[n] = sharedClassMetaData;
        }

        private synchronized void ensureSize(int n) {
            if (this.store.length < n + 1) {
                int n2 = n + 10;
                SharedClassMetaData[] sharedClassMetaDataArray = new SharedClassMetaData[n2];
                System.arraycopy(this.store, 0, sharedClassMetaDataArray, 0, this.store.length);
                this.store = sharedClassMetaDataArray;
            }
        }
    }

    private class SharedClassMetaData {
        private CodeSource codeSource;
        private Manifest manifest;

        SharedClassMetaData(CodeSource codeSource, Manifest manifest) {
            this.codeSource = codeSource;
            this.manifest = manifest;
        }

        public CodeSource getCodeSource() {
            return this.codeSource;
        }

        public Manifest getManifest() {
            return this.manifest;
        }
    }

    private class SharedClassIndexHolder
    implements SharedClassURLClasspathHelper.IndexHolder {
        int index;

        private SharedClassIndexHolder() {
        }

        public void setIndex(int n) {
            this.index = n;
        }
    }
}

