/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectLongBufferRS;
import java.nio.LongBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectLongBufferS
extends LongBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(long[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectLongBufferS(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + (long)n5;
        this.att = directBuffer;
    }

    @Override
    public LongBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 3;
        assert (n4 >= 0);
        return new DirectLongBufferS(this, -1, 0, n3, n3, n4);
    }

    @Override
    public LongBuffer duplicate() {
        return new DirectLongBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new DirectLongBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int n) {
        return this.address + ((long)n << 3);
    }

    @Override
    public long get() {
        return Bits.swap(unsafe.getLong(this.ix(this.nextGetIndex())));
    }

    @Override
    public long get(int n) {
        return Bits.swap(unsafe.getLong(this.ix(this.checkIndex(n))));
    }

    @Override
    public LongBuffer get(long[] lArray, int n, int n2) {
        if ((long)n2 << 3 > 6L) {
            int n3;
            DirectLongBufferS.checkBounds(n, n2, lArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToLongArray(this.ix(n4), lArray, (long)n << 3, (long)n2 << 3);
            } else {
                Bits.copyToArray(this.ix(n4), lArray, arrayBaseOffset, (long)n << 3, (long)n2 << 3);
            }
            this.position(n4 + n2);
        } else {
            super.get(lArray, n, n2);
        }
        return this;
    }

    @Override
    public LongBuffer put(long l) {
        unsafe.putLong(this.ix(this.nextPutIndex()), Bits.swap(l));
        Bits.keepAlive(this);
        return this;
    }

    @Override
    public LongBuffer put(int n, long l) {
        unsafe.putLong(this.ix(this.checkIndex(n)), Bits.swap(l));
        Bits.keepAlive(this);
        return this;
    }

    @Override
    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer instanceof DirectLongBufferS) {
            int n;
            if (longBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectLongBufferS directLongBufferS = (DirectLongBufferS)longBuffer;
            int n2 = directLongBufferS.position();
            int n3 = directLongBufferS.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directLongBufferS.ix(n2), this.ix(n5), (long)n4 << 3);
            Bits.keepAlive(this);
            directLongBufferS.position(n2 + n4);
            this.position(n5 + n4);
        } else if (longBuffer.hb != null) {
            int n = longBuffer.position();
            int n8 = longBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(longBuffer.hb, longBuffer.offset + n, n9);
            longBuffer.position(n + n9);
        } else {
            super.put(longBuffer);
        }
        return this;
    }

    @Override
    public LongBuffer put(long[] lArray, int n, int n2) {
        if ((long)n2 << 3 > 6L) {
            int n3;
            DirectLongBufferS.checkBounds(n, n2, lArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromLongArray(lArray, (long)n << 3, this.ix(n4), (long)n2 << 3);
            } else {
                Bits.copyFromArray(lArray, arrayBaseOffset, (long)n << 3, this.ix(n4), (long)n2 << 3);
            }
            this.position(n4 + n2);
        } else {
            super.put(lArray, n, n2);
        }
        return this;
    }

    @Override
    public LongBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        unsafe.copyMemory(this.ix(n), this.ix(0), (long)n3 << 3);
        Bits.keepAlive(this);
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

