/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import com.ibm.jvm.MemorySafetyService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarVerifier;
import java.util.jar.JavaUtilJarAccessImpl;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.misc.IOUtils;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;
import sun.security.util.ManifestEntryVerifier;
import sun.security.util.SignatureFileVerifier;

public class JarFile
extends ZipFile {
    private SoftReference<Manifest> manRef;
    private Manifest manRT;
    private JarEntry manEntry;
    private JarVerifier jv;
    private boolean jvInitialized;
    private boolean verify;
    private boolean hasClassPathAttribute;
    private volatile boolean hasCheckedSpecialAttributes;
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final char[] CLASSPATH_CHARS;
    private static final int[] CLASSPATH_LASTOCC;
    private static final int[] CLASSPATH_OPTOSFT;
    private static String javaHome;
    private static volatile String[] jarNames;

    public JarFile(String string) throws IOException {
        this(new File(string), true, 1);
    }

    public JarFile(String string, boolean bl) throws IOException {
        this(new File(string), bl, 1);
    }

    public JarFile(File file) throws IOException {
        this(file, true, 1);
    }

    public JarFile(File file, boolean bl) throws IOException {
        this(file, bl, 1);
    }

    public JarFile(File file, boolean bl, int n) throws IOException {
        super(file, n);
        this.verify = bl;
    }

    public Manifest getManifest() throws IOException {
        return this.getManifestFromReference();
    }

    private Manifest getManifestFromReference() throws IOException {
        JarEntry jarEntry;
        Manifest manifest;
        if (MemorySafetyService.isSafeMode()) {
            return this.getManifestRT();
        }
        Manifest manifest2 = manifest = this.manRef != null ? this.manRef.get() : null;
        if (manifest == null && (jarEntry = this.getManEntry()) != null) {
            if (this.verify) {
                byte[] byArray = this.getBytes(jarEntry);
                manifest = new Manifest(new ByteArrayInputStream(byArray));
                if (!this.jvInitialized) {
                    this.jv = new JarVerifier(byArray);
                }
            } else {
                manifest = new Manifest(super.getInputStream(jarEntry));
            }
            this.manRef = new SoftReference<Manifest>(manifest);
        }
        return manifest;
    }

    private Manifest getManifestRT() throws IOException {
        JarEntry jarEntry;
        if (this.manRT == null && (jarEntry = this.getManEntry()) != null) {
            if (this.verify) {
                byte[] byArray = this.getBytes(jarEntry);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                long l = -1L;
                try {
                    l = MemorySafetyService.enterObjectsMemoryArea((Object)this);
                    this.manRT = new Manifest(byteArrayInputStream);
                }
                catch (Exception exception) {
                    throw new IOException("Unable to create Manifest");
                }
                finally {
                    MemorySafetyService.exitLastMemoryArea((long)l);
                }
                if (!this.jvInitialized) {
                    this.jv = new JarVerifier(byArray);
                }
            } else {
                InputStream inputStream = super.getInputStream(jarEntry);
                long l = -1L;
                try {
                    l = MemorySafetyService.enterObjectsMemoryArea((Object)this);
                    this.manRT = new Manifest(inputStream);
                }
                catch (Exception exception) {
                    throw new IOException("Unable to create Manifest");
                }
                finally {
                    MemorySafetyService.exitLastMemoryArea((long)l);
                }
            }
        }
        return this.manRT;
    }

    private native String[] getMetaInfEntryNames();

    public JarEntry getJarEntry(String string) {
        return (JarEntry)this.getEntry(string);
    }

    @Override
    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration<JarEntry> entries() {
        return new JarEntryIterator();
    }

    public Stream<JarEntry> stream() {
        return StreamSupport.stream(Spliterators.spliterator(new JarEntryIterator(), (long)this.size(), 1297), false);
    }

    private void maybeInstantiateVerifier() throws IOException {
        if (this.jv != null) {
            return;
        }
        if (this.verify) {
            String[] stringArray = this.getMetaInfEntryNames();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i].toUpperCase(Locale.ENGLISH);
                    if (!string.endsWith(".DSA") && !string.endsWith(".RSA") && !string.endsWith(".EC") && !string.endsWith(".SF")) continue;
                    this.getManifest();
                    return;
                }
            }
            this.verify = false;
        }
    }

    private void initializeVerifier() {
        block10: {
            ManifestEntryVerifier manifestEntryVerifier = null;
            try {
                String[] stringArray = this.getMetaInfEntryNames();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        byte[] byArray;
                        String string = stringArray[i].toUpperCase(Locale.ENGLISH);
                        if (!MANIFEST_NAME.equals(string) && !SignatureFileVerifier.isBlockOrSF(string)) continue;
                        JarEntry jarEntry = this.getJarEntry(stringArray[i]);
                        if (jarEntry == null) {
                            throw new JarException("corrupted jar file");
                        }
                        if (manifestEntryVerifier == null) {
                            manifestEntryVerifier = new ManifestEntryVerifier(this.getManifestFromReference());
                        }
                        if ((byArray = this.getBytes(jarEntry)) == null || byArray.length <= 0) continue;
                        this.jv.beginEntry(jarEntry, manifestEntryVerifier);
                        this.jv.update(byArray.length, byArray, 0, byArray.length, manifestEntryVerifier);
                        this.jv.update(-1, null, 0, 0, manifestEntryVerifier);
                    }
                }
            }
            catch (IOException iOException) {
                this.jv = null;
                this.verify = false;
                if (JarVerifier.debug == null) break block10;
                JarVerifier.debug.println("jarfile parsing error!");
                iOException.printStackTrace();
            }
        }
        if (this.jv != null) {
            this.jv.doneWithMeta();
            if (JarVerifier.debug != null) {
                JarVerifier.debug.println("done with meta!");
            }
            if (this.jv.nothingToVerify()) {
                if (JarVerifier.debug != null) {
                    JarVerifier.debug.println("nothing to verify!");
                }
                this.jv = null;
                this.verify = false;
            }
        }
    }

    private byte[] getBytes(ZipEntry zipEntry) throws IOException {
        try (InputStream inputStream = super.getInputStream(zipEntry);){
            byte[] byArray = IOUtils.readFully(inputStream, (int)zipEntry.getSize(), true);
            return byArray;
        }
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        this.maybeInstantiateVerifier();
        if (this.jv == null) {
            return super.getInputStream(zipEntry);
        }
        if (!this.jvInitialized) {
            this.initializeVerifier();
            this.jvInitialized = true;
            if (this.jv == null) {
                return super.getInputStream(zipEntry);
            }
        }
        return new JarVerifier.VerifierStream(this.getManifestFromReference(), zipEntry instanceof JarFileEntry ? (JarEntry)zipEntry : this.getJarEntry(zipEntry.getName()), super.getInputStream(zipEntry), this.jv);
    }

    private JarEntry getManEntry() {
        if (this.manEntry == null) {
            String[] stringArray;
            this.manEntry = this.getJarEntry(MANIFEST_NAME);
            if (this.manEntry == null && (stringArray = this.getMetaInfEntryNames()) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!MANIFEST_NAME.equals(stringArray[i].toUpperCase(Locale.ENGLISH))) continue;
                    this.manEntry = this.getJarEntry(stringArray[i]);
                    break;
                }
            }
        }
        return this.manEntry;
    }

    boolean hasClassPathAttribute() throws IOException {
        this.checkForSpecialAttributes();
        return this.hasClassPathAttribute;
    }

    private boolean match(char[] cArray, byte[] byArray, int[] nArray, int[] nArray2) {
        char c;
        int n;
        int n2 = cArray.length;
        int n3 = byArray.length - n2;
        block0: for (int i = 0; i <= n3; i += Math.max(n + 1 - nArray[c & 0x7F], nArray2[n])) {
            for (n = n2 - 1; n >= 0; --n) {
                c = (char)byArray[i + n];
                char c2 = c = (c - 65 | 90 - c) >= 0 ? (char)(c + 32) : c;
                if (c == cArray[n]) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private void checkForSpecialAttributes() throws IOException {
        byte[] byArray;
        JarEntry jarEntry;
        if (this.hasCheckedSpecialAttributes) {
            return;
        }
        if (!this.isKnownNotToHaveSpecialAttributes() && (jarEntry = this.getManEntry()) != null && this.match(CLASSPATH_CHARS, byArray = this.getBytes(jarEntry), CLASSPATH_LASTOCC, CLASSPATH_OPTOSFT)) {
            this.hasClassPathAttribute = true;
        }
        this.hasCheckedSpecialAttributes = true;
    }

    private boolean isKnownNotToHaveSpecialAttributes() {
        String[] stringArray;
        if (javaHome == null) {
            javaHome = AccessController.doPrivileged(new GetPropertyAction("java.home"));
        }
        String string = this.getName();
        String string2 = javaHome;
        if (MemorySafetyService.isSafeMode()) {
            return string.startsWith(string2) && (string.endsWith("rt.jar") || string.endsWith("sunrsasign.jar") || string.endsWith("jsse.jar") || string.endsWith("jce.jar") || string.endsWith("charsets.jar") || string.endsWith("dnsns.jar") || string.endsWith("ldapsec.jar") || string.endsWith("localedata.jar") || string.endsWith("sunjce_provider.jar") || string.endsWith("sunpkcs11.jar"));
        }
        if (jarNames == null) {
            stringArray = new String[11];
            String string3 = File.separator;
            int n = 0;
            stringArray[n++] = string3 + "rt.jar";
            stringArray[n++] = string3 + "jsse.jar";
            stringArray[n++] = string3 + "jce.jar";
            stringArray[n++] = string3 + "charsets.jar";
            stringArray[n++] = string3 + "dnsns.jar";
            stringArray[n++] = string3 + "zipfs.jar";
            stringArray[n++] = string3 + "localedata.jar";
            int n2 = n++;
            string3 = "cldrdata.jar";
            stringArray[n2] = "cldrdata.jar";
            stringArray[n++] = string3 + "sunjce_provider.jar";
            stringArray[n++] = string3 + "sunpkcs11.jar";
            stringArray[n++] = string3 + "sunec.jar";
            jarNames = stringArray;
        }
        if (string.startsWith(string2)) {
            stringArray = jarNames;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.endsWith(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized void ensureInitialization() {
        try {
            this.maybeInstantiateVerifier();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (this.jv != null && !this.jvInitialized) {
            this.initializeVerifier();
            this.jvInitialized = true;
        }
    }

    JarEntry newEntry(ZipEntry zipEntry) {
        return new JarFileEntry(zipEntry);
    }

    Enumeration<String> entryNames(CodeSource[] codeSourceArray) {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.entryNames(this, codeSourceArray);
        }
        boolean bl = false;
        for (int i = 0; i < codeSourceArray.length; ++i) {
            if (codeSourceArray[i].getCodeSigners() != null) continue;
            bl = true;
            break;
        }
        if (bl) {
            return this.unsignedEntryNames();
        }
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public String nextElement() {
                throw new NoSuchElementException();
            }
        };
    }

    Enumeration<JarEntry> entries2() {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.entries2(this, super.entries());
        }
        final Enumeration<? extends ZipEntry> enumeration = super.entries();
        return new Enumeration<JarEntry>(){
            ZipEntry entry;

            @Override
            public boolean hasMoreElements() {
                if (this.entry != null) {
                    return true;
                }
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    if (JarVerifier.isSigningRelated(zipEntry.getName())) continue;
                    this.entry = zipEntry;
                    return true;
                }
                return false;
            }

            @Override
            public JarFileEntry nextElement() {
                if (this.hasMoreElements()) {
                    ZipEntry zipEntry = this.entry;
                    this.entry = null;
                    return new JarFileEntry(zipEntry);
                }
                throw new NoSuchElementException();
            }
        };
    }

    CodeSource[] getCodeSources(URL uRL) {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.getCodeSources(this, uRL);
        }
        Enumeration<String> enumeration = this.unsignedEntryNames();
        if (enumeration.hasMoreElements()) {
            return new CodeSource[]{JarVerifier.getUnsignedCS(uRL)};
        }
        return null;
    }

    private Enumeration<String> unsignedEntryNames() {
        final Enumeration<JarEntry> enumeration = this.entries();
        return new Enumeration<String>(){
            String name;

            @Override
            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    String string = zipEntry.getName();
                    if (zipEntry.isDirectory() || JarVerifier.isSigningRelated(string)) continue;
                    this.name = string;
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    CodeSource getCodeSource(URL uRL, String string) {
        this.ensureInitialization();
        if (this.jv != null) {
            if (this.jv.eagerValidation) {
                CodeSource codeSource = null;
                JarEntry jarEntry = this.getJarEntry(string);
                codeSource = jarEntry != null ? this.jv.getCodeSource(uRL, this, jarEntry) : this.jv.getCodeSource(uRL, string);
                return codeSource;
            }
            return this.jv.getCodeSource(uRL, string);
        }
        return JarVerifier.getUnsignedCS(uRL);
    }

    void setEagerValidation(boolean bl) {
        try {
            this.maybeInstantiateVerifier();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (this.jv != null) {
            this.jv.setEagerValidation(bl);
        }
    }

    List<Object> getManifestDigests() {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.getManifestDigests();
        }
        return new ArrayList<Object>();
    }

    static {
        SharedSecrets.setJavaUtilJarAccess(new JavaUtilJarAccessImpl());
        CLASSPATH_CHARS = new char[]{'c', 'l', 'a', 's', 's', '-', 'p', 'a', 't', 'h'};
        CLASSPATH_LASTOCC = new int[128];
        CLASSPATH_OPTOSFT = new int[10];
        JarFile.CLASSPATH_LASTOCC[99] = 1;
        JarFile.CLASSPATH_LASTOCC[108] = 2;
        JarFile.CLASSPATH_LASTOCC[115] = 5;
        JarFile.CLASSPATH_LASTOCC[45] = 6;
        JarFile.CLASSPATH_LASTOCC[112] = 7;
        JarFile.CLASSPATH_LASTOCC[97] = 8;
        JarFile.CLASSPATH_LASTOCC[116] = 9;
        JarFile.CLASSPATH_LASTOCC[104] = 10;
        for (int i = 0; i < 9; ++i) {
            JarFile.CLASSPATH_OPTOSFT[i] = 10;
        }
        JarFile.CLASSPATH_OPTOSFT[9] = 1;
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        @Override
        public Attributes getAttributes() throws IOException {
            Manifest manifest = JarFile.this.getManifest();
            if (manifest != null) {
                return manifest.getAttributes(this.getName());
            }
            return null;
        }

        @Override
        public Certificate[] getCertificates() {
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (this.certs == null && JarFile.this.jv != null) {
                this.certs = JarFile.this.jv.getCerts(JarFile.this, this);
            }
            return this.certs == null ? null : (Certificate[])this.certs.clone();
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (this.signers == null && JarFile.this.jv != null) {
                this.signers = JarFile.this.jv.getCodeSigners(JarFile.this, this);
            }
            return this.signers == null ? null : (CodeSigner[])this.signers.clone();
        }
    }

    private class JarEntryIterator
    implements Enumeration<JarEntry>,
    Iterator<JarEntry> {
        final Enumeration<? extends ZipEntry> e;

        private JarEntryIterator() {
            this.e = JarFile.super.entries();
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        @Override
        public JarEntry next() {
            ZipEntry zipEntry = this.e.nextElement();
            return new JarFileEntry(zipEntry);
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public JarEntry nextElement() {
            return this.next();
        }
    }
}

