/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import com.ibm.security.x509.X509CertImpl;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import sun.security.util.Debug;

public class AnchorCertificates {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final String HASH = "SHA-256";
    private static HashSet<String> certs;

    public static boolean contains(X509Certificate x509Certificate) {
        String string = X509CertImpl.getFingerprint((String)HASH, (X509Certificate)x509Certificate);
        boolean bl = certs.contains(string);
        if (bl && debug != null) {
            debug.println("AnchorCertificate.contains: matched " + x509Certificate.getSubjectDN());
        }
        return bl;
    }

    private AnchorCertificates() {
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                File file = new File(System.getProperty("java.home"), "lib/security/cacerts");
                try {
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        keyStore.load(fileInputStream, null);
                        certs = new HashSet();
                        Enumeration<String> enumeration = keyStore.aliases();
                        while (enumeration.hasMoreElements()) {
                            String string = enumeration.nextElement();
                            if (!string.contains(" [jdk")) continue;
                            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                            certs.add(X509CertImpl.getFingerprint((String)AnchorCertificates.HASH, (X509Certificate)x509Certificate));
                        }
                    }
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.println("Error parsing cacerts");
                    }
                    exception.printStackTrace();
                }
                return null;
            }
        });
    }
}

