/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.axes;

import com.ibm.java.diagnostics.common.datamodel.data.DataPoint;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.common.datamodel.data.axes.Axis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.DataAxisImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class YDataAxisImpl
extends DataAxisImpl
implements YDataAxis {
    private static final Logger TRACE = LogFactory.getTrace(YDataAxisImpl.class);

    public YDataAxisImpl(Axis axis, OutputProperties outputProperties, String string) {
        super(axis, outputProperties, string);
    }

    @Override
    public DataPoint getMaximumBound() {
        return this.properties.getMaximumY(this.axis.getAxisIdentifierName());
    }

    @Override
    public DataPoint getMinimumBound() {
        return this.properties.getMinimumY(this.axis.getAxisIdentifierName());
    }

    @Override
    public void setMaximumBound(DataPoint dataPoint) {
        if (TRACE.isLoggable(Level.FINE)) {
            TRACE.fine(this + " setting maximum to " + dataPoint);
        }
        this.properties.setMaximumY(this.axis.getAxisIdentifierName(), dataPoint);
    }

    @Override
    public void setMinimumBound(DataPoint dataPoint) {
        if (TRACE.isLoggable(Level.FINE)) {
            TRACE.fine(this + " setting minimum to " + dataPoint);
        }
        this.properties.setMinimumY(this.axis.getAxisIdentifierName(), dataPoint);
    }

    @Override
    protected void registerWithProperties() {
        this.properties.registerYAxisListener(this);
    }

    @Override
    protected DataPointBuilder getMaximum(TwoDimensionalData twoDimensionalData) {
        return twoDimensionalData.getMaxY();
    }

    @Override
    protected DataPointBuilder getMinimum(TwoDimensionalData twoDimensionalData) {
        return twoDimensionalData.getMinY();
    }

    @Override
    protected double getValue(DataPointBuilder dataPointBuilder) {
        return dataPointBuilder.getY();
    }

    @Override
    public void clearMinimumBound() {
        this.properties.clearMinimumY();
    }

    @Override
    public void clearMaximumBound() {
        this.properties.clearMaximumY();
    }
}

