/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment.BlockingCommandRunner;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment.CommandResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UlimitCheck {
    protected String ulimitHardAllOutput = "";
    String ulimitHardCoreOutput = "";
    private boolean isAIX;
    private boolean isLinux;
    private Logger logger;
    private String osName;
    private static final String[] ULIMIT_AIX_ALL = new String[]{"/usr/bin/ulimit", "-H", "-a"};
    private static final String[] ULIMIT_AIX_CORE = new String[]{"/usr/bin/ulimit", "-H", "-c"};
    private static final String[] ULIMIT_LINUX_CORE = new String[]{"/bin/bash", "-c", "ulimit -H -c"};
    private static final String[] ULIMIT_LINUX_ALL = new String[]{"/bin/bash", "-c", "ulimit -H -a"};

    public UlimitCheck(Logger logger) {
        this.logger = logger;
        this.osName = System.getProperty("os.name");
        this.isAIX = this.osName.equals("AIX");
        this.isLinux = this.osName.equals("Linux");
        if (this.isAIX || this.isLinux) {
            this.ulimitHardAllOutput = this.getUlimitStdOut(true);
        }
    }

    public UlimitCheck(Logger logger, String string) {
        this.logger = logger;
        this.ulimitHardCoreOutput = string;
        this.isLinux = true;
    }

    private String getUlimitStdOut(boolean bl) {
        if (!this.appliesToPlatform()) {
            return null;
        }
        String[] stringArray = null;
        String string = null;
        if (bl) {
            string = "ulimit all";
            stringArray = this.isAIX ? ULIMIT_AIX_ALL : ULIMIT_LINUX_ALL;
        }
        ArrayList<String> arrayList = null;
        arrayList = stringArray != null ? new ArrayList<String>(Arrays.asList(stringArray)) : new ArrayList();
        BlockingCommandRunner blockingCommandRunner = new BlockingCommandRunner(arrayList, string, false, this.logger);
        CommandResult commandResult = blockingCommandRunner.runCommand(60, false);
        return commandResult.getStdOut();
    }

    public boolean appliesToPlatform() {
        return this.isAIX || this.isLinux;
    }

    public Level getUlimitReportPriority() {
        Level level = null;
        if (this.appliesToPlatform()) {
            level = this.isUnlimited(this.ulimitHardCoreOutput) ? Level.CONFIG : Level.WARNING;
        }
        return level;
    }

    private boolean isUnlimited(String string) {
        if (string != null) {
            return string.contains("unlimited");
        }
        return false;
    }

    public String getReport() {
        if (!this.appliesToPlatform()) {
            return null;
        }
        String string = null;
        String string2 = System.getProperty("line.separator");
        string = this.isUnlimited(this.ulimitHardCoreOutput) ? Messages.getString("UlimitCheck.0") + string2 + this.ulimitHardAllOutput : Messages.getString("UlimitCheck.1") + string2 + Messages.getString("UlimitCheck.2") + string2 + Messages.getString("UlimitCheck.3") + string2 + this.ulimitHardAllOutput;
        return string;
    }
}

