/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HCInitialContextFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HCSslRMIClientSocketFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HCSslRMIServerSocketFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HCSslSocketFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.NetworkAddressFinder;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.TransportType;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class HCLaunchMBean {
    private static final String VERSION_PROPERTIES = "version.properties";
    private static final String START_MBEAN_SERVER_METHOD = "startMBeanServer";
    private static final String MBEAN_OBJECT_NAME = "IBM:type=HCMBeanServer";
    public static final String JMX_URL_TEMPLATE = "service:jmx:{0}://{1}:{2}/jndi/rmi://{3}:{4}/jmxrmi";
    private static final String JMX_REMOTE_X_ACCESS_FILE = "jmx.remote.x.access.file";
    private static final String JMX_REMOTE_X_PASSWORD_FILE = "jmx.remote.x.password.file";
    private static final int MAX_PORTS_TO_TRY = 100;
    private static final int MILLISECONDS_IN_A_SECOND = 1000;
    private int port = -1;
    private int pid = 0;
    private String className = this.getClass().getName();
    private boolean jmxBuilderSet = false;
    private HealthCenterOptionHandler handler;
    private Logger logger;
    private final NetworkAddressFinder networkAddressFinder;
    private boolean useSSL = false;
    private static final int ERROR_CODE_GENERIC_JMX_STARTUP_FAILURE = -1;
    private static final int ERROR_CODE_MISSING_SSLPARM = -2;
    private static final int ERROR_CODE_TRIED_ALL_PORT_IN_RANGE = -3;
    private static final int ERROR_CODE_BEAN_REGISTRATION_FAILED = -4;
    private static final int ERROR_CODE_BAD_AUTHENTICATION_FILE = -5;
    private static final int ERROR_CODE_SSL_KEYSTORE_NOT_FOUND = -6;

    private boolean isCORBAKeepAlive(Thread thread) {
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (!"com.ibm.CORBA.iiop.KeepAlive".equals(stackTraceElementArray[i].getClassName())) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        if (System.getProperty("jzos.launcher") != null) {
            try {
                object2 = Class.forName("com.ibm.jzos.ZUtil");
                object = ((Class)object2).getMethod("redirectStandardStreams", new Class[0]);
                ((Method)object).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                System.err.println("jzos.launcher specified but com.ibm.jzos.ZUtil.redirectStandardStreams() not invoked");
                System.err.println("stdout/stderr redirection to JZOS datasets not performed");
                exception.printStackTrace();
            }
        }
        object2 = new HealthCenterOptionHandler(stringArray);
        object = new HCLaunchMBean((HealthCenterOptionHandler)object2);
        DataCollectionLevel dataCollectionLevel = ((HealthCenterOptionHandler)object2).getDataCollectionLevel();
        if (dataCollectionLevel.ordinal() != DataCollectionLevel.NONE.ordinal()) {
            int n = ((HCLaunchMBean)object).startAgent();
            ((HealthCenterOptionHandler)object2).setAgentPort(n);
            System.setProperty("com.ibm.java.diagnostics.healthcenter.running", "true");
        }
    }

    public HCLaunchMBean(HealthCenterOptionHandler healthCenterOptionHandler) {
        this.handler = healthCenterOptionHandler;
        this.pid = healthCenterOptionHandler.getPid();
        if (this.logger == null) {
            AgentLogFactory.setPid(this.pid);
            this.logger = AgentLogFactory.setUpLogging(this.getClass());
        }
        this.networkAddressFinder = new NetworkAddressFinder();
        String string = MessageFormat.format(Messages.getString("HCLaunchMBean.agent.version"), "99.99.99.29991231");
        this.logger.info(string);
    }

    public int startAgent() {
        this.logger.fine("Starting Health Center agent initialization.");
        JmxStarterThread jmxStarterThread = new JmxStarterThread(Messages.getString("HCLaunchMBean.jmx.starter.thread.name"), this.pid);
        this.logger.fine("Starting MBean starter thread.");
        jmxStarterThread.start();
        while (jmxStarterThread.isAlive()) {
            try {
                jmxStarterThread.join();
            }
            catch (Exception exception) {
                this.logger.fine("Interrupted joining Agent starter thread");
            }
        }
        this.port = jmxStarterThread.getPort();
        if (this.port < 0) {
            this.logger.info(Messages.getString("HCLaunchMBean.agent.did.not.start.correctly"));
        } else {
            DataCollectionLevel dataCollectionLevel = this.handler.getDataCollectionLevel();
            if (dataCollectionLevel.ordinal() == DataCollectionLevel.OFF.ordinal()) {
                this.logger.info(Messages.getString("HCLaunchMBean.agent.pseudo.lateattach"));
            }
            if (this.useSSL) {
                String string = MessageFormat.format(Messages.getString("HCLaunchMBean.agent.started.ssl"), Integer.toString(this.port));
                this.logger.info(string);
            } else {
                String string = MessageFormat.format(Messages.getString("HCLaunchMBean.agent.started"), Integer.toString(this.port));
                this.logger.info(string);
            }
        }
        return this.port;
    }

    public int startMBeanServer(int n, int n2) {
        Object object;
        this.logger.entering(this.className, START_MBEAN_SERVER_METHOD);
        Registry registry = null;
        boolean bl = true;
        String string = null;
        if (this.handler.isTryOverrideBuilder()) {
            string = System.getProperty("javax.management.builder.initial");
            this.logger.config(MessageFormat.format(Messages.getString("HCLaunchMBean.original.builder"), string));
            if (string != null) {
                this.jmxBuilderSet = true;
                try {
                    Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = false;
                    this.logger.fine("Clearing builder");
                    System.clearProperty("javax.management.builder.initial");
                }
                if (bl) {
                    object = MessageFormat.format("Loaded class {0} OK", string);
                    this.logger.fine((String)object);
                }
            }
        }
        MBeanServer mBeanServer = null;
        if (this.handler.isUsePlatformMBeanServer()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Getting platform MBean server");
            }
            mBeanServer = ManagementFactory.getPlatformMBeanServer();
        } else {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Creating a new MBean server");
            }
            mBeanServer = MBeanServerFactory.createMBeanServer();
        }
        this.logger.fine(MessageFormat.format("MBean server: {0}", mBeanServer));
        if (this.jmxBuilderSet && !bl) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(MessageFormat.format("Restoring builder to {0}", string));
            }
            System.setProperty("javax.management.builder.initial", string);
        }
        this.logger.fine(MessageFormat.format("Registering our MBean (PID: {0})", Integer.toString(n2)));
        try {
            object = new HealthCenter(n2, this.handler);
            ObjectName objectName = new ObjectName(MBEAN_OBJECT_NAME);
            mBeanServer.registerMBean(object, objectName);
        }
        catch (Throwable throwable) {
            this.logger.log(Level.SEVERE, Messages.getString("HCLaunchMBean.agent.did.not.start"), throwable);
            throwable.printStackTrace();
            return -4;
        }
        return this.createJMXConnector(n, registry, mBeanServer);
    }

    private int createJMXConnector(int n, Registry registry, MBeanServer mBeanServer) {
        String string;
        Object object;
        this.ensureNetworkAddressIsSensible();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Initialize the environment map");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = this.handler.getSslKeystore();
        String string3 = this.handler.getSslKeystorePassword();
        String string4 = this.handler.getSslKeystoreCertificatePassword();
        String string5 = this.handler.getSslTruststore();
        String string6 = this.handler.getSslTruststorePassword();
        String string7 = this.handler.getSslTruststoreCertificatePassword();
        if (string2 != null || string3 != null) {
            boolean bl = false;
            if (string2 == null) {
                object = Messages.getString("HCLaunchMBean.bad.ssl.definition.missing.parameter");
                string = MessageFormat.format((String)object, "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStore");
                this.logger.warning(string);
                bl = true;
            }
            if (string3 == null) {
                object = Messages.getString("HCLaunchMBean.bad.ssl.definition.missing.parameter");
                string = MessageFormat.format((String)object, "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStorePassword");
                this.logger.warning(string);
                bl = true;
            }
            if (bl) {
                return -2;
            }
            this.useSSL = true;
            if (!new File(string2).exists()) {
                this.useSSL = false;
                object = Messages.getString("HCLaunchMBean.bad.ssl.definition.keystore.not.found");
                string = MessageFormat.format((String)object, string2);
                this.logger.warning(string);
            }
            if (!string2.equals(string5) && !new File(string5).exists()) {
                this.useSSL = false;
                object = Messages.getString("HCLaunchMBean.bad.ssl.definition.keystore.not.found");
                string = MessageFormat.format((String)object, string5);
                this.logger.warning(string);
            }
            if (!this.useSSL) {
                return -6;
            }
        }
        try {
            if (this.useSSL) {
                HCSslSocketFactory.setSSLValues(string5, string6, string7);
                HCSslRMIClientSocketFactory hCSslRMIClientSocketFactory = new HCSslRMIClientSocketFactory();
                object = new HCSslRMIServerSocketFactory(string2, string3, string4);
                this.logger.fine(MessageFormat.format("Creating RMI registry on port {0} using SSL", Integer.toString(n)));
                registry = LocateRegistry.createRegistry(n, hCSslRMIClientSocketFactory, (RMIServerSocketFactory)object);
                hashMap.put("jmx.remote.rmi.client.socket.factory", hCSslRMIClientSocketFactory);
                hashMap.put("jmx.remote.rmi.server.socket.factory", object);
                hashMap.put("com.sun.jndi.rmi.factory.socket", hCSslRMIClientSocketFactory);
            } else {
                this.logger.fine(MessageFormat.format("Creating RMI registry on port {0}", Integer.toString(n)));
                registry = LocateRegistry.createRegistry(n);
            }
        }
        catch (Exception exception) {
            object = Messages.getString("HCLaunchMBean.failed.to.create.rmi.registry");
            string = MessageFormat.format((String)object, Integer.toString(n), exception.toString());
            try {
                UnicastRemoteObject.unexportObject(registry, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            this.logger.log(Level.WARNING, string);
            if (n > this.handler.getStartPort() + 100) {
                return -3;
            }
            return this.startMBeanServer(++n, this.pid);
        }
        this.logger.fine(MessageFormat.format("RMI registry created on port {0}", Integer.toString(n)));
        boolean bl = false;
        object = this.handler.getAutheFile();
        string = this.handler.getAuthoFile();
        if (object != null && string != null) {
            if (new File((String)object).exists() && new File(string).exists()) {
                hashMap.put(JMX_REMOTE_X_PASSWORD_FILE, object);
                hashMap.put(JMX_REMOTE_X_ACCESS_FILE, string);
                bl = true;
            } else {
                String string8 = Messages.getString("HCLaunchMBean.bad.authentication.file");
                String string9 = MessageFormat.format(string8, object, string);
                this.logger.warning(string9);
                return -5;
            }
        }
        hashMap.put("java.naming.factory.initial", HCInitialContextFactory.class.getName());
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Creating an RMI connector server");
        }
        try {
            String string10;
            Object object2;
            String string11;
            if (this.networkAddressFinder.defaultAddressIsUnreliable()) {
                string11 = this.networkAddressFinder.getLocalAddress();
                if (string11 == null) {
                    string11 = InetAddress.getLocalHost().getHostName();
                }
            } else {
                string11 = InetAddress.getLocalHost().getHostName();
            }
            String string12 = Integer.toString(n);
            String string13 = this.handler.getTransportType().getJMXType();
            String string14 = null;
            if (this.handler.getTransportType() == TransportType.IIOP) {
                String string15 = this.handler.getAgentIIOPPort();
                if (string15 != null) {
                    string14 = System.setProperty("com.ibm.CORBA.ListenerPort", string15);
                    object2 = Messages.getString("HCLaunchMBean.iiop.port.specified");
                    string10 = MessageFormat.format((String)object2, string15);
                    this.logger.info(string10);
                } else {
                    object2 = Messages.getString("HCLaunchMBean.iiop.port.not.specified");
                    string10 = MessageFormat.format((String)object2, "com.ibm.java.diagnostics.healthcenter.agent.iiop.port");
                    this.logger.info(string10);
                }
            }
            JMXServiceURL jMXServiceURL = new JMXServiceURL(MessageFormat.format(JMX_URL_TEMPLATE, string13, string11, string12, string11, string12));
            JMXConnectorServer jMXConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, hashMap, mBeanServer);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(MessageFormat.format("Starting the RMI connector server ({0})", jMXServiceURL));
            }
            jMXConnectorServer.start();
            if (this.handler.getTransportType() == TransportType.IIOP) {
                if (string14 == null) {
                    System.clearProperty("com.ibm.CORBA.ListenerPort");
                } else {
                    System.setProperty("com.ibm.CORBA.ListenerPort", string14);
                }
            }
            object2 = new StopJMXConnectorThread(jMXConnectorServer);
            ((Thread)object2).start();
            string10 = bl ? "with" : "without";
            this.logger.fine(MessageFormat.format("RMI connector server started {0} authentication.", string10));
        }
        catch (Throwable throwable) {
            try {
                UnicastRemoteObject.unexportObject(registry, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            this.logger.log(Level.SEVERE, Messages.getString("HCLaunchMBean.agent.failed.to.start"), throwable);
            return -1;
        }
        return n;
    }

    private void ensureNetworkAddressIsSensible() {
        if (this.networkAddressFinder.defaultAddressIsUnreliable()) {
            String string;
            String string2;
            String string3;
            String string4 = this.networkAddressFinder.getLocalAddress();
            try {
                string3 = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                string3 = Messages.getString("HCLaunchMBean.unknown.host");
            }
            if (this.handler.getTransportType() == TransportType.JRMP && System.getProperty("java.rmi.server.hostname") == null && string4 != null) {
                string2 = Messages.getString("HCLaunchMBean.overriding.network.address.warning");
                string = MessageFormat.format(string2, string4, string3, "java.rmi.server.hostname");
                this.logger.warning(string);
                System.setProperty("java.rmi.server.hostname", string4);
            }
            if (this.handler.getTransportType() == TransportType.IIOP && System.getProperty("com.ibm.CORBA.LocalHost") == null && string4 != null) {
                string2 = Messages.getString("HCLaunchMBean.overriding.orb.network.address.warning");
                string = MessageFormat.format(string2, string4, string3, "com.ibm.CORBA.LocalHost");
                this.logger.warning(string);
                System.setProperty("com.ibm.CORBA.LocalHost", string4);
            }
        }
    }

    public boolean stopMBeanServer(int n) {
        boolean bl = false;
        try {
            Registry registry = LocateRegistry.getRegistry(n);
            bl = UnicastRemoteObject.unexportObject(registry, true);
        }
        catch (Throwable throwable) {
            String string = Messages.getString("HCLaunchMBean.failed.to.stop.registry");
            String string2 = MessageFormat.format(string, n, throwable.toString());
            this.logger.log(Level.WARNING, string2);
        }
        return bl;
    }

    private static void loadNativeLibrary() {
        try {
            HealthCenter.isLoaded();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                File[] fileArray;
                File file;
                String string = System.getProperty("com.ibm.system.agent.path");
                String string2 = System.getProperty("com.ibm.java.diagnostics.healthcenter.agent.path");
                String string3 = string2 != null ? (string != null && string.indexOf("/lib") != -1 ? string2 + string.substring(string.indexOf("/lib")) : string) : string;
                if (string3 != null && (file = new File(string3)) != null && (fileArray = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.equals("healthcenter.dll") || string.equals("libhealthcenter.so");
                    }
                })) != null && fileArray.length > 0) {
                    System.load(fileArray[0].getAbsolutePath());
                }
                HealthCenter.isLoaded();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                try {
                    System.loadLibrary("healthcenter");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
                    // empty catch block
                }
            }
        }
    }

    static {
        HCLaunchMBean.loadNativeLibrary();
    }

    private class JmxStarterThread
    extends Thread {
        protected int port;
        protected int pid;

        public JmxStarterThread(String string, int n) {
            super(string);
            this.port = -1;
            this.pid = 0;
            this.pid = n;
        }

        public int getPort() {
            return this.port;
        }

        @Override
        public void run() {
            int n = HCLaunchMBean.this.handler.getStartDelaySeconds();
            if (n > 0) {
                try {
                    Thread.sleep(n * 1000);
                }
                catch (Exception exception) {
                    HCLaunchMBean.this.logger.fine(MessageFormat.format(Messages.getString("HCLaunchMBean.thread.interrupted"), this.getName()));
                }
            }
            HCLaunchMBean.this.logger.fine("Calling startMBeanServer");
            this.port = HCLaunchMBean.this.startMBeanServer(HCLaunchMBean.this.handler.getStartPort(), this.pid);
            HCLaunchMBean.this.logger.fine("startMBeanServer returned");
        }
    }

    public class StopJMXConnectorThread
    extends Thread {
        private final JMXConnectorServer cs;

        public StopJMXConnectorThread(JMXConnectorServer jMXConnectorServer) {
            super(Messages.getString("HCLaunchMBean.thread.name"));
            this.cs = jMXConnectorServer;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.stopJMXConnectorOnceNoThreadsRemain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopJMXConnectorOnceNoThreadsRemain() {
            this.blockUntilNoThreadsRemain();
            if (!HCLaunchMBean.this.handler.isKeepAlive()) {
                try {
                    String string = Messages.getString("HCLaunchMBean.stopping.jmx.connector.server");
                    HCLaunchMBean.this.logger.log(Level.FINE, string);
                    this.cs.stop();
                }
                catch (Throwable throwable) {
                    String string = Messages.getString("HCLaunchMBean.problem.stopping.server");
                    HCLaunchMBean.this.logger.log(Level.WARNING, string, throwable);
                }
                finally {
                    try {
                        this.cs.stop();
                    }
                    catch (Throwable throwable) {
                        System.exit(-1);
                    }
                }
            }
        }

        private void blockUntilNoThreadsRemain() {
            boolean bl;
            do {
                bl = false;
                Thread[] threadArray = new Thread[Thread.activeCount()];
                Thread.enumerate(threadArray);
                if (Thread.activeCount() > threadArray.length) {
                    bl = true;
                }
                for (Thread thread : threadArray) {
                    if (thread == null || !thread.isAlive() || thread.isDaemon() || thread.getName().startsWith("RMI Reaper") || thread.getName().startsWith("DestroyJavaVM helper thread") || HCLaunchMBean.this.isCORBAKeepAlive(thread)) continue;
                    bl = true;
                    try {
                        HCLaunchMBean.this.logger.fine("blockUntilNoThreadsRemain() Joining " + thread.getName());
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } while (bl);
        }
    }
}

