/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class HCSslRMIServerSocketFactory
extends SslRMIServerSocketFactory {
    private final String keystoreName;
    private final String keystorePassword;
    private final String certificatePassword;

    public HCSslRMIServerSocketFactory(String string, String string2, String string3) {
        this.keystoreName = string;
        this.keystorePassword = string2;
        this.certificatePassword = string3;
    }

    @Override
    public ServerSocket createServerSocket(int n) throws IOException {
        SSLServerSocket sSLServerSocket = null;
        FileInputStream fileInputStream = new FileInputStream(new File(this.keystoreName));
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("IBMX509");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(fileInputStream, this.keystorePassword.toCharArray());
            keyManagerFactory.init(keyStore, this.certificatePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("IBMX509");
            trustManagerFactory.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
            sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new IOException(keyStoreException);
        }
        catch (CertificateException certificateException) {
            throw new IOException(certificateException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new IOException(unrecoverableKeyException);
        }
        catch (KeyManagementException keyManagementException) {
            throw new IOException(keyManagementException);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return sSLServerSocket;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.getClass().equals(object.getClass());
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

