/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.postprocessor.analysis;

import com.ibm.java.diagnostics.common.datamodel.impl.preferences.PreferencesHelper;
import com.ibm.java.diagnostics.healthcenter.gc.preferences.GCPreferenceInitializer;
import java.util.prefs.Preferences;

public class SummarisingPostProcessorPreferenceHelper
extends PreferencesHelper {
    public static final String SEPARATOR = "SummarisingPostProcessorPreferenceHelper.classLineThickness";
    public static final String REQUEST_THRESHOLD = "SummarisingPostProcessorPreferenceHelper.classRequestThreshold";
    public static final String COMPACT_FRACTION_THRESHOLD = "SummarisingPostProcessorPreferenceHelper.classCompactFractionThreshold";
    public static final String SYSTEM_GC_FRACTION_THRESHOLD = "SummarisingPostProcessorPreferenceHelper.classSystemGCFractionThreshold";
    public static final String PAUSE_THRESHOLD = "SummarisingPostProcessorPreferenceHelper.classPauseThreshold";
    public static final String FRAGMENTATION_THRESHOLD = "SummarisingPostProcessorPreferenceHelper.classFragmentationThreshold";
    public static final String HIGH_OCCUPANCY_THRESHOLD = "SummarisingPostProcessorPreferenceHelper.classHighOccupancyThreshold";
    public static final String CRITICALLY_HIGH_OCCUPANCY_THRESHOLD = "SummarisingPostProcessorPreferenceHelper.classCriticallyHighOccupancyThreshold";
    public static final String LOW_OCCUPANCY_THRESHOLD = "SummarisingPostProcessorPreferenceHelper.classLowOccupancyThreshold";
    public static final String CRITICALLY_LOW_OCCUPANCY_THRESHOLD = "SummarisingPostProcessorPreferenceHelper.classCriticallyLowOccupancyThreshold";
    public static final String LEAK_THRESHOLD = "SummarisingPostProcessorPreferenceHelper.classLeakThreshold";
    private static final int DEFAULT_HIGH_OCCUPANCY_THRESHOLD = 70;
    private static final int DEFAULT_CRITICALLY_HIGH_OCCUPANCY_THRESHOLD = 80;
    private static final int DEFAULT_LOW_OCCUPANCY_THRESHOLD = 40;
    private static final int DEFAULT_CRITICALLY_LOW_OCCUPANCY_THRESHOLD = 15;
    private static final int DEFAULT_LEAK_THRESHOLD = 10;
    private static final int DEFAULT_REQUEST_THRESHOLD = 512000;
    private static final int DEFAULT_PAUSE_THRESHOLD = 5000;
    private static final int DEFAULT_COMPACT_FRACTION_THRESHOLD = 15;
    private static final int DEFAULT_SYSTEM_GC_FRACTION_THRESHOLD = 10;
    private static final int DEFAULT_FRAGMENTATION_THRESHOLD = 15;

    public SummarisingPostProcessorPreferenceHelper() {
        this.instantiatePreferences();
        if (this.preferences.getInt(COMPACT_FRACTION_THRESHOLD, -1) == -1) {
            this.initializeDefaultPreferences();
        }
    }

    protected Preferences instantiatePreferences() {
        return GCPreferenceInitializer.getInstance().getPreferences();
    }

    public String getSeparator() {
        return this.preferences.get(SEPARATOR, "");
    }

    public int getRequestSizeThreshold() {
        return this.preferences.getInt(REQUEST_THRESHOLD, 512000);
    }

    public int getCompactProportionThreshold() {
        return this.preferences.getInt(COMPACT_FRACTION_THRESHOLD, 15);
    }

    public int getSystemGCProportionThreshold() {
        return this.preferences.getInt(SYSTEM_GC_FRACTION_THRESHOLD, 10);
    }

    public int getLongPauseThreshold() {
        return this.preferences.getInt(PAUSE_THRESHOLD, 5000);
    }

    public int getFragmentationThreshold() {
        return this.preferences.getInt(FRAGMENTATION_THRESHOLD, 15);
    }

    public int getHighOccupancyThreshold() {
        return this.preferences.getInt(HIGH_OCCUPANCY_THRESHOLD, 70);
    }

    public int getCriticallyHighOccupancyThreshold() {
        return this.preferences.getInt(CRITICALLY_HIGH_OCCUPANCY_THRESHOLD, 80);
    }

    public int getLowOccupancyThreshold() {
        return this.preferences.getInt(LOW_OCCUPANCY_THRESHOLD, 40);
    }

    public int getCriticallyLowOccupancyThreshold() {
        return this.preferences.getInt(CRITICALLY_LOW_OCCUPANCY_THRESHOLD, 15);
    }

    public int getLeakThreshold() {
        return this.preferences.getInt(LEAK_THRESHOLD, 10);
    }

    public static void initializeDefaults(Preferences preferences) {
        preferences.putInt(COMPACT_FRACTION_THRESHOLD, 15);
        preferences.putInt(SYSTEM_GC_FRACTION_THRESHOLD, 10);
        preferences.putInt(REQUEST_THRESHOLD, 512000);
        preferences.putInt(PAUSE_THRESHOLD, 5000);
        preferences.putInt(FRAGMENTATION_THRESHOLD, 15);
        preferences.putInt(HIGH_OCCUPANCY_THRESHOLD, 70);
        preferences.putInt(CRITICALLY_HIGH_OCCUPANCY_THRESHOLD, 80);
        preferences.putInt(LOW_OCCUPANCY_THRESHOLD, 40);
        preferences.putInt(CRITICALLY_LOW_OCCUPANCY_THRESHOLD, 15);
        preferences.putInt(LEAK_THRESHOLD, 10);
    }

    @Override
    public void initializeDefaultPreferences() {
        this.preferences.putInt(COMPACT_FRACTION_THRESHOLD, 15);
        this.preferences.putInt(SYSTEM_GC_FRACTION_THRESHOLD, 10);
        this.preferences.putInt(REQUEST_THRESHOLD, 512000);
        this.preferences.putInt(PAUSE_THRESHOLD, 5000);
        this.preferences.putInt(FRAGMENTATION_THRESHOLD, 15);
        this.preferences.putInt(HIGH_OCCUPANCY_THRESHOLD, 70);
        this.preferences.putInt(CRITICALLY_HIGH_OCCUPANCY_THRESHOLD, 80);
        this.preferences.putInt(LOW_OCCUPANCY_THRESHOLD, 40);
        this.preferences.putInt(CRITICALLY_LOW_OCCUPANCY_THRESHOLD, 15);
        this.preferences.putInt(LEAK_THRESHOLD, 10);
    }
}

