/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.datatruncation;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.healthcenter.impl.datatruncation.DataSeedingJob;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.HealthCenterThread;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;

public class DataSeedingThread
extends HealthCenterThread {
    private static final String THREAD_NAME = Messages.getString("DataSeedingThread.thread.name");
    private OutputProperties properties;

    public DataSeedingThread(Marshaller marshaller, OutputProperties outputProperties) {
        super(THREAD_NAME, marshaller);
        this.properties = outputProperties;
    }

    @Override
    protected int getDefaultTimingInterval() {
        return 86400000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueWork() {
        DataSeedingJob dataSeedingJob = null;
        Data data = this.marshaller.getData(null);
        if (data != null) {
            dataSeedingJob = new DataSeedingJob((DataBuilder)data, this.properties);
            Object object = this.marshaller.getQueueLock();
            synchronized (object) {
                this.marshaller.addJobToQueue(dataSeedingJob);
            }
        }
    }

    @Override
    public void terminate() {
        super.terminate();
        this.properties = null;
    }
}

