/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.marshalling.data.events;

import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ClassesInternalEvent;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ClassesInternalObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ClassesEventHandler
extends Thread {
    List<ClassesInternalEvent> listeners = new ArrayList<ClassesInternalEvent>();
    Queue<ClassesInternalObject> events = new ConcurrentLinkedQueue<ClassesInternalObject>();
    private boolean flushData = false;
    private static int eventQueueSize = 0;
    private static final int maxEventQueueSize = 15;
    protected volatile boolean run = true;

    public ClassesEventHandler() {
        super("Classes Event Handler");
        this.setDaemon(true);
    }

    public void addClassesEventListener(ClassesInternalEvent classesInternalEvent) {
        this.listeners.add(classesInternalEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(ClassesInternalObject classesInternalObject) {
        Queue<ClassesInternalObject> queue = this.events;
        synchronized (queue) {
            if (eventQueueSize < 15 && !this.flushData) {
                this.events.add(classesInternalObject);
                ++eventQueueSize;
            } else {
                this.flushData = true;
            }
            this.events.notify();
        }
    }

    private void triggerClasses(ClassesInternalObject classesInternalObject) {
        for (ClassesInternalEvent classesInternalEvent : this.listeners) {
            classesInternalEvent.classesEvent(classesInternalObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            try {
                if (!this.events.isEmpty()) {
                    if (this.flushData) {
                        while (this.flushData) {
                            this.triggerClasses(this.events.poll());
                            --eventQueueSize;
                            if (!this.events.isEmpty()) continue;
                            this.flushData = false;
                        }
                    } else {
                        this.triggerClasses(this.events.poll());
                        --eventQueueSize;
                    }
                }
                Queue<ClassesInternalObject> queue = this.events;
                synchronized (queue) {
                    try {
                        if (this.events.isEmpty()) {
                            this.events.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void terminate() {
        this.run = false;
        this.interrupt();
    }
}

