/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.marshalling.data.events;

import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.SocketInternalEvent;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.SocketInternalObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SocketEventHandler
extends Thread {
    List<SocketInternalEvent> listeners = new ArrayList<SocketInternalEvent>();
    Queue<SocketInternalObject> events = new ConcurrentLinkedQueue<SocketInternalObject>();
    private boolean flushData = false;
    private static int eventQueueSize = 0;
    private static final int maxEventQueueSize = 15;
    protected volatile boolean run = true;

    public SocketEventHandler() {
        super("Socket Event Handler");
        this.setDaemon(true);
    }

    public void addSocketEventListener(SocketInternalEvent socketInternalEvent) {
        this.listeners.add(socketInternalEvent);
    }

    private void triggerSocket(SocketInternalObject socketInternalObject) {
        for (SocketInternalEvent socketInternalEvent : this.listeners) {
            socketInternalEvent.socketEvent(socketInternalObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(SocketInternalObject socketInternalObject) {
        Queue<SocketInternalObject> queue = this.events;
        synchronized (queue) {
            if (eventQueueSize < 15 && !this.flushData) {
                this.events.add(socketInternalObject);
                ++eventQueueSize;
            } else {
                this.flushData = true;
            }
            this.events.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            try {
                if (!this.events.isEmpty()) {
                    if (this.flushData) {
                        while (this.flushData) {
                            this.triggerSocket(this.events.poll());
                            --eventQueueSize;
                            if (!this.events.isEmpty()) continue;
                            this.flushData = false;
                        }
                    } else {
                        this.triggerSocket(this.events.poll());
                        --eventQueueSize;
                    }
                }
                Queue<SocketInternalObject> queue = this.events;
                synchronized (queue) {
                    try {
                        if (this.events.isEmpty()) {
                            this.events.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void terminate() {
        this.run = false;
        this.interrupt();
    }
}

