/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax.events;

import com.ibm.xml.xlxp.api.stax.XMLStreamWriterImpl;
import com.ibm.xml.xlxp.api.util.ImmutableArrayList;
import com.ibm.xml.xlxp.api.util.ImmutableEmptyList;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class XMLEventImpl
implements XMLEvent {
    private final int fEventType;
    private final Location fLocation;
    private static final Location EMPTY_LOCATION = new Location(){

        public int getLineNumber() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        public int getCharacterOffset() {
            return -1;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }
    };

    public XMLEventImpl(int n) {
        this(n, null);
    }

    public XMLEventImpl(int n, Location location) {
        this.fEventType = n;
        this.fLocation = location == null ? EMPTY_LOCATION : new LocationClone(location.getCharacterOffset(), location.getColumnNumber(), location.getLineNumber(), location.getPublicId(), location.getSystemId());
    }

    public final int getEventType() {
        return this.fEventType;
    }

    public final Location getLocation() {
        return this.fLocation;
    }

    public final boolean isStartElement() {
        return this.fEventType == 1;
    }

    public final boolean isAttribute() {
        return this.fEventType == 10;
    }

    public final boolean isNamespace() {
        return this.fEventType == 13;
    }

    public final boolean isEndElement() {
        return this.fEventType == 2;
    }

    public final boolean isEntityReference() {
        return this.fEventType == 9;
    }

    public final boolean isProcessingInstruction() {
        return this.fEventType == 3;
    }

    public final boolean isCharacters() {
        return this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6;
    }

    public final boolean isCData() {
        return this.fEventType == 12;
    }

    public final boolean isIgnorableWhiteSpace() {
        return this.fEventType == 6;
    }

    public final boolean isStartDocument() {
        return this.fEventType == 7;
    }

    public final boolean isEndDocument() {
        return this.fEventType == 8;
    }

    public final StartElement asStartElement() {
        return (StartElement)((Object)this);
    }

    public final EndElement asEndElement() {
        return (EndElement)((Object)this);
    }

    public final Characters asCharacters() {
        return (Characters)((Object)this);
    }

    public final QName getSchemaType() {
        return null;
    }

    public abstract void writeAsEncodedUnicode(Writer var1) throws XMLStreamException;

    public static String escape(String string, int n) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = null;
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            switch (c) {
                case '&': {
                    if (n == 15) {
                        if (n3 + 1 < n2 && string.charAt(n3 + 1) == '#') {
                            stringBuffer = XMLEventImpl.append(stringBuffer, string, n3, "&#38;");
                            break;
                        }
                        if (stringBuffer == null) break;
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer = XMLEventImpl.append(stringBuffer, string, n3, "&amp;");
                    break;
                }
                case '<': {
                    if (n != 15) {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, n3, "&lt;");
                        break;
                    }
                    if (stringBuffer == null) break;
                    stringBuffer.append(c);
                    break;
                }
                case '>': {
                    if (n == 4 && n3 >= 2 && string.charAt(n3 - 1) == ']' && string.charAt(n3 - 2) == ']') {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, n3, "&gt;");
                        break;
                    }
                    if (stringBuffer == null) break;
                    stringBuffer.append(c);
                    break;
                }
                case '\"': {
                    if (n == 10 || n == 15) {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, n3, "&quot;");
                        break;
                    }
                    if (stringBuffer == null) break;
                    stringBuffer.append(c);
                    break;
                }
                case '%': {
                    if (n == 15) {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, n3, "&#37;");
                        break;
                    }
                    if (stringBuffer == null) break;
                    stringBuffer.append(c);
                    break;
                }
                case '\t': {
                    if (n == 10) {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, n3, "&#9;");
                        break;
                    }
                    if (stringBuffer == null) break;
                    stringBuffer.append(c);
                    break;
                }
                case '\n': {
                    if (n == 10) {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, n3, "&#10;");
                        break;
                    }
                    if (stringBuffer == null) break;
                    stringBuffer.append(c);
                    break;
                }
                case '\r': {
                    stringBuffer = XMLEventImpl.append(stringBuffer, string, n3, "&#13;");
                    break;
                }
                case '\u0085': {
                    stringBuffer = XMLEventImpl.append(stringBuffer, string, n3, "&#133;");
                    break;
                }
                case '\u2028': {
                    stringBuffer = XMLEventImpl.append(stringBuffer, string, n3, "&#8232;");
                    break;
                }
                default: {
                    if (c >= '\u0001' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, n3, "&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        break;
                    }
                    if (stringBuffer == null) break;
                    stringBuffer.append(c);
                }
            }
            ++n3;
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    private static StringBuffer append(StringBuffer stringBuffer, String string, int n, String string2) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n));
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }

    public void writeAsEncodedUnicode(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (xMLStreamWriter instanceof XMLStreamWriterImpl) {
            ((XMLStreamWriterImpl)xMLStreamWriter).writeAsEncodedUnicode(this);
        }
    }

    static List iteratorToList(Iterator iterator) {
        if (iterator == null || !iterator.hasNext()) {
            return ImmutableEmptyList.INSTANCE;
        }
        Object[] objectArray = new Object[8];
        int n = 0;
        while (iterator.hasNext()) {
            if (objectArray.length <= n) {
                Object[] objectArray2 = new Object[objectArray.length * 2];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray = objectArray2;
            }
            objectArray[n++] = iterator.next();
        }
        return new ImmutableArrayList(objectArray, n);
    }

    private static final class LocationClone
    implements Location {
        private final int characterOffset;
        private final int columnNumber;
        private final int lineNumber;
        private final String publicId;
        private final String systemId;

        private LocationClone(int n, int n2, int n3, String string, String string2) {
            this.characterOffset = n;
            this.columnNumber = n2;
            this.lineNumber = n3;
            this.publicId = string;
            this.systemId = string2;
        }

        public int getCharacterOffset() {
            return this.characterOffset;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }
    }
}

