/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax.serializer;

import com.ibm.xml.jaxp.util.HashtableFactory;
import com.ibm.xml.xlxp.api.stax.serializer.Encoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public final class GenericEncoding
extends Encoding {
    private ByteArrayOutputStream fStream = new ByteArrayOutputStream();
    private OutputStreamWriter fWriter;
    private boolean[] fLowCharacters;
    private EncodingNode fCache;
    private Hashtable fSupplementaryCache;
    private MyInteger fSupplInt;

    public GenericEncoding(String string) throws UnsupportedEncodingException {
        super(string);
        this.fWriter = new OutputStreamWriter((OutputStream)this.fStream, string);
        this.fCache = new EncodingNode(0, 65535);
        this.fSupplementaryCache = HashtableFactory.newHashtable();
        this.fSupplInt = new MyInteger(0);
        this.fLowCharacters = this.getEncodabilityArray(128, 255);
    }

    public final boolean isEncodable(char c) {
        if (c <= '\u007f') {
            return true;
        }
        if (c <= '\u00ff') {
            return this.fLowCharacters[c - 128];
        }
        return this.fCache.isEncodable(c);
    }

    public boolean isEncodable(char c, char c2) {
        this.fSupplInt.value = Encoding.toCodePoint(c, c2);
        Boolean bl = (Boolean)this.fSupplementaryCache.get(this.fSupplInt);
        if (bl == null) {
            bl = this.testEncodability(c, c2) ? Boolean.TRUE : Boolean.FALSE;
            this.fSupplementaryCache.put(new MyInteger(this.fSupplInt.value), bl);
        }
        return bl == Boolean.TRUE;
    }

    private boolean[] getEncodabilityArray(int n, int n2) {
        boolean[] blArray = new boolean[n2 - n + 1];
        int n3 = n;
        while (n3 <= n2) {
            blArray[n3 - n] = this.testEncodability(n3);
            ++n3;
        }
        return blArray;
    }

    private final synchronized boolean testEncodability(int n) {
        try {
            try {
                this.fWriter.write(n);
                this.fWriter.flush();
                byte[] byArray = this.fStream.toByteArray();
                boolean bl = this.checkBytes(byArray);
                Object var5_6 = null;
                this.fStream.reset();
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                Object var5_7 = null;
                this.fStream.reset();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.fStream.reset();
            throw throwable;
        }
    }

    private final synchronized boolean testEncodability(char c, char c2) {
        try {
            try {
                this.fWriter.write(new char[]{c, c2});
                this.fWriter.flush();
                byte[] byArray = this.fStream.toByteArray();
                boolean bl = this.checkBytes(byArray);
                Object var6_7 = null;
                this.fStream.reset();
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                Object var6_8 = null;
                this.fStream.reset();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.fStream.reset();
            throw throwable;
        }
    }

    private boolean checkBytes(byte[] byArray) {
        return byArray.length > 0 && byArray[0] != 63;
    }

    private class EncodingNode {
        private static final int NODE_RANGE = 256;
        private EncodingNode fLowChild;
        private EncodingNode fHighChild;
        private boolean[] isEncodable;
        private int fLow;
        private int fHigh;
        private int fImplLow;
        private int fImplHigh;
        private boolean fInitialized;

        public EncodingNode(int n, int n2) {
            this.fHigh = n2;
            this.fLow = n;
            int n3 = (n + n2) / 2;
            this.fImplLow = (n3 - n) / 256 * 256 + n;
            this.fImplHigh = this.fImplLow + 256 - 1;
            this.fInitialized = false;
        }

        public boolean isEncodable(int n) {
            if (n < this.fImplLow) {
                if (n >= this.fLow) {
                    if (this.fLowChild == null) {
                        this.fLowChild = new EncodingNode(this.fLow, this.fImplLow - 1);
                    }
                    return this.fLowChild.isEncodable(n);
                }
                return false;
            }
            if (n > this.fImplHigh) {
                if (n <= this.fHigh) {
                    if (this.fHighChild == null) {
                        this.fHighChild = new EncodingNode(this.fImplHigh + 1, this.fHigh);
                    }
                    return this.fHighChild.isEncodable(n);
                }
                return false;
            }
            if (!this.fInitialized) {
                this.fInitialized = true;
                this.isEncodable = GenericEncoding.this.getEncodabilityArray(this.fImplLow, this.fImplHigh);
            }
            return this.isEncodable[n - this.fImplLow];
        }
    }

    private class MyInteger {
        public int value;

        public MyInteger(int n) {
            this.value = n;
        }

        public boolean equals(Object object) {
            return this.value == ((MyInteger)object).value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

