/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.DateTimeBase;
import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XDataTypeUtils;
import com.ibm.xtq.xml.datamodel.XDate;
import com.ibm.xtq.xml.datamodel.XDayTimeDuration;
import com.ibm.xtq.xml.datamodel.XGDay;
import com.ibm.xtq.xml.datamodel.XGMonth;
import com.ibm.xtq.xml.datamodel.XGMonthDay;
import com.ibm.xtq.xml.datamodel.XGYear;
import com.ibm.xtq.xml.datamodel.XGYearMonth;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XTime;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.datamodel.XYearMonthDuration;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeError;
import java.math.BigDecimal;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.DateTimeDV;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class XDateTime
extends XItemBase {
    private static TypeValidator m_validator = new DateTimeDV();
    private final XDayTimeDuration ZERO_DTD = new XDayTimeDuration(0, 0, 0, 0.0);
    private int m_year;
    private int m_month;
    private int m_day;
    private int m_hour;
    private int m_minute;
    private double m_second;
    private XDayTimeDuration m_timezone;

    protected XDateTime(DateTimeBase dateTimeBase) {
        this.m_year = dateTimeBase.getYear();
        this.m_month = dateTimeBase.getMonth();
        this.m_day = dateTimeBase.getDay();
        this.m_hour = dateTimeBase.getHours();
        this.m_minute = dateTimeBase.getMinutes();
        this.m_second = (double)dateTimeBase.getSeconds() + dateTimeBase.getFraction();
        this.m_type = Type.DATETIME;
    }

    public XDateTime(int n, int n2, int n3, int n4, int n5, double d) {
        this(n, n2, n3, n4, n5, d, null, Type.DATETIME);
    }

    public XDateTime(int n, int n2, int n3, int n4, int n5, double d, ItemType itemType) {
        this(n, n2, n3, n4, n5, d, null, itemType);
    }

    public XDateTime(int n, int n2, int n3, int n4, int n5, double d, XDayTimeDuration xDayTimeDuration) {
        this(n, n2, n3, n4, n5, d, xDayTimeDuration, Type.DATETIME);
    }

    public XDateTime(int n, int n2, int n3, int n4, int n5, double d, int n6, int n7) {
        this(n, n2, n3, n4, n5, d, new XDayTimeDuration(0, n6, n7, 0.0), Type.DATETIME);
    }

    public XDateTime(int n, int n2, int n3, int n4, int n5, double d, XDayTimeDuration xDayTimeDuration, ItemType itemType) {
        this.m_year = n;
        this.m_month = n2;
        this.m_day = n3;
        this.m_hour = n4;
        this.m_minute = n5;
        this.m_second = d;
        this.m_timezone = xDayTimeDuration;
        this.m_type = itemType;
    }

    @Override
    public int getPrimitiveId() {
        return 9;
    }

    public static XDateTime parse(String string) {
        try {
            return new XDateTime((DateTimeBase)m_validator.getActualValue(string, null));
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new DynamicError(invalidDatatypeValueException.toString());
        }
    }

    public XDateTime normalize() {
        if (this.m_timezone != null && !this.m_timezone.equals(this.ZERO_DTD)) {
            XDateTime xDateTime = new XDateTime(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), 0, 0);
            return xDateTime.subtract(this.m_timezone);
        }
        return this;
    }

    public int getYear() {
        return this.m_year;
    }

    public int getMonth() {
        return this.m_month;
    }

    public int getDay() {
        return this.m_day;
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public double getSecond() {
        return this.m_second;
    }

    public XDayTimeDuration getTimeZone() {
        return this.m_timezone;
    }

    public int getTimeZoneHour() {
        return this.m_timezone != null ? this.m_timezone.getHours() : Integer.MAX_VALUE;
    }

    public int getTimeZoneMinute() {
        return this.m_timezone != null ? this.m_timezone.getMinutes() : Integer.MAX_VALUE;
    }

    @Override
    public XDate toDate() {
        return new XDate(this.m_year, this.m_month, this.m_day, this.m_timezone);
    }

    public XDateTime toDateTime() {
        return this;
    }

    @Override
    public XGDay toGDay() {
        String string = CastLibrary.convertTo2CharString(this.m_day);
        String string2 = CastLibrary.convertTZtoString(this.m_timezone);
        return XGDay.parse("---" + string + string2);
    }

    @Override
    public XGMonth toGMonth() {
        String string = CastLibrary.convertTo2CharString(this.m_month);
        String string2 = CastLibrary.convertTZtoString(this.m_timezone);
        return XGMonth.parse("--" + string + string2);
    }

    @Override
    public XGMonthDay toGMonthDay() {
        String string = CastLibrary.convertTo2CharString(this.m_month);
        String string2 = CastLibrary.convertTo2CharString(this.m_day);
        String string3 = CastLibrary.convertTZtoString(this.m_timezone);
        return XGMonthDay.parse("--" + string + "-" + string2 + string3);
    }

    @Override
    public XGYear toGYear() {
        String string = CastLibrary.convertYearToString(this.m_year);
        String string2 = CastLibrary.convertTZtoString(this.m_timezone);
        return XGYear.parse(string + string2);
    }

    @Override
    public XGYearMonth toGYearMonth() {
        String string = CastLibrary.convertYearToString(this.m_year);
        String string2 = CastLibrary.convertTo2CharString(this.m_month);
        String string3 = CastLibrary.convertTZtoString(this.m_timezone);
        return XGYearMonth.parse(string + "-" + string2 + string3);
    }

    @Override
    public String toString() {
        return CastLibrary.composeDateTimeStrRep(this.m_year, this.m_month, this.m_day, this.m_hour, this.m_minute, this.m_second, this.m_timezone);
    }

    @Override
    public XTime toTime() {
        return new XTime(this.m_hour, this.m_minute, this.m_second, this.m_timezone);
    }

    @Override
    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public XDateTime add(XYearMonthDuration xYearMonthDuration) {
        int n = this.m_month + xYearMonthDuration.getMonths();
        int n2 = (int)XDataTypeUtils.modulo((double)n, 1, 13);
        int n3 = XDataTypeUtils.fQuotient(n, 1, 13);
        int n4 = this.m_year + xYearMonthDuration.getYears() + n3;
        int n5 = XDataTypeUtils.normalizeDay(this.m_day, n2, n4);
        int[] nArray = new int[3];
        nArray = XDataTypeUtils.normalizeDate(n5, n2, n4);
        return new XDateTime(nArray[2], nArray[1], nArray[0], this.m_hour, this.m_minute, this.m_second, this.m_timezone);
    }

    public XDateTime add(XDayTimeDuration xDayTimeDuration) {
        double d = this.m_second + xDayTimeDuration.getSeconds();
        int n = XDataTypeUtils.fQuotient(d, 60.0);
        double d2 = XDataTypeUtils.modulo(d, 60.0, n);
        int n2 = this.m_minute + xDayTimeDuration.getMinutes() + n;
        n = XDataTypeUtils.fQuotient(n2, 60.0);
        int n3 = (int)XDataTypeUtils.modulo((double)n2, 60.0, n);
        n2 = this.m_hour + xDayTimeDuration.getHours() + n;
        n = XDataTypeUtils.fQuotient(n2, 24.0);
        int n4 = (int)XDataTypeUtils.modulo((double)n2, 24.0, n);
        int n5 = XDataTypeUtils.normalizeDay(this.m_day, this.m_month, this.m_year);
        int[] nArray = new int[3];
        nArray = XDataTypeUtils.normalizeDate(n5 += xDayTimeDuration.getDays() + n, this.m_month, this.m_year);
        return new XDateTime(nArray[2], nArray[1], nArray[0], n4, n3, d2, this.m_timezone);
    }

    @Override
    public XItem add(XItem xItem) {
        switch (xItem.getPrimitiveId()) {
            case 7: {
                return this.add(xItem.toYearMonthDuration());
            }
            case 8: {
                return this.add(xItem.toDayTimeDuration());
            }
        }
        throw new TypeError();
    }

    public XDateTime subtract(XYearMonthDuration xYearMonthDuration) {
        return this.add(XDataTypeUtils.negate(xYearMonthDuration));
    }

    public XDateTime subtract(XDayTimeDuration xDayTimeDuration) {
        return this.add(XDataTypeUtils.negate(xDayTimeDuration));
    }

    public XDayTimeDuration subtract(XDateTime xDateTime) {
        XDateTime xDateTime2 = this.normalize();
        XDateTime xDateTime3 = xDateTime.normalize();
        int n = XDataTypeUtils.numberOfDays(xDateTime2.getDay(), xDateTime2.getMonth(), xDateTime2.getYear()) - XDataTypeUtils.numberOfDays(xDateTime3.getDay(), xDateTime3.getMonth(), xDateTime3.getYear());
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n, 0, 0, 0.0);
        double d = XDataTypeUtils.timeToSeconds(new XTime(xDateTime2.getHour(), xDateTime2.getMinute(), xDateTime2.getSecond())) - XDataTypeUtils.timeToSeconds(new XTime(xDateTime3.getHour(), xDateTime3.getMinute(), xDateTime3.getSecond()));
        if (n > 0 && d < 0.0) {
            return xDayTimeDuration.subtract(XDataTypeUtils.secondsTodayTimeDuration(new BigDecimal(d * -1.0)));
        }
        return xDayTimeDuration.add(XDataTypeUtils.secondsTodayTimeDuration(new BigDecimal(d)));
    }

    @Override
    public XItem subtract(XItem xItem) {
        switch (xItem.getPrimitiveId()) {
            case 7: {
                return this.subtract(xItem.toYearMonthDuration());
            }
            case 8: {
                return this.subtract(xItem.toDayTimeDuration());
            }
            case 9: {
                return this.subtract(xItem.toDatetime());
            }
        }
        throw new TypeError();
    }

    @Override
    public final int compareTo(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 9: {
                return this.compareTo(xItem.toDatetime());
            }
        }
        throw new TypeError();
    }

    public final int compareTo(XDateTime xDateTime) throws TypeError {
        int n = this.m_year - xDateTime.getYear();
        if (n != 0) {
            return XItemBase.FormatCompareOut(n);
        }
        n = this.m_month - xDateTime.getMonth();
        if (n != 0) {
            return XItemBase.FormatCompareOut(n);
        }
        n = this.m_day - xDateTime.getDay();
        if (n != 0) {
            return XItemBase.FormatCompareOut(n);
        }
        n = this.m_hour - xDateTime.getHour();
        if (n != 0) {
            return XItemBase.FormatCompareOut(n);
        }
        n = this.m_minute - xDateTime.getMinute();
        if (n != 0) {
            return XItemBase.FormatCompareOut(n);
        }
        double d = this.m_second - xDateTime.getSecond();
        return XItemBase.FormatCompareOut(d);
    }

    public final boolean equals(XDateTime xDateTime) throws TypeError {
        return this.compareTo(xDateTime) == 0;
    }

    public final boolean notEquals(XDateTime xDateTime) throws TypeError {
        return !this.equals(xDateTime);
    }

    public final boolean greaterThan(XDateTime xDateTime) throws TypeError {
        return this.compareTo(xDateTime) > 0;
    }

    public final boolean greaterOrEquals(XDateTime xDateTime) throws TypeError {
        return this.compareTo(xDateTime) >= 0;
    }

    public final boolean lessThan(XDateTime xDateTime) throws TypeError {
        return this.compareTo(xDateTime) < 0;
    }

    public final boolean lessOrEquals(XDateTime xDateTime) throws TypeError {
        return this.compareTo(xDateTime) <= 0;
    }
}

