/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.dtm.ref;

import com.ibm.xtq.xml.dtm.ref.CoroutineManager;
import com.ibm.xtq.xml.dtm.ref.IncrementalSAXSource;
import com.ibm.xtq.xml.dtm.utils.ThreadControllerWrapper;
import com.ibm.xtq.xml.res.XMLMessages;
import java.io.IOException;
import java.io.Serializable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class IncrementalSAXSource_Filter
implements IncrementalSAXSource,
ContentHandler,
DTDHandler,
LexicalHandler,
ErrorHandler,
Runnable {
    boolean DEBUG = false;
    private CoroutineManager fCoroutineManager = null;
    private int fControllerCoroutineID = -1;
    private int fSourceCoroutineID = -1;
    private ContentHandler clientContentHandler = null;
    private LexicalHandler clientLexicalHandler = null;
    private DTDHandler clientDTDHandler = null;
    private ErrorHandler clientErrorHandler = null;
    private int eventcounter;
    private int frequency = 5;
    private boolean fNoMoreEvents = false;
    private XMLReader fXMLReader = null;
    private InputSource fXMLReaderInputSource = null;

    public IncrementalSAXSource_Filter() {
        this.init(new CoroutineManager(), -1, -1);
    }

    public IncrementalSAXSource_Filter(CoroutineManager coroutineManager, int n) {
        this.init(coroutineManager, n, -1);
    }

    public static IncrementalSAXSource createIncrementalSAXSource(CoroutineManager coroutineManager, int n) {
        return new IncrementalSAXSource_Filter(coroutineManager, n);
    }

    public void init(CoroutineManager coroutineManager, int n, int n2) {
        if (coroutineManager == null) {
            coroutineManager = new CoroutineManager();
        }
        this.fCoroutineManager = coroutineManager;
        this.fControllerCoroutineID = coroutineManager.co_joinCoroutineSet(n);
        this.fSourceCoroutineID = coroutineManager.co_joinCoroutineSet(n2);
        if (this.fControllerCoroutineID == -1 || this.fSourceCoroutineID == -1) {
            throw new RuntimeException(XMLMessages.createXMLMessage("ERR_SYSTEM", "co_joinCoroutineSet() failed"));
        }
        this.fNoMoreEvents = false;
        this.eventcounter = this.frequency;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.fXMLReader = xMLReader;
        xMLReader.setContentHandler(this);
        xMLReader.setDTDHandler(this);
        xMLReader.setErrorHandler(this);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.clientContentHandler = contentHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this.clientDTDHandler = dTDHandler;
    }

    @Override
    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.clientLexicalHandler = lexicalHandler;
    }

    public void setErrHandler(ErrorHandler errorHandler) {
        this.clientErrorHandler = errorHandler;
    }

    public void setReturnFrequency(int n) {
        if (n < 1) {
            n = 1;
        }
        this.frequency = this.eventcounter = n;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.characters(cArray, n, n2);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endDocument();
        }
        this.eventcounter = 0;
        this.co_yield(false);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endElement(string, string2, string3);
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endPrefixMapping(string);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.processingInstruction(string, string2);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (--this.eventcounter <= 0) {
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.setDocumentLocator(locator);
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.skippedEntity(string);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.co_entry_pause();
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startDocument();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startPrefixMapping(string, string2);
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.comment(cArray, n, n2);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.endCDATA();
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.endDTD();
        }
    }

    @Override
    public void endEntity(String string) throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.endEntity(string);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.startCDATA();
        }
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.startDTD(string, string2, string3);
        }
    }

    @Override
    public void startEntity(String string) throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.startEntity(string);
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (null != this.clientDTDHandler) {
            this.clientDTDHandler.notationDecl(string, string2, string3);
        }
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (null != this.clientDTDHandler) {
            this.clientDTDHandler.unparsedEntityDecl(string, string2, string3, string4);
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        if (null != this.clientErrorHandler) {
            this.clientErrorHandler.error(sAXParseException);
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (null != this.clientErrorHandler) {
            this.clientErrorHandler.error(sAXParseException);
        }
        this.eventcounter = 0;
        this.co_yield(false);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (null != this.clientErrorHandler) {
            this.clientErrorHandler.error(sAXParseException);
        }
    }

    public int getSourceCoroutineID() {
        return this.fSourceCoroutineID;
    }

    public int getControllerCoroutineID() {
        return this.fControllerCoroutineID;
    }

    public CoroutineManager getCoroutineManager() {
        return this.fCoroutineManager;
    }

    protected void count_and_yield(boolean bl) throws SAXException {
        if (!bl) {
            this.eventcounter = 0;
        }
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
    }

    private void co_entry_pause() throws SAXException {
        if (this.fCoroutineManager == null) {
            this.init(null, -1, -1);
        }
        try {
            Object object = this.fCoroutineManager.co_entry_pause(this.fSourceCoroutineID);
            if (object == Boolean.FALSE) {
                this.co_yield(false);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (this.DEBUG) {
                noSuchMethodException.printStackTrace();
            }
            throw new SAXException(noSuchMethodException);
        }
    }

    private void co_yield(boolean bl) throws SAXException {
        if (this.fNoMoreEvents) {
            return;
        }
        try {
            Object object = Boolean.FALSE;
            if (bl) {
                object = this.fCoroutineManager.co_resume(Boolean.TRUE, this.fSourceCoroutineID, this.fControllerCoroutineID);
            }
            if (object == Boolean.FALSE) {
                this.fNoMoreEvents = true;
                if (this.fXMLReader != null) {
                    throw new StopException();
                }
                this.fCoroutineManager.co_exit_to(Boolean.FALSE, this.fSourceCoroutineID, this.fControllerCoroutineID);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.fNoMoreEvents = true;
            this.fCoroutineManager.co_exit(this.fSourceCoroutineID);
            throw new SAXException(noSuchMethodException);
        }
    }

    @Override
    public void startParse(InputSource inputSource) throws SAXException {
        if (this.fNoMoreEvents) {
            throw new SAXException(XMLMessages.createXMLMessage("ERR_SYSTEM", "IncrementalSAXSource_Filter not currently restartable"));
        }
        if (this.fXMLReader == null) {
            throw new SAXException(XMLMessages.createXMLMessage("ERR_SYSTEM", "XMLReader not before startParse request"));
        }
        this.fXMLReaderInputSource = inputSource;
        ThreadControllerWrapper.runThread(this, -1);
    }

    @Override
    public void run() {
        if (this.fXMLReader == null) {
            return;
        }
        if (this.DEBUG) {
            System.out.println("IncrementalSAXSource_Filter parse thread launched");
        }
        Serializable serializable = Boolean.FALSE;
        try {
            this.fXMLReader.parse(this.fXMLReaderInputSource);
        }
        catch (IOException iOException) {
            serializable = iOException;
        }
        catch (StopException stopException) {
            if (this.DEBUG) {
                System.out.println("Active IncrementalSAXSource_Filter normal stop exception");
            }
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof StopException) {
                if (this.DEBUG) {
                    System.out.println("Active IncrementalSAXSource_Filter normal stop exception");
                }
            }
            if (this.DEBUG) {
                System.out.println("Active IncrementalSAXSource_Filter UNEXPECTED SAX exception: " + exception);
                exception.printStackTrace();
            }
            serializable = sAXException;
        }
        this.fXMLReader = null;
        try {
            this.fNoMoreEvents = true;
            this.fCoroutineManager.co_exit_to(serializable, this.fSourceCoroutineID, this.fControllerCoroutineID);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace(System.err);
            this.fCoroutineManager.co_exit(this.fSourceCoroutineID);
        }
    }

    @Override
    public Object deliverMoreNodes(boolean bl) {
        if (this.fNoMoreEvents) {
            return Boolean.FALSE;
        }
        try {
            Object object = this.fCoroutineManager.co_resume(bl ? Boolean.TRUE : Boolean.FALSE, this.fControllerCoroutineID, this.fSourceCoroutineID);
            if (object == Boolean.FALSE) {
                this.fCoroutineManager.co_exit(this.fControllerCoroutineID);
            }
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return noSuchMethodException;
        }
    }

    class StopException
    extends RuntimeException {
        private static final long serialVersionUID = 2263978686197558602L;

        StopException() {
        }
    }
}

