/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.annot;

import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleLinker;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.PolymorphicADTDesugarer;
import com.ibm.xylem.Program;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.annot.AnnotationEnvironment;
import com.ibm.xylem.annot.AnnotationTable;
import com.ibm.xylem.annot.FunctionAnnotationInfo;
import com.ibm.xylem.annot.FunctionCallSpec;
import com.ibm.xylem.annot.IAnnotation;
import com.ibm.xylem.annot.IAnnotator;
import com.ibm.xylem.annot.ICallSpec;
import com.ibm.xylem.annot.IConverter;
import com.ibm.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xylem.annot.LambdaAnnotationInfo;
import com.ibm.xylem.annot.LambdaApplySpec;
import com.ibm.xylem.annot.NullAnnotation;
import com.ibm.xylem.annot.PedanticAnormalForm;
import com.ibm.xylem.annot.RecursiveADTStreamAppendInstruction;
import com.ibm.xylem.annot.meta.EmptyStreamMetaAnnotation;
import com.ibm.xylem.annot.meta.LambdaMetaAnnotation;
import com.ibm.xylem.annot.meta.MetaAnnotation;
import com.ibm.xylem.annot.meta.TupleMetaAnnotation;
import com.ibm.xylem.builders.LetChainBuilder;
import com.ibm.xylem.instructions.ApplyInstruction;
import com.ibm.xylem.instructions.AssertTypeInstruction;
import com.ibm.xylem.instructions.AutomatonInstruction;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.ForEachInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xylem.instructions.ProcessStreamInstruction;
import com.ibm.xylem.instructions.StreamElementInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.TestStreamInstruction;
import com.ibm.xylem.instructions.TupleInstruction;
import com.ibm.xylem.instructions.TupleMatchInstruction;
import com.ibm.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xylem.optimizers.FindFreeVariables;
import com.ibm.xylem.optimizers.ReducedForm;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.ICollectionType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.LambdaType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.utils.XylemError;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConversionEngine {
    private static final boolean DENNIS_PARALLEL = false;
    static final Logger s_logger = Logger.getInstance(ConversionEngine.class);
    public static final boolean DEBUG_TYPE_CHECK = false;
    public static final String ITEM_SUFFIX = "$item";
    public static final String ITEM_INDEX_SUFFIX = "$index";
    private LetChainBuilder m_lcb = new LetChainBuilder();
    private Map m_convertedLambdas;
    private AnnotationEnvironment m_environment;
    private IConverter m_converter;
    private Module m_module;
    private ArrayList m_functionsToTypeCheck = new ArrayList();
    private ArrayList m_functionsToConvert = new ArrayList();

    public static Function analyzeAndConvert(String string, Program program, Function function, IAnnotator iAnnotator, boolean bl) {
        try {
            try {
                if (bl) {
                    Program.dumpXylemFile(program, null, string + ".original");
                }
            }
            catch (Exception exception) {
                s_logger.error("could not dump program", exception);
            }
            s_logger.info("converting to pedantic anormal");
            program.optimize(new PedanticAnormalForm());
            program.typeCheckReduced();
            try {
                if (bl) {
                    Program.dumpXylemFile(program, null, string + ".pedantic");
                }
            }
            catch (Exception exception) {
                s_logger.error("could not dump program", exception);
            }
            s_logger.info("applying pre-analysis methods");
            iAnnotator.preAnalysis(program);
            try {
                if (bl) {
                    Program.dumpXylemFile(program, null, string + ".pre_analysis");
                }
            }
            catch (Exception exception) {
                s_logger.error("could not dump program", exception);
                exception.printStackTrace();
            }
            s_logger.info("clearing type info");
            program.clearTypeInformation(true);
            s_logger.info("type checking");
            program.typeCheckReduced();
            s_logger.info("instantiating reduced");
            program.instantiateReducedPolymorphicFunctions();
        }
        catch (TypeCheckException typeCheckException) {
            s_logger.error("error type-checking pre-conversion form", typeCheckException);
            throw new RuntimeException();
        }
        s_logger.info("analyzing code with " + iAnnotator);
        AnnotationTable annotationTable = AnnotationTable.analyzeProgram(program, function, iAnnotator);
        IConverter iConverter = iAnnotator.getConverter();
        s_logger.info("converting code with " + iConverter);
        iConverter.preConversion(program);
        ConversionEngine.convertEntryPoints(program, annotationTable, iConverter);
        try {
            if (bl) {
                Program.dumpXylemFile(program, null, string + ".converted");
            }
        }
        catch (Exception exception) {
            s_logger.error("could not dump program", exception);
        }
        try {
            s_logger.info("type checking converted code");
            function.typeCheckReduced(program, new LinkedList());
            ModuleLinker.reflattenModules(program);
            program.typeCheckReduced();
            program.instantiateReducedPolymorphicFunctions();
            program.typeCheckReduced();
            function.typeCheckReduced(program, new LinkedList());
            int n = 0;
            s_logger.info("optimizing converted code:" + n);
            if (bl) {
                Program.dumpXylemFile(program, null, string + ".optimized." + n++);
            }
            s_logger.info("optimizing converted code:" + n);
            if (bl) {
                Program.dumpXylemFile(program, null, string + ".optimized." + n++);
            }
            s_logger.info("optimizing converted code:" + n);
            DeadLetEliminatorOptimizer.eliminateDeadLets(program);
            if (bl) {
                Program.dumpXylemFile(program, null, string + ".optimized." + n++);
            }
            s_logger.info("optimizing converted code:" + n);
            program.removeDeadFunctions();
            program.typeCheckReduced();
            s_logger.info("optimizing converted code:" + n);
            if (bl) {
                Program.dumpXylemFile(program, null, string + ".optimized." + n++);
            }
            s_logger.info("optimizing converted code:" + n);
            program.removeDeadFunctions();
            if (bl) {
                Program.dumpXylemFile(program, null, string + ".optimized." + n++);
            }
            s_logger.info("optimizing converted code:" + n);
            new PolymorphicADTDesugarer(program).desugar();
            if (bl) {
                Program.dumpXylemFile(program, null, string + ".optimized." + n++);
            }
        }
        catch (Throwable throwable) {
            s_logger.error("error optimizing converted code (dumping program to " + string + ".exception.xylem)", throwable);
            Program.dumpXylemFile(program, null, string + ".exception");
            throw new XylemError("ERR_SYSTEM", "error optimizing converted code");
        }
        return null;
    }

    private static void convertEntryPoints(Module module, AnnotationTable annotationTable, IConverter iConverter) {
        ConversionEngine conversionEngine = new ConversionEngine(iConverter, module);
        FunctionAnnotationInfo[] functionAnnotationInfoArray = annotationTable.getEntryPoints();
        s_logger.info("converting " + functionAnnotationInfoArray.length + " entry points");
        conversionEngine.m_functionsToConvert.addAll(Arrays.asList(functionAnnotationInfoArray));
        while (!conversionEngine.m_functionsToConvert.isEmpty()) {
            FunctionAnnotationInfo functionAnnotationInfo = (FunctionAnnotationInfo)conversionEngine.m_functionsToConvert.remove(conversionEngine.m_functionsToConvert.size() - 1);
            conversionEngine.convertFunctionBody(functionAnnotationInfo);
        }
    }

    private void reduceFunction(Function function) {
        Instruction instruction;
        Instruction instruction2 = instruction = function.getBody();
        function.setBody(instruction);
        try {
            ReducedForm.reduceFunction(function);
        }
        catch (Exception exception) {
            function.setComment(function.getComment() + "\n" + exception);
            s_logger.error("converted code did not reduce. See output in function.xylem", exception);
            function.setBody(instruction2);
            Program.dumpXylemFunctions(new Function[]{function}, new File("."), "function");
            Program.dumpXylemFile(this.m_module, new File("."), "program");
            throw new Error("died");
        }
    }

    private void convertEntryPoint(FunctionAnnotationInfo functionAnnotationInfo) {
        Function function = functionAnnotationInfo.getFunction();
        Map map = this.m_convertedLambdas;
        this.m_environment = functionAnnotationInfo.getEnvironment();
        this.m_convertedLambdas = new HashMap();
        function.setBody(this.convertInstruction(function.getBody()));
        this.reduceFunction(function);
        try {
            function.clearTypeInformation(true);
            function.typeCheckReduced(this.m_module, new LinkedList());
        }
        catch (Exception exception) {
            s_logger.error("function " + function.getName() + " did not typeCheck", exception);
            throw new RuntimeException();
        }
        this.m_convertedLambdas = map;
        this.m_environment = null;
    }

    private ConversionEngine(IConverter iConverter, Module module) {
        this.m_converter = iConverter;
        this.m_module = module;
    }

    public static Object generateIdentifier(Object object, Object object2) {
        return object.toString() + "_" + object2.toString();
    }

    public void insertBinding(Object object, Instruction instruction) {
        while (instruction instanceof LetInstruction) {
            LetInstruction letInstruction = (LetInstruction)instruction;
            this.m_lcb.bind(letInstruction.getVariable(), letInstruction.getValue(), true);
            instruction = letInstruction.getBody();
        }
        this.m_lcb.bind(object, instruction, true);
    }

    public LetChainBuilder getLetChainBuilder() {
        return this.m_lcb;
    }

    private Function convert(FunctionAnnotationInfo functionAnnotationInfo) {
        Object object;
        Function function = functionAnnotationInfo.getFunction();
        if (!functionAnnotationInfo.isCallAnnotated()) {
            return function;
        }
        Function function2 = function.lookupDerivative(functionAnnotationInfo.getSpec());
        if (function2 != null) {
            return function2;
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("converting " + functionAnnotationInfo);
            try {
                object = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)object);
                new Error().printStackTrace(printStream);
                StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(((ByteArrayOutputStream)object).toString()));
                while (streamTokenizer.nextToken() != -1) {
                }
                s_logger.debug("stack-depth=" + streamTokenizer.lineno());
            }
            catch (Exception exception) {
                s_logger.error(exception);
            }
        }
        object = function.cloneFunctionForFixup(functionAnnotationInfo.getSpec(), false, false, true);
        ((Function)object).setReturnType(this.convertReturnType(functionAnnotationInfo));
        int n = function.m_parameters.length;
        ((Function)object).m_parameters = this.convertParamBindings(functionAnnotationInfo);
        this.m_module.addFunction((Function)object);
        this.m_functionsToConvert.add(functionAnnotationInfo);
        s_logger.debug("created fixup '" + ((Function)object).getName() + "' for " + functionAnnotationInfo);
        return object;
    }

    private void convertFunctionBody(FunctionAnnotationInfo functionAnnotationInfo) {
        Function function = functionAnnotationInfo.getFunction();
        final Function function2 = functionAnnotationInfo.isCallAnnotated() ? function.lookupDerivative(functionAnnotationInfo.getSpec()) : function;
        s_logger.debug("converting body of '" + function2.getName() + "' for " + functionAnnotationInfo);
        this.m_environment = functionAnnotationInfo.getEnvironment();
        this.m_environment.debug();
        this.m_convertedLambdas = new HashMap();
        Instruction instruction = this.convertInstruction(function.getBody());
        if (function.getMemoizeResult()) {
            instruction = new Optimizer(){

                @Override
                protected Instruction optimizeStep(Instruction instruction) {
                    if (instruction instanceof MatchInstruction || instruction instanceof ForEachInstruction || instruction instanceof ParallelForEachInstruction) {
                        function2.setMemoizeResult(true);
                    }
                    return instruction;
                }
            }.optimize(instruction);
        }
        function2.setBody(instruction);
        this.reduceFunction(function2);
        s_logger.debug("finished converting body of '" + function2.getName() + "' for " + functionAnnotationInfo);
    }

    public Instruction convertInstruction(Instruction instruction) {
        LetChainBuilder letChainBuilder = this.m_lcb;
        this.m_lcb = new LetChainBuilder();
        instruction = (instruction = this.convertNonLet(this.convertLets(instruction), this.m_converter)) != null ? this.m_lcb.packageUp(instruction) : this.m_lcb.packageUp(StreamInstruction.charStreamLiteral("dead-code"));
        this.m_lcb = letChainBuilder;
        return instruction;
    }

    private Instruction convertNonLet(Instruction instruction, IConverter iConverter) {
        IAnnotation iAnnotation;
        if (instruction instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
            FunctionCallSpec functionCallSpec = new FunctionCallSpec(functionCallInstruction, this.m_environment);
            Object[] objectArray = new Object[functionCallInstruction.m_parameters.length];
            for (int i = 0; i < objectArray.length; ++i) {
                Instruction instruction2 = functionCallInstruction.m_parameters[i];
                if (!(instruction2 instanceof IdentifierInstruction)) continue;
                objectArray[i] = ((IdentifierInstruction)instruction2).getVariable();
            }
            return this.convertFunctionCall(functionCallSpec, objectArray, functionCallInstruction.m_parameters);
        }
        if (instruction instanceof AutomatonInstruction) {
            return this.convertAutomaton((AutomatonInstruction)instruction);
        }
        if (instruction instanceof ForEachInstruction) {
            return this.convertForEach((ForEachInstruction)instruction);
        }
        if (instruction instanceof TestStreamInstruction) {
            return this.convertTestStream((TestStreamInstruction)instruction);
        }
        if (instruction instanceof MatchInstruction) {
            return this.convertMatch((MatchInstruction)instruction);
        }
        instruction = instruction instanceof ApplyInstruction ? this.convertLambdaApplication((ApplyInstruction)instruction) : (instruction instanceof IdentifierInstruction ? ((iAnnotation = this.m_environment.get(instruction)) instanceof MetaAnnotation ? ((MetaAnnotation)iAnnotation).convert(instruction, this.m_environment, this) : iConverter.convert(instruction, this.m_environment, this)) : iConverter.convert(instruction, this.m_environment, this));
        return instruction;
    }

    public Instruction convertInstructionAsCopy(Instruction instruction) {
        Instruction instruction2 = instruction.cloneShallow();
        int n = instruction.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            Instruction instruction3 = instruction.getChildInstruction(i);
            instruction3 = instruction3 instanceof LetInstruction ? this.convertInstruction(instruction3) : this.convertNonLet(instruction3, this.m_converter);
            instruction2.setChildInstruction(i, instruction3);
        }
        return instruction2;
    }

    private Instruction convertMatch(MatchInstruction matchInstruction) {
        Instruction instruction = matchInstruction.getToMatch();
        IAnnotation iAnnotation = this.m_environment.get(instruction);
        if (iAnnotation instanceof TupleMetaAnnotation) {
            MatchInstruction.DeconstructionMatch deconstructionMatch = (MatchInstruction.DeconstructionMatch)matchInstruction.getMatches()[0];
            for (int i = 0; i < deconstructionMatch.getBindings().length; ++i) {
                ((TupleMetaAnnotation)iAnnotation).insertMatchOperation(i, deconstructionMatch.getBindings()[i], this.m_environment, this);
            }
            return this.convertLets(deconstructionMatch.getHandler());
        }
        if (matchInstruction.getMatches()[0] instanceof MatchInstruction.LiteralMatch && iAnnotation == null) {
            Set set = this.m_environment.getComputedLiteral(instruction);
            ArrayList<MatchInstruction.LiteralMatch> arrayList = new ArrayList<MatchInstruction.LiteralMatch>();
            if (set != null) {
                Object object;
                Iterator iterator = set.iterator();
                Instruction instruction2 = null;
                s_logger.debug("proactively optimizing match on " + instruction);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    object = matchInstruction.getMatches();
                    int n = 0;
                    for (n = 0; n < ((MatchInstruction.Match[])object).length; ++n) {
                        LiteralInstruction literalInstruction = ((MatchInstruction.LiteralMatch)object[n]).getLiteral();
                        if (!literalInstruction.getValue().equals(e)) continue;
                        Instruction instruction3 = object[n].getHandler();
                        s_logger.debug("proactively optimizing match on " + instruction + " for literal " + e);
                        instruction3 = this.convertInstruction(instruction3);
                        arrayList.add(new MatchInstruction.LiteralMatch(literalInstruction, instruction3));
                        break;
                    }
                    if (n != ((MatchInstruction.Match[])object).length || instruction2 != null) continue;
                    s_logger.debug("proactively optimizing match on " + instruction + " for default");
                    instruction2 = this.convertInstruction(matchInstruction.getDefault());
                }
                int n = arrayList.size();
                if (instruction2 != null) {
                    ++n;
                }
                if (n == 0) {
                    s_logger.debug("proactively optimizing match on " + instruction + " : no case matches replacing with HCFI.");
                    return Instruction.shouldNeverReach(matchInstruction.getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment()));
                }
                if (n == 1 && instruction2 == null) {
                    s_logger.debug("proactively optimizing match on " + instruction + " : one case matches.");
                    return ((MatchInstruction.Match)arrayList.get(0)).getHandler();
                }
                if (n == 1 && instruction2 != null) {
                    s_logger.debug("proactively optimizing match on " + instruction + " : default case matches.");
                    return instruction2;
                }
                s_logger.debug("proactively optimizing match on " + instruction + " : " + n + " cases match.");
                object = this.convertNonLet(instruction, this.m_converter);
                object = new MatchInstruction(instruction, arrayList.toArray(new MatchInstruction.Match[0]), instruction2);
                return object;
            }
        }
        return this.convertInstructionAsCopy(matchInstruction);
    }

    private Instruction convertForEach(ForEachInstruction forEachInstruction) {
        Type type;
        IAnnotation iAnnotation = this.m_environment.get(forEachInstruction.getSource());
        Object object = forEachInstruction.getVarName();
        IAnnotation iAnnotation2 = this.m_environment.get(object);
        if (iAnnotation == null || iAnnotation2 == null) {
            return this.convertInstructionAsCopy(forEachInstruction);
        }
        Instruction instruction = NavigationUtilities.skipLets(forEachInstruction.getBody());
        IAnnotation iAnnotation3 = this.m_environment.get(instruction);
        Instruction instruction2 = this.convertInstruction(forEachInstruction.getBody());
        instruction2 = this.insertLoopBindingAnnotationOperation(instruction2, iAnnotation, iAnnotation2);
        List list = iAnnotation instanceof MetaAnnotation ? ((MetaAnnotation)iAnnotation).getBindingList(iAnnotation.getVariable(), iAnnotation, this) : this.m_converter.getBindingList(iAnnotation.getVariable(), iAnnotation, this);
        if (list == null) {
            throw new XylemError("ERR_SYSTEM", " illegal null bindings in " + iAnnotation);
        }
        List list2 = null;
        if (iAnnotation3 instanceof MetaAnnotation) {
            list2 = ((MetaAnnotation)iAnnotation3).getBindingList(iAnnotation3.getVariable(), iAnnotation3, this);
        } else if (iAnnotation3 != null) {
            list2 = this.m_converter.getBindingList(iAnnotation3.getVariable(), iAnnotation3, this);
        }
        if (list.size() == 0) {
            s_logger.debug("for-each on " + forEachInstruction.getSource() + " converts to empty");
            Type type2 = forEachInstruction.getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment());
            if (type2 == null) {
                throw new XylemError("ERR_SYSTEM", "type null for " + forEachInstruction);
            }
            return new StreamInstruction(((StreamType)type2).getElementType());
        }
        String string = iAnnotation.getVariable() + ITEM_INDEX_SUFFIX;
        if (forEachInstruction.getIndexVar() != null) {
            instruction2 = new LetInstruction(forEachInstruction.getIndexVar(), new IdentifierInstruction(string), instruction2);
        }
        if ((type = ((Binding)list.get(0)).getBindingType()) instanceof ICollectionType) {
            s_logger.debug("for-each on " + forEachInstruction.getSource() + " converts to streams");
            instruction2 = this.convertForeachOnStreams(iAnnotation.getVariable(), list, instruction2, list2);
        } else if (this.isLambdaIterator(list)) {
            s_logger.debug("for-each on " + forEachInstruction.getSource() + " converts to lambda-iterator");
            Type type3 = this.convertType(iAnnotation3, forEachInstruction.getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment()));
            instruction2 = this.convertForeachOnLambdaIterator(type3, iAnnotation.getVariable(), list, instruction2, list2);
        } else {
            s_logger.debug("for-each on " + forEachInstruction.getSource() + " converts to atomic");
            this.insertBinding(string, LiteralInstruction.integerLiteral(0));
            instruction2 = this.convertLoopAtomics(list, instruction2);
        }
        return instruction2;
    }

    private Instruction convertLoopAtomics(List list, Instruction instruction) {
        for (IBinding iBinding : list) {
            instruction = new LetInstruction(iBinding.getName() + ITEM_SUFFIX, new IdentifierInstruction(iBinding.getName()), instruction);
        }
        return instruction;
    }

    private Instruction convertForeachOnStreams(Object object, List list, Instruction instruction, List list2) {
        IBinding iBinding = (IBinding)list.get(0);
        IdentifierInstruction identifierInstruction = new IdentifierInstruction(iBinding.getName());
        String string = iBinding.getName() + ITEM_SUFFIX;
        String string2 = object + ITEM_INDEX_SUFFIX;
        if (list2 != null && list2.size() > 1) {
            instruction = this.convertLoopBodyOnStreams(string2, Collections.EMPTY_LIST, instruction);
            Binding[] bindingArray = list.toArray(new Binding[0]);
            Object[] objectArray = new Object[bindingArray.length];
            Instruction[] instructionArray = new Instruction[bindingArray.length];
            for (int i = 0; i < bindingArray.length; ++i) {
                instructionArray[i] = new IdentifierInstruction(bindingArray[i].getName());
                objectArray[i] = bindingArray[i].getName() + ITEM_SUFFIX;
            }
            ParallelForEachInstruction parallelForEachInstruction = new ParallelForEachInstruction(instructionArray, objectArray, instruction);
            parallelForEachInstruction.setIndexVar(string2);
            return parallelForEachInstruction;
        }
        instruction = this.convertLoopBodyOnStreams(string2, list.subList(1, list.size()), instruction);
        return new ForEachInstruction((Instruction)identifierInstruction, (Object)string, string2, instruction);
    }

    private void convertAutomatonOtherwiseOnStreams(AutomatonInstruction automatonInstruction, Object object, List list, Instruction instruction) {
        IBinding iBinding = (IBinding)list.get(0);
        IdentifierInstruction identifierInstruction = new IdentifierInstruction(iBinding.getName());
        String string = iBinding.getName() + ITEM_SUFFIX;
        String string2 = object + ITEM_INDEX_SUFFIX;
        instruction = this.convertLoopBodyOnStreams(string2, list.subList(1, list.size()), instruction);
        automatonInstruction.setSource(identifierInstruction);
        automatonInstruction.setDefaultHandler(instruction);
        automatonInstruction.getDefaultElementBinding().setName(string);
        if (automatonInstruction.getLoopIndexBinding() != null) {
            automatonInstruction.getLoopIndexBinding().setName(string2);
        } else {
            automatonInstruction.setLoopIndexVar(string2);
        }
    }

    private Instruction convertLoopBodyOnStreams(Object object, List list, Instruction instruction) {
        Object object22;
        LinkedList<IdentifierInstruction> linkedList = new LinkedList<IdentifierInstruction>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        LinkedList<IBinding> linkedList3 = new LinkedList<IBinding>();
        for (Object object22 : list) {
            if (object22.getBindingType() instanceof ICollectionType) {
                linkedList.add(new IdentifierInstruction(object22.getName()));
                linkedList2.add(object22.getName() + ITEM_SUFFIX);
                continue;
            }
            linkedList3.add((IBinding)object22);
        }
        instruction = this.convertLoopAtomics(linkedList3, instruction);
        Iterator iterator = linkedList.iterator();
        object22 = linkedList2.iterator();
        while (iterator.hasNext()) {
            Object e = object22.next();
            Instruction instruction2 = (Instruction)iterator.next();
            instruction = new LetInstruction(e, new StreamElementInstruction(instruction2, new IdentifierInstruction(object)), instruction);
        }
        return instruction;
    }

    private boolean isLambdaIterator(List list) {
        if (list.size() < 3) {
            s_logger.debug("  isLambda: <3 bindings.");
            return false;
        }
        Type type = ((IBinding)list.get(2)).getBindingType();
        IBinding iBinding = (IBinding)list.get(0);
        if (!(iBinding.getBindingType() instanceof LambdaType)) {
            s_logger.debug("  isLambda: " + iBinding + " != lambda.");
            return false;
        }
        LambdaType lambdaType = (LambdaType)iBinding.getBindingType();
        if (lambdaType.getElementTypes().length != 1 || !lambdaType.getReturnType().equals(BooleanType.s_booleanType) || !type.equals(lambdaType.getElementTypes()[0])) {
            s_logger.debug("  isLambda: " + lambdaType + " != (-> (state) boolean).");
            return false;
        }
        IBinding iBinding2 = (IBinding)list.get(1);
        if (!(iBinding2.getBindingType() instanceof LambdaType)) {
            s_logger.debug("  isLambda: " + iBinding + " != lambda.");
            return false;
        }
        LambdaType lambdaType2 = (LambdaType)iBinding2.getBindingType();
        if (lambdaType2.getElementTypes().length != 1 || !lambdaType2.getReturnType().equals(type) || !type.equals(lambdaType2.getElementTypes()[0])) {
            s_logger.debug("  isLambda: " + lambdaType2 + " != (-> (state) state).");
            return false;
        }
        return true;
    }

    private Instruction convertForeachOnLambdaIterator(Type type, Object object, List list, Instruction instruction, List list2) {
        Object object2;
        int n;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        List list3 = list.subList(3, list.size());
        instruction = this.convertLoopAtomics(list3, instruction);
        Type type2 = ((IBinding)list.get(2)).getBindingType();
        IBinding iBinding = (IBinding)list.get(0);
        IBinding iBinding2 = (IBinding)list.get(1);
        IBinding iBinding3 = (IBinding)list.get(2);
        String string = "$next";
        String string2 = iBinding3.getName() + ITEM_SUFFIX;
        String string3 = string2 + string;
        String string4 = object + ITEM_INDEX_SUFFIX;
        String string5 = string4 + string;
        Set set = FindFreeVariables.findFreeVariables(instruction);
        boolean bl = set.remove(string4);
        set.remove(string2);
        set.remove(iBinding.getName());
        set.remove(iBinding2.getName());
        ArrayList<IBinding> arrayList = new ArrayList<IBinding>(set.size() + 4);
        ArrayList<IdentifierInstruction> arrayList2 = new ArrayList<IdentifierInstruction>(set.size() + 4);
        arrayList.add(new Binding((Object)string2, type2));
        arrayList2.add(new IdentifierInstruction(string3));
        arrayList.add(iBinding);
        arrayList2.add(new IdentifierInstruction(iBinding.getName()));
        arrayList.add(iBinding2);
        arrayList2.add(new IdentifierInstruction(iBinding2.getName()));
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (list2 != null && list2.size() > 1) {
            stringArray = new String[list2.size()];
            stringArray2 = new String[list2.size()];
            Iterator iterator = list2.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                object6 = (Binding)iterator.next();
                stringArray[n2] = "head" + n2;
                stringArray2[n2] = stringArray[n2] + string;
                object5 = ((Binding)object6).getBindingType() instanceof StreamType ? ((Binding)object6).getBindingType() : ((Binding)object6).getBindingType().getStreamType();
                arrayList.add(new Binding((Object)stringArray[n2], (Type)object5));
                arrayList2.add(new IdentifierInstruction(stringArray2[n2]));
                ++n2;
            }
        }
        if (bl) {
            arrayList.add(new Binding((Object)string4, IntType.s_intType));
            arrayList2.add(new IdentifierInstruction(string5));
        }
        for (Object e : set) {
            object6 = new Binding(e);
            arrayList.add((IBinding)object6);
            arrayList2.add(new IdentifierInstruction(e));
        }
        String string6 = "foreachFunction$" + object + "$" + ReductionHelper.generateIntermediateIdentifier2();
        object6 = object + "$body";
        object5 = object + "$isEmpty";
        Instruction instruction2 = new FunctionCallInstruction(string6, arrayList2);
        if (list2 == null || list2.size() <= 1) {
            instruction2 = new StreamInstruction(((ICollectionType)((Object)type)).getElementType(), new Instruction[]{new IdentifierInstruction(object6), instruction2});
        } else {
            object4 = new Object[list2.size()];
            object3 = list2.iterator();
            n = 0;
            while (object3.hasNext()) {
                object2 = (Binding)object3.next();
                object4[n] = "body" + n;
                Type type3 = ((Binding)object2).getBindingType();
                if (type3 instanceof StreamType) {
                    type3 = ((StreamType)type3).getElementType();
                }
                instruction2 = new LetInstruction(stringArray2[n], new StreamInstruction(type3, new Instruction[]{new IdentifierInstruction(stringArray[n]), new IdentifierInstruction(object4[n])}), instruction2);
                ++n;
            }
            instruction2 = new TupleMatchInstruction((Instruction)new IdentifierInstruction((String)object6 + "$2"), (Object[])object4, instruction2);
        }
        if (list2 != null && list2.size() > 1) {
            instruction2 = new LetInstruction((String)object6 + "$2", new AssertTypeInstruction(new IdentifierInstruction(object6), type), instruction2);
        }
        instruction2 = new LetInstruction(object6, instruction, instruction2);
        if (bl) {
            instruction2 = new LetInstruction(string5, new PrimitiveArithmeticInstruction(new IdentifierInstruction(string4), LiteralInstruction.integerLiteral(1), 0), instruction2);
        }
        object4 = new ApplyInstruction((Instruction)new IdentifierInstruction(iBinding2.getName()), new Instruction[]{new IdentifierInstruction(string2)}, true);
        instruction2 = new LetInstruction(string3, (Instruction)object4, instruction2);
        if (list2 == null || list2.size() <= 1) {
            instruction2 = new ChooseInstruction(new IdentifierInstruction(object5), (Instruction)new StreamInstruction(((ICollectionType)((Object)type)).getElementType()), instruction2);
        } else {
            object3 = new Instruction[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                object3[n] = new IdentifierInstruction(stringArray[n]);
            }
            instruction2 = new ChooseInstruction(new IdentifierInstruction(object5), (Instruction)new TupleInstruction((Instruction[])object3), instruction2);
        }
        object3 = new ApplyInstruction((Instruction)new IdentifierInstruction(iBinding.getName()), new Instruction[]{new IdentifierInstruction(string2)}, true);
        instruction2 = new LetInstruction(object5, (Instruction)object3, instruction2);
        Function function = new Function(string6, arrayList.toArray(new Binding[0]), instruction2);
        this.m_module.addFunction(function);
        function.setReturnType(type);
        this.reduceFunction(function);
        this.insertBinding(string3, new IdentifierInstruction(iBinding3.getName()));
        if (list2 != null && list2.size() > 1) {
            object2 = list2.iterator();
            int n3 = 0;
            while (object2.hasNext()) {
                Binding binding = (Binding)object2.next();
                Type type4 = binding.getBindingType();
                if (binding.getBindingType() instanceof StreamType) {
                    type4 = ((StreamType)type4).getElementType();
                }
                this.insertBinding(stringArray2[n3++], new StreamInstruction(type4));
            }
        }
        if (bl) {
            this.insertBinding(string5, LiteralInstruction.integerLiteral(0));
        }
        return new FunctionCallInstruction(string6, arrayList2);
    }

    private Instruction convertAutomatonOnLambdaIterator(AutomatonInstruction automatonInstruction, Object object, List list, Instruction instruction) {
        Object object2;
        Instruction instruction22;
        Instruction instruction3 = automatonInstruction.getInitialState();
        Object object3 = automatonInstruction.getDefaultStateBinding().getName();
        AbstractDataType.Constructor constructor = automatonInstruction.getStateComboConstructor(this.m_environment.getTypeEnvironment());
        List list2 = list.subList(3, list.size());
        instruction = this.convertLoopAtomics(list2, instruction);
        Type type = automatonInstruction.getResultElementType(this.m_environment.getTypeEnvironment());
        Type type2 = ((IBinding)list.get(2)).getBindingType();
        IBinding iBinding = (IBinding)list.get(0);
        IBinding iBinding2 = (IBinding)list.get(1);
        IBinding iBinding3 = (IBinding)list.get(2);
        String string = iBinding3.getName() + ITEM_SUFFIX;
        String string2 = object + ITEM_INDEX_SUFFIX;
        String string3 = "$next";
        String string4 = string + string3;
        String string5 = string2 + string3;
        String string6 = object3 + string3;
        String string7 = "automatonFunction" + object + "$" + ReductionHelper.generateIntermediateIdentifier2();
        String string8 = object + "$bodyCombo";
        String string9 = object + "$bodyValue";
        String string10 = object + "$isEmpty";
        Set set = FindFreeVariables.findFreeVariables(instruction);
        boolean bl = set.remove(string2);
        set.remove(string);
        set.remove(iBinding.getName());
        set.remove(iBinding2.getName());
        set.remove(object3);
        ArrayList<IBinding> arrayList = new ArrayList<IBinding>(set.size() + 4);
        ArrayList<IdentifierInstruction> arrayList2 = new ArrayList<IdentifierInstruction>(set.size() + 4);
        arrayList.add(new Binding((Object)string, type2));
        arrayList2.add(new IdentifierInstruction(string4));
        arrayList.add(iBinding);
        arrayList2.add(new IdentifierInstruction(iBinding.getName()));
        arrayList.add(iBinding2);
        arrayList2.add(new IdentifierInstruction(iBinding2.getName()));
        arrayList.add(new Binding(object3, IntType.s_intType));
        arrayList2.add(new IdentifierInstruction(string6));
        if (bl) {
            arrayList.add(new Binding((Object)string2, IntType.s_intType));
            arrayList2.add(new IdentifierInstruction(string5));
        }
        for (Instruction instruction22 : set) {
            object2 = new Binding(instruction22);
            arrayList.add((IBinding)object2);
            arrayList2.add(new IdentifierInstruction(instruction22));
        }
        instruction22 = null;
        instruction22 = automatonInstruction.getWrapResult() ? new RecursiveADTStreamAppendInstruction(new FunctionCallInstruction(string7, arrayList2), new IdentifierInstruction(string9 + "$2")) : new StreamInstruction(type, new Instruction[]{new IdentifierInstruction(string9 + "$2"), new FunctionCallInstruction(string7, arrayList2)});
        instruction22 = new LetInstruction(string9 + "$2", new AssertTypeInstruction(new IdentifierInstruction(string9), type.getStreamType()), instruction22);
        object2 = new ApplyInstruction((Instruction)new IdentifierInstruction(iBinding2.getName()), new Instruction[]{new IdentifierInstruction(string)}, true);
        instruction22 = new LetInstruction(string4, (Instruction)object2, instruction22);
        instruction22 = new LetInstruction(string9, new MatchInstruction((Instruction)new IdentifierInstruction(string8), constructor, 0), instruction22);
        instruction22 = new LetInstruction(string6, new MatchInstruction((Instruction)new IdentifierInstruction(string8), constructor, 1), instruction22);
        instruction22 = new LetInstruction(string8, new AssertTypeInstruction(new IdentifierInstruction(string8 + "$2"), automatonInstruction.getStateComboType()), instruction22);
        instruction22 = new LetInstruction(string8 + "$2", instruction, instruction22);
        if (bl) {
            instruction22 = new LetInstruction(string5, new PrimitiveArithmeticInstruction(new IdentifierInstruction(string2), LiteralInstruction.integerLiteral(1), 0), instruction22);
        }
        Integer n = ReductionHelper.generateIntermediateIdentifier2();
        Instruction instruction4 = new IdentifierInstruction(n);
        if (automatonInstruction.getWrapResult()) {
            instruction4 = new ConstructorInstantiationInstruction(constructor, new Instruction[]{instruction4, new IdentifierInstruction(object3)});
        }
        instruction22 = new ChooseInstruction(new IdentifierInstruction(string10), instruction4, instruction22);
        instruction22 = new LetInstruction(n, new StreamInstruction(type), instruction22);
        ApplyInstruction applyInstruction = new ApplyInstruction((Instruction)new IdentifierInstruction(iBinding.getName()), new Instruction[]{new IdentifierInstruction(string)}, true);
        instruction22 = new LetInstruction(string10, applyInstruction, instruction22);
        Function function = new Function(string7, arrayList.toArray(new Binding[0]), instruction22);
        if (automatonInstruction.getWrapResult()) {
            function.setReturnType(automatonInstruction.getStateComboType());
        } else {
            function.setReturnType(type.getStreamType());
        }
        this.m_module.addFunction(function);
        this.reduceFunction(function);
        this.insertBinding(string4, new IdentifierInstruction(iBinding3.getName()));
        this.insertBinding(string6, instruction3);
        if (bl) {
            this.insertBinding(string5, LiteralInstruction.integerLiteral(0));
        }
        return new FunctionCallInstruction(string7, arrayList2);
    }

    private Instruction convertAutomaton(AutomatonInstruction automatonInstruction) {
        IAnnotation iAnnotation = this.m_environment.get(automatonInstruction.getSource());
        if (iAnnotation == null || iAnnotation instanceof EmptyStreamMetaAnnotation && ((EmptyStreamMetaAnnotation)iAnnotation).getAtomicModel() == null) {
            s_logger.debug("not converting automaton on " + automatonInstruction.getSource());
            return this.convertInstructionAsCopy(automatonInstruction);
        }
        if (automatonInstruction.getDefaultHandler() == null || automatonInstruction.m_matches.length != 0) {
            throw new Error("not yet supported! " + automatonInstruction);
        }
        IAnnotation iAnnotation2 = this.m_environment.get(automatonInstruction.getDefaultElementBinding().getName());
        if (iAnnotation2 == null) {
            return this.convertInstructionAsCopy(automatonInstruction);
        }
        Instruction instruction = this.convertInstruction(automatonInstruction.getDefaultHandler());
        instruction = this.insertLoopBindingAnnotationOperation(instruction, iAnnotation, iAnnotation2);
        List list = iAnnotation instanceof MetaAnnotation ? ((MetaAnnotation)iAnnotation).getBindingList(iAnnotation.getVariable(), iAnnotation, this) : this.m_converter.getBindingList(iAnnotation.getVariable(), iAnnotation, this);
        AbstractDataType.Constructor constructor = automatonInstruction.getStateComboConstructor(this.m_environment.getTypeEnvironment());
        if (list.size() == 0) {
            s_logger.debug("automaton on " + automatonInstruction.getSource() + " converts to empty");
            TypeEnvironment typeEnvironment = this.m_environment.getTypeEnvironment();
            Type type = automatonInstruction.getResultElementType(typeEnvironment);
            if (type == null) {
                throw new XylemError("ERR_SYSTEM", "type null for " + automatonInstruction);
            }
            Integer n = ReductionHelper.generateIntermediateIdentifier2();
            this.insertBinding(n, new StreamInstruction(type));
            if (automatonInstruction.getWrapResult()) {
                Instruction instruction2 = automatonInstruction.getInitialState().cloneShallow();
                IdentifierInstruction identifierInstruction = new IdentifierInstruction(n);
                n = ReductionHelper.generateIntermediateIdentifier2();
                this.insertBinding(n, new ConstructorInstantiationInstruction(constructor, new Instruction[]{identifierInstruction, instruction2}));
            }
            return new IdentifierInstruction(n);
        }
        String string = iAnnotation.getVariable() + ITEM_INDEX_SUFFIX;
        if (automatonInstruction.getLoopIndexBinding() != null) {
            instruction = new LetInstruction(automatonInstruction.getLoopIndexBinding().getName(), new IdentifierInstruction(string), instruction);
        }
        AutomatonInstruction automatonInstruction2 = (AutomatonInstruction)automatonInstruction.cloneShallow();
        Type type = ((Binding)list.get(0)).getBindingType();
        if (type instanceof ICollectionType) {
            s_logger.debug("automaton otherwise " + automatonInstruction.getDefaultElementBinding().getName() + " converts to streams " + list.get(0));
            this.convertAutomatonOtherwiseOnStreams(automatonInstruction2, iAnnotation.getVariable(), list, instruction);
            instruction = automatonInstruction2;
        } else if (this.isLambdaIterator(list)) {
            s_logger.debug("automaton otherwise " + automatonInstruction.getDefaultElementBinding().getName() + " converts to lambda " + list.get(0));
            instruction = this.convertAutomatonOnLambdaIterator(automatonInstruction2, iAnnotation.getVariable(), list, instruction);
        } else {
            s_logger.debug("automaton on " + automatonInstruction.getSource() + " converts to atomic " + list.get(0));
            this.insertBinding(automatonInstruction.getDefaultStateBinding().getName(), automatonInstruction.getInitialState());
            s_logger.debug("automaton otherwise " + automatonInstruction.getDefaultElementBinding().getName() + " converts to atomic " + list.get(0));
            this.insertBinding(string, LiteralInstruction.integerLiteral(0));
            instruction = this.convertLoopAtomics(list, instruction);
            if (!automatonInstruction.getWrapResult()) {
                instruction = new MatchInstruction(instruction, constructor, 0);
            }
        }
        return instruction;
    }

    private Instruction convertTestStream(TestStreamInstruction testStreamInstruction) {
        IAnnotation iAnnotation = this.m_environment.get(testStreamInstruction.getSource());
        Object object = testStreamInstruction.getElementBinding().getName();
        IAnnotation iAnnotation2 = this.m_environment.get(object);
        if (iAnnotation == null || iAnnotation2 == null) {
            testStreamInstruction = (TestStreamInstruction)testStreamInstruction.cloneShallow();
            Integer n = ReductionHelper.generateIntermediateIdentifier2();
            this.insertBinding(n, new AssertTypeInstruction(testStreamInstruction.getSource(), testStreamInstruction.getSource().getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment())));
            testStreamInstruction.setSource(new IdentifierInstruction(n));
            testStreamInstruction.setHint(this.convertInstruction(testStreamInstruction.getHint()));
            testStreamInstruction.setBody(this.convertInstruction(testStreamInstruction.getBody()));
            return testStreamInstruction;
        }
        if (testStreamInstruction instanceof ProcessStreamInstruction) {
            throw new XylemError("ERR_SYSTEM", "not yet supported");
        }
        Instruction instruction = this.convertInstruction(testStreamInstruction.getBody());
        instruction = this.insertLoopBindingAnnotationOperation(instruction, iAnnotation, iAnnotation2);
        List list = iAnnotation instanceof MetaAnnotation ? ((MetaAnnotation)iAnnotation).getBindingList(iAnnotation.getVariable(), iAnnotation, this) : this.m_converter.getBindingList(iAnnotation.getVariable(), iAnnotation, this);
        if (list.size() == 0) {
            s_logger.debug("test-stream on " + testStreamInstruction.getSource() + " converts to empty");
            if (testStreamInstruction instanceof ProcessStreamInstruction) {
                ProcessStreamInstruction processStreamInstruction = (ProcessStreamInstruction)testStreamInstruction;
                Integer n = ReductionHelper.generateIntermediateIdentifier2();
                Type type = testStreamInstruction.getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment());
                if (!(type instanceof ICollectionType)) {
                    throw new XylemError("ERR_SYSTEM", "not yet supported: conversion of empty psi with wrapResult");
                }
                this.insertBinding(n, new StreamInstruction(((ICollectionType)((Object)type)).getElementType()));
                return new IdentifierInstruction(n);
            }
            return testStreamInstruction.getHint().cloneShallow();
        }
        Type type = ((Binding)list.get(0)).getBindingType();
        if (type instanceof ICollectionType) {
            s_logger.debug("test-stream on " + testStreamInstruction.getSource() + " converts to streams");
            IBinding iBinding = (IBinding)list.get(0);
            IdentifierInstruction identifierInstruction = new IdentifierInstruction(iBinding.getName());
            String string = iBinding.getName() + ITEM_SUFFIX;
            instruction = this.convertLoopAtomics(list.subList(1, list.size()), instruction);
            instruction = new TestStreamInstruction(identifierInstruction, this.convertInstruction(testStreamInstruction.getHint()), string, testStreamInstruction.getHintBinding().getName(), instruction, (ICollectionType)((Object)type));
        } else if (this.isLambdaIterator(list)) {
            s_logger.debug("test-stream on " + testStreamInstruction.getSource() + " converts to lambda-iterator");
            instruction = this.convertTestStreamOnLambdaIterator(testStreamInstruction, iAnnotation.getVariable(), list, instruction);
        } else {
            s_logger.debug("test-stream on " + testStreamInstruction.getSource() + " converts to atomic");
            instruction = this.convertLoopAtomics(list, instruction);
            instruction = new LetInstruction(testStreamInstruction.getHintBinding().getName(), testStreamInstruction.getHint(), instruction);
        }
        return instruction;
    }

    private Instruction convertTestStreamOnLambdaIterator(TestStreamInstruction testStreamInstruction, Object object, List list, Instruction instruction) {
        Object object2;
        Object object32;
        Instruction instruction2 = testStreamInstruction.getHint();
        List list2 = list.subList(3, list.size());
        instruction = this.convertLoopAtomics(list2, instruction);
        IBinding iBinding = (IBinding)list.get(0);
        IBinding iBinding2 = (IBinding)list.get(1);
        IBinding iBinding3 = (IBinding)list.get(2);
        Type type = ((IBinding)list.get(2)).getBindingType();
        String string = iBinding3.getName() + ITEM_SUFFIX;
        Object object4 = testStreamInstruction.getHintBinding().getName();
        String string2 = iBinding3.getName() + "$isEmpty";
        String string3 = "$next";
        String string4 = string + string3;
        String string5 = object4 + string3;
        String string6 = "testStreamFunction" + object + "$" + ReductionHelper.generateIntermediateIdentifier2();
        Set set = FindFreeVariables.findFreeVariables(instruction);
        set.remove(string);
        set.remove(iBinding.getName());
        set.remove(iBinding2.getName());
        set.remove(object4);
        ArrayList<IBinding> arrayList = new ArrayList<IBinding>(set.size() + 4);
        ArrayList<IdentifierInstruction> arrayList2 = new ArrayList<IdentifierInstruction>(set.size() + 4);
        arrayList.add(new Binding((Object)string, type));
        arrayList2.add(new IdentifierInstruction(string4));
        arrayList.add(iBinding);
        arrayList2.add(new IdentifierInstruction(iBinding.getName()));
        arrayList.add(iBinding2);
        arrayList2.add(new IdentifierInstruction(iBinding2.getName()));
        arrayList.add(new Binding(object4, testStreamInstruction.getHintBinding().getBindingType()));
        arrayList2.add(new IdentifierInstruction(string5));
        for (Object object32 : set) {
            object2 = new Binding(object32);
            arrayList.add((IBinding)object2);
            arrayList2.add(new IdentifierInstruction(object32));
        }
        object32 = new FunctionCallInstruction(string6, arrayList2);
        object2 = new ApplyInstruction((Instruction)new IdentifierInstruction(iBinding2.getName()), new Instruction[]{new IdentifierInstruction(string)}, true);
        object32 = new LetInstruction(string4, (Instruction)object2, (Instruction)object32);
        object32 = new LetInstruction(string5, instruction, (Instruction)object32);
        IdentifierInstruction identifierInstruction = new IdentifierInstruction(object4);
        object32 = new ChooseInstruction(new IdentifierInstruction(string2), (Instruction)identifierInstruction, (Instruction)object32);
        ApplyInstruction applyInstruction = new ApplyInstruction((Instruction)new IdentifierInstruction(iBinding.getName()), new Instruction[]{new IdentifierInstruction(string)}, true);
        object32 = new LetInstruction(string2, applyInstruction, (Instruction)object32);
        Function function = new Function(string6, arrayList.toArray(new Binding[0]), (Instruction)object32);
        function.setReturnType(testStreamInstruction.getHint().getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment()));
        this.m_module.addFunction(function);
        this.reduceFunction(function);
        this.insertBinding(string4, new IdentifierInstruction(iBinding3.getName()));
        this.insertBinding(string5, instruction2);
        return new FunctionCallInstruction(string6, arrayList2);
    }

    private Instruction convertLets(Instruction instruction) {
        while (instruction instanceof LetInstruction) {
            LetInstruction letInstruction = (LetInstruction)instruction;
            Object object = letInstruction.getVariable();
            Instruction instruction2 = letInstruction.getValue();
            IAnnotation iAnnotation = this.m_environment.get(object);
            s_logger.debug("converting let val for " + object);
            Instruction instruction3 = iAnnotation instanceof MetaAnnotation ? this.convertNonLet(instruction2, (MetaAnnotation)iAnnotation) : this.convertNonLet(instruction2, this.m_converter);
            if (instruction3 != null) {
                this.insertBinding(object, instruction3);
            }
            if (instruction2 instanceof ISpecialForm || instruction2 instanceof FunctionCallInstruction) {
                this.insertValueDecomposition(object, iAnnotation);
            } else {
                this.insertAnnotationOperation(iAnnotation);
            }
            instruction = letInstruction.getBody();
        }
        return instruction;
    }

    public void insertAnnotationOperation(IAnnotation iAnnotation) {
        if (iAnnotation != null && !(iAnnotation instanceof NullAnnotation)) {
            if (iAnnotation instanceof MetaAnnotation) {
                ((MetaAnnotation)iAnnotation).insertAnnotationOperation(iAnnotation, this.m_environment, this);
            } else {
                this.m_converter.insertAnnotationOperation(iAnnotation, this.m_environment, this);
            }
        }
    }

    public void insertValueDecomposition(Object object, IAnnotation iAnnotation) {
        if (iAnnotation != null && !(iAnnotation instanceof NullAnnotation)) {
            if (iAnnotation instanceof MetaAnnotation) {
                ((MetaAnnotation)iAnnotation).insertValueDecomposition(object, iAnnotation, this.m_environment, this);
            } else {
                this.m_converter.insertValueDecomposition(object, iAnnotation, this.m_environment, this);
            }
        }
    }

    private Instruction insertLoopBindingAnnotationOperation(Instruction instruction, IAnnotation iAnnotation, IAnnotation iAnnotation2) {
        s_logger.debug("inserting loop annotations for (" + iAnnotation2 + ")");
        LetChainBuilder letChainBuilder = this.m_lcb;
        this.m_lcb = new LetChainBuilder();
        if (!(iAnnotation2 instanceof NullAnnotation)) {
            if (iAnnotation2 == null) {
                throw new XylemError("ERR_SYSTEM", "null elt for src=" + iAnnotation);
            }
            if (iAnnotation2 instanceof MetaAnnotation) {
                ((MetaAnnotation)iAnnotation2).insertLoopBinding(iAnnotation, iAnnotation2, this.m_environment, this);
            } else {
                this.m_converter.insertLoopBinding(iAnnotation, iAnnotation2, this.m_environment, this);
            }
        }
        instruction = this.m_lcb.packageUp(instruction);
        this.m_lcb = letChainBuilder;
        s_logger.debug("done(" + iAnnotation2 + ")");
        return instruction;
    }

    public Instruction convertSyntheticFunctionCall(Function function, Object[] objectArray, AnnotationEnvironment annotationEnvironment) {
        AnnotationEnvironment annotationEnvironment2 = this.m_environment;
        this.m_environment = annotationEnvironment;
        IAnnotation[] iAnnotationArray = new IAnnotation[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            iAnnotationArray[i] = this.m_environment.get(objectArray[i]);
            s_logger.debug("paramAnnotations[" + i + "] (i.e., " + objectArray[i] + ")=" + iAnnotationArray[i]);
        }
        FunctionCallSpec functionCallSpec = new FunctionCallSpec(function, iAnnotationArray);
        Instruction instruction = this.convertFunctionCall(functionCallSpec, objectArray, null);
        this.m_environment = annotationEnvironment2;
        return instruction;
    }

    private Instruction convertFunctionCall(FunctionCallSpec functionCallSpec, Object[] objectArray, Instruction[] instructionArray) {
        FunctionAnnotationInfo functionAnnotationInfo = (FunctionAnnotationInfo)this.m_environment.getTable().getFunctionInfo(functionCallSpec);
        Function function = functionCallSpec.getFunction();
        if (functionAnnotationInfo != null) {
            function = this.convert(functionAnnotationInfo);
        }
        Instruction[] instructionArray2 = this.convertCallParams(functionAnnotationInfo, functionCallSpec, objectArray, instructionArray);
        FunctionCallInstruction functionCallInstruction = new FunctionCallInstruction(function.getName(), instructionArray2);
        s_logger.debug("converted call " + functionCallSpec);
        s_logger.debug("            => " + functionCallInstruction);
        return functionCallInstruction;
    }

    private Instruction convertLambdaApplication(ApplyInstruction applyInstruction) {
        Instruction instruction;
        LambdaMetaAnnotation lambdaMetaAnnotation = (LambdaMetaAnnotation)this.m_environment.get(applyInstruction.getLambda());
        IAnnotation[] iAnnotationArray = this.m_environment.get(applyInstruction.getOperands());
        Instruction instruction2 = lambdaMetaAnnotation.getIdentifier(iAnnotationArray);
        Instruction[] instructionArray = applyInstruction.getOperands();
        Object[] objectArray = new Object[applyInstruction.getOperands().length];
        for (int i = 0; i < objectArray.length; ++i) {
            instruction = applyInstruction.getOperands()[i];
            if (!(instruction instanceof IdentifierInstruction)) continue;
            objectArray[i] = ((IdentifierInstruction)instruction).getVariable();
        }
        Instruction[] instructionArray2 = this.convertCallParams(iAnnotationArray, objectArray, instructionArray);
        instruction = new ApplyInstruction(instruction2, instructionArray2, applyInstruction.isPure());
        return instruction;
    }

    public ApplyInstruction convertSyntheticLambdaApplication(String string, Instruction instruction, Object[] objectArray, AnnotationEnvironment annotationEnvironment) {
        AnnotationEnvironment annotationEnvironment2 = this.m_environment;
        this.m_environment = annotationEnvironment;
        LambdaApplySpec lambdaApplySpec = new LambdaApplySpec(string, instruction, annotationEnvironment.get(objectArray), true);
        LambdaAnnotationInfo lambdaAnnotationInfo = (LambdaAnnotationInfo)this.m_environment.getTable().getFunctionInfo(lambdaApplySpec);
        if (lambdaAnnotationInfo == null) {
            throw new XylemError("ERR_SYSTEM", "no lai for " + lambdaApplySpec);
        }
        Object object = this.convertLambda(lambdaAnnotationInfo);
        ApplyInstruction applyInstruction = new ApplyInstruction((Instruction)new IdentifierInstruction(object), this.convertCallParams(lambdaAnnotationInfo, lambdaApplySpec, objectArray, null), lambdaAnnotationInfo.isPure());
        this.m_environment = annotationEnvironment2;
        return applyInstruction;
    }

    public Object convertSyntheticLambdaApplication(String string, Instruction instruction, IAnnotation[] iAnnotationArray, AnnotationEnvironment annotationEnvironment) {
        AnnotationEnvironment annotationEnvironment2 = this.m_environment;
        this.m_environment = annotationEnvironment;
        LambdaApplySpec lambdaApplySpec = new LambdaApplySpec(string, instruction, iAnnotationArray, true);
        LambdaAnnotationInfo lambdaAnnotationInfo = (LambdaAnnotationInfo)this.m_environment.getTable().getFunctionInfo(lambdaApplySpec);
        if (lambdaAnnotationInfo == null) {
            throw new XylemError("ERR_SYSTEM", "no lai for " + lambdaApplySpec);
        }
        Object object = this.convertLambda(lambdaAnnotationInfo);
        this.m_environment = annotationEnvironment2;
        return object;
    }

    public Object convertLambda(LambdaAnnotationInfo lambdaAnnotationInfo) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = this.m_convertedLambdas.get(lambdaAnnotationInfo);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("converting " + lambdaAnnotationInfo);
            try {
                object3 = new ByteArrayOutputStream();
                object2 = new PrintStream((OutputStream)object3);
                new Error().printStackTrace((PrintStream)object2);
                object = new StreamTokenizer(new StringReader(((ByteArrayOutputStream)object3).toString()));
                while (((StreamTokenizer)object).nextToken() != -1) {
                }
                s_logger.debug("stack-depth=" + ((StreamTokenizer)object).lineno());
            }
            catch (Exception exception) {
                s_logger.error(exception);
            }
        }
        object3 = this.m_environment;
        object2 = this.m_convertedLambdas;
        this.m_environment = lambdaAnnotationInfo.getEnvironment();
        this.m_convertedLambdas = new HashMap();
        object = this.convertInstruction(lambdaAnnotationInfo.getBody());
        this.m_convertedLambdas = object2;
        this.m_environment = object3;
        LambdaInstruction lambdaInstruction = new LambdaInstruction((Instruction)object, this.convertParamBindings(lambdaAnnotationInfo), lambdaAnnotationInfo.isPure());
        object4 = ReductionHelper.generateIntermediateIdentifier2();
        this.insertBinding(object4, lambdaInstruction);
        s_logger.debug("created new lambda '" + object4 + "' for " + lambdaAnnotationInfo);
        this.m_convertedLambdas.put(lambdaAnnotationInfo, object4);
        return object4;
    }

    public Type convertReturnType(IFunctionAnnotationInfo iFunctionAnnotationInfo) {
        if (iFunctionAnnotationInfo.getResultAnnotation() == null) {
            return iFunctionAnnotationInfo.getOriginalReturnType();
        }
        if (iFunctionAnnotationInfo.getResultAnnotation() instanceof MetaAnnotation) {
            return ((MetaAnnotation)iFunctionAnnotationInfo.getResultAnnotation()).getValueType(iFunctionAnnotationInfo.getResultAnnotation(), this);
        }
        return this.m_converter.getValueType(iFunctionAnnotationInfo.getResultAnnotation(), this);
    }

    public List getBindingList(Object object, IAnnotation iAnnotation) {
        if (iAnnotation instanceof MetaAnnotation) {
            return ((MetaAnnotation)iAnnotation).getBindingList(object, iAnnotation, this);
        }
        return this.m_converter.getBindingList(object, iAnnotation, this);
    }

    public Binding[] convertParamBindings(IFunctionAnnotationInfo iFunctionAnnotationInfo) {
        int n = iFunctionAnnotationInfo.getParamBindings().length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Binding binding = iFunctionAnnotationInfo.getParamBindings()[i];
            IAnnotation iAnnotation = iFunctionAnnotationInfo.getParamAnnotations()[i];
            if (iAnnotation == null) {
                arrayList.add(binding.clone());
                continue;
            }
            if (iAnnotation instanceof MetaAnnotation) {
                arrayList.addAll(((MetaAnnotation)iAnnotation).getBindingList(iAnnotation.getVariable(), iAnnotation, this));
                continue;
            }
            arrayList.addAll(this.m_converter.getBindingList(iAnnotation.getVariable(), iAnnotation, this));
        }
        return arrayList.toArray(new Binding[0]);
    }

    public Type convertType(IAnnotation iAnnotation, Type type) {
        if (iAnnotation == null) {
            return type;
        }
        if (iAnnotation instanceof MetaAnnotation) {
            return ((MetaAnnotation)iAnnotation).getValueType(iAnnotation, this);
        }
        return this.m_converter.getValueType(iAnnotation, this);
    }

    public Binding[] convertParamBindings(IAnnotation[] iAnnotationArray, IBinding[] iBindingArray) {
        int n = iBindingArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Binding binding = (Binding)iBindingArray[i];
            IAnnotation iAnnotation = iAnnotationArray[i];
            if (iAnnotation == null) {
                arrayList.add(binding.clone());
                continue;
            }
            if (iAnnotation instanceof MetaAnnotation) {
                arrayList.addAll(((MetaAnnotation)iAnnotation).getBindingList(iAnnotation.getVariable(), iAnnotation, this));
                continue;
            }
            arrayList.addAll(this.m_converter.getBindingList(iAnnotation.getVariable(), iAnnotation, this));
        }
        return arrayList.toArray(new Binding[0]);
    }

    private Instruction[] convertCallParams(IFunctionAnnotationInfo iFunctionAnnotationInfo, ICallSpec iCallSpec, Object[] objectArray, Instruction[] instructionArray) {
        if (s_logger.isDebugEnabled()) {
            int n;
            System.out.println("converting call/apply " + iCallSpec);
            System.out.println("originalParams=");
            if (null == instructionArray) {
                System.out.println("null");
            } else {
                for (n = 0; n < instructionArray.length; ++n) {
                    System.out.print("  " + instructionArray[n]);
                }
            }
            System.out.println("\nparamVars=");
            for (n = 0; n < objectArray.length; ++n) {
                System.out.print("  " + objectArray[n]);
            }
            System.out.println();
        }
        IAnnotation[] iAnnotationArray = new IAnnotation[objectArray.length];
        if (iFunctionAnnotationInfo != null) {
            iAnnotationArray = iFunctionAnnotationInfo.getParamAnnotations();
        } else {
            s_logger.debug("no fai found for '" + iCallSpec + "'");
        }
        return this.convertCallParams(iAnnotationArray, objectArray, instructionArray);
    }

    private Instruction[] convertCallParams(IAnnotation[] iAnnotationArray, Object[] objectArray, Instruction[] instructionArray) {
        int n = objectArray.length;
        ArrayList<IdentifierInstruction> arrayList = new ArrayList<IdentifierInstruction>(n);
        for (int i = 0; i < n; ++i) {
            IAnnotation iAnnotation;
            Object object = objectArray[i];
            if (object != null && (iAnnotation = this.m_environment.get(object)) != null && iAnnotationArray[i] != null) {
                List list = this.getIdentifierList(iAnnotation.getVariable(), iAnnotationArray[i]);
                s_logger.debug("    param " + object + " => ");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    s_logger.debug("    " + iterator.next());
                }
                arrayList.addAll(list);
                continue;
            }
            s_logger.debug("    param " + object + " unchanged.");
            arrayList.add((IdentifierInstruction)(instructionArray == null ? new IdentifierInstruction(object) : instructionArray[i]));
        }
        return arrayList.toArray(new Instruction[0]);
    }

    public List getIdentifierList(Object object, IAnnotation iAnnotation) {
        List list = this.getBindingList(object, iAnnotation);
        ArrayList<IdentifierInstruction> arrayList = new ArrayList<IdentifierInstruction>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new IdentifierInstruction(((Binding)iterator.next()).getName()));
        }
        return arrayList;
    }
}

