/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.types;

import com.ibm.xtq.bcel.generic.InstructionConstants;
import com.ibm.xtq.bcel.generic.InstructionFactory;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.FloatType;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.types.IPrimitiveType;
import com.ibm.xylem.types.SingletonType;

public abstract class PrimitiveNumericalType
extends SingletonType
implements IPrimitiveType,
INumericalType {
    private static final long serialVersionUID = -3024613341486006823L;
    private static final String[] s_operators = new String[]{"+", "-", "*", "/", "%", ">", ">=", "<", "<=", "==", "&", "|", "^", "<<", ">>", ">>>"};
    private static final boolean[] s_isComparisonOperator = new boolean[]{false, false, false, false, false, true, true, true, true, true, false, false, false, false, false, false};

    public static int getOperatorSize() {
        return s_operators.length;
    }

    public static String getOperator(int n) {
        int n2 = PrimitiveNumericalType.getOperatorSize();
        if (n >= n2 || n < 0) {
            return null;
        }
        return s_operators[n];
    }

    public static boolean isComparisonOperator(int n) {
        int n2 = s_isComparisonOperator.length;
        if (n >= n2 || n < 0) {
            return false;
        }
        return s_isComparisonOperator[n];
    }

    @Override
    public final String generateCodeForOperation(String string, String string2, int n) {
        return "(" + (s_isComparisonOperator[n] ? "" : "(" + this.toString() + ") ") + "((" + string + ") " + s_operators[n] + " (" + string2 + ")))";
    }

    public final Object evaluateComparisonOperation(Object object, Object object2, int n) {
        return PrimitiveNumericalType.evaluateComparisonOperationHelper(object, object2, n);
    }

    public static final Object evaluateComparisonOperationHelper(Object object, Object object2, int n) {
        Comparable comparable = (Comparable)object;
        switch (n) {
            case 5: {
                return comparable.compareTo(object2) > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return comparable.compareTo(object2) < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return comparable.compareTo(object2) >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return comparable.compareTo(object2) <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return comparable.equals(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String generateNullValue(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        return "((" + this.getImplementationName(dataFlowCodeGenerationHelper) + ") 0)";
    }

    @Override
    public void generateCodeForOperation(InstructionListBuilder instructionListBuilder, int n) {
        if (n == 4) {
            if (DoubleType.s_doubleType.equals(this)) {
                instructionListBuilder.append(InstructionConstants.DREM);
                return;
            }
            if (FloatType.s_floatType.equals(this)) {
                instructionListBuilder.append(InstructionConstants.FREM);
                return;
            }
        }
        instructionListBuilder.append(InstructionFactory.createBinaryOperation(s_operators[n], this.getImplementationType(instructionListBuilder.getCodeGenerationHelper())));
    }
}

