/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.CodepointMappings;
import org.apache.xml.serializer.EncodingInfo;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.SerializerTraceWriter;
import org.apache.xml.serializer.TreeWalker;
import org.apache.xml.serializer.WriterChain;
import org.apache.xml.serializer.WriterOptimized;
import org.apache.xml.serializer.WriterStateless;
import org.apache.xml.serializer.WriterToASCI;
import org.apache.xml.serializer.WriterToUTF8Buffered;
import org.apache.xml.serializer.charmap.CharacterMaps;
import org.apache.xml.serializer.charmap.OutputCharacter;
import org.apache.xml.serializer.unicode.UnicodeNormalizer;
import org.apache.xml.serializer.unicode.UnicodeNormalizerFactory;
import org.apache.xml.serializer.utils.Utils;
import org.apache.xml.serializer.utils.WrappedRuntimeException;
import org.apache.xml.serializer.utils.XML11Char;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class ToStream
extends SerializerBase {
    private static final String COMMENT_BEGIN = "<!--";
    private static final String COMMENT_END = "-->";
    protected BoolStack m_disableOutputEscapingStates = new BoolStack();
    EncodingInfo m_encodingInfo = new EncodingInfo(null, null, '\u0000', true);
    protected boolean m_ispreserve = false;
    protected boolean m_isprevtext = false;
    char[] m_lineSep = (char[])s_systemLineSep.clone();
    protected boolean m_lineSepUse = true;
    protected int m_lineSepLen = this.m_lineSep.length;
    CharInfo m_charInfo;
    boolean m_shouldFlush = true;
    protected boolean m_spaceBeforeClose = false;
    boolean m_startNewLine;
    protected boolean m_inDoctype = false;
    boolean m_isUTF8 = false;
    protected boolean m_cdataStartCalled = false;
    boolean m_expandDTDEntities = true;
    UnicodeNormalizer m_unicodeNormalizer = null;
    int m_normalizerMode = 1;
    int m_optLevel;
    final CharInfo.CharKey m_charKey = new CharInfo.CharKey();
    protected boolean m_escaping = true;
    OutputStream m_outputStream;
    private boolean m_writer_set_by_user;
    CodepointMappings m_codepoint2String;
    CharacterMaps m_charcterMaps;
    protected boolean m_specialEscapeURLs = true;
    protected boolean m_omitMetaTag = false;

    protected void closeCDATA() throws SAXException {
        try {
            this.m_writer.write("]]>");
            this.m_cdataTagOpen = false;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void serialize(Node node) throws IOException {
        try {
            Object object;
            String string = null;
            try {
                object = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty("user.dir");
                    }
                });
                string = (String)object + File.separator + "dummy.xsl";
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            object = new TreeWalker(this, string);
            ((TreeWalker)object).traverse(node);
        }
        catch (SAXException sAXException) {
            throw new WrappedRuntimeException(sAXException);
        }
    }

    protected final void flushWriter() throws SAXException {
        OutputStream outputStream;
        Writer writer = this.m_writer;
        if (null != writer) {
            try {
                if (writer instanceof WriterOptimized) {
                    if (this.m_shouldFlush) {
                        ((WriterOptimized)writer).flush();
                    } else {
                        ((WriterOptimized)writer).flushBuffer();
                    }
                } else if (writer instanceof WriterToASCI) {
                    if (this.m_shouldFlush) {
                        writer.flush();
                    }
                } else {
                    writer.flush();
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        if ((outputStream = this.m_outputStream) != null) {
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            Writer writer = this.m_writer;
            this.DTDprolog();
            writer.write("<!ELEMENT ");
            writer.write(string);
            writer.write(32);
            writer.write(string2);
            writer.write(62);
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            this.DTDprolog();
            this.outputEntityDecl(string, string2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    void outputEntityDecl(String string, String string2) throws IOException {
        Writer writer = this.m_writer;
        writer.write("<!ENTITY ");
        writer.write(string);
        writer.write(" \"");
        writer.write(string2);
        writer.write("\">");
        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
    }

    protected final void outputLineSep() throws IOException {
        this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
    }

    @Override
    void setProp(String string, String string2, boolean bl) {
        if (string2 != null) {
            String string3 = ToStream.getLocalNameFromExpanded(string);
            char c = string3.charAt(0);
            switch (c) {
                case 'b': {
                    if (!"byte-order-mark".equals(string) || "yes".equals(string2) || "no".equals(string2)) break;
                    Object[] objectArray = new String[]{this.getURI(), "byte-order-mark", string2};
                    this.reportWarning("WARN_PARAM_NOT_YES_OR_NO", objectArray);
                    return;
                }
                case 'c': {
                    if (!"cdata-section-elements".equals(string)) break;
                    String string4 = string2;
                    this.addCdataSectionElements(string4);
                    break;
                }
                case 'd': {
                    if ("doctype-system".equals(string)) {
                        this.m_doctypeSystem = string2;
                        break;
                    }
                    if (!"doctype-public".equals(string)) break;
                    this.m_doctypePublic = string2;
                    if (!string2.startsWith("-//W3C//DTD XHTML")) break;
                    this.m_spaceBeforeClose = true;
                    break;
                }
                case 'e': {
                    String string5 = string2;
                    if ("encoding".equals(string)) {
                        OutputStream outputStream;
                        String string6 = Encodings.getMimeEncoding(string2);
                        if (string6 != null) {
                            super.setProp("mime-name", string6, bl);
                        }
                        String string7 = this.getOutputPropertyNonDefault("encoding");
                        String string8 = this.getOutputPropertyDefault("encoding");
                        if ((!bl || string8 != null && string8.equalsIgnoreCase(string5)) && (bl || string7 != null && string7.equalsIgnoreCase(string5))) break;
                        EncodingInfo encodingInfo = Encodings.getEncodingInfo(string5);
                        if (string5 != null && encodingInfo.name == null) {
                            this.reportWarning("ER_ENCODING_NOT_SUPPORTED", new String[]{string5, "UTF-8"});
                            string5 = "UTF-8";
                            string2 = "UTF-8";
                            encodingInfo = Encodings.getEncodingInfo(string5);
                        }
                        if (bl && string7 != null) break;
                        this.m_encodingInfo = encodingInfo;
                        if (string5 != null) {
                            this.m_isUTF8 = string5.equals("UTF-8");
                        }
                        if ((outputStream = this.getOutputStream()) == null) break;
                        Writer writer = this.m_writer;
                        String string9 = this.getOutputProperty("encoding");
                        if (writer != null && this.m_writer_set_by_user || string5.equalsIgnoreCase(string9)) break;
                        super.setProp(string, string2, bl);
                        break;
                    }
                    if (!"escape-uri-attributes".equals(string)) break;
                    if (!"yes".equals(string2) && !"no".equals(string2)) {
                        Object[] objectArray = new String[]{this.getURI(), "escape-uri-attributes", string2};
                        this.reportWarning("WARN_PARAM_NOT_YES_OR_NO", objectArray);
                        return;
                    }
                    this.m_specialEscapeURLs = "yes".equals(string2);
                    break;
                }
                case 'i': {
                    if ("{http://xml.apache.org/xalan}indent-amount".equals(string)) {
                        boolean bl2 = true;
                        try {
                            int n = Integer.parseInt(string2);
                            if (0 <= n) {
                                bl2 = false;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (bl2) {
                            Object[] objectArray = new String[]{this.getURI(), "indent-amount", string2};
                            this.reportWarning("WARN_PARAM_BAD", objectArray);
                            return;
                        }
                        this.setIndentAmount(Integer.parseInt(string2));
                        break;
                    }
                    if ("indent".equals(string)) {
                        boolean bl3;
                        if (!"yes".equals(string2) && !"no".equals(string2)) {
                            Object[] objectArray = new String[]{this.getURI(), "indent", string2};
                            this.reportWarning("WARN_PARAM_NOT_YES_OR_NO", objectArray);
                            return;
                        }
                        this.m_doIndent = bl3 = "yes".equals(string2);
                        break;
                    }
                    if (!"include-content-type".equals(string)) break;
                    if (!"yes".equals(string2) && !"no".equals(string2)) {
                        Object[] objectArray = new String[]{this.getURI(), "include-content-type", string2};
                        this.reportWarning("WARN_PARAM_NOT_YES_OR_NO", objectArray);
                        return;
                    }
                    this.m_omitMetaTag = "no".equals(string2);
                    break;
                }
                case 'l': {
                    if (!"{http://xml.apache.org/xalan}line-separator".equals(string)) break;
                    this.m_lineSep = string2.toCharArray();
                    this.m_lineSepLen = this.m_lineSep.length;
                    break;
                }
                case 'm': {
                    if ("media-type".equals(string)) {
                        this.m_mediatype = string2;
                        break;
                    }
                    if (!"method".equals(string) || "xml".equals(string2) || "html".equals(string2) || "text".equals(string2) || "xhtml".equals(string2)) break;
                    Object[] objectArray = new String[]{this.getURI(), "method", string2};
                    this.reportWarning("WARN_PARM_VALUE_NOT_SUPPORTED", objectArray);
                    return;
                }
                case 'n': {
                    if (!"normalization-form".equals(string)) break;
                    if ("NFC".equals(string2)) {
                        this.m_normalizerMode = 2;
                    } else if ("NFD".equals(string2)) {
                        this.m_normalizerMode = 3;
                    } else if ("NFKC".equals(string2)) {
                        this.m_normalizerMode = 4;
                    } else if ("NFKD".equals(string2)) {
                        this.m_normalizerMode = 5;
                    } else if ("fully-normalized".equals(string2)) {
                        this.m_normalizerMode = 6;
                    } else if ("none".equals(string2)) {
                        this.m_normalizerMode = 1;
                    } else {
                        Object[] objectArray = new String[]{this.getURI(), "include-content-type", string2};
                        this.reportWarning("WARN_PARM_VALUE_NOT_SUPPORTED", objectArray);
                        return;
                    }
                    if (this.m_normalizerMode == 1) break;
                    this.m_unicodeNormalizer = UnicodeNormalizerFactory.getUnicodeNormalizer();
                    break;
                }
                case 'o': {
                    if ("omit-xml-declaration".equals(string)) {
                        boolean bl4;
                        if (!"yes".equals(string2) && !"no".equals(string2)) {
                            Object[] objectArray = new String[]{this.getURI(), "omit-xml-declaration", string2};
                            this.reportWarning("WARN_PARAM_NOT_YES_OR_NO", objectArray);
                            return;
                        }
                        this.m_shouldNotWriteXMLHeader = bl4 = "yes".equals(string2);
                        break;
                    }
                    if (!"{http://xml.apache.org/xalan}omit-meta-tag".equals(string)) break;
                    if (!"yes".equals(string2) && !"no".equals(string2)) {
                        Object[] objectArray = new String[]{this.getURI(), string3, string2};
                        this.reportWarning("WARN_PARAM_NOT_YES_OR_NO", objectArray);
                        return;
                    }
                    if (this.getOutputPropertyNonDefault("include-content-type") != null) {
                        return;
                    }
                    this.m_omitMetaTag = "yes".equals(string2);
                    break;
                }
                case 's': {
                    if (!"standalone".equals(string)) break;
                    if (!"yes".equals(string2) && !"no".equals(string2)) {
                        Object[] objectArray = new String[]{this.getURI(), "standalone", string2};
                        this.reportWarning("WARN_PARAM_NOT_YES_OR_NO", objectArray);
                        return;
                    }
                    if (bl) {
                        this.setStandaloneInternal(string2);
                        break;
                    }
                    this.m_standaloneWasSpecified = true;
                    this.setStandaloneInternal(string2);
                    break;
                }
                case 'u': {
                    if ("undeclare-prefixes".equals(string)) {
                        if (!"yes".equals(string2) && !"no".equals(string2)) {
                            Object[] objectArray = new String[]{this.getURI(), "undeclare-prefixes", string2};
                            this.reportWarning("WARN_PARAM_NOT_YES_OR_NO", objectArray);
                            return;
                        }
                        if ("yes".equals(string2)) {
                            this.m_undeclareNamespaces = true;
                            if (this.m_prefixMap == null) break;
                            this.m_prefixMap.setUndeclaration(true);
                            break;
                        }
                        this.m_undeclareNamespaces = false;
                        if (this.m_prefixMap == null) break;
                        this.m_prefixMap.setUndeclaration(false);
                        break;
                    }
                    if (!"{http://xml.apache.org/xalan}use-url-escaping".equals(string)) break;
                    if (!"yes".equals(string2) && !"no".equals(string2)) {
                        Object[] objectArray = new String[]{this.getURI(), string3, string2};
                        this.reportWarning("WARN_PARAM_NOT_YES_OR_NO", objectArray);
                        return;
                    }
                    if (this.getOutputPropertyNonDefault("escape-uri-attributes") != null) {
                        return;
                    }
                    this.m_specialEscapeURLs = "yes".equals(string2);
                    break;
                }
                case 'v': {
                    if (!"version".equals(string)) break;
                    if (!XML11Char.isXML11ValidNmtoken(string2)) {
                        Object[] objectArray = new String[]{this.getURI(), "version", string2};
                        this.reportWarning("WARN_PARAM_NOT_NMTOKEN", objectArray);
                        return;
                    }
                    this.m_version = string2;
                    break;
                }
            }
            super.setProp(string, string2, bl);
        }
    }

    @Override
    public void setOutputFormat(Properties properties) {
        Enumeration<Object> enumeration;
        Object object;
        boolean bl = this.m_shouldFlush;
        int n = 0;
        if (properties != null) {
            if (this.m_wasJustReset) {
                enumeration = properties instanceof OutputPropertiesFactory.SerializerProps ? (!((OutputPropertiesFactory.SerializerProps)(object = (OutputPropertiesFactory.SerializerProps)properties)).hasOnlyStandardDefaults() ? properties.propertyNames() : null) : properties.propertyNames();
                this.m_wasJustReset = false;
            } else {
                enumeration = properties.propertyNames();
            }
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    ++n;
                    object = (String)enumeration.nextElement();
                    String string = properties.getProperty((String)object);
                    String string2 = (String)properties.get(object);
                    if (string2 == null && string != null) {
                        this.setOutputPropertyDefault((String)object, string);
                    }
                    if (string2 == null) continue;
                    this.setOutputProperty((String)object, string2);
                }
            }
        }
        if (0 < n && null != (enumeration = (String)properties.get("{http://xml.apache.org/xalan}entities"))) {
            object = (String)properties.get("method");
            this.m_charInfo = CharInfo.getCharInfo(enumeration, (String)object);
        }
        this.m_shouldFlush = bl;
    }

    @Override
    public Properties getOutputFormat() {
        String string;
        Object object;
        Properties properties = new Properties();
        Object object2 = this.getOutputPropDefaultKeys();
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            object = (String)object3.next();
            string = this.getOutputPropertyDefault((String)object);
            properties.put(object, string);
        }
        object2 = new Properties(properties);
        object3 = this.getOutputPropKeys();
        object = object3.iterator();
        while (object.hasNext()) {
            string = (String)object.next();
            String string2 = this.getOutputPropertyNonDefault(string);
            if (string2 == null) continue;
            ((Properties)object2).put(string, string2);
        }
        return object2;
    }

    @Override
    public void setWriter(Writer writer) {
        this.m_outputStream = null;
        this.setWriterInternal(writer, true);
    }

    private void setWriterInternal(Writer writer, boolean bl) {
        this.m_writer_set_by_user = bl;
        this.m_writer = writer;
        if (this.m_tracer != null) {
            boolean bl2 = true;
            Writer writer2 = this.m_writer;
            while (writer2 instanceof WriterChain) {
                if (writer2 instanceof SerializerTraceWriter) {
                    bl2 = false;
                    break;
                }
                writer2 = ((WriterChain)((Object)writer2)).getWriter();
            }
            if (bl2) {
                this.m_writer = new SerializerTraceWriter(this.m_writer, this.m_tracer);
            }
        }
        this.m_writerOptimized = this.m_writer instanceof WriterOptimized ? (WriterOptimized)this.m_writer : null;
    }

    public boolean setLineSepUse(boolean bl) {
        boolean bl2 = this.m_lineSepUse;
        this.m_lineSepUse = bl;
        return bl2;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.m_outputStream = outputStream;
        this.m_writer = null;
    }

    private void setOutputStreamInternal(OutputStream outputStream, boolean bl) {
        this.m_outputStream = outputStream;
        String string = this.getOutputProperty("encoding");
        if ("UTF-8".equalsIgnoreCase(string)) {
            WriterOptimized writerOptimized = this.m_writerOptimized;
            if (writerOptimized == null) {
                writerOptimized = new WriterToUTF8Buffered(outputStream);
            } else {
                writerOptimized.setOuputStream(outputStream);
            }
            this.setWriterInternal(writerOptimized, false);
        } else if ("WINDOWS-1250".equals(string) || "US-ASCII".equals(string) || "ASCII".equals(string)) {
            this.setWriterInternal(new WriterToASCI(outputStream), false);
        } else if (string != null) {
            Writer writer = null;
            try {
                String string2;
                if ("UTF-16".equals(string) && (string2 = this.getOutputPropertyNonDefault("byte-order-mark")) != null && "no".equals(string2)) {
                    string = "UnicodeBigUnmarked";
                }
                writer = !bl && this.m_encodingInfo != null && this.m_encodingInfo.isStatelessEncoding() ? new WriterStateless(outputStream, this.m_encodingInfo) : Encodings.getWriter(outputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                writer = null;
            }
            if (writer == null) {
                this.reportWarning("WARN_UTF16_AND_BYTE_ORDER_MARK", new String[]{this.getURI(), "UTF-8"});
                string = "UTF-8";
                this.setEncoding(string);
                try {
                    writer = Encodings.getWriter(outputStream, string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            this.setWriterInternal(writer, false);
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            this.setWriterInternal(outputStreamWriter, false);
        }
    }

    @Override
    public boolean setEscaping(boolean bl) {
        boolean bl2 = this.m_escaping;
        this.m_escaping = bl;
        return bl2;
    }

    protected void indent(int n) throws IOException {
        if (this.m_startNewLine) {
            this.outputLineSep();
        }
        if (this.m_indentAmount > 0) {
            this.printSpace(n * this.m_indentAmount);
        }
    }

    protected void indent() throws IOException {
        this.indent(this.m_elemContext.m_currentElemDepth);
    }

    void printSpace(int n) throws IOException {
        Writer writer = this.m_writer;
        for (int i = 0; i < n; ++i) {
            writer.write(32);
        }
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            Writer writer = this.m_writer;
            this.DTDprolog();
            writer.write("<!ATTLIST ");
            writer.write(string);
            writer.write(32);
            writer.write(string2);
            writer.write(32);
            writer.write(string3);
            if (string4 != null) {
                writer.write(32);
                writer.write(string4);
            }
            writer.write(62);
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public Writer getWriter() {
        if (this.m_writer == null && this.m_outputStream != null) {
            this.setOutputStreamInternal(this.m_outputStream, false);
        }
        return this.m_writer;
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        try {
            this.DTDprolog();
            this.m_writer.write("<!ENTITY ");
            this.m_writer.write(string);
            if (string2 != null) {
                this.m_writer.write(" PUBLIC \"");
                this.m_writer.write(string2);
            } else {
                this.m_writer.write(" SYSTEM \"");
                this.m_writer.write(string3);
            }
            this.m_writer.write("\" >");
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected boolean escapingNotNeeded(int n) {
        boolean bl = n < 127 ? n >= 32 || 10 == n || 13 == n || 9 == n : this.m_encodingInfo.isCodePointInEncoding(n);
        return bl;
    }

    int writeUTF16Surrogate(char c, char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (n + 1 >= n2) {
            throw new IOException(Utils.messages.createMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c)}));
        }
        char c2 = c;
        char c3 = cArray[n + 1];
        if (!Encodings.isLowUTF16Surrogate(c3)) {
            throw new IOException(Utils.messages.createMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c) + " " + Integer.toHexString(c3)}));
        }
        Writer writer = this.m_writer;
        if (this.m_encodingInfo.isSurrogatePairInEncoding(c, c3)) {
            writer.write(cArray, n, 2);
        } else {
            String string = this.getEncoding();
            if (string != null) {
                n3 = Encodings.toCodePoint(c2, c3);
                writer.write(38);
                writer.write(35);
                writer.write(Integer.toString(n3));
                writer.write(59);
            } else {
                writer.write(cArray, n, 2);
            }
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int accumDefaultEntity(Writer writer, char c, int n, char[] cArray, int n2, boolean bl, boolean bl2) throws IOException {
        if (!bl2 && '\n' == c) {
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            return n + 1;
        } else {
            if ((!bl || !this.shouldMapTextChar(c)) && (bl || !this.shouldMapAttrChar(c))) return n;
            String string = this.m_charInfo.getOutputStringForChar(c, this.m_charKey);
            if (null == string) return n;
            writer.write(string);
        }
        return n + 1;
    }

    void writeNormalizedChars(char[] cArray, int n, int n2, boolean bl, boolean bl2) throws IOException, SAXException {
        int n3;
        Writer writer = this.m_writer;
        int n4 = n;
        int n5 = n;
        int n6 = n + n2;
        block12: while (n5 < n6) {
            int n7;
            int n8;
            int n9 = cArray[n5];
            switch (n9) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n3 = n5 - n4;
                    this.writeCDATAnumericEntity(bl, writer, cArray, n4, n3, n9);
                    n4 = ++n5;
                    continue block12;
                }
                case 9: {
                    ++n5;
                    continue block12;
                }
                case 10: {
                    if (bl2) {
                        n3 = n5 - n4;
                        if (bl && !this.m_cdataTagOpen) {
                            writer.write("<![CDATA[");
                            this.m_cdataTagOpen = true;
                        }
                        writer.write(cArray, n4, n3);
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        n4 = ++n5;
                        continue block12;
                    }
                    ++n5;
                    continue block12;
                }
                case 11: 
                case 12: {
                    n3 = n5 - n4;
                    this.writeCDATAnumericEntity(bl, writer, cArray, n4, n3, n9);
                    n4 = ++n5;
                    continue block12;
                }
                case 13: {
                    if (bl) {
                        n3 = n5 - n4;
                        this.writeCDATAnumericEntity(bl, writer, cArray, n4, n3, n9);
                        n4 = ++n5;
                        continue block12;
                    }
                    ++n5;
                    continue block12;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    n3 = n5 - n4;
                    this.writeCDATAnumericEntity(bl, writer, cArray, n4, n3, n9);
                    n4 = ++n5;
                    continue block12;
                }
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: {
                    ++n5;
                    continue block12;
                }
                case 93: {
                    if (bl) {
                        if (n5 < n6 - 2 && ']' == cArray[n5 + 1] && '>' == cArray[n5 + 2]) {
                            if (!this.m_cdataTagOpen) {
                                n5 += 3;
                                continue block12;
                            }
                            n3 = n5 - n4;
                            writer.write(cArray, n4, n3);
                            writer.write("]]]]><![CDATA[>");
                            n4 = n5 += 3;
                            continue block12;
                        }
                        ++n5;
                        continue block12;
                    }
                    ++n5;
                    continue block12;
                }
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: {
                    ++n5;
                    continue block12;
                }
                case 127: {
                    n3 = n5 - n4;
                    this.writeCDATAnumericEntity(bl, writer, cArray, n4, n3, n9);
                    n4 = ++n5;
                    continue block12;
                }
            }
            if (Encodings.isHighUTF16Surrogate((char)n9) && n5 + 1 < n6) {
                char c = cArray[n5 + 1];
                n8 = Encodings.toCodePoint((char)n9, c);
                n7 = 2;
            } else {
                n8 = n9;
                n7 = 1;
            }
            if (this.m_encodingInfo.isCodePointInEncoding(n8)) {
                n5 += n7;
                continue;
            }
            n3 = n5 - n4;
            this.writeCDATAnumericEntity(bl, writer, cArray, n4, n3, n9);
            n4 = n5 += n7;
        }
        n3 = n5 - n4;
        if (n3 > 0) {
            if (bl) {
                if (!this.m_cdataTagOpen) {
                    writer.write("<![CDATA[");
                    this.m_cdataTagOpen = true;
                }
                writer.write(cArray, n4, n3);
            } else {
                writer.write(cArray, n4, n3);
            }
        }
    }

    private void writeCDATAnumericEntity(boolean bl, Writer writer, char[] cArray, int n, int n2, int n3) throws IOException {
        if (bl) {
            if (!this.m_cdataTagOpen) {
                if (n2 > 0) {
                    writer.write("<![CDATA[");
                    writer.write(cArray, n, n2);
                    writer.write("]]>");
                }
            } else {
                if (n2 > 0) {
                    writer.write(cArray, n, n2);
                }
                writer.write("]]>");
                this.m_cdataTagOpen = false;
            }
        } else {
            writer.write(cArray, n, n2);
        }
        writer.write("&#");
        writer.write(Integer.toString(n3));
        writer.write(59);
    }

    public void endNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.pop();
    }

    public void startNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.push(true);
    }

    protected void cdata(char[] cArray, int n, int n2) throws SAXException {
        try {
            boolean bl;
            int n3 = n;
            if (this.m_elemContext.m_startTagOpen) {
                this.closeStartTag();
                this.m_elemContext.m_startTagOpen = false;
            }
            this.m_ispreserve = true;
            if (this.shouldIndent()) {
                this.indent();
            }
            boolean bl2 = bl = n2 >= 1 && this.escapingNotNeeded(cArray[n]);
            if (bl && !this.m_cdataTagOpen) {
                this.m_writer.write("<![CDATA[");
                this.m_cdataTagOpen = true;
            }
            if (this.isEscapingDisabled()) {
                this.charactersRaw(cArray, n, n2);
            } else {
                this.writeNormalizedChars(cArray, n, n2, true, this.m_lineSepUse);
            }
            if (bl && cArray[n + n2 - 1] == ']') {
                this.closeCDATA();
            }
            if (this.m_tracer != null) {
                super.fireCDATAEvent(cArray, n3, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(Utils.messages.createMessage("ER_OIERROR", null), iOException);
        }
    }

    private boolean isEscapingDisabled() {
        return this.m_disableOutputEscapingStates.peekOrFalse();
    }

    protected void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        try {
            int n3;
            if (this.m_elemContext.m_startTagOpen) {
                this.closeStartTag();
                this.m_elemContext.m_startTagOpen = false;
            }
            this.m_ispreserve = true;
            int n4 = n + n2;
            int n5 = n;
            int n6 = 0;
            for (n3 = n; n3 < n4; ++n3) {
                int n7;
                int n8 = cArray[n3];
                if (n8 <= 127) continue;
                int n9 = 0;
                if (Encodings.isHighUTF16Surrogate((char)n8) && n3 + 1 < n4) {
                    char c = cArray[n3 + 1];
                    n7 = Encodings.toCodePoint((char)n8, c);
                    n9 = 1;
                } else {
                    n7 = n8;
                }
                if (!this.m_encodingInfo.isCodePointInEncoding(n7)) {
                    n6 = n3 - n5;
                    this.m_writer.write(cArray, n5, n6);
                    String string = this.m_charInfo.getOutputStringForChar(n7, this.m_charKey);
                    if (this.shouldMapTextChar(n7) && string != null) {
                        this.m_writer.write(string);
                    } else {
                        this.m_writer.write("&#");
                        this.m_writer.write(Integer.toString(n7));
                        this.m_writer.write(59);
                    }
                    n5 = n3 + n9 + 1;
                }
                n3 += n9;
            }
            n6 = n3 - n5;
            this.m_writer.write(cArray, n5, n6);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0 || this.m_inEntityRef && !this.m_expandDTDEntities) {
            return;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.m_docIsEmpty = false;
            this.startDocumentInternal();
        }
        if (this.m_cdataStartCalled || this.m_elemContext.m_isCdataSection) {
            this.cdata(cArray, n, n2);
            return;
        }
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (this.m_disableOutputEscapingStates.peekOrFalse() || !this.m_escaping) {
            this.charactersRaw(cArray, n, n2);
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
            return;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        }
        try {
            int n3;
            Writer writer = this.m_writer;
            int n4 = n;
            int n5 = n + n2;
            int n6 = n;
            int n7 = 0;
            boolean bl = true;
            block7: for (n4 = n; n4 < n5 && bl; ++n4) {
                n3 = cArray[n4];
                if (this.m_codepoint2String != null && this.m_codepoint2String.getString(n3) != null) {
                    bl = false;
                } else {
                    switch (n3) {
                        case 9: 
                        case 32: {
                            ++n7;
                            continue block7;
                        }
                        case 10: {
                            if (!this.m_lineSepUse || this.m_lineSepLen == 1 && this.m_lineSep[0] == '\n') break;
                            if (n7 > 0) {
                                writer.write(cArray, n6, n7);
                                n7 = 0;
                            }
                            n6 = n4 + 1;
                            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                            break;
                        }
                        case 13: {
                            if (n7 > 0) {
                                writer.write(cArray, n6, n7);
                                n7 = 0;
                            }
                            n6 = n4 + 1;
                            writer.write("&#13;");
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                }
                if (!bl) break;
            }
            n7 = n4 - n6;
            if (n4 < n5 || !bl) {
                this.m_ispreserve = true;
            }
            int n8 = 1;
            if (this.m_codepoint2String != null && this.m_codepoint2String.hasMappings()) {
                for (int i = n6 + n7; i < n5; i += n8) {
                    int n9;
                    n3 = cArray[i];
                    if (Encodings.isHighUTF16Surrogate((char)n3) && i + 1 < n5) {
                        char c = cArray[i + 1];
                        n9 = Encodings.toCodePoint((char)n3, c);
                        n8 = 2;
                    } else {
                        n9 = n3;
                        n8 = 1;
                    }
                    String string = this.m_codepoint2String.getString(n9);
                    if (string != null) {
                        if (n7 > 0) {
                            this.unicodeNormalizeTextThenEscape(cArray, n6, n7);
                        }
                        writer.write(string);
                        n6 = i + n8;
                        n7 = 0;
                        continue;
                    }
                    n7 += n8;
                }
            } else {
                n7 = n5 - n6;
            }
            if (n7 > 0) {
                this.unicodeNormalizeTextThenEscape(cArray, n6, n7);
            }
            this.m_isprevtext = true;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (this.m_tracer != null) {
            super.fireCharEvent(cArray, n, n2);
        }
    }

    void unicodeNormalizeTextThenEscape(char[] cArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n2;
        int n5 = n;
        Writer writer = this.m_writer;
        if (this.m_normalizerMode != 1 && !this.m_unicodeNormalizer.alreadyNormalized(cArray, n, n + n2, this.m_normalizerMode)) {
            n3 = n + 3 * n2 + 1;
            if (this.m_normalizedCharsBuff.length < n3) {
                this.m_normalizedCharsBuff = new char[n3];
            }
            n4 = this.m_unicodeNormalizer.normalizeUnicode(cArray, n, n + n2, this.m_normalizedCharsBuff, n, n3, this.m_normalizerMode);
            cArray = this.m_normalizedCharsBuff;
        }
        n3 = n + n4;
        int n6 = 1;
        int n7 = 0;
        for (int i = n; i < n3; i += n6) {
            int n8;
            int n9 = cArray[i];
            if (Encodings.isHighUTF16Surrogate((char)n9) && i + 1 < n3) {
                char c = cArray[i + 1];
                n8 = Encodings.toCodePoint((char)n9, c);
                n6 = 2;
            } else {
                n8 = n9;
                n6 = 1;
            }
            if (this.shouldMapTextChar(n8)) {
                if (n7 > 0) {
                    writer.write(cArray, n5, n7);
                    n7 = 0;
                }
                n5 = i + n6;
                String string = this.m_charInfo.getOutputStringForChar(n8, this.m_charKey);
                writer.write(string);
                continue;
            }
            if (n8 <= 31) {
                switch (n8) {
                    case 9: {
                        n7 += n6;
                        break;
                    }
                    case 10: {
                        if (!this.m_lineSepUse || this.m_lineSepLen == 1 && this.m_lineSep[0] == '\n') {
                            n7 += n6;
                            break;
                        }
                        if (n7 > 0) {
                            writer.write(cArray, n5, n7);
                            n7 = 0;
                        }
                        n5 = i + n6;
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        break;
                    }
                    case 13: {
                        if (n7 > 0) {
                            writer.write(cArray, n5, n7);
                            n7 = 0;
                        }
                        n5 = i + n6;
                        writer.write("&#13;");
                        break;
                    }
                    default: {
                        if (n7 > 0) {
                            writer.write(cArray, n5, n7);
                            n7 = 0;
                        }
                        n5 = i + n6;
                        writer.write("&#");
                        writer.write(Integer.toString(n8));
                        writer.write(59);
                        break;
                    }
                }
                continue;
            }
            if (n8 < 127) {
                switch (n8) {
                    case 38: {
                        if (n7 > 0) {
                            writer.write(cArray, n5, n7);
                            n7 = 0;
                        }
                        n5 = i + n6;
                        writer.write("&amp;");
                        break;
                    }
                    case 60: {
                        if (n7 > 0) {
                            writer.write(cArray, n5, n7);
                            n7 = 0;
                        }
                        n5 = i + n6;
                        writer.write("&lt;");
                        break;
                    }
                    default: {
                        n7 += n6;
                        break;
                    }
                }
                continue;
            }
            if (n8 <= 159) {
                if (n7 > 0) {
                    writer.write(cArray, n5, n7);
                    n7 = 0;
                }
                n5 = i + n6;
                writer.write("&#");
                writer.write(Integer.toString(n8));
                writer.write(59);
                continue;
            }
            if (n8 == 8232) {
                if (n7 > 0) {
                    writer.write(cArray, n5, n7);
                    n7 = 0;
                }
                n5 = i + n6;
                writer.write("&#8232;");
                continue;
            }
            if (this.m_encodingInfo.isCodePointInEncoding(n8)) {
                n7 += n6;
                continue;
            }
            if (n7 > 0) {
                writer.write(cArray, n5, n7);
                n7 = 0;
            }
            n5 = i + n6;
            writer.write("&#");
            writer.write(Integer.toString(n8));
            writer.write(59);
        }
        if (n7 > 0) {
            writer.write(cArray, n5, n7);
        }
    }

    boolean shouldMapTextChar(int n) {
        return this.m_charInfo.shouldMapTextChar(n);
    }

    boolean shouldMapAttrChar(int n) {
        return this.m_charInfo.shouldMapAttrChar(n);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
            this.m_docIsEmpty = false;
        } else if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        try {
            if (this.m_needToOutputDocTypeDecl) {
                if (null != this.getDoctypeSystem()) {
                    this.outputDocTypeDecl(string3, true);
                }
                this.m_needToOutputDocTypeDecl = false;
            }
            if (this.m_elemContext.m_startTagOpen) {
                this.closeStartTag();
                this.m_elemContext.m_startTagOpen = false;
            }
            if (string != null) {
                this.ensurePrefixIsDeclared(string, string3);
            }
            this.m_ispreserve = false;
            if (this.shouldIndent() && this.m_startNewLine) {
                this.indent();
            }
            this.m_startNewLine = true;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (attributes != null) {
            this.addAttributes(attributes);
        }
        this.m_elemContext = this.m_elemContext.push(string, string2, string3);
        this.m_isprevtext = false;
        if (this.m_tracer != null) {
            this.firePseudoAttributes();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3) throws SAXException {
        this.startElement(string, string2, string3, null);
    }

    @Override
    public void startElement(String string) throws SAXException {
        this.startElement(null, null, string, null);
    }

    void outputDocTypeDecl(String string, boolean bl) throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        try {
            String string2;
            Writer writer = this.m_writer;
            writer.write("<!DOCTYPE ");
            writer.write(string);
            String string3 = this.getDoctypePublic();
            if (null != string3) {
                writer.write(" PUBLIC \"");
                writer.write(string3);
                writer.write(34);
            }
            if (null != (string2 = this.getDoctypeSystem())) {
                if (null == string3) {
                    writer.write(" SYSTEM \"");
                } else {
                    writer.write(" \"");
                }
                writer.write(string2);
                if (bl) {
                    writer.write("\">");
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    bl = false;
                } else {
                    writer.write(34);
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    abstract void processAttributes(Writer var1, int var2) throws IOException, SAXException;

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_prefixMap.popNamespaces(this.m_elemContext.m_currentElemDepth, null);
        try {
            Writer writer = this.m_writer;
            if (this.m_elemContext.m_startTagOpen) {
                int n;
                String string4 = this.m_elemContext.m_elementName;
                this.m_writer.write(60);
                this.m_writer.write(string4);
                if (this.m_tracer != null) {
                    super.fireStartElem(string4);
                }
                if ((n = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(this.m_writer, n);
                    this.m_attributes.clear();
                }
                if (this.m_spaceBeforeClose) {
                    writer.write(" />");
                } else {
                    writer.write("/>");
                }
            } else {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                if (this.shouldIndent()) {
                    this.indent(this.m_elemContext.m_currentElemDepth - 1);
                }
                writer.write(60);
                writer.write(47);
                writer.write(string3);
                writer.write(62);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (this.m_doIndent) {
            this.m_ispreserve = false;
        }
        this.m_isprevtext = false;
        if (this.m_tracer != null) {
            super.fireEndElem(string3);
        }
        this.m_elemContext = this.m_elemContext.m_prev;
    }

    @Override
    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.startPrefixMapping(string, string2, true);
    }

    @Override
    public boolean startPrefixMapping(String string, String string2, boolean bl) throws SAXException {
        int n;
        if (bl) {
            this.flushInternal();
            n = this.m_elemContext.m_currentElemDepth + 1;
        } else {
            n = this.m_elemContext.m_currentElemDepth;
        }
        boolean bl2 = this.m_prefixMap.pushNamespace(string, string2, n);
        if (bl2) {
            if ("".equals(string)) {
                String string3 = "xmlns";
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", string3, string3, "CDATA", string2, false);
            } else if (!"".equals(string2)) {
                String string4 = "xmlns:" + string;
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", string, string4, "CDATA", string2, false);
            } else if (this.m_undeclareNamespaces) {
                String string5 = "xmlns:" + string;
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", string, string5, "CDATA", "", false);
            }
        }
        return bl2;
    }

    @Override
    public void comment(String string) throws SAXException {
        char[] cArray;
        this.flushInternal();
        this.m_docIsEmpty = false;
        int n = string.length();
        int n2 = this.getChars(string, 0, n);
        if (n2 == n) {
            cArray = this.getCharsBuff();
        } else {
            cArray = new char[n];
            string.getChars(0, n, cArray, 0);
        }
        this.comment(cArray, 0, n);
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        int n3 = n;
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
            this.m_docIsEmpty = false;
        }
        try {
            int n4;
            int n5 = n + n2;
            boolean bl = false;
            if (this.m_cdataTagOpen) {
                this.closeCDATA();
            }
            if (this.shouldIndent()) {
                this.indent();
            }
            Writer writer = this.m_writer;
            writer.write(COMMENT_BEGIN);
            for (n4 = n; n4 < n5; ++n4) {
                if (bl && cArray[n4] == '-') {
                    writer.write(cArray, n, n4 - n);
                    writer.write(" -");
                    n = n4 + 1;
                }
                bl = cArray[n4] == '-';
            }
            if (n2 > 0) {
                n4 = n5 - n;
                if (n4 > 0) {
                    writer.write(cArray, n, n4);
                }
                if (cArray[n5 - 1] == '-') {
                    writer.write(32);
                }
            }
            writer.write(COMMENT_END);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.m_startNewLine = true;
        if (this.m_tracer != null) {
            super.fireCommentEvent(cArray, n3, n2);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        this.m_cdataStartCalled = false;
    }

    @Override
    public void endDTD() throws SAXException {
        try {
            Writer writer = this.m_writer;
            if (this.m_needToOutputDocTypeDecl && !this.m_needToCallStartDocument) {
                this.outputDocTypeDecl(this.m_elemContext.m_elementName, false);
                this.m_needToOutputDocTypeDecl = false;
                writer.write(62);
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            }
            if (!this.m_inDoctype) {
                writer.write("]>");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (0 == n2) {
            return;
        }
        this.characters(cArray, n, n2);
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_cdataStartCalled = true;
    }

    @Override
    public void startEntity(String string) throws SAXException {
        if (string.equals("[dtd]")) {
            this.m_inExternalDTD = true;
        }
        if (!this.m_expandDTDEntities && !this.m_inExternalDTD) {
            this.startNonEscaping();
            this.characters("&" + string + ';');
            this.endNonEscaping();
        }
        this.m_inEntityRef = true;
    }

    protected void closeStartTag() throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            try {
                int n;
                String string = this.m_elemContext.m_elementName;
                this.m_writer.write(60);
                this.m_writer.write(string);
                if (this.m_tracer != null) {
                    super.fireStartElem(string);
                }
                if ((n = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(this.m_writer, n);
                    this.m_attributes.clear();
                }
                this.m_writer.write(62);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            if (this.m_CdataElems != null) {
                this.m_elemContext.m_isCdataSection = this.isCdataSection();
            }
            if (this.m_doIndent) {
                this.m_isprevtext = false;
            }
        }
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.setDoctypeSystem(string3);
        this.setDoctypePublic(string2);
        this.m_elemContext.m_elementName = string;
        this.m_inDoctype = true;
        if (this.m_writer == null && this.m_outputStream != null) {
            this.setOutputStreamInternal(this.m_outputStream, false);
        }
    }

    @Override
    public int getIndentAmount() {
        return this.m_indentAmount;
    }

    @Override
    public void setIndentAmount(int n) {
        this.m_indentAmount = n;
    }

    protected boolean shouldIndent() {
        return this.m_doIndent && !this.m_ispreserve && !this.m_isprevtext && this.m_elemContext.m_currentElemDepth > 0;
    }

    @Override
    public void setCdataSectionElements(Vector vector) {
        int n;
        if (vector != null && (n = vector.size() - 1) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; i += 2) {
                if (i != 0) {
                    stringBuffer.append(' ');
                }
                String string = (String)vector.elementAt(i);
                String string2 = (String)vector.elementAt(i + 1);
                if (string != null) {
                    stringBuffer.append('{');
                    stringBuffer.append(string);
                    stringBuffer.append('}');
                }
                stringBuffer.append(string2);
            }
            this.m_StringOfCDATASections = stringBuffer.toString();
        }
        this.initCdataElems(this.m_StringOfCDATASections);
    }

    protected String ensureAttributesNamespaceIsDeclared(String string, String string2, String string3) throws SAXException {
        if (string != null && string.length() > 0) {
            String string4;
            int n = 0;
            n = string3.indexOf(":");
            String string5 = string4 = n < 0 ? "" : string3.substring(0, n);
            if (n > 0) {
                String string6 = this.m_prefixMap.lookupNamespace(string4);
                if (string6 != null && string6.equals(string)) {
                    return null;
                }
                this.startPrefixMapping(string4, string, false);
                this.addAttribute("http://www.w3.org/2000/xmlns/", string4, "xmlns:" + string4, "CDATA", string, false);
                return string4;
            }
            String string7 = this.m_prefixMap.lookupPrefix(string);
            if (string7 == null) {
                string7 = this.m_prefixMap.generateNextPrefix();
                this.startPrefixMapping(string7, string, false);
                this.addAttribute("http://www.w3.org/2000/xmlns/", string7, "xmlns:" + string7, "CDATA", string, false);
            }
            return string7;
        }
        return null;
    }

    void ensurePrefixIsDeclared(String string, String string2) throws SAXException {
        if (string != null && string.length() > 0) {
            String string3;
            String string4;
            int n = string2.indexOf(":");
            boolean bl = n < 0;
            String string5 = string4 = bl ? "" : string2.substring(0, n);
            if (!(null == string4 || null != (string3 = this.m_prefixMap.lookupNamespace(string4)) && string3.equals(string))) {
                this.startPrefixMapping(string4, string);
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", bl ? "xmlns" : string4, bl ? "xmlns" : "xmlns:" + string4, "CDATA", string, false);
            }
        }
    }

    @Override
    void flushInternal() throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        }
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
            this.m_cdataTagOpen = false;
        }
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
    }

    public boolean addAttributeAlways(String string, String string2, String string3, String string4, String string5, boolean bl) {
        boolean bl2;
        int n = string == null || string2 == null || string.length() == 0 ? this.m_attributes.getIndex(string3) : this.m_attributes.getIndex(string, string2);
        if (n < 0 && "http://www.w3.org/2000/xmlns/".equals(string)) {
            n = this.m_attributes.getIndex(string3);
        }
        if (n >= 0) {
            String string6 = null;
            if (this.m_tracer != null && string5.equals(string6 = this.m_attributes.getValue(n))) {
                string6 = null;
            }
            this.m_attributes.setValue(n, string5);
            bl2 = false;
            if (string6 != null) {
                this.firePseudoAttributes();
            }
        } else {
            if (bl) {
                String string7;
                NamespaceMappings.MappingRecord mappingRecord;
                int n2 = string3.indexOf(58);
                if (n2 > 0 && (mappingRecord = this.m_prefixMap.getMappingFromPrefix(string7 = string3.substring(0, n2))) != null && mappingRecord.m_declarationDepth == this.m_elemContext.m_currentElemDepth && !mappingRecord.m_uri.equals(string)) {
                    string7 = this.m_prefixMap.lookupPrefix(string);
                    if (string7 == null) {
                        string7 = this.m_prefixMap.generateNextPrefix();
                    }
                    string3 = string7 + ':' + string2;
                }
                try {
                    this.ensureAttributesNamespaceIsDeclared(string, string2, string3);
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
            }
            this.m_attributes.addAttribute(string, string2, string3, string4, string5, 0);
            bl2 = true;
            if (this.m_tracer != null) {
                this.firePseudoAttributes();
            }
        }
        return bl2;
    }

    protected void firePseudoAttributes() {
        if (this.m_tracer != null) {
            try {
                Object object;
                this.m_writer.flush();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('<');
                stringBuffer.append(this.m_elemContext.m_elementName);
                int n = this.m_attributes.getLength();
                if (n > 0) {
                    object = new WritertoStringBuffer(stringBuffer);
                    this.processAttributes((Writer)object, n);
                }
                stringBuffer.append('>');
                object = stringBuffer.toString().toCharArray();
                this.m_tracer.fireGenerateEvent(11, (char[])object, 0, ((Object)object).length);
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setTransformer(Transformer transformer) {
        super.setTransformer(transformer);
        if (this.m_tracer != null && !(this.m_writer instanceof SerializerTraceWriter)) {
            this.setWriterInternal(new SerializerTraceWriter(this.m_writer, this.m_tracer), false);
        }
    }

    @Override
    public boolean reset() {
        super.reset();
        this.resetToStream();
        return true;
    }

    private void resetToStream() {
        this.m_cdataStartCalled = false;
        this.m_charcterMaps = null;
        if (this.m_codepoint2String != null) {
            this.m_codepoint2String.reset();
        }
        this.m_disableOutputEscapingStates.clear();
        this.m_escaping = true;
        this.m_expandDTDEntities = true;
        this.m_inDoctype = false;
        this.m_ispreserve = false;
        this.m_isprevtext = false;
        this.m_isUTF8 = false;
        this.m_lineSep = s_systemLineSep;
        this.m_lineSepLen = s_systemLineSep.length;
        this.m_lineSepUse = true;
        this.m_normalizerMode = 1;
        this.m_omitMetaTag = false;
        this.m_shouldFlush = true;
        this.m_spaceBeforeClose = false;
        this.m_specialEscapeURLs = true;
        this.m_startNewLine = false;
        this.m_unicodeNormalizer = null;
        this.m_writer_set_by_user = false;
    }

    @Override
    public void setEncoding(String string) {
        this.setOutputProperty("encoding", string);
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        try {
            this.DTDprolog();
            this.m_writer.write("<!NOTATION ");
            this.m_writer.write(string);
            if (string2 != null) {
                this.m_writer.write(" PUBLIC \"");
                this.m_writer.write(string2);
            } else {
                this.m_writer.write(" SYSTEM \"");
                this.m_writer.write(string3);
            }
            this.m_writer.write("\" >");
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        try {
            this.DTDprolog();
            this.m_writer.write("<!ENTITY ");
            this.m_writer.write(string);
            if (string2 != null) {
                this.m_writer.write(" PUBLIC \"");
                this.m_writer.write(string2);
            } else {
                this.m_writer.write(" SYSTEM \"");
                this.m_writer.write(string3);
            }
            this.m_writer.write("\" NDATA ");
            this.m_writer.write(string4);
            this.m_writer.write(" >");
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void DTDprolog() throws SAXException, IOException {
        Writer writer = this.m_writer;
        if (this.m_needToOutputDocTypeDecl) {
            this.outputDocTypeDecl(this.m_elemContext.m_elementName, false);
            this.m_needToOutputDocTypeDecl = false;
        }
        if (this.m_inDoctype) {
            writer.write(" [");
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            this.m_inDoctype = false;
        }
    }

    @Override
    public void setDTDEntityExpansion(boolean bl) {
        this.m_expandDTDEntities = bl;
    }

    public void setNewLine(char[] cArray) {
        this.m_lineSep = cArray;
        this.m_lineSepLen = cArray.length;
    }

    @Override
    public void addCdataSectionElements(String string) {
        if (string != null) {
            this.initCdataElems(string);
        }
        this.m_StringOfCDATASections = this.m_StringOfCDATASections == null ? string : this.m_StringOfCDATASections + " " + string;
    }

    void reportWarning(String string, Object[] objectArray) {
        ErrorListener errorListener;
        String string2 = Utils.messages.createMessage(string, objectArray);
        Transformer transformer = super.getTransformer();
        if (transformer != null && (errorListener = transformer.getErrorListener()) != null) {
            TransformerException transformerException = this.m_sourceLocator != null ? new TransformerException(string2, this.m_sourceLocator) : new TransformerException(string2);
            try {
                errorListener.warning(transformerException);
                return;
            }
            catch (TransformerException transformerException2) {
                // empty catch block
            }
        }
        System.err.println(string2);
    }

    void reportError(String string, Object[] objectArray) {
        ErrorListener errorListener;
        String string2 = Utils.messages.createMessage(string, objectArray);
        Transformer transformer = super.getTransformer();
        if (transformer != null && (errorListener = transformer.getErrorListener()) != null) {
            TransformerException transformerException = this.m_sourceLocator != null ? new TransformerException(string2, this.m_sourceLocator) : new TransformerException(string2);
            try {
                errorListener.error(transformerException);
                return;
            }
            catch (TransformerException transformerException2) {
                // empty catch block
            }
        }
        System.err.println(string2);
    }

    @Override
    public void setCharacterMaps(CharacterMaps characterMaps) {
        this.m_charcterMaps = characterMaps;
    }

    @Override
    protected void startDocumentInternal() throws SAXException {
        String string;
        this.m_wasJustReset = false;
        if (this.m_writer == null && this.m_outputStream != null) {
            this.setOutputStreamInternal(this.m_outputStream, false);
        }
        super.fireStartDoc();
        if (this.m_charcterMaps != null && (string = this.getOutputProperty("use-character-maps")) != null) {
            StringTokenizer stringTokenizer = Utils.whitespaceTokenize(string);
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                OutputCharacter[] outputCharacterArray = this.m_charcterMaps.getOutputCharacters(string2);
                for (int i = 0; i < outputCharacterArray.length; ++i) {
                    int n = outputCharacterArray[i].getCharacter();
                    String string3 = outputCharacterArray[i].getString();
                    this.setOutputCharacter(n, string3);
                }
            }
        }
        if (this.m_isUTF8 && "yes".equals(string = this.getOutputPropertyNonDefault("byte-order-mark"))) {
            try {
                this.m_writer.write(65279);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        int n = this.m_normalizerMode != 1 ? 1 : 0;
        int n2 = this.m_codepoint2String != null && this.m_codepoint2String.hasMappings() ? 2 : 0;
        int n3 = this.m_charInfo != null && !this.m_charInfo.getOnlyStandardEntities() ? 4 : 0;
        this.m_optLevel = n + n2 + n3;
    }

    @Override
    public void setOutputCharacter(int n, String string) {
        if (this.m_codepoint2String == null) {
            this.m_codepoint2String = new CodepointMappings();
        }
        this.m_codepoint2String.setString(n, string);
    }

    void writeXMLAttr(Writer writer, WriterOptimized writerOptimized, String string) throws IOException {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            n = this.getChars(string, i, n2);
            char[] cArray = this.getCharsBuff();
            int n3 = 0;
            int n4 = 0;
            int n5 = 1;
            if (this.m_codepoint2String != null && this.m_codepoint2String.hasMappings()) {
                for (int j = 0; j < n; j += n5) {
                    int n6;
                    int n7 = cArray[j];
                    if (Encodings.isHighUTF16Surrogate((char)n7) && j + 1 < n) {
                        char c = cArray[j + 1];
                        n6 = Encodings.toCodePoint((char)n7, c);
                        n5 = 2;
                    } else {
                        n6 = n7;
                        n5 = 1;
                    }
                    String string2 = this.m_codepoint2String.getString(n6);
                    if (string2 != null) {
                        if (n4 > 0) {
                            this.uniNormXMLAttr(writer, string.substring(n3, n3 + n4), writerOptimized, cArray, n3, n4);
                        }
                        writer.write(string2);
                        n3 = j + n5;
                        n4 = 0;
                        continue;
                    }
                    n4 += n5;
                }
            } else {
                n4 = n;
            }
            if (n4 <= 0) continue;
            this.uniNormXMLAttr(writer, string.substring(n3, n3 + n4), writerOptimized, cArray, n3, n4);
        }
    }

    void writeXMLAttrOpt(Writer writer, WriterOptimized writerOptimized, String string) throws IOException {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            int n3;
            int n4;
            n = this.getChars(string, i, n2);
            char[] cArray = this.getCharsBuff();
            int n5 = n4 = 0;
            int n6 = n4;
            int n7 = n4 + n;
            block14: while (n6 < n7) {
                int n8;
                int n9;
                int n10 = cArray[n6];
                switch (n10) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        n3 = n6 - n5;
                        this.writeNumericEntity(writer, writerOptimized, n10, cArray, n3, n5);
                        n5 = ++n6;
                        continue block14;
                    }
                    case 32: 
                    case 33: {
                        ++n6;
                        continue block14;
                    }
                    case 34: {
                        n3 = n6 - n5;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n5, n3);
                            } else {
                                writer.write(cArray, n5, n3);
                            }
                        }
                        writer.write("&quot;");
                        n5 = ++n6;
                        continue block14;
                    }
                    case 35: 
                    case 36: 
                    case 37: {
                        ++n6;
                        continue block14;
                    }
                    case 38: {
                        n3 = n6 - n5;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n5, n3);
                            } else {
                                writer.write(cArray, n5, n3);
                            }
                        }
                        writer.write("&amp;");
                        n5 = ++n6;
                        continue block14;
                    }
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: {
                        ++n6;
                        continue block14;
                    }
                    case 60: {
                        n3 = n6 - n5;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n5, n3);
                            } else {
                                writer.write(cArray, n5, n3);
                            }
                        }
                        writer.write("&lt;");
                        n5 = ++n6;
                        continue block14;
                    }
                    case 61: {
                        ++n6;
                        continue block14;
                    }
                    case 62: {
                        n3 = n6 - n5;
                        if (n3 > 0) {
                            if (writerOptimized == writer) {
                                writerOptimized.writeASCII(cArray, n5, n3);
                            } else {
                                writer.write(cArray, n5, n3);
                            }
                        }
                        writer.write("&gt;");
                        n5 = ++n6;
                        continue block14;
                    }
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: {
                        ++n6;
                        continue block14;
                    }
                    case 127: {
                        n3 = n6 - n5;
                        this.writeNumericEntity(writer, writerOptimized, n10, cArray, n3, n5);
                        n5 = ++n6;
                        continue block14;
                    }
                }
                if (Encodings.isHighUTF16Surrogate((char)n10) && n6 + 1 < n7) {
                    char c = cArray[n6 + 1];
                    n9 = Encodings.toCodePoint((char)n10, c);
                    n8 = 2;
                } else {
                    n9 = n10;
                    n8 = 1;
                }
                if (127 <= n9 && n9 <= 159 || n9 == 160 || n9 == 8232) {
                    n3 = n6 - n5;
                    this.writeNumericEntity(writer, writerOptimized, n10, cArray, n3, n5);
                    n5 = n6 += n8;
                    continue;
                }
                if (this.m_encodingInfo.isCodePointInEncoding(n9)) {
                    if (writerOptimized == writer) {
                        n3 = n6 - n5;
                        writerOptimized.writeASCII(cArray, n5, n3);
                        if (n8 == 1) {
                            writerOptimized.write(n10);
                        } else {
                            writerOptimized.write(cArray, n6, 2);
                        }
                        n5 = n6 += n8;
                        continue;
                    }
                    n6 += n8;
                    continue;
                }
                n3 = n6 - n5;
                if (n3 > 0) {
                    if (writerOptimized == writer) {
                        writerOptimized.writeASCII(cArray, n5, n3);
                    } else {
                        writer.write(cArray, n5, n3);
                    }
                }
                String string2 = this.m_charInfo.getOutputStringForChar(n9, this.m_charKey);
                if (this.shouldMapTextChar(n9) && string2 != null) {
                    writer.write(string2);
                } else {
                    writer.write("&#");
                    writer.write(Integer.toString(n9));
                    writer.write(59);
                }
                n5 = n6 += n8;
            }
            n3 = n6 - n5;
            if (n3 <= 0) continue;
            if (writerOptimized == writer) {
                writerOptimized.writeASCII(cArray, n5, n3);
                continue;
            }
            writer.write(cArray, n5, n3);
        }
    }

    void writeNumericEntity(Writer writer, WriterOptimized writerOptimized, int n, char[] cArray, int n2, int n3) throws IOException {
        if (n2 > 0) {
            if (writerOptimized == writer) {
                writerOptimized.writeASCII(cArray, n3, n2);
            } else {
                writer.write(cArray, n3, n2);
            }
        }
        writer.write("&#");
        writer.write(Integer.toString(n));
        writer.write(59);
    }

    private void uniNormXMLAttr(Writer writer, String string, WriterOptimized writerOptimized, char[] cArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n2;
        int n5 = n;
        if (this.m_normalizerMode != 1 && !this.m_unicodeNormalizer.alreadyNormalized(cArray, n, n + n2, this.m_normalizerMode)) {
            n3 = n + 3 * n2 + 1;
            if (this.m_normalizedCharsBuff.length < n3) {
                this.m_normalizedCharsBuff = new char[n3];
            }
            n4 = this.m_unicodeNormalizer.normalizeUnicode(cArray, n, n + n2, this.m_normalizedCharsBuff, n, n3, this.m_normalizerMode);
            cArray = this.m_normalizedCharsBuff;
            string = null;
        }
        if (!this.m_charInfo.getOnlyStandardEntities()) {
            n3 = n;
            int n6 = n3 + n4;
            char c = '\u0000';
            int n7 = 1;
            int n8 = 0;
            int n9 = 0;
            for (int i = n3; i < n6; i += n7) {
                int n10 = cArray[i];
                if (Encodings.isHighUTF16Surrogate((char)n10) && i + 1 < n4) {
                    c = cArray[i + 1];
                    n8 = Encodings.toCodePoint((char)n10, c);
                    n7 = 2;
                } else {
                    n8 = n10;
                    n7 = 1;
                }
                if (this.m_charInfo.shouldMapAttrChar(n8)) {
                    if (n9 > 0) {
                        writer.write(cArray, n5, n9);
                        n9 = 0;
                    }
                    n5 = i + n7;
                    String string2 = this.m_charInfo.getOutputStringForChar(n8, this.m_charKey);
                    writer.write(string2);
                    continue;
                }
                if (0 <= n8 && n8 <= 31) {
                    if (n9 > 0) {
                        writer.write(cArray, n5, n9);
                        n9 = 0;
                    }
                    n5 = i + n7;
                    switch (n8) {
                        case 9: {
                            writer.write("&#9;");
                            break;
                        }
                        case 10: {
                            writer.write("&#10;");
                            break;
                        }
                        case 13: {
                            writer.write("&#13;");
                            break;
                        }
                        default: {
                            writer.write("&#");
                            writer.write(Integer.toString(n8));
                            writer.write(59);
                            break;
                        }
                    }
                    continue;
                }
                if (n8 < 127) {
                    switch (n8) {
                        case 34: {
                            if (n9 > 0) {
                                writer.write(cArray, n5, n9);
                                n9 = 0;
                            }
                            n5 = i + n7;
                            writer.write("&quot;");
                            break;
                        }
                        case 38: {
                            if (n9 > 0) {
                                writer.write(cArray, n5, n9);
                                n9 = 0;
                            }
                            n5 = i + n7;
                            writer.write("&amp;");
                            break;
                        }
                        case 60: {
                            if (n9 > 0) {
                                writer.write(cArray, n5, n9);
                                n9 = 0;
                            }
                            n5 = i + n7;
                            writer.write("&lt;");
                            break;
                        }
                        default: {
                            n9 += n7;
                            break;
                        }
                    }
                    continue;
                }
                if (n8 <= 159) {
                    if (n9 > 0) {
                        writer.write(cArray, n5, n9);
                        n9 = 0;
                    }
                    n5 = i + n7;
                    writer.write("&#");
                    writer.write(Integer.toString(n8));
                    writer.write(59);
                    continue;
                }
                if (n8 == 8232) {
                    if (n9 > 0) {
                        writer.write(cArray, n5, n9);
                        n9 = 0;
                    }
                    n5 = i + n7;
                    writer.write("&#8232;");
                    continue;
                }
                if (this.m_encodingInfo.isCodePointInEncoding(n8)) {
                    n9 += n7;
                    continue;
                }
                if (n9 > 0) {
                    writer.write(cArray, n5, n9);
                    n9 = 0;
                }
                n5 = i + n7;
                writer.write("&#");
                writer.write(Integer.toString(n8));
                writer.write(59);
            }
            if (n9 > 1) {
                if (n5 == 0 && string != null && n9 == string.length()) {
                    writer.write(string);
                } else {
                    writer.write(cArray, n5, n9);
                }
            } else if (n9 == 1) {
                writer.write(n8);
            }
        } else {
            this.writeXMLAttrOpt(writer, writerOptimized, string);
        }
    }

    static final class BoolStack {
        private boolean[] m_values;
        private int m_allocatedSize;
        private int m_index;

        public BoolStack() {
            this(32);
        }

        public BoolStack(int n) {
            this.m_allocatedSize = n;
            this.m_values = new boolean[n];
            this.m_index = -1;
        }

        public final int size() {
            return this.m_index + 1;
        }

        public final void clear() {
            this.m_index = -1;
        }

        public final boolean push(boolean bl) {
            if (this.m_index == this.m_allocatedSize - 1) {
                this.grow();
            }
            boolean bl2 = bl;
            this.m_values[++this.m_index] = bl2;
            return bl2;
        }

        public final boolean pop() {
            return this.m_values[this.m_index--];
        }

        public final boolean popAndTop() {
            --this.m_index;
            return this.m_index >= 0 ? this.m_values[this.m_index] : false;
        }

        public final void setTop(boolean bl) {
            this.m_values[this.m_index] = bl;
        }

        public final boolean peek() {
            return this.m_values[this.m_index];
        }

        public final boolean peekOrFalse() {
            return this.m_index > -1 ? this.m_values[this.m_index] : false;
        }

        public final boolean peekOrTrue() {
            return this.m_index > -1 ? this.m_values[this.m_index] : true;
        }

        public boolean isEmpty() {
            return this.m_index == -1;
        }

        private void grow() {
            this.m_allocatedSize *= 2;
            boolean[] blArray = new boolean[this.m_allocatedSize];
            System.arraycopy(this.m_values, 0, blArray, 0, this.m_index + 1);
            this.m_values = blArray;
        }
    }

    private class WritertoStringBuffer
    extends Writer {
        private final StringBuffer m_stringbuf;

        WritertoStringBuffer(StringBuffer stringBuffer) {
            this.m_stringbuf = stringBuffer;
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            this.m_stringbuf.append(cArray, n, n2);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void write(int n) {
            this.m_stringbuf.append((char)n);
        }

        @Override
        public void write(String string) {
            this.m_stringbuf.append(string);
        }
    }
}

