/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.domapi;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.domapi.XPathExpressionImpl;
import org.apache.xpath.domapi.XPathNSResolverImpl;
import org.apache.xpath.domapi.XPathStylesheetDOM3Exception;
import org.apache.xpath.res.XPATHMessages;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathExpression;
import org.w3c.dom.xpath.XPathNSResolver;

public final class XPathEvaluatorImpl
implements XPathEvaluator {
    private final Document m_doc;

    public XPathEvaluatorImpl(Document document) {
        this.m_doc = document;
    }

    public XPathEvaluatorImpl() {
        this.m_doc = null;
    }

    @Override
    public XPathExpression createExpression(String string, XPathNSResolver xPathNSResolver) throws XPathException, DOMException {
        try {
            XPath xPath = new XPath(string, null, null == xPathNSResolver ? new DummyPrefixResolver() : (PrefixResolver)((Object)xPathNSResolver), 0);
            return new XPathExpressionImpl(xPath, this.m_doc);
        }
        catch (TransformerException transformerException) {
            if (transformerException instanceof XPathStylesheetDOM3Exception) {
                throw new DOMException(14, transformerException.getMessageAndLocation());
            }
            throw new XPathException(51, transformerException.getMessageAndLocation());
        }
    }

    @Override
    public XPathNSResolver createNSResolver(Node node) {
        return new XPathNSResolverImpl(node.getNodeType() == 9 ? ((Document)node).getDocumentElement() : node);
    }

    @Override
    public Object evaluate(String string, Node node, XPathNSResolver xPathNSResolver, short s, Object object) throws XPathException, DOMException {
        XPathExpression xPathExpression = this.createExpression(string, xPathNSResolver);
        return xPathExpression.evaluate(node, s, object);
    }

    private class DummyPrefixResolver
    implements PrefixResolver {
        DummyPrefixResolver() {
        }

        @Override
        public String getNamespaceForPrefix(String string, Node node) {
            String string2 = XPATHMessages.createXPATHMessage("ER_NULL_RESOLVER", null);
            throw new DOMException(14, string2);
        }

        @Override
        public String getNamespaceForPrefix(String string) {
            return this.getNamespaceForPrefix(string, null);
        }

        @Override
        public boolean handlesNullPrefixes() {
            return false;
        }

        @Override
        public String getBaseIdentifier() {
            return null;
        }
    }
}

