/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.FatalInstallException;
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.InstallException;
import core.CustomCodeActionShim;
import core.InstallerState;
import java.io.IOException;

public class CADeletableFile
extends CustomCodeActionShim {
    @Override
    public void installImpl(IAProxy ip) throws InstallException {
        this.CheckForLockedDirectories(ip, false);
    }

    @Override
    public String getInstallStatusMessage() {
        return "Executing command...";
    }

    @Override
    public String getUninstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public void uninstallImpl(IAProxy up) throws InstallException {
        this.CheckForLockedDirectories(up, true);
    }

    public void CheckForLockedDirectories(IAProxy ip, boolean bUninstall) throws InstallException {
        boolean bSilentInstall = false;
        ip.setVariable("$LOCKED_DIRECTORY$", "$EMPTY_STRING$");
        ip.setVariable("$CADELETABLEFILE_EXCEPTION$", "$EMPTY_STRING$");
        String strSilentInstall = ip.substitute("$INSTALLER_UI$");
        if (strSilentInstall.contains("SILENT")) {
            bSilentInstall = true;
        }
        String strUninstallFolder = "";
        if (bUninstall) {
            strUninstallFolder = "uninstall";
        }
        String strInstallDirectory = ip.substitute("$USER_INSTALL_DIR$");
        String strLockedDirs = "";
        try {
            strLockedDirs = DeletableFile.CheckInstallDirectory(strInstallDirectory, strUninstallFolder);
            if (!strLockedDirs.isEmpty()) {
                ip.setVariable("$LOCKED_DIRECTORY$", strLockedDirs);
                InstallerState.log.info("Upgrade process", "Locked directories:", strLockedDirs);
                if (bSilentInstall) {
                    throw new IOException("Unable to delete locked directory:" + strLockedDirs);
                }
            }
        }
        catch (Exception e) {
            ip.setVariable("$CADELETABLEFILE_EXCEPTION$", e.getLocalizedMessage());
            throw new FatalInstallException(e.getLocalizedMessage());
        }
    }
}

