/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.InstallException;
import core.CustomCodeActionShim;
import core.InstallerState;
import java.util.Locale;

public class CAInstallDirectoryValidator
extends CustomCodeActionShim {
    @Override
    public void installImpl(IAProxy ip) throws InstallException {
        InstallerState.log.enter(this);
        ip.setVariable("$VALIDATE_INSTALL_DIR$", "$EMPTY_STRING$");
        String strInstallDirectory = ip.substitute("$USER_INSTALL_DIR$");
        InstallDirectoryValidator dirValidator = new InstallDirectoryValidator(strInstallDirectory);
        this.SetErrorMessage(dirValidator.Validate(), ip);
        InstallerState.log.exit(this);
    }

    private void SetErrorMessage(InstallDirectoryValidator.installDirError errorCode, IAProxy ip) {
        InstallerState.log.enter(this);
        String strResourceMessage = "";
        String strInvalidCharacterID = "InstallDirectoryValidator.invalid_character_windows";
        if (!InstallerState.isWindows) {
            strInvalidCharacterID = "InstallDirectoryValidator.invalid_character_unix";
        }
        if (errorCode == InstallDirectoryValidator.installDirError.ERR_INVALID_CHARACTER) {
            strResourceMessage = ip.getValue(strInvalidCharacterID);
            if (strResourceMessage.isEmpty()) {
                strResourceMessage = ip.getValue(strInvalidCharacterID, Locale.ENGLISH);
            }
        } else if (errorCode == InstallDirectoryValidator.installDirError.ERR_INVALID_DRIVE) {
            strResourceMessage = ip.getValue("InstallDirectoryValidator.invalid_drive");
            if (strResourceMessage.isEmpty()) {
                strResourceMessage = ip.getValue("InstallDirectoryValidator.invalid_drive", Locale.ENGLISH);
            }
        } else if (errorCode == InstallDirectoryValidator.installDirError.ERR_NO_WRITE_ACCESS && (strResourceMessage = ip.getValue("InstallDirectoryValidator.read-only")).isEmpty()) {
            strResourceMessage = ip.getValue("InstallDirectoryValidator.read-only", Locale.ENGLISH);
        }
        ip.setVariable("$VALIDATE_INSTALL_DIR$", strResourceMessage);
        InstallerState.log.exit(this);
    }

    @Override
    public String getInstallStatusMessage() {
        return "Executing command...";
    }

    @Override
    public String getUninstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public void uninstallImpl(IAProxy up) throws InstallException {
    }
}

