/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.InstallException;
import core.CustomCodeActionShim;
import core.InstallerState;
import java.io.IOException;
import manifest.UnsupportedArchiveException;
import repository.ExternalRepositoryException;

public class CARepoLicense
extends CustomCodeActionShim {
    private String strSelectedProduct = "";
    private String strManifestName = "";

    @Override
    public void installImpl(IAProxy ip) throws InstallException {
        this.strSelectedProduct = ip.substitute("$SELECTED_PRODUCT$");
        String strExtractionDirectory = ip.substitute(InstallerState.IDS_IA_EXTRACTIONDIR_VARIABLE);
        if (InstallerState.manifest != null) {
            this.strManifestName = InstallerState.manifest.getManifestName();
        }
        RepoLicense licenseComponent = new RepoLicense(this.strSelectedProduct, strExtractionDirectory);
        try {
            RepoLicense.installPartError errCode = licenseComponent.GetLicense();
            if (errCode != RepoLicense.installPartError.SUCCESS) {
                this.SetErrorMessage(ip);
            }
        }
        catch (IOException | UnsupportedArchiveException | ExternalRepositoryException e) {
            String strMsg = String.format(InstallerState.LOCALIZED_GET_REPO_LICENSE_ERROR, this.strSelectedProduct, this.strManifestName);
            InstallerState.log.error("CARepoLicense", strMsg, e.getLocalizedMessage());
            ip.setVariable("$CAGETLICENSEFROMREPO_EXCEPTION$", e.getLocalizedMessage());
        }
    }

    @Override
    public String getInstallStatusMessage() {
        return "Executing command...";
    }

    @Override
    public String getUninstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public void uninstallImpl(IAProxy up) throws InstallException {
    }

    private void SetErrorMessage(IAProxy ip) {
        InstallerState.log.enter(this);
        String strMsg = String.format(InstallerState.LOCALIZED_GET_REPO_LICENSE_ERROR, this.strSelectedProduct, this.strManifestName);
        InstallerState.log.error("CARepoLicense", strMsg);
        ip.setVariable("$CAGETLICENSEFROMREPO_EXCEPTION$", strMsg);
        InstallerState.log.exit(this);
    }
}

