/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.CustomError;
import com.zerog.ia.api.pub.FatalInstallException;
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.ReplayVariableService;
import core.CustomCodeActionShim;
import core.InstallerState;
import java.io.File;
import repository.ExternalRepositoryException;

public class CARepositoryState
extends CustomCodeActionShim {
    protected static final String IDS_REPO = "repo";
    protected static final String IDS_REPO_ZIP = "repo.zip";
    private static RepositoryState m_RepositoryState = null;

    @Override
    public void installImpl(IAProxy ip) throws InstallException {
        if (ip != null) {
            String strCAClientInstall;
            String strCAServerInstall;
            boolean bSilentInstall;
            block5: {
                CustomError ceInstallLog = (CustomError)ip.getService(CustomError.class);
                bSilentInstall = false;
                strCAServerInstall = ip.substitute("$BISRVR_CA_INSTALL$");
                strCAClientInstall = ip.substitute("$BISRVR_CA_TOOLS_INSTALL$");
                String strSilentInstall = ip.substitute("$INSTALLER_UI$");
                if (strSilentInstall.contains("SILENT")) {
                    bSilentInstall = true;
                }
                ip.setVariable("$CAREPOSTATE_EXCEPTION$", "");
                this.RegisterREPOVariable(ip);
                InstallerState.log.debug("CARepositoryState", "BISRVR_CA_INSTALL: " + strCAServerInstall);
                InstallerState.log.debug("CARepositoryState", "BISRVR_CA_TOOLS_INSTALL: " + strCAClientInstall);
                InstallerState.log.debug("CARepositoryState", "INSTALLER_UI: " + strSilentInstall);
                try {
                    CARepositoryState.SetRepositoryState(new RepositoryState(this.GetRepoName(ip), ip.substitute("$MANIFEST$"), ip.substitute("$INSTALLER_LAUNCH_DIR$"), bSilentInstall, ip));
                }
                catch (ExternalRepositoryException e) {
                    ip.setVariable("$CAREPOSTATE_EXCEPTION$", e.getLocalizedMessage());
                    if (!bSilentInstall) break block5;
                    throw new FatalInstallException(e.getLocalizedMessage());
                }
            }
            if (bSilentInstall) {
                m_RepositoryState.SetSilentInstallManifest(strCAServerInstall, strCAClientInstall);
            }
        }
    }

    private void RegisterREPOVariable(IAProxy ip) {
        String strRepoPath = ip.substitute("$REPOPATH$");
        String strRepoFile = ip.substitute("$REPOFILE$");
        String strRepo = ip.substitute("$REPO$");
        if (!strRepoPath.isEmpty() && !strRepoFile.isEmpty()) {
            ReplayVariableService replay = (ReplayVariableService)ip.getService(ReplayVariableService.class);
            replay.register("$REPO$", strRepo);
        }
    }

    public void InitializeRepoObject(String strRepoName, String strManifest, String strLaunchDir, IAProxy iap) throws InstallException, ExternalRepositoryException {
        CARepositoryState.SetRepositoryState(new RepositoryState(strRepoName, strManifest, strLaunchDir, false, iap));
    }

    private String GetRepoName(IAProxy ip) {
        File dirRepoSource;
        String strRepoName = ip.substitute("$REPO$");
        if (strRepoName.isEmpty() && !(dirRepoSource = new File(strRepoName = ip.substitute("$INSTALLER_LAUNCH_DIR$") + File.separator + IDS_REPO)).exists()) {
            strRepoName = ip.substitute("$INSTALLER_LAUNCH_DIR$") + File.separator + IDS_REPO_ZIP;
        }
        return strRepoName;
    }

    @Override
    public String getInstallStatusMessage() {
        return "Executing command...";
    }

    @Override
    public String getUninstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public void uninstallImpl(IAProxy up) throws InstallException {
    }

    public static RepositoryState GetRepositoryState() {
        return m_RepositoryState;
    }

    public static void SetRepositoryState(RepositoryState repositoryState) {
        m_RepositoryState = repositoryState;
    }
}

