/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.CustomError;
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.InstallException;
import core.CustomCodeActionShim;
import core.InstallerState;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class CAUpgradeUtility
extends CustomCodeActionShim {
    private String userInstallDir = "";
    private CustomError m_InstallLog = null;

    @Override
    protected void installImpl(IAProxy ip) throws InstallException {
        ip.setVariable("$CAUPGRADEUTILITY_EXCEPTION$", "$EMPTY_STRING$");
        this.m_InstallLog = (CustomError)ip.getService(CustomError.class);
        this.userInstallDir = ip.substitute("$USER_INSTALL_DIR$");
        ArrayList<String> exludedDirs = new ArrayList<String>();
        ArrayList<String> exludedItems = new ArrayList<String>();
        try {
            exludedDirs.add(new File(this.userInstallDir + File.separator + "install_backup").getCanonicalPath());
            exludedItems.add(new File(this.userInstallDir).getCanonicalPath());
            exludedItems.add(new File(this.userInstallDir + File.separator + "rendition.dat").getCanonicalPath());
            exludedItems.add(new File(this.userInstallDir + File.separator + "cmplst.txt").getCanonicalPath());
            InstallerState.log.info("Upgrade Install:", "Cleaning up previous installation.");
            this.CleanDirectory(new File(this.userInstallDir).toPath(), exludedDirs, exludedItems);
        }
        catch (Exception e) {
            ip.setVariable("$CAUPGRADEUTILITY_EXCEPTION$", e.getLocalizedMessage());
        }
    }

    public void CleanDirectory(Path path, List<String> excludeDirList, List<String> excludeItemList) throws Exception {
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            try (DirectoryStream<Path> entries = Files.newDirectoryStream(path);){
                for (Path entry : entries) {
                    if (!excludeDirList.contains(entry.toFile().getCanonicalPath())) {
                        this.CleanDirectory(entry, excludeDirList, excludeItemList);
                        continue;
                    }
                    this.log("Exclude file/directory:" + entry.toFile().getCanonicalPath());
                }
            }
        }
        if (!excludeItemList.contains(path.toFile().getCanonicalPath()) && !path.toFile().delete()) {
            this.log("Failed to delete file:" + path.toFile().getName());
        }
    }

    private void log(String msg) {
        if (this.m_InstallLog != null) {
            this.m_InstallLog.setLogDescription(msg);
            this.m_InstallLog.log();
        }
    }

    @Override
    public String getInstallStatusMessage() {
        return "Executing command...";
    }

    @Override
    public String getUninstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    protected void uninstallImpl(IAProxy iap) throws InstallException {
    }
}

